/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorConstants;
import jet.export.excel.imp.xls.ColorIndex;
import jet.export.excel.imp.xls.PaletteColorIndex;
import util.RandomAccessStream;

public class Palette
extends Biff
implements ColorConstants {
    public static final int DFCOLORCOUNT = 56;
    public static final int MINCELLSIZE = 48;
    public int[] rgch = new int[]{0, 0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0x800000, 32768, 128, 0x808000, 0x800080, 32896, 0xC0C0C0, 0x808080, 0x9999FF, 0xD8D8D8, 0xFFFFCC, 0xEEEEEE, 0x660066, 0xFF8080, 26316, 0xCCCCFF, 4941445, 7449533, 12703467, 15003384, 5072195, 11228747, 16513259, 16119260, 52479, 0xCCFFFF, 0xCCFFCC, 0xFFFF99, 0x99CCFF, 0xFF99CC, 0xCC99FF, 0xFFCC99, 0x3366FF, 0x33CCCC, 0x99CC00, 0xFFCC00, 0xFF9900, 0xFF6600, 0x666699, 0x969696, 13158, 0x339966, 13056, 0x333300, 0x993300, 0x993366, 0x333399, 0x333333};
    boolean[] HSBtoRGB = new boolean[56];
    Hashtable RGBtoHSB = new Hashtable();
    private boolean SEDU = false;
    private boolean add = false;

    public Palette() {
        this.length = 226;
        int n = this.rgch.length;
        while (--n >= 2) {
            this.RGBtoHSB.put(this.rgch[n], new ColorIndex(n + 8, this.rgch[n]));
        }
        this.RGBtoHSB.put(this.rgch[1], new ColorIndex(9, this.rgch[1]));
        this.RGBtoHSB.put(this.rgch[0], new ColorIndex(8, this.rgch[0]));
        this.HSBtoRGB[0] = true;
        this.HSBtoRGB[1] = true;
    }

    @Override
    public final int opcode() {
        return 146;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShort(randomAccessStream, (short)56);
        for (int i = 0; i < 56; ++i) {
            this.writeInt(randomAccessStream, this.HSBtoRGB(this.rgch[i]));
        }
        return this.length + 4;
    }

    int HSBtoRGB(int n) {
        return (n & 0xFF) << 16 | n & 0xFF00 | (n & 0xFF0000) >> 16;
    }

    public int getColor(int n, int n2, int n3) {
        return (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
    }

    public int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public int getBlue(int n) {
        return n & 0xFF;
    }

    public int RGBtoHBS(int n) {
        int n2 = this.getRed(n);
        int n3 = this.getGreen(n);
        int n4 = this.getBlue(n);
        float[] fArray2 = new float[3];
        fArray2 = Color.RGBtoHSB(n2, n3, n4, fArray2);
        int n5 = (int)((double)(fArray2[0] * 240.0f) + 0.5);
        int n6 = (int)((double)(fArray2[1] * 240.0f) + 0.5);
        n4 = (int)((double)(fArray2[2] * 240.0f) + 0.5);
        return (n5 & 0xFF) << 16 | (n4 & 0xFF) << 8 | (n6 & 0xFF) << 0;
    }

    int RGBtoHSB(int n) {
        return n >> 16 & 0xFF;
    }

    int SEDU(int n) {
        return n >> 8 & 0xFF;
    }

    int add(int n) {
        return n >> 0 & 0xFF;
    }

    public int HBStoRGB(int n) {
        int n2 = this.RGBtoHSB(n);
        int n3 = this.SEDU(n);
        int n4 = this.add(n);
        float f = ((float)n2 - 0.5f) / 240.0f;
        float f2 = ((float)n3 - 0.5f) / 240.0f;
        float f3 = ((float)n4 - 0.5f) / 240.0f;
        int n5 = Color.HSBtoRGB(f, f3, f2) & 0xFFFFFF;
        return n5;
    }

    public int getColorIndex(int n) {
        PaletteColorIndex paletteColorIndex = (PaletteColorIndex)this.RGBtoHSB.get(n);
        return paletteColorIndex.F;
    }

    public void addColor(int n) {
        if (this.add) {
            return;
        }
        ColorIndex colorIndex = (ColorIndex)this.RGBtoHSB.get(n);
        if (colorIndex == null) {
            int n2 = this.RGBtoHSB.size() + 18;
            this.RGBtoHSB.put(n, new ColorIndex(n2, n));
        } else {
            int n3 = colorIndex.F - 8;
            if (n3 < 56) {
                this.HSBtoRGB[n3] = true;
            }
        }
    }

    private int clear() {
        int n = 0;
        for (int i = 0; i < 56; ++i) {
            n += this.HSBtoRGB[i] ? 0 : 1;
        }
        return n;
    }

    public boolean merge() {
        if (this.add) {
            return false;
        }
        if (this.RGBtoHSB.size() > 56) {
            this.add = true;
            int n = this.clear();
            if (this.RGBtoHSB.size() - n > 56) {
                Serializable serializable;
                Object object;
                Object object2;
                Enumeration enumeration;
                Hashtable hashtable = new Hashtable();
                Hashtable hashtable2 = new Hashtable();
                for (int i = 0; i < 56; ++i) {
                    enumeration = this.rgch[i];
                    if (this.HSBtoRGB[i]) {
                        hashtable.put((Integer)((Object)enumeration), this.RGBtoHSB.remove(enumeration));
                        continue;
                    }
                    hashtable2.put((Integer)((Object)enumeration), this.RGBtoHSB.remove(enumeration));
                }
                Hashtable hashtable3 = new Hashtable();
                hashtable3.putAll(this.RGBtoHSB);
                this.RGBtoHSB.clear();
                enumeration = hashtable3.keys();
                Vector<Float> vector = new Vector<Float>();
                Hashtable<Object, ArrayList> hashtable4 = new Hashtable<Object, ArrayList>();
                while (enumeration.hasMoreElements()) {
                    float f;
                    int n2;
                    Object object3;
                    Object object4;
                    Object e = enumeration.nextElement();
                    ColorIndex colorIndex = (ColorIndex)hashtable3.get(e);
                    float f2 = Float.MAX_VALUE;
                    object2 = hashtable.keys();
                    while (object2.hasMoreElements()) {
                        float f3;
                        object4 = object2.nextElement();
                        if (e.equals(object4) || !((f3 = this.containsKey(colorIndex, (ColorIndex)(object3 = (ColorIndex)hashtable.get(object4)))) < f2)) continue;
                        f2 = f3;
                    }
                    object4 = hashtable2.keys();
                    while (object4.hasMoreElements()) {
                        ColorIndex colorIndex2;
                        float f4;
                        object3 = object4.nextElement();
                        if (e.equals(object3) || !((f4 = this.containsKey(colorIndex, colorIndex2 = (ColorIndex)hashtable2.get(object3))) < f2)) continue;
                        f2 = f4;
                    }
                    for (n2 = 0; n2 < vector.size() && !(f2 <= (f = ((Float)vector.get(n2)).floatValue())); ++n2) {
                    }
                    object = new Float(f2);
                    vector.insertElementAt((Float)object, n2);
                    serializable = hashtable4.containsKey(object) ? (ArrayList)hashtable4.get(object) : new ArrayList();
                    serializable.add(e);
                    hashtable4.put(object, (ArrayList)serializable);
                }
                this.RGBtoHSB.putAll(hashtable);
                hashtable = null;
                int n3 = 0;
                int n4 = hashtable2.size();
                while (hashtable3.size() > n4) {
                    Object e = vector.get(n3);
                    ++n3;
                    if (!hashtable4.containsKey(e)) continue;
                    object2 = (ArrayList)hashtable4.remove(e);
                    for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                        Object e2 = ((ArrayList)object2).get(i);
                        object = (ColorIndex)hashtable3.remove(e2);
                        serializable = Integer.valueOf(((ColorIndex)object).C());
                        if (this.RGBtoHSB.containsKey(serializable)) {
                            this.RGBtoHSB.put(e2, new PaletteColorIndex(((PaletteColorIndex)this.RGBtoHSB.get((Object)serializable)).F));
                            continue;
                        }
                        int n5 = ((PaletteColorIndex)hashtable2.get((Object)serializable)).F;
                        this.RGBtoHSB.put(e2, new PaletteColorIndex(n5));
                        n5 -= 8;
                        if (--n4 < 0) {
                            n4 = 0;
                        }
                        this.HSBtoRGB[n5] = true;
                    }
                }
                enumeration = hashtable3.keys();
                for (int i = 55; i >= 0; --i) {
                    if (this.HSBtoRGB[i]) continue;
                    if (!enumeration.hasMoreElements()) break;
                    object2 = (Integer)enumeration.nextElement();
                    this.RGBtoHSB.put(object2, new PaletteColorIndex(i + 8));
                    this.rgch[i] = (Integer)object2;
                }
                hashtable3.clear();
            } else {
                Hashtable hashtable = new Hashtable();
                for (int i = 0; i < 56; ++i) {
                    Integer n6 = this.rgch[i];
                    if (this.HSBtoRGB[i]) {
                        hashtable.put(n6, this.RGBtoHSB.remove(n6));
                        continue;
                    }
                    this.RGBtoHSB.remove(n6);
                }
                Enumeration enumeration = this.RGBtoHSB.keys();
                for (int i = 55; i >= 0; --i) {
                    if (this.HSBtoRGB[i]) continue;
                    if (!enumeration.hasMoreElements()) break;
                    Integer n7 = (Integer)enumeration.nextElement();
                    this.RGBtoHSB.put(n7, new PaletteColorIndex(i + 8));
                    this.rgch[i] = n7;
                }
                this.RGBtoHSB.putAll(hashtable);
            }
        }
        return true;
    }

    void index(int n, int[] nArray) {
        nArray[0] = this.RGBtoHSB(n) == 240 ? 47 : this.RGBtoHSB(n) / 5;
        nArray[1] = this.SEDU(n) == 240 ? 47 : this.SEDU(n) / 5;
        nArray[2] = this.add(n) == 240 ? 47 : this.add(n) / 5;
    }

    private float containsKey(ColorIndex colorIndex, ColorIndex colorIndex2) {
        float f = colorIndex.B() - colorIndex2.B();
        f = f < 0.0f ? -f : f;
        f = (double)f > 0.4 ? (float)(0.8 - (double)f) : f;
        f *= f;
        float f2 = colorIndex.D() - colorIndex2.D();
        f2 *= f2;
        float f3 = colorIndex.F() - colorIndex2.F();
        f3 *= f3;
        float f4 = (float)Math.sqrt(f + f2 + f3);
        if (colorIndex.I() > f4) {
            colorIndex.I(f4, colorIndex2.Z());
        }
        return f4;
    }

    void I(boolean bl) {
        this.SEDU = bl;
    }

    boolean I() {
        return this.SEDU;
    }
}

