/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.ExcelFont;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

public class CellFont
implements ExcelFont {
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    double SEDU = 11.0;
    String equals = "Arial";
    int getRGB = -16777216;
    boolean hashCode = false;
    boolean length = false;
    boolean readBoolean = false;
    byte readByte = (byte)-1;
    boolean readDouble = false;
    short readInt = 0;

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeDouble(this.SEDU);
        dataOutputStream.writeUTF(this.equals);
        dataOutputStream.writeInt(this.getRGB);
        dataOutputStream.writeBoolean(this.hashCode);
        dataOutputStream.writeBoolean(this.length);
        dataOutputStream.writeBoolean(this.readBoolean);
        dataOutputStream.writeByte(this.readByte);
        dataOutputStream.writeBoolean(this.readDouble);
        dataOutputStream.writeShort(this.readInt);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.SEDU = dataInputStream.readDouble();
        this.equals = dataInputStream.readUTF();
        this.getRGB = dataInputStream.readInt();
        this.hashCode = dataInputStream.readBoolean();
        this.length = dataInputStream.readBoolean();
        this.readBoolean = dataInputStream.readBoolean();
        this.readByte = dataInputStream.readByte();
        this.readDouble = dataInputStream.readBoolean();
        this.readInt = dataInputStream.readShort();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellFont)) {
            return false;
        }
        CellFont cellFont = (CellFont)object;
        if (cellFont.SEDU != this.SEDU) {
            return false;
        }
        if (!cellFont.equals.equals(this.equals)) {
            return false;
        }
        if (cellFont.hashCode != this.hashCode) {
            return false;
        }
        if (cellFont.getRGB != this.getRGB) {
            return false;
        }
        if (cellFont.length != this.length) {
            return false;
        }
        if (cellFont.readBoolean != this.readBoolean) {
            return false;
        }
        if (cellFont.readByte != this.readByte) {
            return false;
        }
        if (cellFont.readDouble != this.readDouble) {
            return false;
        }
        return cellFont.readInt == this.readInt;
    }

    public int hashCode() {
        return (int)this.SEDU + this.equals.hashCode() + (this.hashCode ? 1 : 0) + this.getRGB + (this.length ? 1 : 0) + (this.readBoolean ? 1 : 0) + this.readByte + (this.readDouble ? 1 : 0) + this.readInt;
    }

    void write(String string, String string2, XMLStreamWriter xMLStreamWriter) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement(string);
            xMLStreamWriter.writeEmptyElement("sz");
            xMLStreamWriter.writeAttribute("val", String.valueOf(this.SEDU));
            if (this.equals.length() > 0) {
                xMLStreamWriter.writeEmptyElement(string2);
                xMLStreamWriter.writeAttribute("val", this.equals);
            }
            if (this.hashCode) {
                xMLStreamWriter.writeEmptyElement("color");
                xMLStreamWriter.writeAttribute("rgb", Integer.toHexString(this.getRGB));
            }
            if (this.length) {
                xMLStreamWriter.writeEmptyElement("b");
            }
            if (this.readBoolean) {
                xMLStreamWriter.writeEmptyElement("i");
            }
            if (this.readByte != -1) {
                switch (this.readByte) {
                    case 2: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "double");
                        break;
                    }
                    case 34: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "doubleAccounting");
                        break;
                    }
                    case 0: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "none");
                        break;
                    }
                    case 1: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "single");
                        break;
                    }
                    case 33: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "singleAccounting");
                    }
                }
            }
            if (this.readDouble) {
                xMLStreamWriter.writeEmptyElement("strike");
            }
            if (this.readInt != 0) {
                switch (this.readInt) {
                    case 1: {
                        xMLStreamWriter.writeEmptyElement("vertAlign");
                        xMLStreamWriter.writeAttribute("val", "superscript");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeEmptyElement("vertAlign");
                        xMLStreamWriter.writeAttribute("val", "subscript");
                    }
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("The parameter name can not be null.");
        }
        this.equals = string;
    }

    public void setColor(int n) {
        this.getRGB = n;
        this.hashCode = true;
    }

    public void setSize(double d) {
        this.SEDU = d;
    }

    @Override
    public void setIsBold(boolean bl) {
        this.length = bl;
    }

    @Override
    public void setIsItalic(boolean bl) {
        this.readBoolean = bl;
    }

    @Override
    public void setUnderline(byte by) {
        this.readByte = by;
    }

    @Override
    public void setIsStruckout(boolean bl) {
        this.readDouble = bl;
    }

    @Override
    public void setFontColor(Color color) {
        this.getRGB = color.getRGB();
        this.hashCode = true;
    }

    @Override
    public void setSuperSubScript(short s) {
        this.readInt = s;
    }

    @Override
    public void setIsOutline(boolean bl) {
    }

    @Override
    public void setIsShadow(boolean bl) {
    }
}

