/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.BlankCellImp;
import jet.export.excel.imp.xlsx.BooleanCellImp;
import jet.export.excel.imp.xlsx.Cell;
import jet.export.excel.imp.xlsx.FormulaCellImp;
import jet.export.excel.imp.xlsx.LabelCellImp;
import jet.export.excel.imp.xlsx.Links;
import jet.export.excel.imp.xlsx.Merges;
import jet.export.excel.imp.xlsx.NumberCellImp;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

class InnerRow {
    private int SEDU;
    private double error = -1.0;
    private Cell getCellType;
    private Cell getCol;
    private boolean getColNum = false;
    private InnerRow getRowNum;
    private InnerRow isError;

    public InnerRow(int n) {
        this.SEDU = n;
    }

    public int getRowNum() {
        return this.SEDU;
    }

    public void setNextRow(InnerRow innerRow) {
        this.getRowNum = innerRow;
    }

    public InnerRow getNextRow() {
        return this.getRowNum;
    }

    public void setPrevRow(InnerRow innerRow) {
        this.isError = innerRow;
    }

    public InnerRow getPrevRow() {
        return this.isError;
    }

    public int setHeight(double d) {
        if (d >= 0.0) {
            if (this.error == -1.0) {
                this.error = d;
                this.getColNum = false;
                return 1;
            }
            this.error = d;
            this.getColNum = false;
            return 0;
        }
        return 0;
    }

    public double getHeight() {
        return this.error;
    }

    private void SEDU(Cell cell) {
        if (!cell.C() || this.getCol.C()) {
            Cell cell2 = this.getCol.Z();
            Cell cell3 = this.getCol.I();
            if (cell2 == null) {
                this.getCellType = cell;
            } else {
                cell2.I(cell);
                cell.Z(cell2);
            }
            if (cell3 != null) {
                cell3.Z(cell);
                cell.I(cell3);
            }
            this.getCol = cell;
        }
    }

    public int addCell(Cell cell) {
        short s = cell.getColNum();
        if (this.getCol == null) {
            this.getCellType = cell;
            this.getCol = cell;
            return 1;
        }
        short s2 = this.getCol.getColNum();
        if (s2 == s) {
            this.SEDU(cell);
            return 0;
        }
        if (s2 < s) {
            Cell cell2 = null;
            while (s2 < s) {
                cell2 = this.getCol.I();
                if (cell2 == null) {
                    cell.Z(this.getCol);
                    this.getCol.I(cell);
                    this.getCol = cell;
                    return 1;
                }
                s2 = cell2.getColNum();
                this.getCol = cell2;
            }
            if (s2 == s) {
                this.SEDU(cell);
                return 0;
            }
            cell2 = this.getCol.Z();
            cell2.I(cell);
            cell.Z(cell2);
            cell.I(this.getCol);
            this.getCol.Z(cell);
            this.getCol = cell;
            return 1;
        }
        Cell cell3 = null;
        while (s2 > s) {
            cell3 = this.getCol.Z();
            if (cell3 == null) {
                this.getCol.Z(cell);
                cell.I(this.getCol);
                this.getCellType = cell;
                this.getCol = cell;
                return 1;
            }
            s2 = cell3.getColNum();
            this.getCol = cell3;
        }
        if (s2 == s) {
            this.SEDU(cell);
            return 0;
        }
        cell3 = this.getCol.I();
        cell3.Z(cell);
        cell.I(cell3);
        cell.Z(this.getCol);
        this.getCol.I(cell);
        this.getCol = cell;
        return 1;
    }

    public int dump(DataOutput dataOutput) throws IOException {
        int n = 0;
        if (this.error != -1.0) {
            ++n;
        }
        dataOutput.writeDouble(this.error);
        for (Cell cell = this.getCellType; cell != null; cell = cell.I()) {
            dataOutput.write(cell.getCellType());
            dataOutput.writeShort(cell.getColNum());
            cell.I(dataOutput);
            ++n;
        }
        dataOutput.write(255);
        return n;
    }

    public static void skip(DataInput dataInput) throws IOException {
        dataInput.readDouble();
        byte by = dataInput.readByte();
        while (by != -1) {
            dataInput.readShort();
            switch (by) {
                case 0: {
                    BlankCellImp.skip(dataInput);
                    break;
                }
                case 4: {
                    BooleanCellImp.skip(dataInput);
                    break;
                }
                case 3: {
                    FormulaCellImp.skip(dataInput);
                    break;
                }
                case 2: {
                    LabelCellImp.skip(dataInput);
                    break;
                }
                case 1: {
                    NumberCellImp.skip(dataInput);
                }
            }
            by = dataInput.readByte();
        }
    }

    public int load(DataInput dataInput) throws IOException {
        int n;
        block28: {
            Cell cell;
            block31: {
                Cell cell2;
                block30: {
                    Cell cell3;
                    int n2;
                    block29: {
                        block27: {
                            n = 0;
                            double d = dataInput.readDouble();
                            if (d != -1.0) {
                                if (this.getColNum) {
                                    this.error = d;
                                } else if (this.error == -1.0) {
                                    this.error = d;
                                    this.getColNum = true;
                                    ++n;
                                }
                            }
                            n2 = 0;
                            cell2 = null;
                            cell3 = null;
                            byte by = dataInput.readByte();
                            while (by != -1) {
                                short s = dataInput.readShort();
                                cell = null;
                                switch (by) {
                                    case 0: {
                                        cell = new BlankCellImp(this.SEDU, s);
                                        break;
                                    }
                                    case 4: {
                                        cell = new BooleanCellImp(this.SEDU, s);
                                        break;
                                    }
                                    case 3: {
                                        cell = new FormulaCellImp(this.SEDU, s);
                                        break;
                                    }
                                    case 2: {
                                        cell = new LabelCellImp(this.SEDU, s);
                                        break;
                                    }
                                    case 1: {
                                        cell = new NumberCellImp(this.SEDU, s);
                                        break;
                                    }
                                    default: {
                                        RuntimeException runtimeException = new RuntimeException("Unknown cell type.");
                                        if (JRLog.isError(1)) {
                                            JRLog.error(1, runtimeException);
                                        }
                                        throw runtimeException;
                                    }
                                }
                                cell.I(dataInput);
                                if (cell2 == null) {
                                    cell2 = cell;
                                } else {
                                    cell3.I(cell);
                                    cell.Z(cell3);
                                }
                                cell3 = cell;
                                ++n2;
                                by = dataInput.readByte();
                            }
                            if (cell2 == null) {
                                return n;
                            }
                            if (this.getCol != null) break block27;
                            this.getCellType = cell2;
                            this.getCol = cell3;
                            n += n2;
                            break block28;
                        }
                        if (this.getCol.I() != null || this.getCol.getColNum() >= cell2.getColNum()) break block29;
                        this.getCol.I(cell2);
                        cell2.Z(this.getCol);
                        this.getCol = cell3;
                        n += n2;
                        break block28;
                    }
                    if (this.getCellType.getColNum() <= cell3.getColNum()) break block30;
                    this.getCellType.Z(cell3);
                    cell3.I(this.getCellType);
                    this.getCellType = cell2;
                    n += n2;
                    break block28;
                }
                Cell cell4 = this.getCellType;
                cell = cell2;
                if (cell4.getColNum() < cell.getColNum()) {
                    this.getCellType = cell4;
                    cell4 = cell4.I();
                } else if (cell4.getColNum() > cell.getColNum()) {
                    this.getCellType = cell;
                    cell = cell.I();
                    ++n;
                } else {
                    this.getCellType = cell4.C() ? cell : cell4;
                    cell4 = cell4.I();
                    cell = cell.I();
                }
                this.getCol = this.getCellType;
                while (cell4 != null && cell != null) {
                    if (cell4.getColNum() < cell.getColNum()) {
                        this.getCol.I(cell4);
                        cell4.Z(this.getCol);
                        this.getCol = cell4;
                        cell4 = cell4.I();
                        continue;
                    }
                    if (cell4.getColNum() > cell.getColNum()) {
                        this.getCol.I(cell);
                        cell.Z(this.getCol);
                        this.getCol = cell;
                        cell = cell.I();
                        ++n;
                        continue;
                    }
                    if (cell4.C()) {
                        this.getCol.I(cell);
                        cell.Z(this.getCol);
                        this.getCol = cell;
                    } else {
                        this.getCol.I(cell4);
                        cell4.Z(this.getCol);
                        this.getCol = cell4;
                    }
                    cell4 = cell4.I();
                    cell = cell.I();
                }
                if (cell4 == null) break block31;
                this.getCol.I(cell4);
                cell4.Z(this.getCol);
                this.getCol = cell4;
                for (cell4 = cell4.I(); cell4 != null; cell4 = cell4.I()) {
                    this.getCol = cell4;
                }
                break block28;
            }
            if (cell == null) break block28;
            this.getCol.I(cell);
            cell.Z(this.getCol);
            this.getCol = cell;
            cell = cell.I();
            ++n;
            while (cell != null) {
                this.getCol = cell;
                cell = cell.I();
                ++n;
            }
        }
        return n;
    }

    public void write(XMLStreamWriter xMLStreamWriter, Links links, Merges merges) throws IOException, XMLStreamException, XlsxDocumentException {
        xMLStreamWriter.writeStartElement("row");
        xMLStreamWriter.writeAttribute("r", String.valueOf(this.getRowNum() + 1));
        if (this.error != -1.0) {
            xMLStreamWriter.writeAttribute("ht", String.valueOf(this.error));
            xMLStreamWriter.writeAttribute("customHeight", "1");
        }
        int n = -2;
        int n2 = -1;
        for (Cell cell = this.getCellType; cell != null; cell = cell.I()) {
            n2 = cell.getCol();
            cell.write(xMLStreamWriter, links, merges, n + 1 < n2);
            n = n2;
        }
        xMLStreamWriter.writeEndElement();
    }
}

