/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.DumpableContainer;
import jet.export.excel.imp.xlsx.Link;
import jet.export.excel.imp.xlsx.TempFile;
import jet.export.excel.imp.xlsx.URLs;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.Util;

class Links
extends DumpableContainer {
    private URLs SEDU;

    public Links(TempFile tempFile, int n, URLs uRLs) {
        super(tempFile, n);
        this.SEDU = uRLs;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: The maximum count of links of every worksheet in memory is " + n);
        }
    }

    @Override
    protected void dump(DataOutputStream dataOutputStream, Object object) throws IOException {
        Object[] objectArray = (Object[])object;
        dataOutputStream.writeInt((Integer)objectArray[0]);
        dataOutputStream.writeShort(((Short)objectArray[1]).shortValue());
        ((Link)objectArray[2]).I(dataOutputStream);
    }

    @Override
    protected Object load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        short s = dataInputStream.readShort();
        Link link = new Link();
        link.I(dataInputStream);
        return new Object[]{n, s, link};
    }

    @Override
    protected void write(XMLStreamWriter xMLStreamWriter, Object object) throws XMLStreamException, IOException, XlsxDocumentException {
        Object[] objectArray = (Object[])object;
        Link link = (Link)objectArray[2];
        int n = link.getType();
        String string = null;
        if (n != 8 && (string = this.SEDU.add(link.getLinkStr(), true)) == null) {
            return;
        }
        xMLStreamWriter.writeEmptyElement("hyperlink");
        xMLStreamWriter.writeAttribute("ref", Util.colNumToStr(((Short)objectArray[1]).shortValue()) + ((Integer)objectArray[0] + 1));
        if (n == 8) {
            xMLStreamWriter.writeAttribute("location", link.getLinkStr());
        } else {
            xMLStreamWriter.writeAttribute("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id", string);
        }
        if (link.getToolTip() != null) {
            xMLStreamWriter.writeAttribute("tooltip", link.getToolTip());
        }
    }

    @Override
    protected void writeHead(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("hyperlinks");
    }

    @Override
    protected void writeTail(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeEndElement();
    }
}

