/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.PerformanceConfig;
import jet.export.excel.imp.xlsx.PicturePart;
import jet.export.excel.imp.xlsx.TempFile;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.TempFilesManager;
import jet.export.util.Cache;
import jet.util.MessageDigestMaker;

public class OPCPackage {
    public static final String NS_URI_DRAWINGML_CHART = "http://schemas.openxmlformats.org/drawingml/2006/chart";
    public static final String NS_URI_DRAWINGML_MAIN = "http://schemas.openxmlformats.org/drawingml/2006/main";
    public static final String NS_URI_DOC_RELATIONSHIPS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
    public static final String NS_URI_DRAWINGML_CHARTDRAWING = "http://schemas.openxmlformats.org/drawingml/2006/chartDrawing";
    public static final String NS_URI_PACKAGE_CONTENTTYPES = "http://schemas.openxmlformats.org/package/2006/content-types";
    public static final String NS_URI_PACKAGE_COREPROPS = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    public static final String NS_URI_PURL_DC = "http://purl.org/dc/elements/1.1/";
    public static final String NS_URI_PURL_DCTERMS = "http://purl.org/dc/terms/";
    public static final String NS_URI_PURL_DCMITYPE = "http://purl.org/dc/dcmitype/";
    public static final String NS_URI_W3C_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NS_URI_PACKAGE_RELATIONSHIPS = "http://schemas.openxmlformats.org/package/2006/relationships";
    public static final String NS_URI_SPREADSHEETML_MAIN = "http://schemas.openxmlformats.org/spreadsheetml/2006/main";
    public static final String NS_URI_DRAWINGML_SPREADSHEETDRAWING = "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing";
    public static final String NS_URI_OFFICE_SPREADSHEETML_2009_9 = "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main";
    public static final String NS_URI_OFFICE_EXCEL_2006 = "http://schemas.microsoft.com/office/excel/2006/main";
    public static final String NS_URI_XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private int SEDU = 0;
    private int append = 0;
    private int createXMLStreamWriter = 0;
    private int deleteAllTempFiles = 0;
    private TempFilesManager finish;
    private XMLOutputFactory flush;
    private TempFile generateString;
    private TempFile get;
    private PerformanceConfig getClass;
    private final String getName = "UTF-8";
    private Hashtable getPicCount = new Hashtable();
    private static MessageDigestMaker getProperty = new MessageDigestMaker();
    private ZipOutputStream isTrace;
    private Writer newInstance;

    public OPCPackage(Cache cache, PerformanceConfig performanceConfig) throws XlsxDocumentException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: The encoding is UTF-8.");
            JRLog.trace(6, "Xlsx API: The java version is " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + ".");
        }
        this.finish = new TempFilesManager(cache);
        this.flush = XMLOutputFactory.newInstance();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: The class name of the implementation of XMLOutputFactory is " + this.flush.getClass().getName() + ".");
        }
        this.getClass = performanceConfig;
    }

    public String getEncoding() {
        return this.getName;
    }

    public PicturePart getPicturePart(Image image) throws XlsxDocumentException {
        String string = getProperty.generateString(image);
        PicturePart picturePart = (PicturePart)this.getPicCount.get(string);
        if (picturePart == null) {
            int n = this.getPicCount() + 1;
            this.setPicCount(n);
            picturePart = new PicturePart(this, n, image);
            this.getPicCount.put(string, picturePart);
        }
        return picturePart;
    }

    ZipOutputStream I() {
        return this.isTrace;
    }

    Writer Z() {
        return this.newInstance;
    }

    XMLStreamWriter C() throws XMLStreamException {
        return this.flush.createXMLStreamWriter(this.newInstance);
    }

    XMLOutputFactory B() {
        return this.flush;
    }

    public PerformanceConfig getPerformanceConfig() {
        return this.getClass;
    }

    public TempFile getDrawingsTempFile() {
        if (this.generateString == null) {
            this.generateString = new TempFile(this.finish);
        }
        return this.generateString;
    }

    public TempFile getMergeLinkTempFile() {
        if (this.get == null) {
            this.get = new TempFile(this.finish);
        }
        return this.get;
    }

    public void setSheetCount(int n) {
        this.SEDU = n;
    }

    public int getSheetCount() {
        return this.SEDU;
    }

    public void setPicCount(int n) {
        this.append = n;
    }

    public int getPicCount() {
        return this.append;
    }

    public void setChartCount(int n) {
        this.createXMLStreamWriter = n;
    }

    public int getChartCount() {
        return this.createXMLStreamWriter;
    }

    public void setDrawingCount(int n) {
        this.deleteAllTempFiles = n;
    }

    public int getDrawingCount() {
        return this.deleteAllTempFiles;
    }

    public void free() throws XlsxDocumentException {
        this.finish.deleteAllTempFiles();
    }

    TempFilesManager D() {
        return this.finish;
    }

    void I(OutputStream outputStream) throws UnsupportedEncodingException, XMLStreamException {
        this.isTrace = new ZipOutputStream(outputStream);
        this.newInstance = new BufferedWriter(new OutputStreamWriter((OutputStream)this.isTrace, "UTF-8"));
    }

    void F() throws IOException, XMLStreamException {
        this.newInstance.flush();
        this.isTrace.finish();
    }
}

