/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.chart;

import com.jinfonet.util.JRLog;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.chart.BarColumnType;
import jet.export.excel.api.chart.Series1VInfo;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.BarSeries;
import jet.export.excel.imp.xlsx.chart.CombineChartType;
import jet.export.excel.imp.xlsx.chart.CommonChartType;

public class BarChartType
extends CommonChartType
implements CombineChartType,
BarColumnType {
    private byte SEDU = 0;
    private byte add = (byte)2;
    private short append = (short)-1;
    private short getSeriesByIndex = (short)-101;

    public BarChartType() {
        super("barChart");
    }

    public void setBarDirection(byte by) {
        this.add = by;
    }

    public void setOverlap(short s) {
        if (s < -100 || s > 100) {
            throw new IllegalArgumentException("The parameter overlapAmount can not be less than -100 or greater than 100.");
        }
        this.getSeriesByIndex = s;
    }

    @Override
    public boolean supportsXCategoryAxis() {
        return true;
    }

    @Override
    public boolean supportsXValueAxis() {
        return false;
    }

    @Override
    public boolean supportsYValueAxis() {
        return true;
    }

    @Override
    public boolean supportsZSeriesAxis() {
        return false;
    }

    @Override
    void write1stSpecificProps(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeEmptyElement("c", "barDir", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            if (this.add == 1) {
                xMLStreamWriter.writeAttribute("val", "bar");
            } else {
                xMLStreamWriter.writeAttribute("val", "col");
            }
            xMLStreamWriter.writeEmptyElement("c", "grouping", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            switch (this.SEDU) {
                case 6: {
                    xMLStreamWriter.writeAttribute("val", "percentStacked");
                    break;
                }
                case 2: {
                    xMLStreamWriter.writeAttribute("val", "stacked");
                    break;
                }
                case 0: {
                    xMLStreamWriter.writeAttribute("val", "standard");
                    break;
                }
                default: {
                    xMLStreamWriter.writeAttribute("val", "standard");
                    break;
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public boolean isHorizontal() {
        return this.add == 1;
    }

    @Override
    void write2ndSpecificProps(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            if (this.append != -1) {
                xMLStreamWriter.writeEmptyElement("c", "gapWidth", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("val", String.valueOf(this.append));
            }
            if (this.getSeriesByIndex != -101) {
                xMLStreamWriter.writeEmptyElement("c", "overlap", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("val", String.valueOf(this.getSeriesByIndex));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public void setGapWidth(int n) {
        if (n < 0 || n > 500) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + n + " (BarChartType.setGapWidth(int))");
            }
            return;
        }
        this.append = (short)n;
    }

    @Override
    public void setSubType(byte by) {
        this.SEDU = by;
    }

    @Override
    public byte getType() {
        return 5;
    }

    @Override
    public boolean is1VSeriesChartType() {
        return true;
    }

    @Override
    public boolean is2VSeriesChartType() {
        return false;
    }

    @Override
    public boolean is3VSeriesChartType() {
        return false;
    }

    @Override
    public void addSeries(Series1VInfo series1VInfo) {
        if (series1VInfo instanceof BarSeries) {
            this.seriesContainer.add((BarSeries)series1VInfo);
        }
    }

    @Override
    public Series1VInfo getSeries(int n) {
        return (BarSeries)this.getSeriesByIndex(n);
    }

    @Override
    public boolean isBar() {
        return this.add == 1;
    }

    @Override
    void prepareWriting() {
        if (this.SEDU == 2 || this.SEDU == 6) {
            if (this.getSeriesByIndex == -101) {
                this.getSeriesByIndex = (short)100;
            }
            this.supportedDataLabelPos = new byte[]{0, 6, 7, 5};
        } else {
            this.supportedDataLabelPos = new byte[]{0, 6, 7, 8, 5};
        }
    }

    @Override
    public boolean supportsXDateAxis() {
        return true;
    }
}

