/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.chart;

import com.jinfonet.util.JRLog;
import java.util.Arrays;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.FillInfo;
import jet.export.excel.api.chart.DataLabelInfo;
import jet.export.excel.api.chart.SeriesInfo;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.DataLabelFormatProps;
import jet.export.excel.imp.xlsx.chart.DataLabelGroupProps;
import jet.export.excel.imp.xlsx.chart.DataLabelProps;
import jet.export.excel.imp.xlsx.chart.DataPointProps;
import jet.export.excel.imp.xlsx.chart.SingleDataLabelProps;
import jet.export.excel.imp.xlsx.shapeprops.FillStyle;
import jet.export.excel.imp.xlsx.shapeprops.LineStyle;
import jet.export.excel.imp.xlsx.shapeprops.Shadow;
import jet.export.excel.imp.xlsx.shapeprops.TextProps;
import jet.export.excel.imp.xlsx.shapeprops.TextRunProps;

public abstract class Series
implements SeriesInfo {
    protected DataLabelGroupProps seriesDataLabelProps;
    private Hashtable createDefaultShadow = new Hashtable(0);
    private String getBorder;
    private String getFill;
    private Hashtable getFontProps = new Hashtable(0);
    protected boolean hasDataLabelProps = true;
    protected boolean hasDataPointProps = true;
    private LineStyle getPosition;
    private FillStyle getTextRotation;
    private Shadow intValue;
    private boolean isTrace = false;

    public void setName(String string) {
        this.getBorder = string;
        this.getFill = null;
    }

    public void setNameRef(String string) {
        this.getFill = string;
        this.getBorder = null;
    }

    public void setFill(FillStyle fillStyle) {
        this.getTextRotation = fillStyle;
    }

    LineStyle Z() {
        return this.getPosition;
    }

    public void setBorder(LineStyle lineStyle) {
        this.getPosition = lineStyle;
    }

    public void setShadow(Shadow shadow) {
        this.intValue = shadow;
    }

    public void setSeriesDataLabelProps(DataLabelGroupProps dataLabelGroupProps) {
        this.seriesDataLabelProps = dataLabelGroupProps;
    }

    public void setSingleDataLabelProps(SingleDataLabelProps singleDataLabelProps, int n) {
        if (n < 0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + n + " (Series.setSingleDataLabelProps(SingleDataLabelProps, int))");
            }
            return;
        }
        this.createDefaultShadow.put(n, singleDataLabelProps);
    }

    public void setDataPointProps(DataPointProps dataPointProps, int n) {
        if (n < 0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + n + " (Series.setDataPointProps(DataPointProps, int))");
            }
            return;
        }
        this.getFontProps.put(n, dataPointProps);
    }

    void write(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart, int n, byte[] byArray) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("c", "ser", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.writeEmptyElement("c", "idx", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.writeAttribute("val", String.valueOf(n));
            xMLStreamWriter.writeEmptyElement("c", "order", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.writeAttribute("val", String.valueOf(n));
            xMLStreamWriter.writeStartElement("c", "tx", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            if (this.getFill != null) {
                xMLStreamWriter.writeStartElement("c", "strRef", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeStartElement("c", "f", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeCharacters(this.getFill);
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
            } else {
                xMLStreamWriter.writeStartElement("c", "v", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                if (this.getBorder != null) {
                    xMLStreamWriter.writeCharacters(this.getBorder);
                }
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
            if (this.getTextRotation != null || this.getPosition != null || this.intValue != null) {
                xMLStreamWriter.writeStartElement("c", "spPr", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                if (this.getTextRotation != null) {
                    this.getTextRotation.write(xMLStreamWriter, noneRelsPart);
                }
                if (this.getPosition != null) {
                    this.getPosition.write(xMLStreamWriter, noneRelsPart);
                }
                if (this.intValue != null) {
                    this.intValue.write(xMLStreamWriter, noneRelsPart);
                }
                xMLStreamWriter.writeEndElement();
            }
            this.write1stSpecificProps(xMLStreamWriter, noneRelsPart);
            if (this.hasDataPointProps) {
                Object[] objectArray = this.getFontProps.keySet().toArray();
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    DataPointProps dataPointProps = (DataPointProps)this.getFontProps.get(object);
                    if (dataPointProps == null) continue;
                    dataPointProps.write(xMLStreamWriter, noneRelsPart, (Integer)object);
                }
            }
            if (this.hasDataLabelProps) {
                if (this.createDefaultShadow.size() > 0 && this.seriesDataLabelProps == null) {
                    this.seriesDataLabelProps = new DataLabelGroupProps();
                }
                if (this.seriesDataLabelProps != null) {
                    this.seriesDataLabelProps.write(xMLStreamWriter, noneRelsPart, this.createDefaultShadow, byArray);
                }
            }
            this.write2ndSpecificProps(xMLStreamWriter, noneRelsPart);
            this.writeSeriesData(xMLStreamWriter);
            this.write3rdSpecificProps(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    abstract void write1stSpecificProps(XMLStreamWriter var1, NoneRelsPart var2) throws XlsxDocumentException;

    abstract void write2ndSpecificProps(XMLStreamWriter var1, NoneRelsPart var2) throws XlsxDocumentException;

    abstract void write3rdSpecificProps(XMLStreamWriter var1) throws XlsxDocumentException;

    abstract void writeSeriesData(XMLStreamWriter var1) throws XlsxDocumentException;

    protected void writeValues(XMLStreamWriter xMLStreamWriter, String string, double[] dArray, boolean[] blArray, String string2) throws XlsxDocumentException {
        try {
            if (string != null) {
                xMLStreamWriter.writeStartElement("c", string2, "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeStartElement("c", "numRef", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeStartElement("c", "f", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeCharacters(string);
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
            } else if (dArray != null) {
                xMLStreamWriter.writeStartElement("c", string2, "http://schemas.openxmlformats.org/drawingml/2006/chart");
                this.writeValueArray(xMLStreamWriter, dArray, blArray);
                xMLStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    protected void writeValueArray(XMLStreamWriter xMLStreamWriter, double[] dArray, boolean[] blArray) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("c", "numLit", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.writeEmptyElement("c", "ptCount", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.writeAttribute("val", String.valueOf(dArray.length));
            for (int i = 0; i < dArray.length; ++i) {
                xMLStreamWriter.writeStartElement("c", "pt", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("idx", String.valueOf(i));
                xMLStreamWriter.writeStartElement("c", "v", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                if (blArray == null || !blArray[i]) {
                    xMLStreamWriter.writeCharacters(String.valueOf(dArray[i]));
                }
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public void setAreaInfo(int n, FillInfo fillInfo) {
        if (n < 0) {
            this.setFill((FillStyle)fillInfo);
        } else {
            DataPointProps dataPointProps = this.getDataPointProps(n);
            dataPointProps.setFill((FillStyle)fillInfo);
            this.isTrace = true;
        }
    }

    @Override
    public void setBorderInfo(int n, jet.export.excel.api.LineStyle lineStyle) {
        if (n < 0) {
            this.setBorder((LineStyle)lineStyle);
        } else {
            DataPointProps dataPointProps = this.getDataPointProps(n);
            dataPointProps.setBorder((LineStyle)lineStyle);
        }
    }

    @Override
    public void setIsShadow(int n, boolean bl) {
        if (n < 0) {
            if (bl) {
                Shadow shadow = Shadow.createDefaultShadow();
                this.setShadow(shadow);
            } else {
                this.setShadow(null);
            }
        } else {
            DataPointProps dataPointProps = this.getDataPointProps(n);
            if (bl) {
                Shadow shadow = Shadow.createDefaultShadow();
                dataPointProps.setShadow(shadow);
            } else {
                dataPointProps.setShadow(null);
            }
        }
    }

    protected DataPointProps getDataPointProps(int n) {
        DataPointProps dataPointProps = (DataPointProps)this.getFontProps.get(n);
        if (dataPointProps == null) {
            dataPointProps = new DataPointProps();
            this.setDataPointProps(dataPointProps, n);
        }
        return dataPointProps;
    }

    protected SingleDataLabelProps getDataLabelProps(int n) {
        SingleDataLabelProps singleDataLabelProps = (SingleDataLabelProps)this.createDefaultShadow.get(n);
        if (singleDataLabelProps == null) {
            singleDataLabelProps = new SingleDataLabelProps();
            this.setSingleDataLabelProps(singleDataLabelProps, n);
        }
        return singleDataLabelProps;
    }

    private void SEDU(DataLabelProps dataLabelProps, DataLabelFormatProps dataLabelFormatProps) {
        if (dataLabelFormatProps.getFontProps() != null || dataLabelFormatProps.getTextRotation() != Short.MAX_VALUE) {
            TextProps textProps = null;
            textProps = dataLabelFormatProps.getFontProps() != null ? new TextProps(dataLabelFormatProps.getFontProps()) : new TextProps(new TextRunProps());
            if (dataLabelFormatProps.getTextRotation() != Short.MAX_VALUE) {
                textProps.setRotation(dataLabelFormatProps.getTextRotation());
            }
            dataLabelProps.setTextProps(textProps);
        }
        if (dataLabelFormatProps.getFill() != null) {
            dataLabelProps.setFill(dataLabelFormatProps.getFill());
        }
        if (dataLabelFormatProps.getBorder() != null) {
            dataLabelProps.setBorder(dataLabelFormatProps.getBorder());
        }
        dataLabelProps.setPosition(dataLabelFormatProps.getPosition());
    }

    @Override
    public void setDataLabelInfo(int n, DataLabelInfo dataLabelInfo) {
        if (n < 0) {
            if (this.seriesDataLabelProps == null) {
                this.seriesDataLabelProps = new DataLabelGroupProps();
            }
            this.SEDU(this.seriesDataLabelProps, (DataLabelFormatProps)dataLabelInfo);
        } else {
            SingleDataLabelProps singleDataLabelProps = this.getDataLabelProps(n);
            this.SEDU(singleDataLabelProps, (DataLabelFormatProps)dataLabelInfo);
        }
    }

    @Override
    public void setIsShowCat(int n, boolean bl) {
        if (n < 0) {
            if (this.seriesDataLabelProps == null) {
                this.seriesDataLabelProps = new DataLabelGroupProps();
            }
            this.seriesDataLabelProps.setShowCatName(bl);
        } else {
            SingleDataLabelProps singleDataLabelProps = this.getDataLabelProps(n);
            singleDataLabelProps.setShowCatName(bl);
        }
    }

    @Override
    public void setIsShowSeriesName(int n, boolean bl) {
        if (n < 0) {
            if (this.seriesDataLabelProps == null) {
                this.seriesDataLabelProps = new DataLabelGroupProps();
            }
            this.seriesDataLabelProps.setShowSerName(bl);
        } else {
            SingleDataLabelProps singleDataLabelProps = this.getDataLabelProps(n);
            singleDataLabelProps.setShowSerName(bl);
        }
    }

    @Override
    public void setIsShowValue(int n, boolean bl) {
        if (n < 0) {
            if (this.seriesDataLabelProps == null) {
                this.seriesDataLabelProps = new DataLabelGroupProps();
            }
            this.seriesDataLabelProps.setShowValue(bl);
        } else {
            SingleDataLabelProps singleDataLabelProps = this.getDataLabelProps(n);
            singleDataLabelProps.setShowValue(bl);
        }
    }

    @Override
    public void setSeriesNameRef(String string) {
        this.setNameRef(string);
    }

    public void setShowLeaderLines(boolean bl) {
        if (this.seriesDataLabelProps == null) {
            this.seriesDataLabelProps = new DataLabelGroupProps();
        }
        this.seriesDataLabelProps.setShowLeaderLines(bl);
    }

    public void setLeaderLinesStyle(LineStyle lineStyle) {
        if (this.seriesDataLabelProps == null) {
            this.seriesDataLabelProps = new DataLabelGroupProps();
        }
        this.seriesDataLabelProps.setLeaderLinesStyle(lineStyle);
    }

    @Override
    public String getSeriesName() {
        return this.getBorder;
    }

    @Override
    public void setSeriesName(String string) {
        this.setName(string);
    }

    @Override
    public void setFormat(int n, String string) {
        if (n < 0) {
            if (this.seriesDataLabelProps == null) {
                this.seriesDataLabelProps = new DataLabelGroupProps();
            }
            this.seriesDataLabelProps.setNumFormat(string);
        } else {
            SingleDataLabelProps singleDataLabelProps = this.getDataLabelProps(n);
            singleDataLabelProps.setNumFormat(string);
        }
    }

    boolean C() {
        return this.isTrace;
    }
}

