/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.shapeprops;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.GradientInfo;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.shapeprops.FillStyle;

public class GradientFill
extends FillStyle
implements GradientInfo {
    public static final byte TYPE_LINEAR = 1;
    public static final byte TYPE_RECTANGLE = 2;
    private byte SEDU;
    private double add = -1.0;
    private boolean addGradientStop = false;
    private double append;
    private double doubleValue;
    private double get;
    private double getRGB;
    private Vector intValue = new Vector(2);

    public GradientFill(byte by) {
        this.SEDU = by;
    }

    public void setLinearAngle(double d) {
        if (d < 0.0 || d >= 360.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + d + " (GradientFill.setLinearAngle(double))");
            }
            return;
        }
        this.add = d;
    }

    public void setRectangle(double d, double d2, double d3, double d4) {
        this.append = d;
        this.get = d2;
        this.doubleValue = d3;
        this.getRGB = d4;
        this.addGradientStop = true;
    }

    public void addGradientStop(int n, double d, double d2) {
        if (d < 0.0 || d > 100.0 || d2 < 0.0 || d2 > 100.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + d + ", " + d2 + " (GradientFill.addGradientStop(int, double, double))");
            }
            return;
        }
        this.intValue.add(new Object[]{new Integer(n), new Double(d), new Double(d2)});
    }

    @Override
    public void write(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("a", "gradFill", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.writeStartElement("a", "gsLst", "http://schemas.openxmlformats.org/drawingml/2006/main");
            for (int i = 0; i < this.intValue.size(); ++i) {
                Object[] objectArray = (Object[])this.intValue.get(i);
                this.SEDU(xMLStreamWriter, (Integer)objectArray[0], (Double)objectArray[1], (Double)objectArray[2]);
            }
            if (this.intValue.size() == 0) {
                this.SEDU(xMLStreamWriter, -1, 0.0, 0.0);
                this.SEDU(xMLStreamWriter, -16777216, 0.0, 100.0);
            } else if (this.intValue.size() == 1) {
                this.SEDU(xMLStreamWriter, -16777216, 0.0, 100.0);
            }
            xMLStreamWriter.writeEndElement();
            if (this.SEDU == 2) {
                xMLStreamWriter.writeStartElement("a", "path", "http://schemas.openxmlformats.org/drawingml/2006/main");
                xMLStreamWriter.writeAttribute("path", "rect");
                if (this.addGradientStop) {
                    xMLStreamWriter.writeEmptyElement("a", "fillToRect", "http://schemas.openxmlformats.org/drawingml/2006/main");
                    xMLStreamWriter.writeAttribute("l", String.valueOf((int)(this.append * 1000.0)));
                    xMLStreamWriter.writeAttribute("r", String.valueOf((int)(this.doubleValue * 1000.0)));
                    xMLStreamWriter.writeAttribute("t", String.valueOf((int)(this.get * 1000.0)));
                    xMLStreamWriter.writeAttribute("b", String.valueOf((int)(this.getRGB * 1000.0)));
                }
                xMLStreamWriter.writeEndElement();
            } else {
                xMLStreamWriter.writeEmptyElement("a", "lin", "http://schemas.openxmlformats.org/drawingml/2006/main");
                if (this.add != -1.0) {
                    xMLStreamWriter.writeAttribute("ang", String.valueOf((int)(this.add * 60000.0)));
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    private void SEDU(XMLStreamWriter xMLStreamWriter, int n, double d, double d2) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("a", "gs", "http://schemas.openxmlformats.org/drawingml/2006/main");
        xMLStreamWriter.writeAttribute("pos", String.valueOf((int)(d2 * 1000.0)));
        xMLStreamWriter.writeStartElement("a", "srgbClr", "http://schemas.openxmlformats.org/drawingml/2006/main");
        xMLStreamWriter.writeAttribute("val", Integer.toHexString(n | 0xFF000000).substring(2).toUpperCase());
        xMLStreamWriter.writeEmptyElement("a", "alpha", "http://schemas.openxmlformats.org/drawingml/2006/main");
        xMLStreamWriter.writeAttribute("val", String.valueOf(100000 - (int)(d * 1000.0)));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    @Override
    public void addGradientStop(Color color, double d, double d2) {
        this.addGradientStop(color.getRGB(), d, d2);
    }
}

