/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.shapeprops;

import com.jinfonet.util.JRLog;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.ColorFillInfo;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.shapeprops.FillStyle;

public class SolidFill
extends FillStyle
implements ColorFillInfo {
    private int SEDU;
    private double append = -1.0;

    public SolidFill(int n) {
        this.SEDU = n;
    }

    @Override
    public void setTransparency(double d) {
        if (d < 0.0 || d > 100.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + d + " (SolidFill.setTransparency(double))");
            }
            return;
        }
        this.append = d;
    }

    @Override
    public void write(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("a", "solidFill", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.writeStartElement("a", "srgbClr", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.writeAttribute("val", Integer.toHexString(this.SEDU | 0xFF000000).substring(2).toUpperCase());
            if (this.append != -1.0) {
                xMLStreamWriter.writeEmptyElement("a", "alpha", "http://schemas.openxmlformats.org/drawingml/2006/main");
                xMLStreamWriter.writeAttribute("val", String.valueOf(100000 - (int)(this.append * 1000.0)));
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public boolean isNoFill() {
        return false;
    }
}

