/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.type1;

import java.awt.Color;
import jet.datastream.CTGridInfo;
import jet.datastream.DSBody;
import jet.datastream.DSCTField;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSParagraphText;
import jet.datastream.DSPicture;
import jet.datastream.DSSection;
import jet.datastream.DSShape;
import jet.datastream.DSTableRow;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.excel.api.ExcelFactory;
import jet.export.util.CCUtil;
import jet.udos.JHyperLinkRslt;
import jet.util.Containable;
import jet.util.image.ImageResource;

public class ExcelColor {
    private Color[] SEDU;
    private ExcelFactory black;
    private int blue = 0;
    private final int fillColor = 4;

    public ExcelColor(ExcelFactory excelFactory) {
        this.black = excelFactory;
        this.SEDU = new Color[4];
    }

    public ExcelFactory getExcelFactory() {
        return this.black;
    }

    public Color[] getFieldColor(DSField dSField) {
        Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
        Color color2 = CCUtil.getColorPropertyByName(dSField, "Background");
        Color color3 = CCUtil.getColorPropertyByName(dSField, "BorderColor");
        if (color == null) {
            color = Color.black;
        }
        this.SEDU[0] = color;
        if (color2 == null && !(dSField instanceof DSCTField)) {
            color2 = this.SEDU(color2, dSField);
        }
        this.SEDU[1] = color2;
        this.SEDU[2] = color3;
        this.SEDU[3] = CCUtil.getColorPropertyByName(dSField, "PatternColor");
        return this.SEDU;
    }

    private Color SEDU(Color color, JRVisiableResult jRVisiableResult) {
        ++this.blue;
        Containable containable = jRVisiableResult.getParent();
        if (containable != null && containable instanceof DSContainer) {
            int n;
            if ((containable instanceof DSSection || containable instanceof DSTableRow || containable instanceof DSBody) && (n = CCUtil.getIntPropertyByName((JRObjectResult)((Object)containable), "BackgroundType")) != 0) {
                this.blue = 0;
                return color;
            }
            color = CCUtil.getColorPropertyByName((DSContainer)containable, "Background");
            if (color == null && this.blue <= 4) {
                color = this.SEDU(color, (DSContainer)containable);
            } else {
                this.blue = 0;
            }
        } else {
            this.blue = 0;
        }
        return color;
    }

    public Color[] getShapeColor(DSShape dSShape, int n) {
        Color color;
        Color color2;
        this.SEDU[0] = null;
        if (n != 22) {
            color2 = CCUtil.getColorPropertyByName(dSShape, "BorderColor");
            color = CCUtil.getColorPropertyByName(dSShape, "Background");
        } else {
            color2 = CCUtil.getColorPropertyByName(dSShape, "LineColor");
            color = null;
        }
        this.SEDU[1] = color;
        this.SEDU[2] = color2;
        this.SEDU[3] = null;
        return this.SEDU;
    }

    public Color[] getParaTextColor(DSParagraphText dSParagraphText) {
        this.SEDU[2] = null;
        Color color = (Color)dSParagraphText.getPropertyByName("Foreground").getObject();
        Color color2 = (Color)dSParagraphText.getPropertyByName("Background").getObject();
        this.SEDU[0] = color;
        this.SEDU[1] = color2;
        this.SEDU[3] = null;
        return this.SEDU;
    }

    public Color[] getUDOColor(JRVisiableResult jRVisiableResult) {
        ImageResource imageResource;
        this.SEDU[2] = null;
        if (jRVisiableResult instanceof JHyperLinkRslt && ((imageResource = jRVisiableResult.getImgResourceByPropertyName("displayImage")) == null || imageResource.getImage() == null)) {
            Color color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
            Color color2 = (Color)jRVisiableResult.getPropertyByName("background").getObject();
            this.SEDU[0] = color;
            this.SEDU[1] = color2;
            return this.SEDU;
        }
        this.SEDU[0] = null;
        this.SEDU[1] = Color.blue;
        this.SEDU[3] = null;
        return this.SEDU;
    }

    public Color[] getPictureColor(DSPicture dSPicture, int n) {
        Color color;
        this.SEDU[2] = null;
        this.SEDU[1] = null;
        this.SEDU[0] = null;
        if (n == 129 && (color = CCUtil.getColorPropertyByName(dSPicture, "BorderColor")) != null) {
            this.SEDU[2] = color;
        }
        this.SEDU[3] = null;
        return this.SEDU;
    }

    public Color[] getCrosstabFieldColor(DSCTField dSCTField) {
        Color color;
        Object object;
        this.SEDU = this.getFieldColor(dSCTField);
        if (this.SEDU[1] == null && (object = dSCTField.getParentGridInfo()) != null && ((CTGridInfo)object).fillColor != null) {
            this.SEDU[1] = ((CTGridInfo)object).fillColor;
        }
        if (this.SEDU[1] == null && dSCTField.getParent() != null && (object = dSCTField.getParent()) instanceof DSContainer && (color = CCUtil.getColorPropertyByName((DSContainer)object, "Background")) != null) {
            this.SEDU[1] = color;
        }
        return this.SEDU;
    }

    public static int calculateColor(Color color) {
        return color.getRGB() & 0xFFFFFF;
    }
}

