/*
 * Decompiled with CFR 0.152.
 */
package jet.export.relayout.table;

import jet.datastream.DSTableObject;
import jet.export.relayout.table.LogicObj;
import jet.export.relayout.table.imp.AllFormatTool;
import jet.export.relayout.table.imp.BaseTool;
import jet.export.relayout.table.imp.CsvTool;
import jet.export.relayout.table.imp.ExcelTool;
import jet.export.relayout.table.imp.PdfTool;
import jet.export.relayout.table.imp.RemoveRow;
import jet.export.relayout.table.imp.TextTool;
import jet.export.relayout.table.imp.XmlTool;
import jet.export.util.ExportingInfo;

public abstract class VisibleRowTable {
    public static final byte ALL = 0;
    public static final byte EXCEL = 1;
    public static final byte TEXT = 2;
    public static final byte CSV = 3;
    public static final byte XML = 4;
    public static final byte HTML = 5;
    public static final byte PDF = 6;

    public static VisibleRowTable getInstance(DSTableObject dSTableObject, ExportingInfo exportingInfo, byte by) {
        BaseTool baseTool;
        RemoveRow removeRow = new RemoveRow();
        switch (by) {
            case 1: {
                baseTool = new ExcelTool(exportingInfo);
                break;
            }
            case 2: {
                baseTool = new TextTool(exportingInfo);
                break;
            }
            case 3: {
                baseTool = new CsvTool(exportingInfo);
                break;
            }
            case 4: {
                baseTool = new XmlTool(exportingInfo);
                break;
            }
            case 6: {
                baseTool = new PdfTool(exportingInfo);
                break;
            }
            default: {
                baseTool = new AllFormatTool(exportingInfo);
            }
        }
        removeRow.initial(dSTableObject, baseTool);
        return removeRow;
    }

    public abstract boolean hasMoreChild();

    public abstract LogicObj nextChild();

    public abstract boolean isHorTable();
}

