/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.imp;

import jet.export.rtf.api.BorderInfo;
import jet.export.rtf.api.GlobalDoc;
import jet.export.rtf.api.TableCell;
import jet.export.rtf.api.writer.TableCellWriter;
import jet.export.rtf.api.writer.TableRowWriter;

public class RtfTableRow
implements TableRowWriter {
    private StringBuffer SEDU;
    private GlobalDoc append;
    private boolean clear = true;
    private boolean getColor;

    public RtfTableRow(int n, int n2, GlobalDoc globalDoc) {
        this.append = globalDoc;
        this.SEDU = new StringBuffer("\\trowd \\irow");
        this.SEDU.append(n);
        this.SEDU.append("\\irowband").append(n);
        this.SEDU.append("\\trgaph0");
        this.SEDU.append("\\trleft").append(n2);
    }

    @Override
    public String getContents() {
        if (this.clear) {
            this.SEDU.append("\\row\n");
            this.clear = false;
        }
        return this.SEDU.toString();
    }

    @Override
    public void setLeftMargin(int n) {
        this.SEDU.append("\\trpaddfl3\\trpaddl").append(n);
    }

    @Override
    public void setTopMargin(int n) {
        this.SEDU.append("\\trpaddft3\\trpaddt").append(n);
    }

    @Override
    public void setRightMargin(int n) {
        this.SEDU.append("\\trpaddfr3\\trpaddr").append(n);
    }

    @Override
    public void setBottomMargin(int n) {
        this.SEDU.append("\\trpaddfb3\\trpaddb").append(n);
    }

    @Override
    public void addCell(TableCell tableCell) {
        this.SEDU.append(((TableCellWriter)tableCell).getContents());
        tableCell.clear();
    }

    @Override
    public void setIsLastRow(boolean bl) {
        if (bl) {
            this.SEDU.append("\\lastrow");
        }
    }

    @Override
    public void setIsFirstRow(boolean bl) {
        this.getColor = bl;
    }

    @Override
    public void setHeight(int n) {
        this.SEDU.append("\\trrh-").append(n).append("\\trftsWidth1\\trftsWidthB3\\trautofit1\n");
    }

    @Override
    public void setBorder(BorderInfo borderInfo, BorderInfo borderInfo2, BorderInfo borderInfo3, BorderInfo borderInfo4) {
        if (borderInfo != null) {
            if (borderInfo.getStyle() == 0) {
                this.SEDU.append("\\trbrdrl\\brdrs\\brdrw").append(borderInfo.getWidth());
                this.SEDU.append("\\brdrcf").append(this.append.getColorIndex(borderInfo.getColor())).append(" ");
            }
        } else {
            this.SEDU.append("\\trbrdrl\\brdrnone ");
        }
        if (borderInfo2 != null) {
            if (borderInfo2.getStyle() == 0) {
                this.SEDU.append("\\trbrdrt\\brdrs\\brdrw").append(borderInfo2.getWidth());
                this.SEDU.append("\\brdrcf").append(this.append.getColorIndex(borderInfo2.getColor())).append(" ");
            }
        } else {
            this.SEDU.append("\\trbrdrt\\brdrnone ");
        }
        if (borderInfo3 != null) {
            if (borderInfo3.getStyle() == 0) {
                this.SEDU.append("\\trbrdrr\\brdrs\\brdrw").append(borderInfo3.getWidth());
                this.SEDU.append("\\brdrcf").append(this.append.getColorIndex(borderInfo3.getColor())).append(" ");
            }
        } else {
            this.SEDU.append("\\trbrdrr\\brdrnone ");
        }
        if (borderInfo4 != null) {
            if (borderInfo4.getStyle() == 0) {
                this.SEDU.append("\\trbrdrb\\brdrs\\brdrw").append(borderInfo4.getWidth());
                this.SEDU.append("\\brdrcf").append(this.append.getColorIndex(borderInfo4.getColor())).append(" ");
            }
        } else {
            this.SEDU.append("\\trbrdrb\\brdrnone ");
        }
    }

    @Override
    public void setTopGap(int n) {
        if (n > 0) {
            this.SEDU.append("\\trspdt").append(n).append("\\trspdft3");
        }
    }

    @Override
    public void setBottomGap(int n) {
        if (n > 0) {
            this.SEDU.append("\\trspdb").append(n).append("\\trspdfb3");
        }
    }

    @Override
    public void setLeftRightGap(int n, int n2) {
        if (n > 0) {
            this.SEDU.append("\\trspdl").append(n).append("\\trspdfl3");
        }
        if (n2 > 0) {
            this.SEDU.append("\\trspdr").append(n2).append("\\trspdfr3");
        }
    }
}

