/*
 * Decompiled with CFR 0.152.
 */
package jet.export.text;

import com.jinfonet.awt.JFont;
import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import guitools.Painter;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.TextParameter;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSFilterControl;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSNavigateButton;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.DSTableObject;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderText;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.relayout.table.LogicObj;
import jet.export.relayout.table.LogicRow;
import jet.export.relayout.table.TableCellWrap;
import jet.export.relayout.table.VisibleRowTable;
import jet.export.text.TextCache;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.udo.JRObjectRender;
import jet.udo.TextGeneratable;
import jet.udos.JHyperLinkRslt;
import jet.udos.JHyperlinkLineInfo;
import jet.util.Propertiable;
import jet.util.TextBreaker;

public class ExportToText
extends AbstractExporter {
    public static final String EXP = ".txt";
    private static boolean IsForMail;
    private static boolean SEDU;
    private static String add;
    private boolean addElement;
    private boolean adjustJustifyString;
    private boolean adjustString;
    private boolean append = true;
    private boolean charAt;
    private int charsHeight;
    private int charsWidth;
    private int checkFilePathExist = -1;
    private int checkOutputStream;
    private int checkStop;
    private int clear;
    private String clipString;
    private ArrayList close;
    private Stack contains;
    private Stack convertUnitToPixel;
    private PrintWriter createFile;
    private boolean currentThread = false;
    private boolean currentTimeMillis = false;
    private TextCache deIndent;
    private ExportAuxInfo dx;
    private int dy = -1;
    private int elementAt = Integer.MAX_VALUE;
    private long empty = 0L;
    private long endsWith = 0L;
    private long exportToStream = 0L;
    private Hashtable fileUpdated = new Hashtable();

    private void IsForMail() {
        if (this.deIndent != null) {
            this.deIndent.clear();
            this.deIndent = null;
        }
        this.close.clear();
        this.close = null;
        this.fileUpdated.clear();
        this.fileUpdated = null;
    }

    public ExportToText(Communicator[] communicatorArray, TextParameter textParameter) {
        this._commuList = communicatorArray;
        this.charAt = JRLog.isError(2);
        this.fileUpdated(textParameter);
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.dx = exportAuxInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        this.checkFilePathExist(string);
        String string2 = string.endsWith(EXP) ? string : string + EXP;
        FileOutputStream fileOutputStream = null;
        try {
            this.dx.getDiskStore().createFile(string2);
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, string2, true);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        try {
            this.exportToStream(fileOutputStream);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                this.treatIOException(iOException, string2, true);
            }
        }
        try {
            this.dx.getDiskStore().fileUpdated(new File(string2));
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            throw new ExpException(iOException);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        return arrayList;
    }

    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        this.checkOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            this.SEDU(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, null, false);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        finally {
            if (this.deIndent != null) {
                this.deIndent.clear();
                this.deIndent = null;
            }
        }
        this.IsForMail();
    }

    private void SEDU(BufferedOutputStream bufferedOutputStream) throws IOException, ExpException, JRStopEngineException, OutOfSpaceException {
        this.deIndent = new TextCache(this.dx);
        this._commu = this._commuList[0];
        this.waitCommunicator();
        this._commuList(this._commu);
        long l = System.currentTimeMillis();
        boolean bl = JRLog.isTrace(5);
        if (bl) {
            JRLog.indent("Export to normal text");
            JRLog.trace(5, 4402001, new Timestamp(l));
        }
        if (this.charAt) {
            JRLog.indent("Export to normal text error element");
        }
        if (this.currentTimeMillis) {
            this.clipString = "UTF-8";
        }
        this.createFile = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, this.clipString));
        for (int i = 0; i < this._commuList.length; ++i) {
            this._commu = this._commuList[i];
            if (this._commu == null) {
                this.logCommunicatorNullInfo(i);
                continue;
            }
            this.waitCommunicator();
            this._commu(this._commu);
        }
        if (bl) {
            long l2 = System.currentTimeMillis();
            JRLog.trace(5, 4402002, new Timestamp(l2));
            JRLog.trace(5, 4402003, l2 - l - this.empty);
            JRLog.trace(5, "To String times(" + this.endsWith + ")");
            JRLog.trace(5, "Get font and get string width and height times(" + this.exportToStream + ")");
            JRLog.deIndent("Export to normal text");
        }
        if (JRLog.isAd()) {
            JRLog.print("Successed produce the normal text file");
        }
    }

    private void _commu(Communicator communicator) throws JRStopEngineException {
        this.add();
        CommEnumeration commEnumeration = new CommEnumeration(communicator);
        this.close = new ArrayList();
        int n = 0;
        while (commEnumeration.hasMoreElements()) {
            if (++n < this.dy) {
                commEnumeration.nextElement();
                continue;
            }
            ExportUtil.checkStop(communicator);
            this.convertUnitToPixel.insertElementAt(new Stack(), 0);
            long l = System.currentTimeMillis();
            DSPage dSPage = (DSPage)commEnumeration.nextElement();
            long l2 = System.currentTimeMillis();
            this.empty += l2 - l;
            this.adjustJustifyString(dSPage);
            if (n != this.elementAt) continue;
            break;
        }
        this.addElement();
        this.createFile.flush();
        if (this.charAt) {
            JRLog.deIndent("Export to normal text error element");
        }
    }

    private void _commuList(Communicator communicator) {
        this.currentThread = communicator.isHighPrecision();
        if (this.checkFilePathExist <= 0) {
            this.checkFilePathExist = communicator.getResolution();
        }
        this.clipString = communicator.getEncoding();
        if (this.clipString == null) {
            this.clipString = "UTF-8";
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5402006);
            }
        }
        this.deIndent.setResolution(this.checkFilePathExist);
    }

    private void add() {
        this.charsWidth = Integer.MAX_VALUE;
        this.charsHeight = Integer.MAX_VALUE;
        this.contains = new Stack();
        this.convertUnitToPixel = new Stack();
    }

    private void addElement() {
        int n = 0;
        int n2 = 0;
        while (!this.convertUnitToPixel.empty()) {
            int n3;
            Vector<StringBuffer> vector = new Vector<StringBuffer>();
            Stack stack = (Stack)this.convertUnitToPixel.pop();
            n = Integer.parseInt((String)this.close.get(n2++));
            n = this.endsWith(n);
            while (!stack.empty()) {
                int n4;
                TextBlock textBlock = (TextBlock)stack.pop();
                int n5 = this.charsWidth * textBlock.B.length();
                n3 = textBlock.C;
                n3 = n3 < 10 ? (n3 - 1) % 3 : 3;
                switch (n3) {
                    case 1: {
                        textBlock.x += (textBlock.I - n5) / 2;
                        break;
                    }
                    case 2: {
                        textBlock.x += textBlock.I - n5;
                    }
                }
                switch (textBlock.C) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 11: {
                        textBlock.y += (textBlock.Z - this.charsHeight) / 2;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: {
                        textBlock.y += textBlock.Z - this.charsHeight;
                    }
                }
                textBlock.x = textBlock.x < 0 ? 0 : textBlock.x;
                textBlock.y = textBlock.y < 0 ? 0 : textBlock.y;
                int n6 = this.exportToStream(textBlock.x);
                int n7 = this.endsWith(textBlock.y);
                for (n4 = n7 - vector.size(); n4 >= 0; --n4) {
                    vector.addElement(new StringBuffer());
                }
                StringBuffer stringBuffer = (StringBuffer)vector.elementAt(n7);
                for (n4 = n6 - stringBuffer.length(); n4 > 0; --n4) {
                    stringBuffer.append(' ');
                }
                for (n4 = n6; n4 < stringBuffer.length() && n4 < n6 + textBlock.B.length(); ++n4) {
                    stringBuffer.setCharAt(n4, textBlock.B.charAt(n4 - n6));
                }
                for (n4 = stringBuffer.length(); n4 < n6 + textBlock.B.length(); ++n4) {
                    stringBuffer.append(textBlock.B.charAt(n4 - n6));
                }
            }
            for (n3 = 0; n3 < vector.size(); ++n3) {
                StringBuffer stringBuffer = (StringBuffer)vector.elementAt(n3);
                if (this.adjustString && stringBuffer.length() > 0 || !this.adjustString) {
                    this.elementAt(stringBuffer);
                }
                this.createFile.print(stringBuffer.toString());
            }
            if (this.adjustString) continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n - vector.size(); i >= 0; --i) {
                this.elementAt(stringBuffer);
            }
            this.createFile.print(stringBuffer.toString());
        }
    }

    private void adjustJustifyString(DSPage dSPage) {
        this.contains.push(new Offset(0, 0));
        this.close.add(String.valueOf(this.getClass(dSPage.getPageArea().height)));
        for (int i = 0; i < dSPage.size(); ++i) {
            JRObjectResult jRObjectResult = this.dy(dSPage.getObject(i));
            int n = jRObjectResult.getObjectType();
            if (!this.empty(jRObjectResult)) continue;
            if ((n & 0x200) == 512) {
                this.adjustString((DSSection)jRObjectResult, 0);
                continue;
            }
            if (n != 262177) continue;
            this.deIndent.handleContainerBegin((DSBody)jRObjectResult);
            this.adjustString((DSBody)jRObjectResult, 0);
            this.deIndent.handleContainerEnd((DSBody)jRObjectResult);
        }
        this.contains.pop();
    }

    private void adjustString(DSContainer dSContainer, int n) {
        int n2 = dSContainer.getStartYPos();
        JRObjectResult jRObjectResult = null;
        Vector vector = dSContainer.getChildren();
        int n3 = vector.size();
        this.contains.push(new Offset((Offset)this.contains.peek(), this.getClass(dSContainer.getX()), this.getClass(this.getY(dSContainer, n))));
        for (int i = 0; i < n3; ++i) {
            jRObjectResult = this.dy((JRObjectResult)vector.get(i));
            this.append(jRObjectResult, n2);
        }
        this.contains.pop();
    }

    private void append(JRObjectResult jRObjectResult, int n) {
        if (this.empty(jRObjectResult)) {
            int n2 = jRObjectResult.getObjectType();
            if ((n2 & 0x20) == 32) {
                if (n2 == 262179) {
                    this.checkStop((DSTableObject)jRObjectResult, n);
                } else if (n2 == 262178) {
                    this.checkFilePathExist((DSParagraph)jRObjectResult, n);
                } else if (n2 == 262183) {
                    this.charAt((DSMultiValueContainer)jRObjectResult, n);
                } else {
                    this.deIndent.handleContainerBegin((DSContainer)jRObjectResult);
                    this.adjustString((DSContainer)jRObjectResult, n);
                    this.deIndent.handleContainerEnd((DSContainer)jRObjectResult);
                }
            } else if ((n2 & 0x100) == 256 && ((DSField)jRObjectResult).getStartLine() != -1) {
                this.close((DSField)jRObjectResult, n);
            } else if (n2 == 4096) {
                this.deIndent((JRVisiableResult)jRObjectResult, n);
            } else if ((n2 & 0x200) == 512) {
                this.adjustString((DSSection)jRObjectResult, n);
            } else if (jRObjectResult instanceof DSContainer) {
                this.adjustString((DSContainer)jRObjectResult, n);
            } else if (n2 == 524291) {
                this.clear((DSParagraphText)jRObjectResult, n);
            } else if (n2 == 65540) {
                this.charsWidth((DSFilterControl)jRObjectResult, n);
            } else if (n2 == 65541) {
                this.charsHeight((DSNavigateButton)jRObjectResult, n);
            } else if (JRLog.isAd()) {
                JRLog.print("now, can not treat this type! Type : " + n2 + " object is : " + jRObjectResult + " the parent : " + jRObjectResult.getParent());
            }
        }
    }

    private void charAt(DSMultiValueContainer dSMultiValueContainer, int n) {
        Render render = dSMultiValueContainer.getRender();
        if (render instanceof RenderDropDownList) {
            int n2;
            RenderDropDownList renderDropDownList = (RenderDropDownList)render;
            String string = null;
            String string2 = renderDropDownList.getSelectedTexts();
            Vector vector = renderDropDownList.getTexts();
            if (string2 != null && vector != null && vector.size() != 0) {
                string = vector.contains(string2) ? string2 : (String)vector.get(0);
            }
            if (string == null || string.length() == 0) {
                return;
            }
            Font font = render.getFont();
            Offset offset = (Offset)this.contains.peek();
            int n3 = this.getClass(dSMultiValueContainer.getX()) + offset.dx;
            int n4 = this.getClass(this.getY(dSMultiValueContainer, n)) + offset.dy;
            int n5 = this.getClass(dSMultiValueContainer.getWidth());
            int n6 = this.getClass(dSMultiValueContainer.getHeight());
            Integer n7 = (Integer)this.fileUpdated.get(font);
            if (n7 != null) {
                n2 = n7;
            } else {
                n2 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
                n7 = n2;
                this.fileUpdated.put(font, n7);
            }
            if (n2 <= 0) {
                return;
            }
            int n8 = this.createFile(1);
            int n9 = TextBreaker.charsWidth(string, font, this.currentThread);
            this.currentTimeMillis(n3, n4, n5, font.getSize(), string, n9, n2, n8);
        } else if (render instanceof RenderList) {
            RenderList renderList = (RenderList)render;
            Vector vector = renderList.getTexts();
            if (vector != null && vector.size() > 0) {
                int n10;
                Offset offset = (Offset)this.contains.peek();
                Font font = render.getFont();
                int n11 = this.getClass(dSMultiValueContainer.getX()) + offset.dx;
                int n12 = this.getClass(this.getY(dSMultiValueContainer, n)) + offset.dy;
                int n13 = this.getClass(dSMultiValueContainer.getWidth());
                int n14 = this.getClass(dSMultiValueContainer.getHeight());
                String string = (String)vector.get(0);
                Integer n15 = (Integer)this.fileUpdated.get(font);
                if (n15 != null) {
                    n10 = n15;
                } else {
                    n10 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
                    n15 = n10;
                    this.fileUpdated.put(font, n15);
                }
                if (n10 <= 0) {
                    return;
                }
                int n16 = n14 / (n10 + 1);
                if (n16 > vector.size()) {
                    n16 = vector.size();
                }
                for (int i = 0; i < n16; ++i) {
                    string = (String)vector.get(i);
                    int n17 = this.createFile(1);
                    int n18 = TextBreaker.charsWidth(string, font, this.currentThread);
                    this.currentTimeMillis(n11, n12, n13, font.getSize(), string, n18, n10, n17);
                    n12 += n10 + 1;
                }
            }
        } else {
            int n19;
            String string = dSMultiValueContainer.toString();
            if (render instanceof RenderText) {
                string = render.getText();
            }
            if (string == null || string.length() == 0) {
                return;
            }
            Font font = render.getFont();
            Offset offset = (Offset)this.contains.peek();
            int n20 = this.getClass(dSMultiValueContainer.getX()) + offset.dx;
            int n21 = this.getClass(this.getY(dSMultiValueContainer, n)) + offset.dy;
            int n22 = this.getClass(dSMultiValueContainer.getWidth());
            int n23 = this.getClass(dSMultiValueContainer.getHeight());
            Integer n24 = (Integer)this.fileUpdated.get(font);
            if (n24 != null) {
                n19 = n24;
            } else {
                n19 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
                n24 = n19;
                this.fileUpdated.put(font, n24);
            }
            if (n19 <= 0) {
                return;
            }
            int n25 = this.createFile(1);
            int n26 = TextBreaker.charsWidth(string, font, this.currentThread);
            this.currentTimeMillis(n20, n21, n22, font.getSize(), string, n26, n19, n25);
        }
    }

    private void charsHeight(DSNavigateButton dSNavigateButton, int n) {
        int n2;
        String string = dSNavigateButton.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        Render render = dSNavigateButton.getRender();
        Font font = render.getFont();
        Offset offset = (Offset)this.contains.peek();
        int n3 = this.getClass(dSNavigateButton.getX()) + offset.dx;
        int n4 = this.getClass(this.getY(dSNavigateButton, n)) + offset.dy;
        int n5 = this.getClass(dSNavigateButton.getWidth());
        int n6 = this.getClass(dSNavigateButton.getHeight());
        Integer n7 = (Integer)this.fileUpdated.get(font);
        if (n7 != null) {
            n2 = n7;
        } else {
            n2 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
            n7 = n2;
            this.fileUpdated.put(font, n7);
        }
        if (n2 <= 0) {
            return;
        }
        int n8 = this.createFile(1);
        int n9 = TextBreaker.charsWidth(string, font, this.currentThread);
        this.currentTimeMillis(n3, n4, n5, font.getSize(), string, n9, n2, n8);
    }

    private void charsWidth(DSFilterControl dSFilterControl, int n) {
        Render render = dSFilterControl.getRender();
        RenderList renderList = (RenderList)render;
        Vector vector = renderList.getTexts();
        if (vector != null && vector.size() > 0) {
            int n2;
            Offset offset = (Offset)this.contains.peek();
            Font font = render.getFont();
            int n3 = this.getClass(dSFilterControl.getX()) + offset.dx;
            int n4 = this.getClass(this.getY(dSFilterControl, n)) + offset.dy;
            int n5 = this.getClass(dSFilterControl.getWidth());
            int n6 = this.getClass(dSFilterControl.getHeight());
            String string = (String)vector.get(0);
            Integer n7 = (Integer)this.fileUpdated.get(font);
            if (n7 != null) {
                n2 = n7;
            } else {
                n2 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
                n7 = n2;
                this.fileUpdated.put(font, n7);
            }
            if (n2 <= 0) {
                return;
            }
            int n8 = n6 / (n2 + 1);
            if (n8 > vector.size()) {
                n8 = vector.size();
            }
            for (int i = 0; i < n8; ++i) {
                string = (String)vector.get(i);
                int n9 = this.createFile(1);
                int n10 = TextBreaker.charsWidth(string, font, this.currentThread);
                this.currentTimeMillis(n3, n4, n5, font.getSize(), string, n10, n2, n9);
                n4 += n2 + 1;
            }
        }
    }

    private void checkFilePathExist(DSParagraph dSParagraph, int n) {
        int n2;
        int n3;
        int n4;
        JRObjectResult jRObjectResult = null;
        Vector vector = dSParagraph.getChildren();
        ArrayList<JRVisiableResult> arrayList = new ArrayList<JRVisiableResult>(2);
        int n5 = vector.size();
        this.contains.push(new Offset((Offset)this.contains.peek(), this.getClass(dSParagraph.getX()), this.getClass(this.getY(dSParagraph, n))));
        int n6 = 0;
        int n7 = dSParagraph.getStartYPos();
        if (this.deIndent.hasContainer(dSParagraph)) {
            for (int i = 0; i < vector.size(); ++i) {
                jRObjectResult = (JRObjectResult)vector.get(i);
                n6 = jRObjectResult.getObjectType();
                this.append(jRObjectResult, n7);
            }
            this.contains.pop();
            return;
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < n5; ++i) {
            JRVisiableResult jRVisiableResult;
            jRObjectResult = (JRObjectResult)vector.get(i);
            n6 = jRObjectResult.getObjectType();
            if (n6 == 524291) {
                jRVisiableResult = (DSParagraphText)jRObjectResult;
                n4 = this.getClass(this.getY(jRVisiableResult, n7));
                n3 = this.getClass(jRVisiableResult.getHeight());
                n2 = jRVisiableResult.getX();
                this.checkOutputStream(n2, n4, n3, ((DSParagraphText)jRVisiableResult).getText(), vector2);
                continue;
            }
            if ((n6 & 0x100) != 256 || ((DSField)jRObjectResult).getStartLine() != 0 || !this.clipString((DSField)jRObjectResult)) continue;
            jRVisiableResult = (DSField)jRObjectResult;
            if (CCUtil.getIntPropertyByName(jRVisiableResult, "position") == 3) {
                arrayList.add(jRVisiableResult);
                continue;
            }
            n4 = this.getClass(this.getY(jRVisiableResult, n7));
            n3 = this.getClass(jRVisiableResult.getHeight());
            n2 = jRVisiableResult.getX();
            this.checkOutputStream(n2, n4, n3, ((DSField)jRVisiableResult).toString(), vector2);
        }
        Offset offset = (Offset)this.contains.peek();
        int n8 = this.getClass(dSParagraph.getWidth());
        n4 = 0;
        n3 = 0;
        n2 = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            Object object;
            Vector vector3 = (Vector)vector2.get(i);
            Vector<Object> vector4 = new Vector<Object>(vector3.size());
            for (int j = 0; j < vector3.size(); ++j) {
                int n9;
                object = (TextBlock)vector3.get(j);
                if (vector4.isEmpty()) {
                    vector4.add(object);
                    continue;
                }
                for (n9 = 0; n9 < vector4.size() && ((TextBlock)object).x >= ((TextBlock)vector4.get((int)n9)).x; ++n9) {
                }
                if (n9 < vector4.size()) {
                    vector4.insertElementAt(object, n9);
                    continue;
                }
                vector4.add(object);
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < vector4.size(); ++j) {
                if (j == 0) {
                    TextBlock textBlock = (TextBlock)vector4.get(j);
                    n4 = this.getClass(textBlock.x);
                    n3 = textBlock.y;
                    n2 = textBlock.Z;
                }
                stringBuffer.append(((TextBlock)vector4.get((int)j)).B);
            }
            object = stringBuffer.toString();
            n4 += offset.dx;
            n3 += offset.dy;
            if (((String)object).length() == 0) continue;
            this.currentTimeMillis(n4, n3, n8, n2, (String)object, n8, n2, -1);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            DSField dSField = (DSField)arrayList.get(i);
            if (dSField.getStartLine() == -1) continue;
            this.close(dSField, n7);
        }
        this.contains.pop();
    }

    private void checkOutputStream(int n, int n2, int n3, String string, Vector vector) {
        Vector vector2 = new Vector();
        Vector<TextBlock> vector3 = new Vector<TextBlock>();
        Vector vector4 = new Vector();
        if (vector.isEmpty()) {
            vector2 = new Vector();
            vector2.addElement(new TextBlock(n, n2, n3, string));
            vector.addElement(vector2);
        } else {
            TextBlock textBlock;
            int n4;
            boolean bl = true;
            for (n4 = 0; n4 < vector.size(); ++n4) {
                vector2 = (Vector)vector.get(n4);
                textBlock = (TextBlock)vector2.get(0);
                if (n2 == textBlock.y) {
                    vector2.addElement(new TextBlock(n, n2, n3, string));
                    bl = false;
                    break;
                }
                if (n2 >= textBlock.y - n3 / 2 && n2 < textBlock.y + n3 / 2 && textBlock.y + textBlock.Z > n2) {
                    vector2.addElement(new TextBlock(n, n2, n3, string));
                    bl = false;
                    break;
                }
                vector3 = new Vector();
                vector3.addElement(new TextBlock(n, n2, n3, string));
                if (n4 == 0 && n2 <= textBlock.y - n3 / 2) {
                    vector.insertElementAt(vector3, 0);
                    bl = false;
                    break;
                }
                if (n4 == vector.size() - 1 && (n2 > textBlock.y + n3 / 2 || n2 >= textBlock.y + textBlock.Z)) {
                    vector.addElement(vector3);
                    bl = false;
                    break;
                }
                if (n4 <= 0) continue;
                vector4 = (Vector)vector.elementAt(n4 - 1);
                TextBlock textBlock2 = (TextBlock)vector4.elementAt(0);
                if (n2 <= textBlock2.y + n3 / 2 || n2 > textBlock.y - n3 / 2) continue;
                vector.insertElementAt(vector3, n4);
                bl = false;
                break;
            }
            if (bl) {
                for (n4 = 0; n4 < vector.size(); ++n4) {
                    vector2 = (Vector)vector.elementAt(n4);
                    textBlock = (TextBlock)vector2.elementAt(0);
                    if (textBlock.y <= n2) continue;
                    vector3 = new Vector();
                    vector3.addElement(new TextBlock(n, n2, n3, string));
                    vector.insertElementAt(vector3, n4);
                    break;
                }
            }
        }
    }

    private void checkStop(DSTableObject dSTableObject, int n) {
        VisibleRowTable visibleRowTable = VisibleRowTable.getInstance(dSTableObject, this.deIndent, (byte)2);
        this.contains.push(new Offset((Offset)this.contains.peek(), this.getClass(dSTableObject.getX()), this.getClass(this.getY(dSTableObject, n))));
        while (visibleRowTable.hasMoreChild()) {
            LogicObj logicObj = visibleRowTable.nextChild();
            if (logicObj.getType() == 0) {
                LogicRow logicRow = (LogicRow)logicObj;
                this.contains.push(new Offset((Offset)this.contains.peek(), this.getClass(logicRow.getX()), this.getClass(logicRow.getY())));
                while (logicRow.hasMoreChild()) {
                    TableCellWrap tableCellWrap = logicRow.nextChild();
                    this.contains.push(new Offset((Offset)this.contains.peek(), this.getClass(tableCellWrap.getX()), this.getClass(tableCellWrap.getY())));
                    List list = tableCellWrap.getChildren();
                    int n2 = list.size();
                    for (int i = 0; i < n2; ++i) {
                        this.append((JRObjectResult)list.get(i), n);
                    }
                    this.contains.pop();
                }
                this.contains.pop();
                continue;
            }
            if (logicObj.getType() != 1) continue;
        }
        this.contains.pop();
    }

    private void clear(DSParagraphText dSParagraphText, int n) {
        Offset offset = (Offset)this.contains.peek();
        int n2 = this.getClass(dSParagraphText.getX() + dSParagraphText.getTextX()) + offset.dx;
        int n3 = this.getClass(dSParagraphText.getTextY() + dSParagraphText.getY()) + offset.dy;
        int n4 = this.getClass(dSParagraphText.getWidth());
        int n5 = this.getClass(dSParagraphText.getHeight());
        String string = dSParagraphText.getText();
        Font font = this.deIndent.getFont(dSParagraphText);
        int n6 = TextBreaker.charsWidth(string, font, this.currentThread);
        int n7 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
        this.currentTimeMillis(n2, n3, n4, n5, string, n6, n7, -1);
    }

    protected int getRenderType(DSField dSField) {
        Propertiable propertiable = dSField.getPropertyByName("renderType");
        if (propertiable != null) {
            return (Integer)propertiable.getObject();
        }
        return 0;
    }

    private boolean clipString(DSField dSField) {
        String string = dSField.toString();
        return string != null;
    }

    private void close(DSField dSField, int n) {
        int n2;
        long l = System.currentTimeMillis();
        String string = this.deIndent.getFieldValue(dSField);
        long l2 = System.currentTimeMillis();
        this.endsWith += l2 - l;
        if (string.length() == 0) {
            return;
        }
        Offset offset = (Offset)this.contains.peek();
        l = System.currentTimeMillis();
        Font font = this.deIndent.getFont(dSField);
        int n3 = this.getClass(dSField.getX()) + offset.dx;
        int n4 = this.getClass(this.getY(dSField, n)) + offset.dy;
        int n5 = this.getClass(dSField.getWidth());
        int n6 = this.getClass(dSField.getHeight());
        int n7 = this.dx(dSField);
        Integer n8 = (Integer)this.fileUpdated.get(font);
        if (n8 != null) {
            n2 = n8;
        } else {
            n2 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
            n8 = n2;
            this.fileUpdated.put(font, n8);
        }
        l2 = System.currentTimeMillis();
        this.exportToStream += l2 - l;
        if (n2 <= 0) {
            return;
        }
        int n9 = this.createFile(n7);
        if (n6 < n2) {
            n6 = n2;
        }
        int n10 = this.contains(dSField);
        if (dSField.isTextobjFieldable()) {
            string = TextBreaker.clipString(string, font, n9, n5, this.currentThread);
            int n11 = n10 == 0 ? n5 : TextBreaker.charsWidth(string, font, this.currentThread);
            this.currentTimeMillis(n3, n4, n5, n6, string, n11, n2, n7);
        } else {
            int[][] nArray = dSField.getLineBreakPos();
            if (nArray != null) {
                int n12;
                string = Painter.adjustString(string);
                int n13 = dSField.getStartLine();
                int n14 = dSField.getEndLine();
                int n15 = n12 = Math.min(nArray.length - 1, n14) < 0 ? 0 : Math.min(nArray.length - 1, n14);
                if (n13 < 0 && n14 < 0) {
                    n12 = 1;
                }
                n13 = n13 < 0 ? 0 : n13;
                int n16 = n12 - n13 + 1;
                for (int i = n13; i <= n12; ++i) {
                    boolean bl;
                    int n17;
                    String string2;
                    block34: {
                        string2 = "";
                        try {
                            if (string == null || string.length() == 0) break block34;
                            string2 = nArray[i][1] + nArray[i][0] < string.length() ? string.substring(nArray[i][0], nArray[i][0] + nArray[i][1]) : string.substring(nArray[i][0], string.length());
                        }
                        catch (Exception exception) {
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, exception);
                            }
                            if (this.listeners == null) continue;
                            for (n17 = 0; n17 < this.listeners.length; ++n17) {
                                this.listeners[n17].noteError(Thread.currentThread(), exception, 0, "");
                            }
                            continue;
                        }
                    }
                    int n18 = TextBreaker.charsWidth(string2, font, this.currentThread);
                    boolean bl2 = bl = n13 == n14;
                    if (!bl && n7 > 9) {
                        n17 = string2.length();
                        boolean bl3 = true;
                        char[] cArray = string2.toCharArray();
                        for (int j = 0; bl3 && j < cArray.length; bl3 &= cArray[j] == ' ' || cArray[j] == '\n', ++j) {
                        }
                        if (i == n12) {
                            bl3 = true;
                        }
                        if (!bl3) {
                            while ((n17 = string2.length()) > 0 && string2.charAt(n17 - 1) == ' ') {
                                string2 = string2.substring(0, string2.length() - 1);
                            }
                            while (n17 > 0 && string2.charAt(0) == ' ') {
                                string2 = string2.substring(1);
                                n17 = string2.length();
                            }
                            int n19 = string2.indexOf(32);
                            if (n19 > 0 && n19 < string2.length() - 1) {
                                int n20 = TextBreaker.charsWidth(" ", font, this.currentThread);
                                while ((n18 = TextBreaker.charsWidth(string2, font, this.currentThread)) < n5 - n20) {
                                    int n21 = (n5 - n18) / n20;
                                    string2 = Painter.adjustJustifyString(string2, n21);
                                }
                            }
                            n18 = TextBreaker.charsWidth(string2, font, this.currentThread);
                        }
                    }
                    this.currentThread(n3, n4, n5, n6, string2, n18, n2, n7, n16, i - n13);
                }
            } else if (dSField.getObjectType() == 260 && this.getChildren(dSField, "FieldType") == 14) {
                int n22;
                int n23;
                boolean bl = true;
                while ((n23 = string.indexOf(44)) != -1) {
                    if (!bl) {
                        n4 += n2;
                    } else {
                        bl = false;
                    }
                    String string3 = TextBreaker.clipString(string.substring(0, ++n23), font, n9, n5, this.currentThread);
                    n22 = TextBreaker.charsWidth(string3, font, this.currentThread);
                    this.currentTimeMillis(n3, n4, n5, n2, string3, n22, n2, n7);
                    string = string.substring(n23);
                    n4 += n2;
                }
                if (string.length() > 0) {
                    if (!bl) {
                        n4 += n2;
                    }
                    string = TextBreaker.clipString(string, font, n9, n5, this.currentThread);
                    n22 = n10 == 0 ? n5 : TextBreaker.charsWidth(string, font, this.currentThread);
                    this.currentTimeMillis(n3, n4, n5, bl ? n6 : n2, string, n22, n2, n7);
                }
            } else {
                int n24;
                if (dSField.getObjectType() == 257) {
                    string = TextBreaker.clipString(string, font, n9, n5, this.currentThread);
                }
                if (n10 == 0) {
                    n24 = n5;
                } else {
                    n24 = TextBreaker.charsWidth(string, font, this.currentThread);
                    if (n24 > n5) {
                        n5 = n24;
                    }
                }
                this.currentTimeMillis(n3, n4, n5, n6, string, n24, n2, n7);
            }
        }
    }

    private int contains(DSField dSField) {
        return CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
    }

    private int createFile(int n) {
        int n2 = n < 10 ? (n - 1) % 3 : 3;
        return n2;
    }

    private void currentThread(int n, int n2, int n3, int n4, String string, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        if (string.length() <= 0) {
            return;
        }
        int n11 = n6 - n4;
        if (n11 > 0 && n11 < n4 / 2) {
            n6 = n4;
        } else {
            n10 = 0;
            switch (n7) {
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    n10 = (n4 - n6 * n8) / 2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    n10 = n4 - n6 * n8;
                }
            }
            n2 = n2 + n10 + n6 * n9;
        }
        int n12 = n7 < 10 ? (n7 - 1) % 3 : 3;
        switch (n12) {
            case 1: {
                n += (n3 - n5) / 2;
                break;
            }
            case 2: {
                n += n3 - n5;
            }
        }
        n3 = n5;
        n4 = n6;
        n10 = n3 / string.length();
        this.charsWidth = n10 < this.charsWidth ? n10 : this.charsWidth;
        this.charsHeight = n6 < this.charsHeight ? n6 : this.charsHeight;
        ((Stack)this.convertUnitToPixel.elementAt(0)).insertElementAt(new TextBlock(n, n2, n3, n4, n7, string, this.clear), 0);
    }

    private void currentTimeMillis(int n, int n2, int n3, int n4, String string, int n5, int n6, int n7) {
        int n8 = n6 - n4;
        if (n8 > 0 && n8 < n4 / 2) {
            n6 = n4;
        }
        if (string.length() > 0 && n4 - n6 / 2 > 0) {
            int n9 = n7 < 10 ? (n7 - 1) % 3 : 3;
            switch (n9) {
                case 1: {
                    n += (n3 - n5) / 2;
                    break;
                }
                case 2: {
                    n += n3 - n5;
                }
            }
            n3 = n5;
            switch (n7) {
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    n2 += (n4 - n6) / 2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    n2 += n4 - n6;
                }
            }
            n4 = n6;
            int n10 = n3 / string.length();
            this.charsWidth = n10 < this.charsWidth ? n10 : this.charsWidth;
            this.charsHeight = n6 < this.charsHeight ? n6 : this.charsHeight;
            ((Stack)this.convertUnitToPixel.elementAt(0)).insertElementAt(new TextBlock(n, n2, n3, n4, n7, string, this.clear), 0);
        }
    }

    private void deIndent(JRVisiableResult jRVisiableResult, int n) {
        JRObjectRender jRObjectRender;
        String string = null;
        boolean bl = jRVisiableResult instanceof TextGeneratable;
        try {
            jRObjectRender = (JRObjectRender)DynamicClassManager.getInstance().getClass((String)jRVisiableResult.getPropertyByName("UDORenderName").getObject()).newInstance();
        }
        catch (Exception exception) {
            jRObjectRender = null;
        }
        if (jRObjectRender != null) {
            jRObjectRender.setProperty(jRVisiableResult);
            if (bl) {
                string = ((TextGeneratable)((Object)jRVisiableResult)).toText();
                if (string == null || string.length() == 0) {
                    return;
                }
                Offset offset = (Offset)this.contains.peek();
                int n2 = this.getClass(jRVisiableResult.getX()) + offset.dx;
                int n3 = this.getClass(this.getY(jRVisiableResult, n)) + offset.dy;
                int n4 = this.getClass(jRVisiableResult.getWidth());
                int n5 = this.getClass(jRVisiableResult.getHeight());
                Font font = this.deIndent.getUdoFont(jRVisiableResult);
                int n6 = (Integer)jRVisiableResult.getPropertyByName("Alignment").getObject();
                boolean bl2 = font instanceof JFont;
                int n7 = TextBreaker.charsWidth(string, font, this.currentThread);
                int n8 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
                int n9 = this.createFile(n6);
                string = TextBreaker.clipString(string, font, n9, n4, this.currentThread);
                n7 = TextBreaker.charsWidth(string, font, this.currentThread);
                this.currentTimeMillis(n2, n3, n4, n5, string, n7, n8, n6);
            } else if (jRVisiableResult instanceof JHyperLinkRslt) {
                JHyperLinkRslt jHyperLinkRslt = (JHyperLinkRslt)jRVisiableResult;
                List list = jHyperLinkRslt.getLines();
                Offset offset = (Offset)this.contains.peek();
                int n10 = this.getClass(jRVisiableResult.getX()) + offset.dx;
                int n11 = this.getClass(this.getY(jRVisiableResult, n)) + offset.dy;
                int n12 = this.getClass(jRVisiableResult.getWidth());
                int n13 = this.getClass(jRVisiableResult.getHeight());
                if (list != null && list.size() != 0) {
                    Font font = this.deIndent.getUdoFont(jRVisiableResult);
                    int n14 = this.dx(jRVisiableResult);
                    int n15 = list.size();
                    int n16 = this.createFile(n14);
                    if (n15 > 1) {
                        for (int i = 0; i < n15; ++i) {
                            JHyperlinkLineInfo jHyperlinkLineInfo = (JHyperlinkLineInfo)list.get(i);
                            String string2 = jHyperlinkLineInfo.getLine();
                            int n17 = TextBreaker.charsWidth(string2, font, this.currentThread);
                            int n18 = (int)((double)TextBreaker.charsHeight(string2, font, this.currentThread) + 0.5);
                            this.currentThread(n10, n11, n12, n13, string2, n17, n18, n14, n15, i);
                        }
                    } else {
                        JHyperlinkLineInfo jHyperlinkLineInfo = (JHyperlinkLineInfo)list.get(0);
                        string = jHyperlinkLineInfo.getLine();
                        string = TextBreaker.clipString(string, font, n16, n12, this.currentThread);
                        int n19 = TextBreaker.charsWidth(string, font, this.currentThread);
                        int n20 = (int)((double)TextBreaker.charsHeight(string, font, this.currentThread) + 0.5);
                        this.currentTimeMillis(n10, n11, n12, n13, string, n19, n20, n14);
                    }
                }
            }
        }
    }

    private int dx(JRVisiableResult jRVisiableResult) {
        int n = CCUtil.getIntPropertyByName(jRVisiableResult, "HorizontalAlignment");
        int n2 = CCUtil.getIntPropertyByName(jRVisiableResult, "VerticalAlignment");
        int n3 = 5;
        switch (n) {
            case 2: {
                if (n2 == 1) {
                    n3 = 2;
                    break;
                }
                if (n2 == 0) {
                    n3 = 5;
                    break;
                }
                n3 = 8;
                break;
            }
            case 0: {
                if (n2 == 1) {
                    n3 = 1;
                    break;
                }
                if (n2 == 0) {
                    n3 = 4;
                    break;
                }
                n3 = 7;
                break;
            }
            case 1: {
                if (n2 == 1) {
                    n3 = 3;
                    break;
                }
                if (n2 == 0) {
                    n3 = 6;
                    break;
                }
                n3 = 9;
                break;
            }
            default: {
                n3 = n2 == 1 ? 10 : (n2 == 0 ? 11 : 12);
            }
        }
        return n3;
    }

    private int getY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        if (jRVisiableResult.getStartYPos() != 0) {
            JRObjectResult jRObjectResult;
            int n4 = 0;
            if (jRVisiableResult instanceof DSSection && ((jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                n4 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartYPos());
            }
            n3 = (n2 = n4) > 0 ? n2 : 0;
        }
        return n3;
    }

    private JRObjectResult dy(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult.getObjectType();
        while (n == 8192) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    private void elementAt(StringBuffer stringBuffer) {
        if (this.adjustJustifyString) {
            if (this.addElement) {
                stringBuffer.append("\r\n");
            } else {
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append(add);
        }
    }

    private boolean empty(JRObjectResult jRObjectResult) {
        boolean bl = this.deIndent.isExport(jRObjectResult);
        if (bl) {
            int n = jRObjectResult.getObjectType();
            switch (n) {
                case 513: 
                case 514: 
                case 515: 
                case 2561: 
                case 2563: {
                    if (!this.append) {
                        DSContainer dSContainer = (DSContainer)jRObjectResult;
                        this.clear -= this.getClass(dSContainer.getHeight());
                    }
                }
                case 516: 
                case 517: 
                case 518: 
                case 2562: 
                case 2564: {
                    bl = this.append;
                    break;
                }
                case 34: {
                    break;
                }
                case 33: 
                case 37: 
                case 45: {
                    bl = !((DSSubReport)jRObjectResult).isError();
                    break;
                }
            }
        }
        return bl;
    }

    private int endsWith(int n) {
        if (SEDU && this.checkOutputStream > this.charsHeight) {
            this.charsHeight = this.checkOutputStream;
        }
        return Math.round((float)n / (float)this.charsHeight);
    }

    private int exportToStream(int n) {
        if (IsForMail && this.checkStop > this.charsWidth) {
            this.charsWidth = this.checkStop;
        }
        if (this.charsWidth < 1) {
            return n;
        }
        return Math.round((float)n / (float)this.charsWidth);
    }

    private void fileUpdated(TextParameter textParameter) {
        if (textParameter != null) {
            this.flush(textParameter.isForWinExport());
            this.append = textParameter.isHasHeadFoot();
            this.getBooleanPropertyByName(textParameter.getResolution());
            this.get(textParameter.getUDCHWidth(), textParameter.getUDCHHeight());
            this.adjustString = textParameter.isCompress();
            this.currentTimeMillis = textParameter.IsForMail();
            if (JRLog.isTrace(5)) {
                JRLog.indent("normal text parameters");
                JRLog.trace(5, 5402001, "" + textParameter.isHasHeadFoot());
                JRLog.trace(5, 5402002, "" + textParameter.isForWinExport());
                JRLog.trace(5, 5402003, "" + textParameter.getResolution());
                JRLog.trace(5, 5402004, "" + textParameter.getUDCHWidth() + "*" + textParameter.getUDCHHeight());
                JRLog.trace(5, 5402005, "" + textParameter.isCompress());
                JRLog.deIndent("normal text parameters");
            }
        } else if (JRLog.isTrace(5)) {
            JRLog.indent("normal text parameters, it use default parameter");
            JRLog.deIndent("normal text parameters, it use default parameter");
        }
    }

    private void flush(boolean bl) {
        this.addElement = bl;
        this.adjustJustifyString = true;
    }

    private void get(int n, int n2) {
        if (n < 0 && n2 > 0) {
            this.checkOutputStream = n2;
            SEDU = true;
        }
        if (n > 0 && n2 < 0) {
            this.checkStop = n;
            IsForMail = true;
        }
        if (n > 0 && n2 > 0 && n < 11) {
            this.checkStop = n;
            this.checkOutputStream = n2;
            IsForMail = true;
            SEDU = true;
        }
    }

    private void getBooleanPropertyByName(int n) {
        if (n > 0) {
            this.checkFilePathExist = n;
        }
    }

    private int getChildren(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    private int getClass(int n) {
        return Unit.convertUnitToPixel(n, this.checkFilePathExist);
    }

    static {
        add = System.getProperty("line.separator");
    }

    private class TextBlock {
        int x;
        int y;
        int I;
        int Z;
        int C;
        String B;

        TextBlock(int n, int n2, int n3, int n4, int n5, String string, int n6) {
            this.x = n;
            this.y = n2;
            this.I = n3;
            this.Z = n4;
            this.C = n5;
            this.B = string;
        }

        TextBlock(int n, int n2, int n3, String string) {
            this.x = n;
            this.y = n2;
            this.Z = n3;
            this.B = string;
        }
    }
}

