/*
 * Decompiled with CFR 0.152.
 */
package jet.export.text;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.StringTokenizer;
import jet.JRStopEngineException;
import jet.bean.TextParameter;
import jet.datastream.DSBody;
import jet.datastream.DSField;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.RenderText;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.text.CSVCache;

abstract class SDFTextBase
extends AbstractExporter {
    public static final String EXP = ".txt";
    protected static final String CSV = ".csv";
    protected static String lineSeparator = System.getProperty("line.separator");
    protected char delimiter = (char)32;
    protected char quoteMark = (char)34;
    protected boolean forWin;
    protected boolean hasHeadFoot = true;
    protected boolean hasSetSystem;
    protected boolean isCompress;
    protected boolean isRepeat;
    protected boolean isCSV;
    protected boolean useQuoteMark = true;
    protected boolean useDelimiter;
    protected PrintWriter textwriter;
    protected CSVCache cache;
    protected ExportAuxInfo exportAuxInfo;

    SDFTextBase() {
    }

    protected void getParameters(TextParameter textParameter) {
        this.SEDU(textParameter.isForWinExport());
        this.hasHeadFoot = textParameter.isHasHeadFoot();
        this.isCompress = textParameter.isCompress();
        this.isRepeat = textParameter.isRepeat();
        this.useDelimiter = textParameter.isUseDelimiter();
        if (this.useDelimiter) {
            this.setDelimiter(textParameter.getDelimiter());
        }
        this.useQuoteMark = textParameter.isUseQuoteMark();
        if (JRLog.isTrace(5)) {
            JRLog.indent("sdf text parameters");
            JRLog.trace(5, 5402101, "" + textParameter.isHasHeadFoot());
            JRLog.trace(5, 5402102, "" + textParameter.isForWinExport());
            JRLog.trace(5, 5402103, "" + textParameter.getResolution());
            JRLog.trace(5, 5402104, "" + textParameter.isUseQuoteMark());
            JRLog.trace(5, 5402105, "" + textParameter.isCompress());
            JRLog.trace(5, 5402106, "" + textParameter.getDelimiter() + "flag(" + this.useDelimiter + ")");
            JRLog.trace(5, 5402107, "" + textParameter.isRepeat());
            JRLog.deIndent("sdf text parameters");
        }
    }

    protected void free() {
    }

    protected void setDelimiter(char c) {
        this.delimiter = c;
        if (c == ',') {
            this.isCSV = true;
        }
    }

    private void SEDU(boolean bl) {
        this.forWin = bl;
        this.hasSetSystem = true;
    }

    protected void publish(BufferedOutputStream bufferedOutputStream) throws IOException, JRStopEngineException, ExpException, OutOfSpaceException {
        this._commu = this._commuList[0];
        this.waitCommunicator();
        String string = this._commu.getEncoding();
        if (string == null) {
            string = "UTF-8";
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5402006);
            }
        }
        this.textwriter = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, string));
    }

    protected void writePage(DSPage dSPage, boolean bl) {
        int n = dSPage.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = dSPage.getObject(i);
            jRObjectResult = this.getFactOject(jRObjectResult);
            int n2 = jRObjectResult.getObjectType();
            if (!this.canExportToCSV(jRObjectResult)) continue;
            if ((n2 & 0x200) == 512) {
                this.writeSection((DSSection)jRObjectResult, 0, bl);
                continue;
            }
            if (n2 != 262177) continue;
            this.writeBody((DSBody)jRObjectResult, 0, bl);
        }
    }

    protected final JRObjectResult getFactOject(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult.getObjectType();
        while (n == 8192) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    protected abstract void writeSection(DSSection var1, int var2, boolean var3);

    protected abstract void writeBody(DSBody var1, int var2, boolean var3);

    protected String getParagraphValue(DSParagraph dSParagraph) {
        List list = this.zOrder(dSParagraph.getChildren());
        int n = list.size();
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string;
                Object object;
                JRVisiableResult jRVisiableResult;
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
                if (!this.canExportToCSV(jRObjectResult)) continue;
                if (jRObjectResult instanceof DSParagraphText) {
                    jRVisiableResult = (DSParagraphText)jRObjectResult;
                    object = ((DSParagraphText)jRVisiableResult).getText();
                    if (object == null) continue;
                    stringBuffer.append((String)object);
                    continue;
                }
                if (!(jRObjectResult instanceof DSField) || !((object = ((DSField)(jRVisiableResult = (DSField)jRObjectResult)).getRender()) instanceof RenderText) || (string = ((DSField)jRVisiableResult).toString()) == null) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    protected final boolean canExportToCSV(JRObjectResult jRObjectResult) {
        return this.cache.isExport(jRObjectResult);
    }

    protected final String prepareText(String string) {
        boolean bl = false;
        String string2 = "";
        if (string != null && string.length() > 0) {
            if (this.useDelimiter && string.indexOf(this.delimiter) >= 0) {
                bl = true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",\"", true);
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (",".equals(string3)) {
                    bl = true;
                    stringBuffer.append(",");
                    continue;
                }
                if ("\"".equals(string3)) {
                    bl = true;
                    stringBuffer.append("\"\"");
                    continue;
                }
                stringBuffer.append(string3);
            }
            string2 = stringBuffer.toString();
            if (bl && !this.useQuoteMark) {
                string2 = this.quoteMark + string2 + this.quoteMark;
            }
        }
        return string2;
    }

    protected final void addLineSeparator(StringBuffer stringBuffer) {
        if (this.hasSetSystem) {
            if (this.forWin) {
                stringBuffer.append("\r\n");
            } else {
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append(lineSeparator);
        }
    }

    protected final List zOrder(List list) {
        return list;
    }

    protected boolean isTextField(DSField dSField) {
        return this.cache.isTextField(dSField);
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.exportAuxInfo = exportAuxInfo;
    }
}

