/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.datastream.DSBody;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterForm;
import jet.datastream.DSSubReport;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.Cache;
import jet.export.util.FontInfo;
import jet.export.util.FontToolkit;
import jet.util.Propertiable;
import jet.util.nls.INLSMap;

public class ExportCache
implements Cache {
    private Map canBeCatch = new HashMap();
    private int createTempFile = 110;
    private String createTempFolder;
    private File delete;
    private List fileUpdated = new ArrayList();
    private Hashtable getChildren = new Hashtable();
    private boolean getCurrentINLSMap = false;
    private DiskStore getDiskStore;
    private FontToolkit getFontInfo;

    public ExportCache(ExportAuxInfo exportAuxInfo, String string) {
        this.createTempFolder = string == null || string.trim().length() == 0 ? "export" : string;
        this.getDiskStore = exportAuxInfo.getDiskStore();
        this.getFontInfo = new FontToolkit();
    }

    public void setMaxCacheSizeOfRender(int n) {
        this.createTempFile = n < 20 ? 20 : n;
    }

    public int getCachedRenderNumber() {
        return this.canBeCatch.size();
    }

    @Override
    public Render getRender(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Render render = (Render)this.canBeCatch.get(dSTemplatible);
        if (render == null) {
            render = dSField.getRender();
            if (this.canBeCatch.size() < this.createTempFile && render.canBeCatch()) {
                this.canBeCatch.put(dSTemplatible, render);
            }
        } else {
            render.updateRender(dSField);
        }
        return render;
    }

    @Override
    public void clear() {
        if (this.canBeCatch != null) {
            this.canBeCatch.clear();
        }
        if (this.fileUpdated != null) {
            for (int i = 0; i < this.fileUpdated.size(); ++i) {
                File file = (File)this.fileUpdated.get(i);
                this.delete(file);
            }
            this.fileUpdated.clear();
        }
        if (this.getChildren != null) {
            this.getChildren.clear();
        }
        if (this.delete != null) {
            this.delete(this.delete);
            this.delete = null;
        }
        if (this.getFontInfo != null) {
            this.getFontInfo.clear();
        }
    }

    @Override
    public File getTemporaryPath() throws OutOfSpaceException, IOException {
        if (this.delete == null) {
            this.delete = this.getDiskStore.createTempFolder(this.createTempFolder);
        }
        return this.delete;
    }

    @Override
    public File getNextTemporaryFile() throws IOException, OutOfSpaceException {
        if (this.delete == null) {
            this.delete = this.getDiskStore.createTempFolder(this.createTempFolder);
        }
        File file = this.getDiskStore.createTempFile(this.delete.getName(), this.createTempFolder, null);
        this.fileUpdated.add(file);
        return file;
    }

    @Override
    public boolean hasContainer(DSParagraph dSParagraph) {
        Vector vector = dSParagraph.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            int n = jRObjectResult.getObjectType();
            if (n != 262185 && n != 262184) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTextField(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Object v = this.getChildren.get(dSTemplatible);
        if (v != null) {
            return (Boolean)v;
        }
        Propertiable propertiable = dSField.getPropertyByName("renderType");
        if (propertiable != null) {
            int n = (Integer)propertiable.getObject();
            if (n == 0 || n == 4) {
                this.getChildren.put(dSTemplatible, Boolean.TRUE);
                return true;
            }
            this.getChildren.put(dSTemplatible, Boolean.FALSE);
            return false;
        }
        this.getChildren.put(dSTemplatible, Boolean.TRUE);
        return true;
    }

    public void setIsOneHeaderFooter(boolean bl) {
        this.getCurrentINLSMap = bl;
    }

    @Override
    public boolean isOneHeaderFooter() {
        return this.getCurrentINLSMap;
    }

    @Override
    public void fileUpdated(File file) throws OutOfSpaceException, IOException {
        this.getDiskStore.fileUpdated(file);
    }

    @Override
    public void delete(File file) {
        this.getDiskStore.delete(file);
    }

    @Override
    public boolean isExport(JRObjectResult jRObjectResult) {
        return !CCUtil.getBooleanPropertyByName(jRObjectResult, "Invisible");
    }

    @Override
    public FontInfo getFontInfo(DSField dSField) {
        return this.getFontInfo.getFontInfo(dSField);
    }

    @Override
    public FontInfo getFontInfo(DSParagraph dSParagraph) {
        return this.getFontInfo.getFontInfo(dSParagraph);
    }

    @Override
    public FontInfo getFontInfo(DSParagraphText dSParagraphText) {
        return this.getFontInfo.getFontInfo(dSParagraphText);
    }

    @Override
    public FontInfo getUdoFontInfo(JRVisiableResult jRVisiableResult) {
        return this.getFontInfo.getUdoFontInfo(jRVisiableResult);
    }

    @Override
    public FontInfo getFontInfo(DSParameterForm dSParameterForm) {
        return this.getFontInfo.getFontInfo(dSParameterForm);
    }

    @Override
    public FontInfo getFontInfo(JRVisiableResult jRVisiableResult) {
        return this.getFontInfo.getFontInfo(jRVisiableResult);
    }

    @Override
    public void handleContainerBegin(DSContainer dSContainer) {
        this.getFontInfo.handleContainerBegin(dSContainer);
    }

    @Override
    public void handleContainerEnd(DSContainer dSContainer) {
        this.getFontInfo.handleContainerEnd(dSContainer);
    }

    protected INLSMap getCurrentINLSMap() {
        return this.getFontInfo.getCurrentINLSMap();
    }

    protected void setCurrentINLSMap(INLSMap iNLSMap) {
        this.getFontInfo.setCurrentINLSMap(iNLSMap);
    }

    @Override
    public void handleContainerBegin(DSBody dSBody) {
        this.getFontInfo.handleContainerBegin(dSBody);
    }

    @Override
    public void handleContainerEnd(DSBody dSBody) {
        this.getFontInfo.handleContainerEnd(dSBody);
    }

    @Override
    public void handleContainerBegin(DSSubReport dSSubReport) {
        this.getFontInfo.handleContainerBegin(dSSubReport);
    }

    @Override
    public void handleContainerEnd(DSSubReport dSSubReport) {
        this.getFontInfo.handleContainerEnd(dSSubReport);
    }

    @Override
    public String getFormat() {
        return this.createTempFolder;
    }
}

