/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetClobBaseString;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import com.jinfonet.util.JRLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbBuffer;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine8.util.dataswap.ArrayTool;
import jet.ie.PJFAux;

public class RecordDataTool {
    private int SEDU = 0;
    private int abs = 0;
    private final int append;
    private final int array2Bytes;
    private byte[] arraycopy = null;
    private boolean bytes2Array = false;
    private int dataLength = 0;
    private int[] decimalNeedBytes = null;
    private int[] doubleToRawLongBits = null;
    private int error = 0;

    public RecordDataTool(RecordModelInfo recordModelInfo) {
        this.append = recordModelInfo.getColDescs().length;
        this.SEDU = this.array2Bytes = this.append << 2;
        this.decimalNeedBytes = new int[this.append + 1];
        this.doubleToRawLongBits = new int[this.append + 1];
        for (int i = 1; i <= this.append; ++i) {
            DbColDesc dbColDesc = recordModelInfo.getColDesc(i - 1);
            this.decimalNeedBytes[i] = Types.sqlTypeToType(dbColDesc.getSqlType());
            this.doubleToRawLongBits[i] = this.SEDU(dbColDesc.isReadOnly(), this.decimalNeedBytes[i]);
            this.error += Types.swapDataLength(this.decimalNeedBytes[i]) + 4;
        }
        this.arraycopy = new byte[this.error];
    }

    private int SEDU(boolean bl, int n) {
        if (bl) {
            return 0;
        }
        int n2 = Types.dataLength(n);
        return n2;
    }

    public byte[] getRecordData() {
        return this.arraycopy;
    }

    public int getRecordSize() {
        return this.SEDU;
    }

    public void resetRecordSize(int n) {
        this.arraycopy = new byte[n];
    }

    public void setDataLength(int n) {
        this.dataLength = n;
        this.reset();
    }

    public void setRecord(byte[] byArray) {
        if (this.arraycopy.length < byArray.length) {
            byte[] byArray2 = new byte[byArray.length];
            this.arraycopy = byArray2;
        }
        System.arraycopy(byArray, 0, this.arraycopy, 0, byArray.length);
    }

    public void putByte(byte by) {
        this.error(1);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(-6);
        this.arraycopy[this.SEDU++] = by;
    }

    public byte getByte(int n) {
        return this.abs(-6, n);
    }

    private byte abs(int n, int n2) {
        this.getDataTypeName(n, n2);
        int n3 = this.get(n2);
        this.bytes2Array = this.getColDesc(n2);
        if (this.bytes2Array) {
            return 0;
        }
        return this.arraycopy[n3 + 1];
    }

    public void putBoolean(boolean bl) {
        this.error(1);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(-7);
        this.arraycopy[this.SEDU++] = bl ? (byte)1 : 0;
    }

    public boolean getBoolean(int n) {
        return this.abs(-7, n) == 1;
    }

    public void putShort(short s) {
        this.error(2);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(5);
        this.arraycopy[this.SEDU++] = (byte)s;
        this.arraycopy[this.SEDU++] = (byte)(s >> 8);
    }

    public short getShort(int n) {
        this.getDataTypeName(5, n);
        int n2 = this.get(n);
        this.bytes2Array = this.getColDesc(n);
        if (this.bytes2Array) {
            return 0;
        }
        return (short)(this.arraycopy[n2 + 2] << 8 | this.arraycopy[n2 + 1] & 0xFF);
    }

    public void putInt(int n) {
        this.error(4);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(4);
        this.arraycopy[this.SEDU++] = (byte)n;
        this.arraycopy[this.SEDU++] = (byte)(n >> 8);
        this.arraycopy[this.SEDU++] = (byte)(n >> 16);
        this.arraycopy[this.SEDU++] = (byte)(n >> 24);
    }

    public int getInt(int n) {
        this.getDataTypeName(4, n);
        int n2 = this.get(n);
        this.bytes2Array = this.getColDesc(n);
        if (this.bytes2Array) {
            return 0;
        }
        return this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF;
    }

    public void putFloat(float f) {
        this.error(4);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(6);
        int n = Float.floatToIntBits(f);
        this.arraycopy[this.SEDU++] = (byte)n;
        this.arraycopy[this.SEDU++] = (byte)(n >> 8);
        this.arraycopy[this.SEDU++] = (byte)(n >> 16);
        this.arraycopy[this.SEDU++] = (byte)(n >> 24);
    }

    public float getFloat(int n) {
        this.getDataTypeName(6, n);
        this.bytes2Array = this.getColDesc(n);
        if (this.bytes2Array) {
            return 0.0f;
        }
        int n2 = this.get(n);
        return Float.intBitsToFloat(this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF);
    }

    public void putLong(long l) {
        this.error(8);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(-5);
        this.arraycopy[this.SEDU++] = (byte)l;
        this.arraycopy[this.SEDU++] = (byte)(l >> 8);
        this.arraycopy[this.SEDU++] = (byte)(l >> 16);
        this.arraycopy[this.SEDU++] = (byte)(l >> 24);
        this.arraycopy[this.SEDU++] = (byte)(l >> 32);
        this.arraycopy[this.SEDU++] = (byte)(l >> 40);
        this.arraycopy[this.SEDU++] = (byte)(l >> 48);
        this.arraycopy[this.SEDU++] = (byte)(l >> 56);
    }

    private final void append(long l, int n) {
        this.error(8);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(n);
        this.arraycopy[this.SEDU++] = (byte)l;
        this.arraycopy[this.SEDU++] = (byte)(l >> 8);
        this.arraycopy[this.SEDU++] = (byte)(l >> 16);
        this.arraycopy[this.SEDU++] = (byte)(l >> 24);
        this.arraycopy[this.SEDU++] = (byte)(l >> 32);
        this.arraycopy[this.SEDU++] = (byte)(l >> 40);
        this.arraycopy[this.SEDU++] = (byte)(l >> 48);
        this.arraycopy[this.SEDU++] = (byte)(l >> 56);
    }

    public long getLong(int n) {
        return this.array2Bytes(-5, n);
    }

    private long array2Bytes(int n, int n2) {
        this.getDataTypeName(n, n2);
        this.bytes2Array = this.getColDesc(n2);
        if (this.bytes2Array) {
            return 0L;
        }
        int n3 = this.get(n2);
        return (long)this.arraycopy[n3 + 8] << 56 | ((long)this.arraycopy[n3 + 7] & 0xFFL) << 48 | ((long)this.arraycopy[n3 + 6] & 0xFFL) << 40 | ((long)this.arraycopy[n3 + 5] & 0xFFL) << 32 | ((long)this.arraycopy[n3 + 4] & 0xFFL) << 24 | ((long)this.arraycopy[n3 + 3] & 0xFFL) << 16 | ((long)this.arraycopy[n3 + 2] & 0xFFL) << 8 | (long)this.arraycopy[n3 + 1] & 0xFFL;
    }

    public void putDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        this.append(l, 8);
    }

    public double getDouble(int n) {
        return Double.longBitsToDouble(this.array2Bytes(8, n));
    }

    public void putBigDecimal(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        this.error(n + 4);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(3);
        int n2 = bigDecimal.scale();
        this.arraycopy[this.SEDU++] = (byte)n2;
        this.arraycopy[this.SEDU++] = (byte)(n2 >> 8);
        this.arraycopy[this.SEDU++] = (byte)(n2 >> 16);
        this.arraycopy[this.SEDU++] = (byte)(n2 >> 24);
        for (int i = 0; i < n; ++i) {
            this.arraycopy[this.SEDU++] = byArray[i];
        }
    }

    public BigDecimal getBigDecimal(int n) {
        this.getDataTypeName(3, n);
        this.bytes2Array = this.getColDesc(n);
        if (this.bytes2Array) {
            return null;
        }
        int n2 = this.get(n);
        int n3 = this.getColLength(n2, n);
        int n4 = this.arraycopy[n2 + 4] << 24 | (this.arraycopy[n2 + 3] & 0xFF) << 16 | (this.arraycopy[n2 + 2] & 0xFF) << 8 | this.arraycopy[n2 + 1] & 0xFF;
        byte[] byArray = new byte[n3 - 4];
        int n5 = 0;
        int n6 = n2 + 5;
        while (n5 < byArray.length) {
            byArray[n5] = this.arraycopy[n6];
            ++n5;
            ++n6;
        }
        return new BigDecimal(new BigInteger(byArray), n4);
    }

    public void putDate(Date date) {
        this.append(date.getTime(), 91);
    }

    public void putDate(long l) {
        this.append(l, 91);
    }

    public Date getDate(int n) {
        return new JinfonetDate(this.array2Bytes(91, n));
    }

    public void putTimeStamp(Timestamp timestamp) {
        this.append(timestamp.getTime(), 93);
    }

    public void putTimeStamp(long l) {
        this.append(l, 93);
    }

    public Timestamp getTimeStamp(int n) {
        return new JinfonetTimeStamp(this.array2Bytes(93, n));
    }

    public void putTime(Time time) {
        this.append(time.getTime(), 92);
    }

    public void putTime(long l) {
        this.append(l, 92);
    }

    public Time getTime(int n) {
        return new JinfonetTime(this.array2Bytes(92, n));
    }

    public void putString(String string) {
        byte[] byArray = null;
        if (string != null) {
            try {
                byArray = string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JRLog.error(2, unsupportedEncodingException);
            }
        }
        this.dataLength(byArray, 12);
    }

    public String getString(int n) {
        byte[] byArray = this.decimalNeedBytes(12, n);
        try {
            return byArray == null ? null : new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JRLog.error(2, unsupportedEncodingException);
            return byArray == null ? null : new String(byArray);
        }
    }

    public void putBlob(Blob blob) throws DSException {
        if (blob == null) {
            this.putNull(-2);
            return;
        }
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        this.putBytes(byArray);
    }

    public Blob getBlob(int n) {
        this.getDataTypeName(2004, n);
        this.bytes2Array = this.getColDesc(n);
        if (this.bytes2Array) {
            return null;
        }
        byte[] byArray = this.arraycopy(n);
        return new JinfonetBlobBaseBytes(byArray);
    }

    private byte[] arraycopy(int n) {
        int n2 = this.get(n);
        int n3 = this.getColLength(n2, n);
        if (n3 < 0) {
            this.getColLength(n2, n);
        }
        this.bytes2Array = this.getColDesc(n);
        if (this.bytes2Array) {
            return null;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.arraycopy, n2 + 1, byArray, 0, n3);
        return byArray;
    }

    public void putClob(Clob clob) throws DSException {
        if (clob == null) {
            this.putNull(12);
            return;
        }
        this.putString(clob.getSubString(1L, (int)clob.length()));
    }

    public Clob getClob(int n) {
        this.getDataTypeName(2005, n);
        this.bytes2Array = this.getColDesc(n);
        if (this.bytes2Array) {
            return null;
        }
        String string = this.bytes2Array(n);
        return new JinfonetClobBaseString(string);
    }

    private String bytes2Array(int n) {
        byte[] byArray = this.decimalNeedBytes(2005, n);
        try {
            return byArray == null ? null : new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JRLog.error(2, unsupportedEncodingException);
            return byArray == null ? null : new String(byArray);
        }
    }

    public void putBytes(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.error(byArray.length);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(-2);
        for (int i = 0; i < byArray.length; ++i) {
            this.arraycopy[this.SEDU++] = byArray[i];
        }
    }

    private void dataLength(byte[] byArray, int n) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.error(byArray.length);
        this.floatToIntBits(this.abs++, this.SEDU);
        this.getColDescs(n);
        for (int i = 0; i < byArray.length; ++i) {
            this.arraycopy[this.SEDU++] = byArray[i];
        }
    }

    public byte[] getBytes(int n) {
        return this.decimalNeedBytes(-2, n);
    }

    private byte[] decimalNeedBytes(int n, int n2) {
        this.getDataTypeName(n, n2);
        this.bytes2Array = this.getColDesc(n2);
        if (this.bytes2Array) {
            return null;
        }
        int n3 = this.get(n2);
        int n4 = this.getColLength(n3, n2);
        byte[] byArray = new byte[n4];
        System.arraycopy(this.arraycopy, n3 + 1, byArray, 0, n4);
        return byArray;
    }

    public int putRecord() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.abs = 0;
        this.SEDU = this.array2Bytes;
        this.bytes2Array = false;
    }

    public void putNull(int n) {
        this.error(0);
        this.floatToIntBits(this.abs++, -this.SEDU);
        this.getColDescs(n);
        this.SEDU += this.doubleToRawLongBits[this.abs];
    }

    public boolean wasNull() {
        return this.bytes2Array;
    }

    private int doubleToRawLongBits(int n) {
        if (n <= 500) {
            return (int)(2.0f * (float)n);
        }
        if (n <= 1000) {
            return (int)(1.5f * (float)n);
        }
        return (int)(1.2f * (float)n);
    }

    private void error(int n) {
        if (this.arraycopy.length <= this.SEDU + n) {
            byte[] byArray = new byte[this.doubleToRawLongBits(this.SEDU + n)];
            System.arraycopy(this.arraycopy, 0, byArray, 0, this.arraycopy.length);
            this.arraycopy = byArray;
        }
    }

    private void floatToIntBits(int n, int n2) {
        int n3 = n << 2;
        this.arraycopy[n3] = (byte)n2;
        this.arraycopy[n3 + 1] = (byte)(n2 >> 8);
        this.arraycopy[n3 + 2] = (byte)(n2 >> 16);
        this.arraycopy[n3 + 3] = (byte)(n2 >> 24);
    }

    private int get(int n) {
        if (n < 1 || n > this.append) {
            throw new IllegalStateException("columnIndex " + n + " Out of range , current range is :" + this.append);
        }
        int n2 = n - 1 << 2;
        int n3 = this.arraycopy[n2 + 3] << 24 | (this.arraycopy[n2 + 2] & 0xFF) << 16 | (this.arraycopy[n2 + 1] & 0xFF) << 8 | this.arraycopy[n2] & 0xFF;
        return Math.abs(n3);
    }

    private boolean getColDesc(int n) {
        if (n < 1 || n > this.append) {
            throw new IllegalStateException("columnIndex " + n + " Out of range , current range is :" + this.append);
        }
        int n2 = n - 1 << 2;
        return this.arraycopy[n2 + 3] < 0;
    }

    private void getColDescs(int n) {
        this.arraycopy[this.SEDU++] = (byte)n;
    }

    private int getColLength(int n, int n2) {
        if (n2 == this.append) {
            return this.dataLength - n - 1;
        }
        return Math.abs(this.get(n2 + 1)) - n - 1;
    }

    public Object getObject(int n) throws DSException {
        int n2 = this.decimalNeedBytes[n];
        switch (n2) {
            case -6: {
                return new Byte(this.getByte(n));
            }
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case 5: {
                return new Short(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return this.getBigDecimal(n);
            }
            case 12: {
                return this.getString(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 93: {
                return this.getTimeStamp(n);
            }
            case 92: {
                return this.getTime(n);
            }
        }
        throw new DSException(5859, new String[]{" Unkonw dataType in getObject(). ColumnIndex: " + n + "; data type: " + n2});
    }

    public boolean isNull(int n) {
        return this.getColDesc(n);
    }

    private void getDataTypeName(int n, int n2) {
        if (n2 < 1 || n2 > this.append) {
            throw new IllegalStateException("columnIndex " + n2 + " Out of range , current range is :" + this.append);
        }
        if (n != this.decimalNeedBytes[n2]) {
            throw new IllegalStateException("violation data type. indicate " + Types.getDataTypeName(n) + ", but " + Types.getDataTypeName(this.decimalNeedBytes[n2]));
        }
    }

    public void close() {
        this.arraycopy = null;
        this.decimalNeedBytes = null;
    }

    public void putArray(Array array) throws DSException {
        byte[] byArray = ArrayTool.array2Bytes(array);
        this.dataLength(byArray, 2003);
    }

    public Array getArray(int n) {
        byte[] byArray = this.decimalNeedBytes(2003, n);
        return byArray == null ? null : ArrayTool.bytes2Array(byArray);
    }

    public static final void writeDbValue(DbValue dbValue, DataOutput dataOutput) throws IOException {
        boolean bl = dbValue.isNull();
        dataOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            byte[] byArray = new byte[PJFAux.getColLength(dbValue.getColDesc())];
            dataOutput.write(byArray);
            return;
        }
        if (dbValue.getColDesc().isArray()) {
            RecordDataTool.writeArray(dbValue, dataOutput);
            return;
        }
        int n = dbValue.getSqlType();
        switch (n) {
            case 5: {
                dataOutput.writeShort(((DbSmallInt)dbValue).get());
                break;
            }
            case -6: {
                dataOutput.writeByte(((DbTinyInt)dbValue).get());
                break;
            }
            case 4: {
                dataOutput.writeInt(((DbInteger)dbValue).get());
                break;
            }
            case 91: 
            case 92: {
                dataOutput.writeLong(((DbDateTime)dbValue).get());
                break;
            }
            case -5: {
                dataOutput.writeLong(((DbBigInt)dbValue).get());
                break;
            }
            case 6: {
                dataOutput.writeDouble(((DbDouble)dbValue).get());
                break;
            }
            case 7: {
                dataOutput.writeFloat(((DbReal)dbValue).get());
                break;
            }
            case 2: 
            case 3: {
                int n2 = DbBuffer.decimalNeedBytes(dbValue.getColDesc());
                RecordDataTool.writeBigDecimal(((DbDecimal)dbValue).get(), dbValue.getScale(), n2, dataOutput);
                break;
            }
            case 8: {
                dataOutput.writeDouble(((DbDouble)dbValue).get());
                break;
            }
            case -7: {
                dataOutput.writeBoolean(((DbBit)dbValue).get());
                break;
            }
            case 93: {
                dataOutput.writeLong(((DbTimestamp)dbValue).get());
                dataOutput.writeInt(((DbTimestamp)dbValue).getNanos());
                break;
            }
            case 1: 
            case 12: {
                String string = ((DbChar)dbValue).get();
                RecordDataTool.writeVariantBinary(string.getBytes("utf-8"), dataOutput);
                break;
            }
            case -1: {
                RecordDataTool.writeVariantBinary(((DbChar)dbValue).get().getBytes("utf-8"), dataOutput);
                break;
            }
            case -3: {
                RecordDataTool.writeFixedBinary(((DbBinary)dbValue).get(), dbValue.getPrecision(), dataOutput);
                break;
            }
            case -4: {
                RecordDataTool.writeVariantBinary(((DbBinary)dbValue).get(), dataOutput);
            }
        }
    }

    public static final void writeArray(DbValue dbValue, DataOutput dataOutput) throws IOException {
        int n = dbValue.getSqlType();
        switch (n) {
            case -7: {
                boolean[] blArray = (boolean[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(blArray.length);
                for (int i = 0; i < blArray.length; ++i) {
                    dataOutput.writeBoolean(blArray[i]);
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    dataOutput.writeByte(byArray[i]);
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(sArray.length);
                for (int i = 0; i < sArray.length; ++i) {
                    dataOutput.writeShort(sArray[i]);
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    dataOutput.writeInt(nArray[i]);
                }
                break;
            }
            case -5: 
            case 91: 
            case 92: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(lArray.length);
                for (int i = 0; i < lArray.length; ++i) {
                    dataOutput.writeLong(lArray[i]);
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int[] nArray = ((DbArray)dbValue).getNanos();
                dataOutput.writeInt(lArray.length);
                for (int i = 0; i < lArray.length; ++i) {
                    dataOutput.writeLong(lArray[i]);
                    dataOutput.writeInt(nArray[i]);
                }
                break;
            }
            case 6: 
            case 7: {
                float[] fArray2 = (float[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(fArray2.length);
                for (int i = 0; i < fArray2.length; ++i) {
                    dataOutput.writeFloat(fArray2[i]);
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(dArray.length);
                for (int i = 0; i < dArray.length; ++i) {
                    dataOutput.writeDouble(dArray[i]);
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(bigDecimalArray.length);
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    if (bigDecimalArray[i] == null) {
                        dataOutput.writeByte(1);
                        continue;
                    }
                    dataOutput.writeByte(0);
                    dataOutput.writeUTF(bigDecimalArray[i].toString());
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])((DbArray)dbValue).getValue();
                dataOutput.writeInt(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) {
                        dataOutput.writeByte(1);
                        continue;
                    }
                    dataOutput.writeByte(0);
                    dataOutput.writeUTF(stringArray[i]);
                }
                break;
            }
        }
    }

    public static void writeBigDecimal(BigDecimal bigDecimal, int n, int n2, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(n2);
        byte[] byArray = new byte[n2];
        if (bigDecimal == null) {
            for (int i = 0; i < n2; ++i) {
                byArray[i] = 32;
            }
        } else {
            byte[] byArray2 = bigDecimal.movePointRight(n).toBigInteger().toByteArray();
            int n3 = (byArray2[0] & 0x80) != 128 ? 0 : -1;
            for (int i = 0; i < n2; ++i) {
                byArray[i] = n3;
            }
            System.arraycopy(byArray2, 0, byArray, n2 - byArray2.length, byArray2.length);
        }
        dataOutput.write(byArray);
    }

    public static void writeVariantBinary(byte[] byArray, DataOutput dataOutput) throws IOException {
        int n = byArray.length;
        dataOutput.writeInt(n);
        dataOutput.write(byArray, 0, n);
    }

    public static void writeFixedBinary(byte[] byArray, int n, DataOutput dataOutput) throws IOException {
        int n2 = byArray.length > n ? n : byArray.length;
        dataOutput.writeShort(n2);
        dataOutput.write(byArray, 0, n2);
        for (int i = 0; i < n - n2; ++i) {
            dataOutput.writeByte(0);
        }
    }

    public static final void readDbValue(DbValue dbValue, DataInput dataInput, int n) throws IOException {
        boolean bl;
        byte by = dataInput.readByte();
        boolean bl2 = bl = by == 1;
        if (bl) {
            byte[] byArray = new byte[PJFAux.getColLength(dbValue.getColDesc())];
            dataInput.readFully(byArray);
            return;
        }
        if (dbValue.getColDesc().isArray()) {
            RecordDataTool.readArray(dbValue, dataInput, n);
            return;
        }
        int n2 = dbValue.getSqlType();
        switch (n2) {
            case 5: {
                ((DbSmallInt)dbValue).set(dataInput.readShort());
                break;
            }
            case -6: {
                ((DbTinyInt)dbValue).set(dataInput.readByte());
                break;
            }
            case 4: {
                ((DbInteger)dbValue).set(dataInput.readInt());
                break;
            }
            case 91: 
            case 92: {
                ((DbDateTime)dbValue).set(dataInput.readLong());
                break;
            }
            case -5: {
                ((DbBigInt)dbValue).set(dataInput.readLong());
                break;
            }
            case 6: {
                if (n >= 262912) {
                    double d = dataInput.readDouble();
                    ((DbDouble)dbValue).set(d);
                    break;
                }
                ((DbDouble)dbValue).set(dataInput.readFloat());
                break;
            }
            case 7: {
                ((DbReal)dbValue).set(dataInput.readFloat());
                break;
            }
            case 2: 
            case 3: {
                ((DbDecimal)dbValue).set(RecordDataTool.getDouble(dbValue.getScale(), dataInput));
                break;
            }
            case 8: {
                double d = dataInput.readDouble();
                ((DbDouble)dbValue).set(d);
                break;
            }
            case -7: {
                ((DbBit)dbValue).set(dataInput.readBoolean());
                break;
            }
            case 93: {
                ((DbTimestamp)dbValue).set(dataInput.readLong());
                ((DbTimestamp)dbValue).setNanos(dataInput.readInt());
                break;
            }
            case 1: 
            case 12: {
                if (n >= 262400) {
                    ((DbChar)dbValue).set(new String(RecordDataTool.getDate(dataInput), "utf-8"));
                    break;
                }
                ((DbChar)dbValue).setRaw(RecordDataTool.getDate(dataInput));
                break;
            }
            case -1: {
                if (n >= 262400) {
                    ((DbChar)dbValue).set(new String(RecordDataTool.getDate(dataInput), "utf-8"));
                    break;
                }
                ((DbChar)dbValue).setRaw(RecordDataTool.getDate(dataInput));
                break;
            }
            case -3: {
                byte[] byArray = new byte[dbValue.getPrecision()];
                dataInput.readFully(byArray);
                ((DbBinary)dbValue).set(byArray);
                break;
            }
            case -4: {
                ((DbBinary)dbValue).set(RecordDataTool.getDate(dataInput));
            }
        }
    }

    private static byte[] getDate(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray, 0, n);
        return byArray;
    }

    private static BigDecimal getDouble(int n, DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        byte[] byArray = new byte[s];
        dataInput.readFully(byArray, 0, s);
        return new BigDecimal(new BigInteger(byArray), n);
    }

    public static final void readArray(DbValue dbValue, DataInput dataInput, int n) throws IOException {
        int n2 = dbValue.getSqlType();
        Object[] objectArray = null;
        int[] nArray = null;
        int n3 = dataInput.readInt();
        switch (n2) {
            case -7: {
                objectArray = new boolean[n3];
                for (int i = 0; i < n3; ++i) {
                    objectArray[i] = dataInput.readBoolean();
                }
                break;
            }
            case -6: {
                objectArray = new byte[n3];
                for (int i = 0; i < n3; ++i) {
                    ((byte[])objectArray)[i] = dataInput.readByte();
                }
                break;
            }
            case 5: {
                objectArray = new short[n3];
                for (int i = 0; i < n3; ++i) {
                    ((short[])objectArray)[i] = dataInput.readShort();
                }
                break;
            }
            case 4: {
                objectArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    ((int[])objectArray)[i] = dataInput.readInt();
                }
                break;
            }
            case -5: 
            case 91: 
            case 92: {
                objectArray = new long[n3];
                for (int i = 0; i < n3; ++i) {
                    ((long[])objectArray)[i] = dataInput.readLong();
                }
                break;
            }
            case 93: {
                objectArray = new long[n3];
                nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    ((long[])objectArray)[i] = dataInput.readLong();
                    nArray[i] = dataInput.readInt();
                }
                ((DbArray)dbValue).setNanos(nArray);
                break;
            }
            case 6: 
            case 7: {
                objectArray = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    ((float[])objectArray)[i] = dataInput.readFloat();
                }
                break;
            }
            case 8: {
                objectArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    ((double[])objectArray)[i] = dataInput.readDouble();
                }
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n3];
                if (n >= 263424) {
                    for (int i = 0; i < n3; ++i) {
                        byte by = dataInput.readByte();
                        boolean bl = by == 1;
                        ((BigDecimal[])objectArray)[i] = bl ? null : new BigDecimal(dataInput.readUTF());
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        ((BigDecimal[])objectArray)[i] = new BigDecimal(dataInput.readUTF());
                    }
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                objectArray = new String[n3];
                if (n >= 263424) {
                    for (int i = 0; i < n3; ++i) {
                        byte by = dataInput.readByte();
                        boolean bl = by == 1;
                        ((String[])objectArray)[i] = bl ? null : dataInput.readUTF();
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        ((String[])objectArray)[i] = dataInput.readUTF();
                    }
                }
                break;
            }
        }
        ((DbArray)dbValue).setValue(objectArray, n3);
    }
}

