/*
 * Decompiled with CFR 0.152.
 */
package jet.net2.www.http;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RelaxedX509TrustManager
implements X509TrustManager {
    private TrustManager SEDU = null;
    private static boolean add = false;
    private static boolean aliases = false;
    private char[] checkClientTrusted;
    private String close = System.getProperty("javax.net.ssl.trustStore");
    private static String delete = null;
    private static char[] equals;
    private FileInputStream exists = null;
    private KeyStore getAcceptedIssuers = null;

    public RelaxedX509TrustManager() throws Exception {
        Properties properties;
        Object object;
        String string = System.getProperty("javax.net.ssl.trustStorePassword");
        if (this.close == null) {
            this.close = "";
        }
        this.checkClientTrusted = string == null ? "jinfonet".toCharArray() : string.toCharArray();
        if (!this.close.equals("")) {
            delete = this.close;
            equals = this.checkClientTrusted;
        }
        try {
            object = new File(this.close);
            if (!((File)object).exists()) {
                properties = System.getProperties();
                properties.remove("javax.net.ssl.trustStore");
                properties.remove("javax.net.ssl.trustStorePassword");
                System.setProperties(properties);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            ((TrustManagerFactory)object).init((KeyStore)null);
            this.SEDU = ((TrustManagerFactory)object).getTrustManagers()[0];
        }
        catch (Exception exception) {
            properties = System.getProperties();
            properties.remove("javax.net.ssl.trustStore");
            properties.remove("javax.net.ssl.trustStorePassword");
            System.setProperties(properties);
            File file = new File(this.close);
            file.delete();
        }
        if (this.SEDU == null) {
            throw new SSLException("Could not get default TrustManager instance.");
        }
        try {
            this.exists = new FileInputStream(this.close);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.exists = null;
        }
        try {
            this.getAcceptedIssuers = KeyStore.getInstance(KeyStore.getDefaultType());
            this.getAcceptedIssuers.load(this.exists, this.checkClientTrusted);
        }
        catch (KeyStoreException keyStoreException) {
            this.getAcceptedIssuers = null;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            ((X509TrustManager)this.SEDU).checkClientTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            Serializable serializable;
            if ("false".equals(System.getProperty("RelaxedX509TrustManager"))) {
                serializable = System.getProperties();
                ((Properties)serializable).remove("RelaxedX509TrustManager");
                System.setProperties((Properties)serializable);
                aliases = false;
                add = false;
            }
            if (aliases) {
                throw new CertificateException();
            }
            if (this.getAcceptedIssuers == null || x509CertificateArray == null || x509CertificateArray.length == 0) {
                throw new CertificateException();
            }
            if (add) {
                return;
            }
            try {
                serializable = new CertDlg(new Frame(), x509CertificateArray);
                ((Dialog)serializable).setModal(true);
                ((Dialog)serializable).show();
                if (((CertDlg)serializable).I) {
                    add = true;
                }
                if (((CertDlg)serializable).Z) {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        this.getAcceptedIssuers.setCertificateEntry(((Object)x509CertificateArray[i].getSubjectDN()).toString(), x509CertificateArray[i]);
                    }
                    File file = new File(delete.substring(0, delete.lastIndexOf(File.separator)));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(delete);
                    this.getAcceptedIssuers.store(fileOutputStream, equals);
                    fileOutputStream.close();
                    fileOutputStream = null;
                    Properties properties = System.getProperties();
                    properties.put("javax.net.ssl.trustStore", delete);
                    properties.put("javax.net.ssl.trustStorePassword", new String(equals));
                    System.setProperties(properties);
                }
                throw new CertificateException();
            }
            catch (Exception exception) {
                throw new CertificateException(exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray;
        X509Certificate[] x509CertificateArray2 = x509CertificateArray = ((X509TrustManager)this.SEDU).getAcceptedIssuers();
        if (this.getAcceptedIssuers != null) {
            try {
                Enumeration<String> enumeration = this.getAcceptedIssuers.aliases();
                Vector<Certificate> vector = new Vector<Certificate>();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    vector.add(this.getAcceptedIssuers.getCertificate(string.toString()));
                }
                int n = x509CertificateArray.length + vector.size();
                x509CertificateArray2 = new X509Certificate[n];
                Iterator iterator = vector.iterator();
                for (int i = 0; i < n; ++i) {
                    x509CertificateArray2 = i < x509CertificateArray.length ? x509CertificateArray : (X509Certificate[])iterator.next();
                }
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return x509CertificateArray2;
    }

    class CertDlg
    extends JDialog
    implements ActionListener,
    WindowListener {
        JLabel SEDU;
        JLabel access$000;
        JLabel access$102;
        JButton add;
        JButton addActionListener;
        JButton checkValidity;
        JButton deriveFont;
        boolean I = false;
        boolean Z = false;
        private Frame getFont;
        private X509Certificate[] getName;
        private boolean getSource = false;
        private boolean getSubjectDN = false;

        CertDlg(Frame frame, X509Certificate[] x509CertificateArray) {
            this.getName = x509CertificateArray;
            this.getFont = frame;
            this.SEDU(frame);
            this.access$000();
        }

        private void SEDU(Frame frame) {
            this.setTitle("Sercurity Warning");
            this.getContentPane().setLayout(null);
            this.setResizable(false);
            this.setSize(500, 250);
            this.setLocationRelativeTo(frame);
            JLabel jLabel = new JLabel("The certificate sent by the server is unknown and not trustable!");
            jLabel.setBounds(5, 5, 400, 20);
            JLabel jLabel2 = new JLabel("The certificate is issued to");
            jLabel2.setBounds(5, 30, 150, 20);
            this.SEDU = new JLabel("ISSUED TO");
            this.SEDU.setBounds(155, 30, 160, 20);
            this.access$102 = new JLabel("The Certificate does not expire and is still valid.");
            this.access$102.setBounds(5, 55, 300, 20);
            this.access$000 = new JLabel("The Certificate is issued by a company that is not trusted.");
            this.access$000.setBounds(5, 80, 350, 20);
            JLabel jLabel3 = new JLabel("Do you want to grant this certificate?");
            jLabel3.setBounds(5, 115, 250, 20);
            this.deriveFont = new JButton("Grant Once");
            this.deriveFont.setBounds(5, 145, 110, 25);
            this.add = new JButton("Grant always");
            this.add.setBounds(120, 145, 120, 25);
            this.addActionListener = new JButton("Deny");
            this.addActionListener.setBounds(245, 145, 70, 25);
            this.checkValidity = new JButton("View Certificate");
            this.checkValidity.setBounds(320, 145, 130, 25);
            this.getContentPane().add(this.checkValidity);
            this.getContentPane().add(this.addActionListener);
            this.getContentPane().add(this.deriveFont);
            this.getContentPane().add(this.add);
            this.getContentPane().add(jLabel);
            this.getContentPane().add(jLabel2);
            this.getContentPane().add(jLabel3);
            this.getContentPane().add(this.access$102);
            this.getContentPane().add(this.SEDU);
            this.getContentPane().add(this.access$000);
        }

        private void access$000() {
            String string = this.getName[0].getSubjectDN().getName();
            string = string.substring(string.indexOf("CN=") + 3);
            this.SEDU.setText(string.substring(0, string.indexOf(",")));
            try {
                this.getName[0].checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                this.getSource = true;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                this.getSubjectDN = true;
            }
            if (this.getSource) {
                if (this.getSubjectDN) {
                    this.access$102.setText("The Certificate is expired and is not valid.");
                } else {
                    this.access$102.setText("The Certificate is expired and is valid.");
                }
            } else if (this.getSubjectDN) {
                this.access$102.setText("The Certificate is not expired and is not valid.");
            } else {
                this.access$102.setText("The Certificate is not expired and is valid.");
            }
            this.access$000.setFont(this.access$000.getFont().deriveFont(1));
            this.access$102.setFont(this.access$102.getFont().deriveFont(1));
            this.add.addActionListener(this);
            this.add.setEnabled(delete != null);
            this.addActionListener.addActionListener(this);
            this.checkValidity.addActionListener(this);
            this.deriveFont.addActionListener(this);
            this.addWindowListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.add) {
                this.Z = true;
                this.dispose();
            } else if (object == this.addActionListener) {
                aliases = true;
                this.dispose();
            } else if (object == this.checkValidity) {
                ViewCert viewCert = new ViewCert(this.getFont, this.getName);
            } else if (object == this.deriveFont) {
                this.I = true;
                this.dispose();
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.dispose();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        class ViewCert
        extends JDialog
        implements ActionListener {
            private JPanel SEDU = new JPanel();
            private JPanel add = new JPanel();
            private JPanel addActionListener = new JPanel();
            private JComboBox addItem = new JComboBox();
            private JList addItemListener = new JList();
            private JTextArea addListSelectionListener = new JTextArea();
            private JButton append = new JButton("OK");
            private Frame createEtchedBorder;
            private X509Certificate[] createTitledBorder;
            private final String[] digest = new String[]{"Version", "Serial Number", "Signature Algorithm", "Issuer", "Validity Period", "Subject", "Signature", "Certificate Fingerprint"};
            private int equals = 0;

            ViewCert(Frame frame, X509Certificate[] x509CertificateArray) {
                this.createTitledBorder = x509CertificateArray;
                this.createEtchedBorder = frame;
                this.SEDU(frame);
                this.add();
                this.setModal(true);
                this.show();
            }

            private void SEDU(Frame frame) {
                this.setTitle("Certificate Details");
                this.getContentPane().setLayout(null);
                this.setResizable(true);
                this.setSize(410, 460);
                this.setLocationRelativeTo(frame);
                this.SEDU.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Certificate"));
                this.SEDU.setBounds(10, 10, 380, 60);
                this.SEDU.setLayout(new BorderLayout());
                this.SEDU.add(this.addItem);
                this.add.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Field"));
                this.add.setLayout(new BorderLayout());
                this.add.setBounds(10, 80, 380, 150);
                JScrollPane jScrollPane = new JScrollPane(this.addItemListener);
                this.add.add(jScrollPane);
                this.addItemListener.setSelectionMode(0);
                this.addActionListener.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Value"));
                this.addActionListener.setLayout(new BorderLayout());
                this.addActionListener.setBounds(10, 240, 380, 150);
                JScrollPane jScrollPane2 = new JScrollPane(this.addListSelectionListener);
                this.addActionListener.add(jScrollPane2);
                this.append.setBounds(160, 400, 90, 25);
                this.getContentPane().add(this.SEDU);
                this.getContentPane().add(this.add);
                this.getContentPane().add(this.addActionListener);
                this.getContentPane().add(this.append);
            }

            private void add() {
                for (int i = 0; i < this.createTitledBorder.length; ++i) {
                    String string = this.createTitledBorder[i].getSubjectDN().getName();
                    string = string.substring(string.indexOf("CN=") + 3);
                    this.addItem.addItem(i + 1 + ". " + string.substring(0, string.indexOf(",")));
                }
                this.addItem.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        ViewCert.this.addListSelectionListener();
                    }
                });
                this.addItemListener.setListData(this.digest);
                this.addItemListener.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        ViewCert.this.addItemListener();
                    }
                });
                this.addItemListener.setSelectedIndex(0);
                this.addListSelectionListener();
                this.append.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.append) {
                    this.dispose();
                }
            }

            private String addActionListener(byte[] byArray, String string) throws Exception {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                messageDigest.update(byArray);
                byte[] byArray2 = messageDigest.digest();
                return new String(string + ": " + this.addItem(byArray2));
            }

            private String addItem(byte[] byArray) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < byArray.length; ++i) {
                    int n;
                    String string;
                    if (i != 0) {
                        stringBuffer.append(":");
                    }
                    if ((string = Integer.toHexString(n = byArray[i] & 0xFF)).length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }

            private void addItemListener() {
                this.addListSelectionListener();
            }

            private void addListSelectionListener() {
                this.equals = this.addItem.getSelectedIndex();
                String string = (String)this.addItemListener.getSelectedValue();
                if (string.equals("Version")) {
                    this.addListSelectionListener.setText(String.valueOf(this.createTitledBorder[this.equals].getVersion()));
                } else if (string.equals("Serial Number")) {
                    this.addListSelectionListener.setText(this.addItem(this.createTitledBorder[this.equals].getSerialNumber().toByteArray()));
                } else if (string.equals("Signature Algorithm")) {
                    this.addListSelectionListener.setText(this.createTitledBorder[this.equals].getSigAlgName());
                } else if (string.equals("Issuer")) {
                    this.addListSelectionListener.setText(this.createTitledBorder[this.equals].getIssuerDN().getName());
                } else if (string.equals("Validity Period")) {
                    this.addListSelectionListener.setText(this.createTitledBorder[this.equals].getNotBefore().toString() + " - " + this.createTitledBorder[this.equals].getNotAfter().toString());
                } else if (string.equals("Subject")) {
                    this.addListSelectionListener.setText(this.createTitledBorder[this.equals].getSubjectDN().getName());
                } else if (string.equals("Signature")) {
                    this.addListSelectionListener.setText(this.addItem(this.createTitledBorder[this.equals].getSignature()));
                } else if (string.equals("Certificate Fingerprint")) {
                    try {
                        this.addListSelectionListener.setText(this.addActionListener(this.createTitledBorder[this.equals].getEncoded(), "MD5") + "\n" + this.addActionListener(this.createTitledBorder[this.equals].getEncoded(), "SHA1"));
                    }
                    catch (Exception exception) {
                        this.addListSelectionListener.setText("Couldn't calculate fingerprints of the certificate.\nReason: " + exception.getMessage());
                    }
                }
            }
        }
    }
}

