/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import chart.ChartCoordinatePaper;
import chart.ChartDefinition;
import chart.ChartEnv;
import chart.ChartLabelBase;
import chart.ChartLegend;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DLine;
import chart.chart2d.Graph2DLineNode;
import chart.chart3d.ChartMatrix;
import chart.data.ChartDataSetInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartColorPattern;
import chart.properties.ChartNodeProperties;
import chart.util.ChartHtmlMapExport;
import chart.util.ChartRenderTools;
import com.jinfonet.awt.ps.PSGraphics;
import com.jinfonet.util.JRLog;
import guitools.toolkit.TContainer;
import guitools.toolkit.Unit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.Record;
import jet.datastream.DSChartCoordinatepaper;
import jet.datastream.DSChartHeatMapGroupRect;
import jet.datastream.DSChartORGNode;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSContainer;
import jet.datastream.DSSection;
import jet.datastream.JRObjectResult;
import jet.datastream.exportInfo.ChartExportInfoImpl;
import jet.datastream.exportInfo.ChartExportTimeInfo;
import jet.datastream.exportInfo.ChartExportTimeInfoImpl;
import jet.export.ExportAuxInfo;
import jet.export.util.ExportingInfo;
import jet.export.util.ViewerExportingInfo;
import jet.thinviewer.ChartDrillDownImplementor;
import jet.thinviewer.JReportContainer;
import jet.thinviewer.JReportContainerable;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.util.PropertySetable;

public class JReportChartPlatform
extends TContainer
implements JReportObjectRender,
JReportContainerable,
MouseListener,
MouseMotionListener,
ActionListener {
    public static final int CORDINATE_NORMAL = 0;
    public static final int CORDINATE_3D = 1;
    public static final int CORDINATE_3D_BENCH = 2;
    public static final int CORDINATE_PIE = 3;
    private ChartPlatform KEY_ANTIALIASING;
    private DSChartPlatform SEDU;
    private ChartCoordinatePaper VALUE_ANTIALIAS_ON;
    private Point WORDWRAPPER_GAP;
    private int _xrot;
    private float[] abs = new float[3];
    private Point booleanValue;
    ChartLabelBase[] clipRect;
    protected ExportingInfo info = new ViewerExportingInfo();
    private ChartMatrix m = new ChartMatrix();
    private ChartMatrix contains = new ChartMatrix();
    String convertUnitToPixel;
    String create;
    String createChartPlatform;
    boolean createChildren = true;
    ChartLegend custommerConstant;
    int draw = -1;
    boolean drawImage = false;
    Rectangle drawNode = null;
    Point drawZomBut;
    Rectangle drilldownInChart = null;
    float[] elementAt = null;
    boolean equals = false;
    boolean equalsIgnoreCase = false;
    Line2D.Float error = new Line2D.Float();
    Point exportHTML = null;
    int fill = -1;
    private boolean floatValue = true;
    private int[] get = null;

    public JReportChartPlatform() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._xrot = 0;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.KEY_ANTIALIASING == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6401501);
            }
            return;
        }
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        try {
            if (!(graphics instanceof PSGraphics)) {
                // empty if block
            }
            Rectangle rectangle = this.KEY_ANTIALIASING.getBounds();
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
        }
        catch (ClassCastException classCastException) {
            Rectangle rectangle = this.KEY_ANTIALIASING.getBounds();
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
        }
        this.KEY_ANTIALIASING(graphics2D);
        if (bufferedImage != null) {
            graphics.drawImage(bufferedImage, 0, 0, this);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6401502);
        }
    }

    private void KEY_ANTIALIASING(Graphics2D graphics2D) {
        Object object = null;
        if (this.KEY_ANTIALIASING.getProperties().isAntiAliasing()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (!this.KEY_ANTIALIASING.getChartDefinition().isHeatMapChart()) {
            this.KEY_ANTIALIASING.paint(graphics2D);
        } else {
            this.KEY_ANTIALIASING.paintNoLegendAndLabel(graphics2D);
        }
        if (this.VALUE_ANTIALIAS_ON.getProperties().isInteractive()) {
            this.SEDU(graphics2D);
            this.VALUE_ANTIALIAS_ON(graphics2D);
        }
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
        if (this.KEY_ANTIALIASING.getChartDefinition() != null && this.KEY_ANTIALIASING.getChartCoordinatePaper() != null && (this.KEY_ANTIALIASING.getChartDefinition().isORGChart() || this.KEY_ANTIALIASING.getChartDefinition().isHeatMapChart())) {
            Rectangle rectangle = this.KEY_ANTIALIASING.getChartCoordinatePaper().getBounds();
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            JRObjectResult jRObjectResult = null;
            Vector vector = this.SEDU.getChildren();
            for (int i = 0; i < vector.size(); ++i) {
                jRObjectResult = (JRObjectResult)vector.elementAt(i);
                if (jRObjectResult.getObjectType() != 72 || jRObjectResult.getTemplate().getPropertyByName("PaperBackgroundBorderPenThickness") == null) continue;
                int n5 = ((Number)jRObjectResult.getTemplate().getPropertyByName("PaperBackgroundBorderPenThickness").getObject()).intValue();
                int n6 = ((Number)jRObjectResult.getTemplate().getPropertyByName("PaperBackgroundBorderStyle").getObject()).intValue();
                int n7 = ((Number)jRObjectResult.getTemplate().getPropertyByName("PaperBackgroundBorderPenStyle").getObject()).intValue();
                if (n6 == 0) {
                    n5 = 0;
                } else if (n7 == 9) {
                    n5 = 0;
                }
                n5 = Unit.convertUnitToPixel(n5, this.SEDU.getResolution());
                n += n5;
                n2 += n5;
                n3 -= 2 * n5;
                n4 -= 2 * n5;
            }
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.clipRect(n, n2, n3, n4);
            super.paint(graphics2D2);
        } else {
            super.paint(graphics2D);
        }
        if (this.KEY_ANTIALIASING.getChartDefinition().isHeatMapChart()) {
            this.KEY_ANTIALIASING.paintLegendAndLabel(graphics2D);
        }
        this.drawImage(graphics2D);
        this.custommerConstant(graphics2D);
        this.createChildren(graphics2D);
    }

    private void SEDU(Graphics2D graphics2D) {
        if (this.VALUE_ANTIALIAS_ON != null && this.exportHTML != null && this.exportHTML.x > 0 && this.fill >= 0 && this.VALUE_ANTIALIAS_ON.getProperties().getGraphProperties().getLineNodeList() != null && this.VALUE_ANTIALIAS_ON.getProperties().getGraphProperties().getLineNodeList().size() > 0) {
            int n = this.VALUE_ANTIALIAS_ON.getProperties().getGraphProperties().getLineNodeList().size();
            ChartNodeProperties chartNodeProperties = (ChartNodeProperties)this.VALUE_ANTIALIAS_ON.getProperties().getGraphProperties().getLineNodeList().get(this.fill % n);
            if (!chartNodeProperties.getShowHighLightNode()) {
                return;
            }
            Graph2DLineNode graph2DLineNode = new Graph2DLineNode();
            graph2DLineNode.setProperties(chartNodeProperties);
            graph2DLineNode.setFillPattern(new ChartColorPattern(chartNodeProperties.getHighLightNodeClr()));
            graph2DLineNode.setLoc(this.VALUE_ANTIALIAS_ON.getBounds().x + this.exportHTML.x, this.VALUE_ANTIALIAS_ON.getBounds().y + this.exportHTML.y);
            graph2DLineNode.drawNode(graphics2D);
        }
    }

    private void VALUE_ANTIALIAS_ON(Graphics2D graphics2D) {
        if (this.clipRect != null) {
            float f = 0.0f;
            for (int i = this.clipRect.length - 1; i >= 0; --i) {
                if (this.clipRect[i] == null || this.clipRect[i].getLabelText() == null) continue;
                Rectangle2D rectangle2D = this.clipRect[i].getChartTextStyle().getDimension(graphics2D, this.clipRect[i].getLabelText());
                if ((double)this.booleanValue.x + rectangle2D.getWidth() < (double)(this.KEY_ANTIALIASING.getBounds().x + this.KEY_ANTIALIASING.getBounds().width)) {
                    this.clipRect[i].paint(graphics2D, this.booleanValue.x + ChartEnv.WORDWRAPPER_GAP, (float)((double)this.booleanValue.y - rectangle2D.getHeight()) - f);
                } else {
                    this.clipRect[i].paint(graphics2D, (float)((double)(this.booleanValue.x + ChartEnv.WORDWRAPPER_GAP) - rectangle2D.getWidth()), (float)((double)this.booleanValue.y - rectangle2D.getHeight()) - f);
                }
                f = (float)((double)f + (rectangle2D.getHeight() + (double)ChartEnv.WORDWRAPPER_GAP));
            }
        }
    }

    public List getHtmlDrilldownMap() {
        if (this.KEY_ANTIALIASING == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6401501);
            }
            return null;
        }
        String string = (String)this.SEDU.getPropertyByName("HyperLink").getObject();
        String string2 = (String)this.SEDU.getPropertyByName("XHyperLink").getObject();
        String string3 = (String)this.SEDU.getPropertyByName("ZHyperLink").getObject();
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        chartHtmlMapExport.exportHTML(string, string2, string3);
        return chartHtmlMapExport.getResultMap();
    }

    public List getDHtmlDrilldownMap() {
        if (this.KEY_ANTIALIASING == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6401501);
            }
            return null;
        }
        if (this.KEY_ANTIALIASING.getChartDefinition().isORGChart()) {
            return null;
        }
        if (this.KEY_ANTIALIASING.getChartDefinition().isHeatMapChart()) {
            return null;
        }
        String string = (String)this.SEDU.getPropertyByName("HyperLink").getObject();
        String string2 = (String)this.SEDU.getPropertyByName("XHyperLink").getObject();
        String string3 = (String)this.SEDU.getPropertyByName("ZHyperLink").getObject();
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        chartHtmlMapExport.exportHTML(string, string2, string3);
        return chartHtmlMapExport.getResultMap();
    }

    public void setStatus(int n) {
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        Object object;
        this.SEDU = (DSChartPlatform)propertySetable;
        this.SEDU.init();
        this.SEDU.resetBounds();
        if (this.KEY_ANTIALIASING == null) {
            this.KEY_ANTIALIASING = this.SEDU.createChartPlatform();
        }
        if (this.KEY_ANTIALIASING == null) {
            return;
        }
        this.VALUE_ANTIALIAS_ON = this.KEY_ANTIALIASING.getChartCoordinatePaper();
        ChartDefinition chartDefinition = this.KEY_ANTIALIASING.getChartDefinition();
        ChartDataSetInfo[] chartDataSetInfoArray = chartDefinition.getChartDataSetInfos();
        int n = ChartTypeInfo.getPrimType(chartDataSetInfoArray[0].getChartType());
        if (chartDefinition.is3DEffect()) {
            this._xrot = n == 1 ? 2 : 1;
        } else if (n == 4) {
            this._xrot = 3;
        }
        this.convertUnitToPixel = (String)this.SEDU.getPropertyByName("HyperLink").getObject();
        this.create = (String)this.SEDU.getPropertyByName("XHyperLink").getObject();
        this.createChartPlatform = (String)this.SEDU.getPropertyByName("ZHyperLink").getObject();
        Vector vector = this.SEDU.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            object = (JRObjectResult)vector.get(i);
            if (((JRObjectResult)object).getObjectType() != 72) continue;
            this.createChildren = (Boolean)((JRObjectResult)object).getPropertyByName("Interactive").getObject();
            this.m._xrot(((Number)((JRObjectResult)object).getPropertyByName("AngleX").getObject()).intValue());
            this.m.yrot(((Number)((JRObjectResult)object).getPropertyByName("AngleY").getObject()).intValue());
            this.VALUE_ANTIALIAS_ON.properties.getGraphProperties().setPieYRotation(((Number)((JRObjectResult)object).getPropertyByName("PieAngleX").getObject()).floatValue());
            this.VALUE_ANTIALIAS_ON.properties.getGraphProperties().setPieYRotation(((Number)((JRObjectResult)object).getPropertyByName("PieAngleY").getObject()).floatValue());
            try {
                this.m.zrot(((Number)((JRObjectResult)object).getPropertyByName("AngleZ").getObject()).intValue());
            }
            catch (NullPointerException nullPointerException) {
                this.m.zrot(0.0);
            }
            break;
        }
        this.abs[0] = this.VALUE_ANTIALIAS_ON.properties.getGraphProperties().getPieXRotation();
        this.abs[1] = this.VALUE_ANTIALIAS_ON.properties.getGraphProperties().getPieYRotation();
        this.custommerConstant = this.KEY_ANTIALIASING.getChartLegend();
        ChartExportTimeInfo chartExportTimeInfo = null;
        if (chartExportTimeInfo != null && chartExportTimeInfo.getScrollBarInfo() != null && (object = (Object)chartExportTimeInfo.getScrollBarInfo()) != null && object[0] >= 0.0f && object[1] >= 0.0f) {
            this.KEY_ANTIALIASING.setScrollbarInfo((float[])object);
            if (this.KEY_ANTIALIASING.getSimplePaper() != null) {
                this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().setLocate(false);
                this.KEY_ANTIALIASING.getSimplePaper().locate();
            }
            this.KEY_ANTIALIASING.getChartCoordinatePaper().init();
            this.KEY_ANTIALIASING.getChartCoordinatePaper().locate();
        }
    }

    @Override
    public void createChildren(DSContainer dSContainer) {
        int n = dSContainer.getChildren().size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)dSContainer.getChildren().get(i);
            if (jRObjectResult.getObjectType() != 72) continue;
            DSChartCoordinatepaper dSChartCoordinatepaper = (DSChartCoordinatepaper)jRObjectResult;
            int n2 = Unit.convertUnitToPixel(dSChartCoordinatepaper.getX(), dSContainer.getResolution());
            int n3 = Unit.convertUnitToPixel(dSChartCoordinatepaper.getY(), dSContainer.getResolution());
            int n4 = ((DSContainer)jRObjectResult).getChildren().size();
            for (int j = 0; j < n4; ++j) {
                Rectangle rectangle;
                JReportContainer jReportContainer;
                JRObjectResult jRObjectResult2 = (JRObjectResult)((DSContainer)jRObjectResult).getChildren().get(j);
                if (this.SEDU.isORGChart() && jRObjectResult2.getObjectType() == 77) {
                    jReportContainer = (JReportContainer)ViewerTools.I(jRObjectResult2, false);
                    jReportContainer.setProperty(jRObjectResult2);
                    rectangle = ((DSChartORGNode)jRObjectResult2).getBounds();
                    jReportContainer.setExportInfo(this.info);
                    jReportContainer.setBounds(rectangle.x + n2, rectangle.y + n3, rectangle.width, rectangle.height);
                    jReportContainer.createChildren((DSContainer)jRObjectResult2);
                    if (jReportContainer == null) continue;
                    this.add(jReportContainer);
                    continue;
                }
                if (!(jRObjectResult2 instanceof DSChartHeatMapGroupRect)) continue;
                jReportContainer = (JReportContainer)ViewerTools.I(jRObjectResult2, false);
                jReportContainer.setProperty(jRObjectResult2);
                rectangle = ((DSChartHeatMapGroupRect)jRObjectResult2).getBounds();
                n2 = this.KEY_ANTIALIASING.getChartCoordinatePaper().getBounds().x;
                n3 = this.KEY_ANTIALIASING.getChartCoordinatePaper().getBounds().y;
                jReportContainer.setBounds(rectangle.x + n2, rectangle.y + n3, rectangle.width + 1, rectangle.height + 1);
                jReportContainer.setExportInfo(this.info);
                jReportContainer.createChildren((DSContainer)jRObjectResult2);
                if (jReportContainer == null) continue;
                this.add(jReportContainer);
            }
        }
    }

    public void relocate() {
    }

    public void boundsChanged() {
    }

    public void setSelected(boolean bl) {
    }

    public void deselectAll() {
    }

    public void updateProperties(int n, Component component) {
    }

    public void setProperty(PropertySetable propertySetable, Record record) {
    }

    public String[] toHtml(String string) {
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        return chartHtmlMapExport.getResult();
    }

    public String[] toDHtml(String string) {
        string = this.KEY_ANTIALIASING.getChartDefinition().getCategory();
        if (string == null) {
            string = "";
        }
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        return chartHtmlMapExport.getResult();
    }

    public String[] toDHtml() {
        String string = this.KEY_ANTIALIASING.getChartDefinition().getCategory();
        if (string == null) {
            string = "";
        }
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        return chartHtmlMapExport.getResult();
    }

    public void changeType(int n, int n2, int n3) {
    }

    public void refreshDSChart() {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        Object object;
        Point point;
        int n2;
        int n3;
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        this.draw(mouseEvent);
        if (this.VALUE_ANTIALIAS_ON.getZDim() != null && this.createChartPlatform != null && !this.createChartPlatform.trim().equalsIgnoreCase("") || this.VALUE_ANTIALIAS_ON.getXDim() != null && this.create != null && !this.create.trim().equalsIgnoreCase("")) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.custommerConstant != null) {
            if (this.custommerConstant.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                n3 = mouseEvent.getX() - this.custommerConstant.getBounds().x;
                n2 = mouseEvent.getY() - this.custommerConstant.getBounds().y;
                this.custommerConstant.hintText = this.custommerConstant.getHintValue(n3, n2);
                this.get = this.custommerConstant.getLinkInfo(n3, n2);
                if (this.get != null && (this.get[0] != -1 || this.get[1] != -1 || this.get[2] != -1)) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
                if (this.custommerConstant.hintText != null) {
                    point = mouseEvent.getPoint();
                    this.booleanValue = mouseEvent.getPoint();
                    object = this.custommerConstant.hintText;
                    this.clipRect = new ChartLabelBase[((String[])object).length];
                    for (n = 0; n < ((String[])object).length; ++n) {
                        this.clipRect[n] = new ChartLabelBase(object[n]);
                        this.clipRect[n].setChartTextStyle(this.VALUE_ANTIALIAS_ON.getProperties().getHintTextStyle());
                    }
                } else {
                    this.clipRect = null;
                }
            } else {
                this.clipRect = null;
            }
        }
        if (this.clipRect == null && this.VALUE_ANTIALIAS_ON != null) {
            if (this.VALUE_ANTIALIAS_ON.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                n3 = mouseEvent.getX() - this.VALUE_ANTIALIAS_ON.getBounds().x;
                n2 = mouseEvent.getY() - this.VALUE_ANTIALIAS_ON.getBounds().y;
                this.VALUE_ANTIALIAS_ON.hintText = this.VALUE_ANTIALIAS_ON.getHintValue(n3, n2);
                this.get = this.VALUE_ANTIALIAS_ON.getLinkInfo(n3, n2);
                if (this.get != null && (this.get[0] != -1 || this.get[1] != -1 || this.get[2] != -1)) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
                if (this.VALUE_ANTIALIAS_ON.hintText != null) {
                    point = mouseEvent.getPoint();
                    this.booleanValue = mouseEvent.getPoint();
                    object = this.VALUE_ANTIALIAS_ON.hintText;
                    this.clipRect = new ChartLabelBase[((String[])object).length];
                    for (n = 0; n < ((String[])object).length; ++n) {
                        this.clipRect[n] = new ChartLabelBase((String)object[n]);
                        this.clipRect[n].setChartTextStyle(this.VALUE_ANTIALIAS_ON.getProperties().getHintTextStyle());
                    }
                } else {
                    this.clipRect = null;
                }
                boolean bl = false;
                this.fill = -1;
                if (this.VALUE_ANTIALIAS_ON instanceof Chart2DPaper) {
                    object = ((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getCharts();
                    n = 0;
                    int n4 = 0;
                    boolean bl2 = false;
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        Shape[][] shapeArray;
                        ChartObject chartObject;
                        if (!(((Vector)object).get(i) instanceof Graph2DLine) || (chartObject = (ChartObject)((Vector)object).get(i)) == null || !(chartObject instanceof Graph2DLine)) continue;
                        if (this.exportHTML == null) {
                            this.exportHTML = new Point(-1, -1);
                        }
                        if ((shapeArray = ((Graph2DLine)chartObject).getItemShapes()) == null) continue;
                        for (int j = 0; j < shapeArray.length && !bl; ++j) {
                            Shape[] shapeArray2 = shapeArray[j];
                            for (int k = 0; k < shapeArray2.length; ++k) {
                                if (shapeArray2[k] == null || !shapeArray2[k].contains(n3, n2)) continue;
                                Rectangle rectangle = shapeArray2[k].getBounds();
                                this.exportHTML.x = rectangle.x + rectangle.width / 2;
                                this.exportHTML.y = rectangle.y + rectangle.height / 2;
                                bl = true;
                                this.fill = n4 + j;
                            }
                        }
                        n4 += shapeArray.length;
                    }
                }
                if (!bl) {
                    if (this.exportHTML == null) {
                        this.exportHTML = new Point(-1, -1);
                    } else {
                        this.exportHTML.x = -1;
                        this.exportHTML.y = -1;
                    }
                }
            }
            if (this.KEY_ANTIALIASING.getSimplePaper() != null) {
                boolean bl;
                this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().setMouseLoc(mouseEvent.getX(), mouseEvent.getY());
                Rectangle2D rectangle2D = this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getBounds();
                n2 = mouseEvent.getX() - this.KEY_ANTIALIASING.getSimplePaper().getBounds().x;
                int n5 = mouseEvent.getY() - this.KEY_ANTIALIASING.getSimplePaper().getBounds().y;
                boolean bl3 = bl = this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getLeftButtonBounds() != null && this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getLeftButtonBounds().contains(n2, n5) || this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getRightButtonBounds() != null && this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getRightButtonBounds().contains(n2, n5);
                if (bl) {
                    if (this.KEY_ANTIALIASING.getSimplePaper().isBench()) {
                        this.setCursor(Cursor.getPredefinedCursor(9));
                    } else {
                        this.setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (rectangle2D.contains(n2, n5)) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        this.WORDWRAPPER_GAP = mouseEvent.getPoint();
        this.draw = this.KEY_ANTIALIASING.getMousePosition(mouseEvent.getX(), mouseEvent.getY());
        this.contains(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        this.create(mouseEvent);
        if (this.KEY_ANTIALIASING.getSimplePaper() != null) {
            String string = this.SEDU.getChartID();
            float[] fArray2 = this.KEY_ANTIALIASING.getSimplePaper().getStartAndEndP();
            ChartExportTimeInfo chartExportTimeInfo = ((ChartExportInfoImpl)this.SEDU.getCommunicator().getExportTimeInfo().getChartExportTimeInfo()).getChartExportTimeInfo(string);
            if (chartExportTimeInfo == null) {
                ChartExportTimeInfoImpl chartExportTimeInfoImpl = new ChartExportTimeInfoImpl();
                chartExportTimeInfoImpl.setScrollBarInfo(fArray2);
                ((ChartExportInfoImpl)this.SEDU.getCommunicator().getExportTimeInfo().getChartExportTimeInfo()).getChartExportTimeInfo().put(string, chartExportTimeInfoImpl);
            } else {
                boolean bl = false;
                if (this.KEY_ANTIALIASING.getSimplePaper() != null && this.KEY_ANTIALIASING.getSimplePaper().getBounds().contains(mouseEvent.getPoint())) {
                    bl = true;
                }
                if (!bl) {
                    chartExportTimeInfo.setScrollBarInfo(fArray2);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        switch (this._xrot) {
            case 3: {
                this.WORDWRAPPER_GAP(mouseEvent);
                bl = true;
                break;
            }
            case 1: {
                this._xrot(mouseEvent);
                bl = true;
                break;
            }
            case 2: {
                this.abs(mouseEvent);
                bl = true;
                break;
            }
            default: {
                bl2 = this.booleanValue(mouseEvent);
            }
        }
        if (bl2) {
            this.VALUE_ANTIALIAS_ON.init();
            this.VALUE_ANTIALIAS_ON.locate();
            this.WORDWRAPPER_GAP = mouseEvent.getPoint();
            this.repaint();
        } else if (bl) {
            this.VALUE_ANTIALIAS_ON.locate();
            this.WORDWRAPPER_GAP = mouseEvent.getPoint();
            this.repaint();
        } else if (this.drawImage) {
            this.convertUnitToPixel(mouseEvent);
            this.repaint();
        } else {
            this.WORDWRAPPER_GAP = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        this.createChartPlatform(mouseEvent);
        boolean bl = true;
        if (this.get != null) {
            if (mouseEvent.getClickCount() == 1) {
                object = this.drawZomBut();
                boolean bl2 = true;
                int n = this.get[0];
                if (n != -1 && ((JReportViewer)object).isLCView()) {
                    bl2 = false;
                }
                if (bl2) {
                    try {
                        ((JReportViewer)object).I(this.get[0], this.get[2]);
                    }
                    catch (JRStopEngineException jRStopEngineException) {
                        ViewerTools.I(131600, jRStopEngineException);
                    }
                }
            }
        } else if (mouseEvent.getClickCount() == 2) {
            Object object2;
            Object object3;
            object = this.VALUE_ANTIALIAS_ON.getDrilldown();
            String string = this.VALUE_ANTIALIAS_ON.getXDim();
            String string2 = this.VALUE_ANTIALIAS_ON.getZDim();
            if (this.custommerConstant != null && this.custommerConstant.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                object = null;
            }
            if (object != null) {
                object3 = this.VALUE_ANTIALIAS_ON.getDrilldownGroup();
                object2 = this.getParent();
                while (!(object2 instanceof ChartDrillDownImplementor)) {
                    object2 = ((Component)object2).getParent();
                }
                if (object2 != null) {
                    String string3 = this.getHyperLink(object3[0], object3[1]);
                    if (string3 != null && !string3.equals("")) {
                        ((ChartDrillDownImplementor)object2).drilldownInChart(string3, this.SEDU.getSection());
                    } else {
                        DSSection dSSection = this.SEDU.getSection();
                        if (dSSection != null && ((Boolean)this.SEDU.getPropertyByName("GotoDetail").getObject()).booleanValue()) {
                            try {
                                ((ChartDrillDownImplementor)object2).drilldownInChart(object3[0], object3[1], dSSection);
                            }
                            catch (JRStopEngineException jRStopEngineException) {
                                JRLog.error(131600, jRStopEngineException);
                            }
                        }
                    }
                }
            }
            if (string != null) {
                object3 = this.getParent();
                while (!(object3 instanceof ChartDrillDownImplementor)) {
                    object3 = ((Component)object3).getParent();
                }
                if (object3 != null && (object2 = this.getXHyperLink(string)) != null && !((String)object2).equals("")) {
                    ((ChartDrillDownImplementor)object3).drilldownInChart((String)object2, this.SEDU.getSection());
                }
            }
            if (string2 != null) {
                object3 = this.getParent();
                while (!(object3 instanceof ChartDrillDownImplementor)) {
                    object3 = ((Component)object3).getParent();
                }
                if (object3 != null && (object2 = this.getZHyperLink(string2)) != null && !((String)object2).equals("")) {
                    ((ChartDrillDownImplementor)object3).drilldownInChart((String)object2, this.SEDU.getSection());
                }
            }
        }
        if (mouseEvent.getClickCount() == 2) {
            int n = mouseEvent.getPoint().x;
            int n2 = mouseEvent.getPoint().y;
            this.clipRect(n, n2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void WORDWRAPPER_GAP(MouseEvent mouseEvent) {
        float f = this.KEY_ANTIALIASING.getHeight();
        f = f < (float)this.KEY_ANTIALIASING.getWidth() ? f : (float)this.KEY_ANTIALIASING.getWidth();
        this.abs[0] = this.abs[0] + (float)Math.round((float)((double)((float)(mouseEvent.getX() - this.WORDWRAPPER_GAP.x) * 360.0f / f) / Math.PI));
        this.abs[0] = this.abs[0] < 0.0f ? 360.0f + this.abs[0] : this.abs[0];
        this.abs[0] = this.abs[0] > 360.0f ? this.abs[0] - 360.0f : this.abs[0];
        this.abs[1] = this.abs[1] + (float)Math.round((float)((double)((float)(this.WORDWRAPPER_GAP.y - mouseEvent.getY()) * 180.0f / f) / Math.PI));
        this.abs[1] = this.abs[1] > 90.0f ? 90.0f : this.abs[1];
        this.abs[1] = this.abs[1] < 0.0f ? 0.0f : this.abs[1];
        this.VALUE_ANTIALIAS_ON.properties.getGraphProperties().setPieYRotation(this.abs[1]);
        this.VALUE_ANTIALIAS_ON.properties.getGraphProperties().setPieXRotation(this.abs[0]);
    }

    private void _xrot(MouseEvent mouseEvent) {
        float[] fArray2;
        fArray2 = new float[]{(float)((double)fArray2[0] + (double)((float)(mouseEvent.getY() - this.WORDWRAPPER_GAP.y) * 360.0f / (float)this.KEY_ANTIALIASING.getWidth()) / Math.PI), (float)((double)fArray2[1] + (double)((float)(this.WORDWRAPPER_GAP.x - mouseEvent.getX()) * 360.0f / (float)this.KEY_ANTIALIASING.getHeight()) / Math.PI)};
        this.contains.unit();
        this.contains.xrot(fArray2[0]);
        this.contains.yrot(fArray2[1]);
        this.m.mul(this.contains);
        this.VALUE_ANTIALIAS_ON.properties.setRotationMatrix(this.m.getMatrix());
    }

    private void abs(MouseEvent mouseEvent) {
        float[] fArray2;
        fArray2 = new float[]{(float)((double)fArray2[0] + (double)((float)(this.WORDWRAPPER_GAP.x - mouseEvent.getX()) * 360.0f / (float)this.KEY_ANTIALIASING.getHeight()) / Math.PI), (float)((double)fArray2[1] + (double)((float)(mouseEvent.getY() - this.WORDWRAPPER_GAP.y) * 360.0f / (float)this.KEY_ANTIALIASING.getWidth()) / Math.PI)};
        this.contains.unit();
        this.contains.xrot(fArray2[0]);
        this.contains.yrot(fArray2[1]);
        this.m.mul(this.contains);
        this.VALUE_ANTIALIAS_ON.properties.setRotationMatrix(this.m.getMatrix());
    }

    private boolean booleanValue(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING.getSimplePaper() == null) {
            return false;
        }
        boolean bl = false;
        int n = 5;
        int n2 = 0;
        int n3 = 0;
        int n4 = mouseEvent.getX() - this.WORDWRAPPER_GAP.x;
        if (this.KEY_ANTIALIASING.getSimplePaper().isBench()) {
            n4 = mouseEvent.getY() - this.WORDWRAPPER_GAP.y;
        }
        switch (this.draw) {
            case 1: {
                n2 = 0;
                n3 = n4;
                break;
            }
            case 0: {
                n2 = n4;
                n3 = 0;
                break;
            }
            case 2: {
                n2 = n4;
                n3 = n4;
                break;
            }
            default: {
                return false;
            }
        }
        if (this.WORDWRAPPER_GAP == null) {
            return false;
        }
        if (this.WORDWRAPPER_GAP != null && !this.KEY_ANTIALIASING.getSimplePaper().getBounds().contains(this.WORDWRAPPER_GAP)) {
            return false;
        }
        if (!this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().isOutBounds(n2, n3)) {
            this.KEY_ANTIALIASING.setMoveLenght(n2, n3);
            this.KEY_ANTIALIASING.getSimplePaper().setShowIndex();
            this.KEY_ANTIALIASING.getSimplePaper().locate();
            this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().setMouseLoc(mouseEvent.getX(), mouseEvent.getY());
            ChartExportTimeInfo chartExportTimeInfo = ((ChartExportInfoImpl)this.SEDU.getCommunicator().getExportTimeInfo().getChartExportTimeInfo()).getChartExportTimeInfo(this.SEDU.getChartID());
            if (chartExportTimeInfo != null) {
                if (this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getStartAndEndP() != null) {
                    chartExportTimeInfo.setScrollBarInfo(this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getStartAndEndP());
                } else {
                    chartExportTimeInfo.setScrollBarInfo(this.KEY_ANTIALIASING.getScrollbarInfo());
                }
            }
            return true;
        }
        return false;
    }

    public String getHyperLink(String string, String string2) {
        String string3 = this.convertUnitToPixel;
        string3 = string3 != null && !string3.equals("") ? JReportChartPlatform.parseHyperLink(string3, string, string2) : null;
        return string3;
    }

    public String getXHyperLink(String string) {
        String string2 = this.create;
        if (string2 != null) {
            string2 = JReportChartPlatform.parseXHyperLink(string2, string);
        }
        return string2;
    }

    public String getZHyperLink(String string) {
        String string2 = this.createChartPlatform;
        if (string2 != null) {
            string2 = JReportChartPlatform.parseZHyperLink(string2, string);
        }
        return string2;
    }

    public static String parseZHyperLink(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = stringBuffer.toString().indexOf("@ZDIM");
        if (n != -1) {
            stringBuffer.replace(n, n + 5, string2);
        }
        return stringBuffer.toString();
    }

    public static String parseXHyperLink(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = stringBuffer.toString().indexOf("@XDIM");
        if (n != -1) {
            stringBuffer.replace(n, n + 5, string2);
        }
        return stringBuffer.toString();
    }

    public static String parseHyperLink(String string, String string2, String string3) {
        return ChartHtmlMapExport.parseHyperLink(string, string2, string3);
    }

    public List getCompInfoForDHTML() {
        if (this.KEY_ANTIALIASING == null) {
            return null;
        }
        ChartHtmlMapExport chartHtmlMapExport = new ChartHtmlMapExport(this.KEY_ANTIALIASING);
        return chartHtmlMapExport.getCompInfoForDHTML();
    }

    @Override
    public void update(Graphics graphics) {
        this.repaint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void clipRect(int n, int n2) {
        if (this.KEY_ANTIALIASING.getSimplePaper() == null) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        if (!this.KEY_ANTIALIASING.getSimplePaper().getBounds().contains(n3, n4) || this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getBounds().contains(n3, n4)) {
            return;
        }
        Rectangle2D rectangle2D = this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().getBounds();
        float f = 0.0f;
        if (!this.KEY_ANTIALIASING.getSimplePaper().isBench()) {
            if ((double)n3 < rectangle2D.getX()) {
                f = (float)((double)n3 - rectangle2D.getX());
            } else {
                if (!((double)n3 > rectangle2D.getX() + rectangle2D.getWidth())) return;
                f = (float)((double)n3 - (rectangle2D.getX() + rectangle2D.getWidth()));
            }
        } else if ((double)n4 < rectangle2D.getY()) {
            f = (float)((double)n4 - rectangle2D.getY());
        } else {
            if (!((double)n4 > rectangle2D.getY() + rectangle2D.getHeight())) return;
            f = (float)((double)n4 - (rectangle2D.getY() + rectangle2D.getHeight()));
        }
        float f2 = f;
        float f3 = f;
        if (this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().isOutBounds(f2, f3)) return;
        this.KEY_ANTIALIASING.setMoveLenght(f2, f3);
        this.KEY_ANTIALIASING.getSimplePaper().locate();
        this.KEY_ANTIALIASING.getSimplePaper().setShowIndex();
        this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().setMouseLoc(n3, n4);
        this.VALUE_ANTIALIAS_ON.init();
        this.VALUE_ANTIALIAS_ON.locate();
        this.repaint();
    }

    void contains(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        int n = mouseEvent.getPoint().x;
        int n2 = mouseEvent.getPoint().y;
        if (this.drilldownInChart != null && this.drilldownInChart.contains(mouseEvent.getPoint())) {
            this.equalsIgnoreCase = true;
            this.repaint();
            return;
        }
        if (this.KEY_ANTIALIASING.isSupportScrollChart()) {
            Rectangle rectangle = ChartRenderTools.getGraphArea(this.KEY_ANTIALIASING.getChartCoordinatePaper().getGraphArea(), this.KEY_ANTIALIASING.getChartCoordinatePaper());
            if (rectangle.contains(n, n2)) {
                this.drawImage = true;
                this.drawZomBut = new Point();
                this.drawZomBut.x = n;
                this.drawZomBut.y = n2;
            } else {
                this.drawImage = false;
            }
        }
    }

    void convertUnitToPixel(MouseEvent mouseEvent) {
        Point point;
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        if (!this.drawImage || this.drawZomBut == null) {
            return;
        }
        Rectangle rectangle = ChartRenderTools.getGraphArea(this.KEY_ANTIALIASING.getChartCoordinatePaper().getGraphArea(), this.KEY_ANTIALIASING.getChartCoordinatePaper());
        if (!rectangle.contains(point = mouseEvent.getPoint())) {
            return;
        }
        boolean bl = false;
        int n = ChartTypeInfo.getPrimType(this.KEY_ANTIALIASING.getChartDefinition().getChartDataSetInfos()[0].getChartType());
        if (n == 1) {
            bl = true;
        }
        this.drawNode = new Rectangle();
        if (bl) {
            this.drawNode.x = rectangle.x;
            this.drawNode.width = rectangle.width;
            this.drawNode.y = this.drawZomBut.y < point.y ? this.drawZomBut.y : point.y;
            this.drawNode.height = Math.abs(this.drawZomBut.y - point.y);
        } else {
            this.drawNode.y = rectangle.y;
            this.drawNode.height = rectangle.height;
            this.drawNode.x = this.drawZomBut.x < point.x ? this.drawZomBut.x : point.x;
            this.drawNode.width = Math.abs(this.drawZomBut.x - point.x);
        }
        if (this.elementAt == null) {
            this.elementAt = new float[2];
        }
        if (bl) {
            this.elementAt[0] = (float)(rectangle.y + rectangle.height - this.drawNode.y - this.drawNode.height) * 1.0f / (float)rectangle.height;
            this.elementAt[1] = (float)(rectangle.y + rectangle.height - this.drawNode.y) * 1.0f / (float)rectangle.height;
        } else {
            this.elementAt[0] = (float)(rectangle.x + rectangle.width - this.drawNode.x - this.drawNode.width) * 1.0f / (float)rectangle.width;
            this.elementAt[1] = (float)(rectangle.x + rectangle.width - this.drawNode.x) * 1.0f / (float)rectangle.width;
        }
        this.repaint();
    }

    void create(MouseEvent mouseEvent) {
        Cloneable cloneable;
        Object object;
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        if (this.KEY_ANTIALIASING.isSupportScrollChart() && this.drawImage && this.elementAt != null) {
            object = this.KEY_ANTIALIASING.getScrollbarInfo();
            cloneable = mouseEvent.getPoint();
            boolean bl = false;
            boolean bl2 = bl = this.drawZomBut.x == cloneable.x || this.drawZomBut.y == cloneable.y;
            if (object != null && !bl) {
                Object object2;
                float[] fArray2;
                int n;
                int n2;
                Rectangle rectangle = ChartRenderTools.getGraphArea(this.KEY_ANTIALIASING.getChartCoordinatePaper().getGraphArea(), this.KEY_ANTIALIASING.getChartCoordinatePaper());
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = true;
                int n3 = 0;
                if (this.KEY_ANTIALIASING.getDataSetModel() != null && this.KEY_ANTIALIASING.getDataSetModel().getSeriesN() != null) {
                    bl4 = !this.KEY_ANTIALIASING.getDataSetModel().getSeriesN().equals("");
                    n3 = this.KEY_ANTIALIASING.getDataSetModel().getCategoryCount();
                }
                if (this.KEY_ANTIALIASING.getDataSetModel() != null) {
                    n3 = this.KEY_ANTIALIASING.getDataSetModel().getCategoryCount();
                    List list = this.KEY_ANTIALIASING.getDataSetModel().getChartDataSets();
                    if (list != null) {
                        for (n2 = 0; n2 < list.size(); ++n2) {
                            if (this.KEY_ANTIALIASING.getDataSetModel().getChartDataSet(n2).getShowValueEndIndex() - this.KEY_ANTIALIASING.getDataSetModel().getChartDataSet(n2).getShowValueBeginIndex() <= 1) continue;
                            bl4 = true;
                        }
                    }
                }
                if ((n = ChartTypeInfo.getPrimType(this.KEY_ANTIALIASING.getChartDefinition().getChartDataSetInfos()[0].getChartType())) == 1) {
                    bl3 = true;
                }
                n2 = ChartTypeInfo.getSubType(this.KEY_ANTIALIASING.getChartDefinition().getChartDataSetInfos()[0].getChartType());
                if (n == 0 && n2 == 0) {
                    bl4 = false;
                }
                if (this.elementAt == null) {
                    this.elementAt = new float[2];
                }
                if (bl3) {
                    this.elementAt[0] = this.drawZomBut.y > cloneable.y ? this.drawZomBut.y : cloneable.y;
                    this.elementAt[0] = this.elementAt[0] - (float)(rectangle.y + rectangle.height);
                    this.elementAt[0] = this.elementAt[0] / (float)rectangle.height;
                    this.elementAt[0] = Math.abs(this.elementAt[0]);
                    this.elementAt[1] = this.drawZomBut.y - cloneable.y;
                    this.elementAt[1] = this.elementAt[1] / (float)rectangle.height;
                    this.elementAt[1] = Math.abs(this.elementAt[1]);
                    this.elementAt[1] = this.elementAt[1] + this.elementAt[0];
                    if (this.elementAt[0] > this.elementAt[1]) {
                        this.elementAt[1] = this.elementAt[1] + this.elementAt[0];
                        this.elementAt[0] = this.elementAt[1] - this.elementAt[0];
                        this.elementAt[1] = this.elementAt[1] - this.elementAt[0];
                    }
                    if (this.VALUE_ANTIALIAS_ON instanceof Chart2DPaper && (((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getAxisX1() != null && !((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getAxisX1().custommerConstant() || ((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getAxisX2() != null && !((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getAxisX2().custommerConstant())) {
                        fArray2 = null;
                        bl5 = false;
                        if (!bl4) {
                            fArray2 = ChartRenderTools.getScrollInfo(this.drawNode, this.VALUE_ANTIALIAS_ON, this.KEY_ANTIALIASING.getDataSetModel());
                        } else {
                            fArray2 = new float[2];
                            fArray2[0] = rectangle.y + rectangle.height - (this.drawNode.y + this.drawNode.height);
                            fArray2[0] = fArray2[0] / (float)rectangle.height;
                            fArray2[1] = rectangle.y + rectangle.height - this.drawNode.y;
                            fArray2[1] = fArray2[1] / (float)rectangle.height;
                            float f = fArray2[0] > 1.0f ? 1.0f : (fArray2[0] = fArray2[0] < 0.0f ? 0.0f : fArray2[0]);
                            fArray2[1] = fArray2[1] > 1.0f ? 1.0f : (fArray2[1] < 0.0f ? 0.0f : fArray2[1]);
                            float f2 = fArray2[1] = fArray2[1] < fArray2[0] ? fArray2[0] : fArray2[1];
                            if (n3 != 0) {
                                object[0] = (int)(object[0] * (float)n3);
                                object[1] = (int)(object[1] * (float)n3);
                                object[0] = object[0] / (float)n3;
                                object[1] = object[1] / (float)n3;
                            }
                        }
                        if (fArray2 == null) {
                            this.elementAt[0] = 0.0f;
                            this.elementAt[1] = 1.0f;
                        } else {
                            this.elementAt[0] = fArray2[0];
                            this.elementAt[1] = fArray2[1];
                        }
                    }
                } else {
                    this.elementAt[0] = this.drawZomBut.x < cloneable.x ? this.drawZomBut.x : cloneable.x;
                    this.elementAt[0] = this.elementAt[0] - (float)rectangle.x;
                    this.elementAt[0] = this.elementAt[0] / (float)rectangle.width;
                    this.elementAt[1] = Math.abs(this.drawZomBut.x - cloneable.x);
                    this.elementAt[1] = this.elementAt[1] / (float)rectangle.width;
                    this.elementAt[1] = this.elementAt[1] + this.elementAt[0];
                    if (this.VALUE_ANTIALIAS_ON instanceof Chart2DPaper && (((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getAxisX1() != null && !((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getAxisX1().custommerConstant() || ((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getAxisX2() != null && !((Chart2DPaper)this.VALUE_ANTIALIAS_ON).getAxisX2().custommerConstant())) {
                        fArray2 = null;
                        bl5 = false;
                        if (!bl4) {
                            fArray2 = ChartRenderTools.getScrollInfo(this.drawNode, this.VALUE_ANTIALIAS_ON, this.KEY_ANTIALIASING.getDataSetModel());
                        } else {
                            fArray2 = new float[2];
                            fArray2[0] = this.drawNode.x - rectangle.x;
                            fArray2[0] = fArray2[0] / (float)rectangle.width;
                            fArray2[1] = this.drawNode.x + this.drawNode.width - rectangle.x;
                            fArray2[1] = fArray2[1] / (float)rectangle.width;
                            float f = fArray2[0] > 1.0f ? 1.0f : (fArray2[0] = fArray2[0] < 0.0f ? 0.0f : fArray2[0]);
                            fArray2[1] = fArray2[1] > 1.0f ? 1.0f : (fArray2[1] < 0.0f ? 0.0f : fArray2[1]);
                            float f3 = fArray2[1] = fArray2[1] < fArray2[0] ? fArray2[0] : fArray2[1];
                            if (n3 != 0) {
                                object[0] = (int)(object[0] * (float)n3);
                                object[1] = (int)(object[1] * (float)n3);
                                object[0] = object[0] / (float)n3;
                                object[1] = object[1] / (float)n3;
                            }
                        }
                        if (fArray2 == null) {
                            this.elementAt[0] = 0.0f;
                            this.elementAt[1] = 1.0f;
                        } else {
                            this.elementAt[0] = fArray2[0];
                            this.elementAt[1] = fArray2[1];
                        }
                    }
                }
                this.elementAt[1] = this.elementAt[1] > 1.0f ? 1.0f : this.elementAt[1];
                this.elementAt[0] = this.elementAt[0] < 0.0f ? 0.0f : this.elementAt[0];
                float f = object[1] - object[0];
                float f4 = object[0] + f * this.elementAt[0];
                float f5 = object[0] + f * this.elementAt[1];
                if (bl4) {
                    f5 = (f5 += n3 <= 0 ? 0.0f : 1.0f / (float)n3 - f5 % (1.0f / (float)n3)) > 1.0f ? 1.0f : (f5 < f4 ? f4 : f5);
                }
                object[0] = f4;
                object[1] = f5;
                this.KEY_ANTIALIASING.setScrollbarInfo((float[])object);
                this.VALUE_ANTIALIAS_ON.init();
                this.VALUE_ANTIALIAS_ON.locate();
                if (this.KEY_ANTIALIASING.getSimplePaper() != null) {
                    if (n3 != 0 && !bl5) {
                        object2 = new float[2];
                        object2[0] = (float)((int)(object[0] * (float)n3));
                        object2[1] = (float)((int)(object[1] * (float)n3));
                        object2[0] = object2[0] / (float)n3;
                        object2[1] = object2[1] / (float)n3;
                        this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().setScrollInfo((float[])object2);
                    } else {
                        this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().setScrollInfo((float[])object);
                    }
                    this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().locate();
                }
                object2 = this.SEDU.getChartID();
                float[] fArray3 = this.KEY_ANTIALIASING.getScrollbarInfo();
                ChartExportTimeInfo chartExportTimeInfo = ((ChartExportInfoImpl)this.SEDU.getCommunicator().getExportTimeInfo().getChartExportTimeInfo()).getChartExportTimeInfo((String)object2);
                if (chartExportTimeInfo == null) {
                    chartExportTimeInfo = new ChartExportTimeInfoImpl();
                    chartExportTimeInfo.setScrollBarInfo(fArray3);
                    ((ChartExportInfoImpl)this.SEDU.getCommunicator().getExportTimeInfo().getChartExportTimeInfo()).getChartExportTimeInfo().put(object2, chartExportTimeInfo);
                } else {
                    chartExportTimeInfo.setScrollBarInfo(fArray3);
                }
                this.repaint();
            }
        }
        if (this.drilldownInChart != null && this.drilldownInChart.contains(mouseEvent.getPoint())) {
            this.equalsIgnoreCase = false;
        }
        if (this.drilldownInChart != null) {
            object = ChartRenderTools.getGraphArea(this.KEY_ANTIALIASING.getChartCoordinatePaper().getGraphArea(), this.KEY_ANTIALIASING.getChartCoordinatePaper());
            this.drilldownInChart.x = object.x + object.width - 25;
            this.drilldownInChart.y = object.y;
            cloneable = this.KEY_ANTIALIASING.getChartCoordinatePaper().getBounds();
            if (object.x + object.width > ((Rectangle)cloneable).x + ((Rectangle)cloneable).width) {
                this.drilldownInChart.x = ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - 25;
            }
            if (object.y < ((Rectangle)cloneable).y) {
                this.drilldownInChart.y = ((Rectangle)cloneable).y;
            }
        }
        this.repaint();
        this.drawImage = false;
    }

    void createChartPlatform(MouseEvent mouseEvent) {
        if (this.KEY_ANTIALIASING == null || !this.createChildren) {
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (this.KEY_ANTIALIASING.isSupportScrollChart() && this.drilldownInChart != null && this.drilldownInChart.contains(point)) {
            float[] fArray2 = new float[]{0.0f, 1.0f};
            this.KEY_ANTIALIASING.setScrollbarInfo(fArray2);
            this.VALUE_ANTIALIAS_ON.init();
            this.VALUE_ANTIALIAS_ON.locate();
            if (this.KEY_ANTIALIASING.getSimplePaper() != null) {
                this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().setScrollInfo(fArray2);
                this.KEY_ANTIALIASING.getSimplePaper().getScrollbar().locate();
            }
            if (this.drilldownInChart != null) {
                Rectangle rectangle = ChartRenderTools.getGraphArea(this.KEY_ANTIALIASING.getChartCoordinatePaper().getGraphArea(), this.KEY_ANTIALIASING.getChartCoordinatePaper());
                this.drilldownInChart.x = rectangle.x + rectangle.width - 25;
                this.drilldownInChart.y = rectangle.y;
                Rectangle rectangle2 = this.KEY_ANTIALIASING.getChartCoordinatePaper().getBounds();
                if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                    this.drilldownInChart.x = rectangle2.x + rectangle2.width - 25;
                }
                if (rectangle.y < rectangle2.y) {
                    this.drilldownInChart.y = rectangle2.y;
                }
            }
            this.repaint();
        }
    }

    void createChildren(Graphics2D graphics2D) {
        if (this.drawImage) {
            // empty if block
        }
    }

    void custommerConstant(Graphics2D graphics2D) {
        ChartDataSetInfo[] chartDataSetInfoArray;
        int n;
        ChartDefinition chartDefinition = this.KEY_ANTIALIASING.getChartDefinition();
        if (chartDefinition != null && (n = ChartTypeInfo.getPrimType((chartDataSetInfoArray = chartDefinition.getChartDataSetInfos())[0].getChartType())) == 10) {
            return;
        }
        if (this.drawNode != null && this.drawImage) {
            ChartRenderTools.getSelectAreaFillColor().fill(graphics2D, this.drawNode);
            ChartRenderTools.getSelectAreaPen().draw(graphics2D, this.drawNode);
        }
    }

    void draw(MouseEvent mouseEvent) {
        this.equals = this.drilldownInChart != null && this.drilldownInChart.contains(mouseEvent.getPoint());
    }

    void drawImage(Graphics2D graphics2D) {
        if (!this.KEY_ANTIALIASING.isSupportScrollChart()) {
            return;
        }
        Rectangle rectangle = ChartRenderTools.getGraphArea(this.KEY_ANTIALIASING.getChartCoordinatePaper().getGraphArea(), this.KEY_ANTIALIASING.getChartCoordinatePaper());
        Rectangle rectangle2 = this.KEY_ANTIALIASING.getChartCoordinatePaper().getBounds();
        if (this.drilldownInChart == null) {
            this.drilldownInChart = new Rectangle(rectangle.x + rectangle.width - 25, rectangle.y, 25, 25);
        } else {
            this.drilldownInChart.x = rectangle.x + rectangle.width - 25;
            this.drilldownInChart.y = rectangle.y;
        }
        if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            this.drilldownInChart.x = rectangle2.x + rectangle2.width - 25;
        }
        if (rectangle.y < rectangle2.y) {
            this.drilldownInChart.y = rectangle2.y;
        }
        boolean bl = false;
        if (this.KEY_ANTIALIASING != null) {
            if (this.KEY_ANTIALIASING.getScrollbarInfo() == null) {
                bl = true;
            }
            float[] fArray2 = null;
            fArray2 = this.KEY_ANTIALIASING.getScrollbarInfo();
            if (fArray2 != null && fArray2[0] == 0.0f && fArray2[1] == 1.0f) {
                bl = true;
            }
        }
        if (bl) {
            this.drilldownInChart.width = 0;
            this.drilldownInChart.height = 0;
        } else {
            this.drilldownInChart.width = 25;
            this.drilldownInChart.height = 25;
        }
        ChartRenderTools.drawZomBut(graphics2D, this.drilldownInChart, this.equalsIgnoreCase, this.equals);
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (!this.floatValue) {
            return;
        }
        super.setCursor(cursor);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.drawNode(actionEvent);
    }

    private void drawNode(ActionEvent actionEvent) {
        if (this.KEY_ANTIALIASING.getChartLegend() == null || !this.KEY_ANTIALIASING.getProperties().isShowLegend()) {
            return;
        }
        if (!this.KEY_ANTIALIASING.getProperties().isShowLegend()) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string != null && string.equals("HideLegendLabels")) {
            this.KEY_ANTIALIASING.setIsExpandLegend(false);
            this.KEY_ANTIALIASING.getChartLegend().init();
            this.KEY_ANTIALIASING.locate();
            this.repaint();
            return;
        }
        if (string != null && string.equals("ShowLegendLabels")) {
            this.KEY_ANTIALIASING.setIsExpandLegend(true);
            this.KEY_ANTIALIASING.getChartLegend().init();
            this.KEY_ANTIALIASING.locate();
            this.repaint();
            return;
        }
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
    }

    @Override
    public void setLcView(boolean bl) {
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
        this.info = exportingInfo;
    }

    private JReportViewer drawZomBut() {
        Container container = this.getParent();
        while (!(container instanceof JReportViewer)) {
            container = container.getParent();
        }
        return (JReportViewer)container;
    }
}

