/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import jet.datastream.DSContainer;
import jet.datastream.DSParagraph;
import jet.datastream.JRObjectResult;
import jet.thinviewer.JReportContainer;
import jet.thinviewer.ViewerTools;
import jet.udo.JRObjectRender;
import jet.util.JRInterruptedException;
import jet.util.PropertySetable;

public class JReportParagraph
extends JReportContainer {
    private Rectangle I;
    int[] SEDU = new int[4];
    int[] convertUnitToPixel = new int[4];
    Color[] createComponent = new Color[4];
    private boolean error = true;
    private boolean get = false;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        super.setProperty(propertySetable);
        DSParagraph dSParagraph = (DSParagraph)propertySetable;
        if (!this.get) {
            this.setBounds(dSParagraph.getBounds());
        }
        try {
            DSContainer dSContainer = (DSContainer)propertySetable;
            this.SEDU[0] = this.getIntPropertyByName(dSContainer, "TopLine");
            this.SEDU[1] = this.getIntPropertyByName(dSContainer, "BottomLine");
            this.SEDU[2] = this.getIntPropertyByName(dSContainer, "LeftLine");
            this.SEDU[3] = this.getIntPropertyByName(dSContainer, "RightLine");
            this.convertUnitToPixel[0] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-top-width"), this.resolution);
            this.convertUnitToPixel[1] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-bottom-width"), this.resolution);
            this.convertUnitToPixel[2] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-left-width"), this.resolution);
            this.convertUnitToPixel[3] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-right-width"), this.resolution);
            this.createComponent[0] = this.getColorPropertyByName(dSContainer, "border-top-color");
            this.createComponent[1] = this.getColorPropertyByName(dSContainer, "border-bottom-color");
            this.createComponent[2] = this.getColorPropertyByName(dSContainer, "border-left-color");
            this.createComponent[3] = this.getColorPropertyByName(dSContainer, "border-right-color");
        }
        catch (NullPointerException nullPointerException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401520, propertySetable, (Throwable)nullPointerException);
            }
            this.error = false;
        }
    }

    protected void setActualSize(Rectangle rectangle) {
        this.I = rectangle;
    }

    @Override
    public void createChildren(DSContainer dSContainer) {
        this.removeAll();
        List list = dSContainer.getChildren();
        list = ViewerTools.I(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
            JRObjectRender jRObjectRender = null;
            if (!this.info.isExport(jRObjectResult)) continue;
            try {
                jRObjectRender = this.createComponent(jRObjectResult);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                ViewerTools.I(2401507, exception);
            }
            if (jRObjectRender == null) continue;
            this.add((Component)((Object)jRObjectRender));
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.get) {
            graphics.setClip(this.I.x, this.I.y, this.I.width, this.I.height);
        }
        super.paint(graphics);
        if (this.error) {
            Dimension dimension = new Dimension(this.I.width, this.I.height);
            Color color = this.hasEraser() ? this.getBackground() : null;
            ViewerTools.I(graphics, dimension, color, this.SEDU, this.convertUnitToPixel, this.createComponent, false, false, false, false, null, 0);
        }
    }

    public void resetXY(boolean bl) {
    }
}

