/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import jet.connect.DbArray;
import jet.connect.DbDateTime;
import jet.connect.DbValue;
import jet.datasource.hds.ArrayImpl;
import jet.util.DbValueFormat;

public class DateTimeFormat
extends SimpleDateFormat
implements DbValueFormat {
    public DateTimeFormat() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(String string) {
        super(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(String string, TimeZone timeZone) {
        super(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(String string, DateFormatSymbols dateFormatSymbols) {
        super(string, dateFormatSymbols);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        this.setCalendar(gregorianCalendar);
    }

    public DateTimeFormat(String string, DateFormatSymbols dateFormatSymbols, TimeZone timeZone) {
        super(string, dateFormatSymbols);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        this.setCalendar(gregorianCalendar);
    }

    @Override
    public synchronized String format(DbValue dbValue) {
        Date date = ((DbDateTime)dbValue).toUtilDate();
        return this.format(date);
    }

    private String SEDU(DbValue dbValue, String string) {
        String string2 = null;
        int n = dbValue.getSqlType();
        switch (n) {
            case 91: {
                Date[] dateArray = (Date[])((DbArray)dbValue).getValue();
                for (int i = 0; i < dateArray.length; ++i) {
                    string2 = i == 0 ? this.format(dateArray[i]) : string2 + string + this.format(dateArray[i]);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])((DbArray)dbValue).getValue();
                for (int i = 0; i < timeArray.length; ++i) {
                    string2 = i == 0 ? this.format(timeArray[i]) : string2 + string + this.format(timeArray[i]);
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])((DbArray)dbValue).getValue();
                for (int i = 0; i < timestampArray.length; ++i) {
                    string2 = i == 0 ? this.format(timestampArray[i]) : string2 + string + this.format(timestampArray[i]);
                }
                break;
            }
        }
        return string2;
    }

    @Override
    public synchronized String format(DbValue dbValue, String string) {
        Object object = ((DbArray)dbValue).getValue();
        if (object instanceof Date[] || object instanceof Time[] || object instanceof Timestamp[]) {
            return this.SEDU(dbValue, string);
        }
        String string2 = null;
        int n = dbValue.getSqlType();
        switch (n) {
            case 91: 
            case 92: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                for (int i = 0; i < lArray.length; ++i) {
                    string2 = i == 0 ? this.format(new Date(lArray[i])) : string2 + string + this.format(new Date(lArray[i]));
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int[] nArray = ((DbArray)dbValue).getNanos();
                for (int i = 0; i < lArray.length; ++i) {
                    string2 = i == 0 ? this.format(new Date(lArray[i] + (long)(nArray[i] / 1000000))) : string2 + string + this.format(new Date(lArray[i] + (long)(nArray[i] / 1000000)));
                }
                break;
            }
        }
        return string2;
    }

    @Override
    public String getPattern() {
        return this.toPattern();
    }

    @Override
    public String getLocalizedPattern() {
        return this.toLocalizedPattern();
    }

    @Override
    public void applyPattern(String string) {
        super.applyPattern(string);
    }

    @Override
    public void applyLocalizedPattern(String string) {
        super.applyLocalizedPattern(string);
    }

    @Override
    public void parse(DbValue dbValue, String string) {
        ((DbDateTime)dbValue).set(this.parse(string, new ParsePosition(0)).getTime());
    }

    @Override
    public void parse(DbValue dbValue, String string, String string2) throws ParseException, SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        ArrayImpl arrayImpl = new ArrayImpl(dbValue.getSqlType(), this);
        arrayImpl.setValue(vector);
        ((DbArray)dbValue).set(arrayImpl);
    }

    @Override
    public String[] formatArray(DbArray dbArray) {
        String[] stringArray;
        block15: {
            Object object;
            int n;
            block14: {
                stringArray = null;
                n = dbArray.getSqlType();
                object = dbArray.getValue();
                if (!(object instanceof Date[]) && !(object instanceof Time[]) && !(object instanceof Timestamp[])) break block14;
                switch (n) {
                    case 91: {
                        Date[] dateArray = (Date[])dbArray.getValue();
                        stringArray = new String[dateArray.length];
                        for (int i = 0; i < dateArray.length; ++i) {
                            stringArray[i] = this.format(dateArray[i]);
                        }
                        break block15;
                    }
                    case 92: {
                        Time[] timeArray = (Time[])dbArray.getValue();
                        stringArray = new String[timeArray.length];
                        for (int i = 0; i < timeArray.length; ++i) {
                            stringArray[i] = this.format(timeArray[i]);
                        }
                        break block15;
                    }
                    case 93: {
                        Timestamp[] timestampArray = (Timestamp[])dbArray.getValue();
                        stringArray = new String[timestampArray.length];
                        for (int i = 0; i < timestampArray.length; ++i) {
                            stringArray[i] = this.format(timestampArray[i]);
                        }
                        break block15;
                    }
                }
                break block15;
            }
            switch (n) {
                case 91: 
                case 92: {
                    long[] lArray = (long[])object;
                    stringArray = new String[lArray.length];
                    for (int i = 0; i < lArray.length; ++i) {
                        stringArray[i] = this.format(new Date(lArray[i]));
                    }
                    break;
                }
                case 93: {
                    long[] lArray = (long[])object;
                    stringArray = new String[lArray.length];
                    int[] nArray = dbArray.getNanos();
                    for (int i = 0; i < lArray.length; ++i) {
                        stringArray[i] = this.format(new Date(lArray[i] + (long)(nArray[i] / 1000000)));
                    }
                    break;
                }
            }
        }
        return stringArray;
    }
}

