/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.GuiComponent;
import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.HyperLinkExecutable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class HyperLinkField
extends GuiComponent
implements PainterConstants,
Externalizable {
    private String I;
    private String SEDU;
    private HyperLinkExecutable blue;
    private Image drawImage;
    private boolean drawText = false;
    private boolean execute = false;
    private int fillRect = 4;
    private boolean getHeight = true;
    private boolean getID = true;
    private boolean getPredefinedCursor = true;

    public HyperLinkField() {
        this.enableEvents(16L);
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(Color.white);
        this.setForeground(Color.blue);
    }

    public void setDisplayValue(String string) {
        this.I = string;
    }

    public String getDisplayValue() {
        return this.I;
    }

    public void setDisplayImage(Image image) {
        this.drawImage = image;
    }

    public Image getDisplayImage() {
        return this.drawImage;
    }

    public void setAutoFit(boolean bl) {
        this.drawText = bl;
    }

    public boolean getAutoFit() {
        return this.drawText;
    }

    public void setURL(String string) {
        this.SEDU = string;
        this.setToolTipText(string);
    }

    public String getURL() {
        return this.SEDU;
    }

    public int getAlignment() {
        return this.fillRect;
    }

    public void setAlignment(int n) {
        this.fillRect = n;
    }

    public void setEnableHyperlinkOnPDF(boolean bl) {
        this.getHeight = bl;
    }

    public boolean getEnableHyperlinkOnPDF(boolean bl) {
        return this.getHeight;
    }

    public void setWordwrap(boolean bl) {
        this.execute = bl;
    }

    public void setEnableHyperlinkOnExcel(boolean bl) {
        this.getID = bl;
    }

    public boolean getEnableHyperlinkOnExcel(boolean bl) {
        return this.getID;
    }

    public void setEnableHyperlinkOnHTML(boolean bl) {
        this.getPredefinedCursor = bl;
    }

    public boolean getEnableHyperlinkOnHTML(boolean bl) {
        return this.getPredefinedCursor;
    }

    public void setHyperLinkExecutable(HyperLinkExecutable hyperLinkExecutable) {
        this.blue = hyperLinkExecutable;
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        if (this.drawImage != null) {
            graphics.drawImage(this.drawImage, rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1, this);
        } else {
            Color color = this.getBackground();
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            Painter.drawText((Graphics)graphics, (Rectangle)rectangle, (String)this.I, (Font)this.getFont(), (Color)this.getForeground(), (boolean)this.execute, (boolean)true, (boolean)false, (int)this.fillRect);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.drawText) {
            return this.getSize();
        }
        if (this.drawImage != null) {
            Dimension dimension = new Dimension();
            dimension.width = this.drawImage.getWidth(this);
            dimension.height = this.drawImage.getHeight(this);
            return dimension;
        }
        Vector vector = new Vector(1);
        return Painter.layoutText(vector, (String)this.I, (int)10000, (Font)this.getFont(), (char)'\uffff');
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 502: {
                String string;
                if (this.blue == null || (string = this.blue.execute((Component)this, this.I, this.SEDU)) != null) break;
                break;
            }
            case 505: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            case 504: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Integer(this.getSize().width));
        objectOutput.writeObject(new Integer(this.getSize().height));
        objectOutput.writeObject(this.I);
        objectOutput.writeObject(this.SEDU);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = (Integer)objectInput.readObject();
        int n2 = (Integer)objectInput.readObject();
        this.setSize(n, n2);
        this.I = (String)objectInput.readObject();
        this.SEDU = (String)objectInput.readObject();
    }
}

