/*
 * Decompiled with CFR 0.152.
 */
package jet.client.api.misc;

import java.io.File;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import jet.cs.CSUtil;

public class DeployNodeInfo
extends DefaultMutableTreeNode {
    private String SEDU = null;
    private String append = null;
    private String clear = null;
    private String clone = null;
    private boolean endsWith = false;
    private String exists = null;
    private Hashtable getFullPath = null;
    private int getName = 3;
    private File getPath = null;
    private String getProp = null;
    private String getRelativePath = null;
    private boolean lastIndexOf = true;
    private byte length = 0;
    private boolean makeNoHeadQuery = false;

    public DeployNodeInfo(File file, int n) {
        this.getPath = file;
        this.getName = n;
        this.append = file.getPath();
        this.SEDU = file.getName();
        if (this.SEDU == null || this.SEDU.trim().length() == 0 || this.SEDU.endsWith(File.separator)) {
            this.SEDU = "NewFolder";
        }
        if (n == 0) {
            this.length = 1;
        }
        this.clear = this.SEDU;
    }

    public DeployNodeInfo(String string, int n) {
        this.append = string;
        this.getPath = new File(string);
        if (this.getPath.exists()) {
            this.SEDU = this.getPath.getName();
        } else if (n == 3) {
            this.SEDU = string;
        }
        if (this.SEDU == null || this.SEDU.trim().length() == 0 || this.SEDU.endsWith(File.separator)) {
            this.SEDU = "NewFolder";
        }
        if (n == 0) {
            this.length = 1;
        }
        this.getName = n;
        this.clear = this.SEDU;
    }

    public String getDescription() {
        return this.clone;
    }

    public void setDescription(String string) {
        this.clone = string;
    }

    public byte getStatus() {
        return this.length;
    }

    public void setStatus(byte by) {
        this.length = by;
    }

    public String getFileName() {
        return this.SEDU;
    }

    public boolean isEnabled() {
        return this.lastIndexOf;
    }

    public void setEnabled(boolean bl) {
        this.lastIndexOf = bl;
    }

    public boolean isMapSharedDisk() {
        return false;
    }

    public void setMapSharedDisk(boolean bl) {
    }

    public int getNodeType() {
        return this.getName;
    }

    public Hashtable getProp() {
        if (this.getFullPath == null) {
            this.getFullPath = new Hashtable();
        }
        return this.getFullPath;
    }

    public void setProp(Hashtable hashtable) {
        this.getFullPath = hashtable;
    }

    public String getResourceName() {
        return this.clear;
    }

    public void setResourceName(String string) {
        this.clear = string;
    }

    @Override
    public String toString() {
        return "DeployNode=[FullPath=" + this.append + "," + "FileName=" + this.SEDU + "," + "ResourceName=" + this.clear + "," + "NodeType=" + this.getName + "," + "Description=" + this.clone + "," + "]";
    }

    public String getRealPath() {
        return this.exists;
    }

    public void setRealPath(String string) {
        this.exists = string;
    }

    public String getFullPath() {
        return this.append;
    }

    public void setFullPath(String string) {
        File file = new File(string);
        this.SEDU = file.getName();
        this.append = string;
    }

    public String getRelativePath() {
        if (this.isRoot() && this.getName == 3) {
            return File.separator;
        }
        if (this.isRoot()) {
            return File.separator + this.SEDU;
        }
        DeployNodeInfo deployNodeInfo = (DeployNodeInfo)this.getRoot();
        String string = deployNodeInfo.getFullPath();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!string.startsWith(File.separator)) {
            string = File.separator + string;
        }
        int n = this.append.lastIndexOf(string);
        String string2 = this.append.substring(n += string.length());
        if (!string2.startsWith(File.separator)) {
            string2 = File.separator + string2;
        }
        string2 = CSUtil.replWithEsc((String)string2);
        return string2;
    }

    public Hashtable getProperties(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        if (!this.lastIndexOf) {
            return new Hashtable();
        }
        String string = this.getRelativePath();
        String string2 = "jrs.node_prop$" + string;
        Hashtable hashtable2 = (Hashtable)this.getProp().clone();
        hashtable2.put("jrs.node_name", this.clear);
        if (this.clone != null) {
            hashtable2.put("jrs.node_desc", this.clone);
        }
        hashtable2.put("jrs.node_type", String.valueOf(this.getName));
        if (this.exists != null) {
            hashtable2.put("jrs.node_real_path", this.exists);
        }
        hashtable2.put("jrs.node_share", String.valueOf(this.endsWith));
        hashtable2.put("jrs.enable_dynamic_resource", String.valueOf(this.makeNoHeadQuery));
        hashtable2.put("jrs.node_status", this.length);
        if (this.getName == 2 && this.getRelativePath != null) {
            hashtable2.put("Catalog_New_Path", this.getRelativePath);
        }
        if (this.getProp != null) {
            hashtable2.put("jrs.path", this.getProp);
        }
        hashtable.put(string2, CSUtil.makeNoHeadQuery((Hashtable)hashtable2));
        hashtable2.clear();
        return hashtable;
    }

    public String getDeployTo() {
        return this.getProp;
    }

    public void setDeployTo(String string) {
        this.getProp = string;
    }

    public File getFile() {
        return this.getPath;
    }

    public void setNewFileFullPath(String string) {
        this.getRelativePath = string;
    }

    public String getNewFileFullPath() {
        return this.getRelativePath;
    }

    public boolean isRscFromRealPath() {
        return this.makeNoHeadQuery;
    }

    public void setRscFromRealPath(boolean bl) {
        this.makeNoHeadQuery = bl;
    }
}

