/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui;

import guitools.toolkit.JDebug;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jet.JCliResource;
import jet.client.api.JRClient;
import jet.cs.CSUtil;
import jet.cs.ReportListIntf;
import jet.cs.ui.schedule.CheckList;
import jet.cs.ui.schedule.CheckListItem;
import jet.cs.ui.schedule.CheckListSelectionListener;
import jet.cs.ui.schedule.ISubItem;
import jet.cs.ui.schedule.disk.DiskDhtmlResult;
import jet.cs.ui.schedule.disk.DiskExcel;
import jet.cs.ui.schedule.disk.DiskHtml;
import jet.cs.ui.schedule.disk.DiskPdf;
import jet.cs.ui.schedule.disk.DiskPostScript;
import jet.cs.ui.schedule.disk.DiskResult;
import jet.cs.ui.schedule.disk.DiskRtf;
import jet.cs.ui.schedule.disk.DiskText;
import jet.cs.ui.schedule.disk.DiskXml;

public class DiskPanel
extends JPanel
implements ItemListener,
CheckListSelectionListener {
    private Properties SEDU;
    private ReportListIntf WARNING;
    private CheckList add = null;
    private CheckListItem[] addCheckItemListener = null;
    private JPanel addCheckListSelectionListener = new JPanel();
    private Rectangle append = new Rectangle(10, 20, 390, 350);
    private Frame checkEdit;
    private boolean checkTask = false;
    private boolean createEtchedBorder = false;
    private boolean createTitledBorder = false;
    private boolean get = true;
    private boolean getBoolean = true;

    public DiskPanel(Frame frame, Properties properties, ReportListIntf reportListIntf) {
        this.checkEdit = frame;
        this.SEDU = properties;
        this.WARNING = reportListIntf;
        this.checkTask = reportListIntf.canExportDhtmlResult(properties);
        this.createTitledBorder = properties == null ? false : CSUtil.getBoolean((String)((String)properties.get("jrs.has_nonbursting_result")), (boolean)false);
        this.init();
    }

    public void init() {
        this.setLayout(null);
        try {
            String string = (String)this.SEDU.get("jrs.catalog");
            String string2 = (String)this.SEDU.get("jrs.report");
            if (string != null && string2 != null) {
                this.createEtchedBorder = this.WARNING.hasPageSecurity(this.WARNING.getLogonUser(), string, string2);
            }
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
            JOptionPane.showMessageDialog(this.checkEdit, throwable.getMessage(), "Error", 0);
        }
        this.addCheckItemListener = this.checkTask ? (this.createEtchedBorder ? new CheckListItem[8] : new CheckListItem[9]) : (this.createEtchedBorder ? new CheckListItem[7] : new CheckListItem[8]);
        int n = 0;
        if (!this.createEtchedBorder) {
            this.addCheckItemListener[n++] = new CheckListItem("jrs.to_rst", JCliResource.getMessage((String)"CS_MSG_33"), new DiskResult(this.WARNING), false);
        }
        if (this.checkTask) {
            this.addCheckItemListener[n++] = new CheckListItem("jrs.to_rsd", JCliResource.getMessage((String)"CS_MSG_244"), new DiskDhtmlResult(this.WARNING), false);
        }
        this.addCheckItemListener[n++] = new CheckListItem("jrs.to_html", JCliResource.getMessage((String)"CS_MSG_34"), new DiskHtml(this.WARNING), false);
        this.addCheckItemListener[n++] = new CheckListItem("jrs.to_pdf", JCliResource.getMessage((String)"CS_MSG_35"), new DiskPdf(this.checkEdit, this.WARNING), false);
        this.addCheckItemListener[n++] = new CheckListItem("jrs.to_excel", JCliResource.getMessage((String)"CS_MSG_37"), new DiskExcel(this.WARNING), false);
        this.addCheckItemListener[n++] = new CheckListItem("jrs.to_text", JCliResource.getMessage((String)"CS_MSG_36"), new DiskText(this.WARNING), false);
        this.addCheckItemListener[n++] = new CheckListItem("jrs.to_rtf", JCliResource.getMessage((String)"CS_MSG_127"), new DiskRtf(this.WARNING), false);
        this.addCheckItemListener[n++] = new CheckListItem("jrs.to_xml", JCliResource.getMessage((String)"CS_MSG_142"), new DiskXml(this.WARNING), false);
        this.addCheckItemListener[n++] = new CheckListItem("jrs.to_ps", JCliResource.getMessage((String)"CS_MSG_38"), new DiskPostScript(this.WARNING), false);
        this.add = new CheckList(this.addCheckItemListener);
        this.add.addCheckItemListener(this);
        this.add.addCheckListSelectionListener(this);
        boolean bl = true;
        try {
            bl = JRClient.isNoBurstRpt((Frame)this.checkEdit, (String)this.WARNING.getServerURL(), (String)this.WARNING.getLogonUser(), (Hashtable)this.SEDU);
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
            JOptionPane.showMessageDialog(this.checkEdit, throwable.getMessage(), "Error", 0);
        }
        if (!bl) {
            this.append = new Rectangle(10, 20, 390, 410);
            this.add.setBounds(10, 15, 110, 440);
            this.addCheckListSelectionListener.setBounds(130, 10, 410, 450);
        } else {
            this.append = new Rectangle(10, 20, 390, 350);
            this.add.setBounds(10, 15, 110, 380);
            this.addCheckListSelectionListener.setBounds(130, 10, 410, 390);
        }
        Component component = (Component)this.addCheckItemListener[0].getValue();
        component.setBounds(this.append);
        this.addCheckListSelectionListener.add(component);
        this.addCheckListSelectionListener.setLayout(null);
        this.addCheckListSelectionListener.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options"));
        this.setLayout(null);
        this.add(this.add);
        this.add(this.addCheckListSelectionListener);
        this.setValues(this.SEDU);
    }

    public void getValues(Properties properties, boolean bl) throws Exception {
        if (this.checkEdit() && this.checkTask()) {
            if (bl) {
                properties.put("jrs.nonbursting$jrs.to_disk", String.valueOf(true));
            } else {
                properties.put("jrs.to_disk", String.valueOf(true));
            }
            int n = this.add.getRowCount();
            for (int i = 0; i < n; ++i) {
                CheckListItem checkListItem = (CheckListItem)this.add.getValue(i);
                if (!checkListItem.isChecked() || checkListItem.getValue() == null) continue;
                if (bl) {
                    properties.put("jrs.nonbursting$" + checkListItem.getId(), String.valueOf(checkListItem.isChecked()));
                } else {
                    properties.put(checkListItem.getId(), String.valueOf(checkListItem.isChecked()));
                }
                ((ISubItem)checkListItem.getValue()).getValues(properties, bl);
            }
        } else if (bl) {
            properties.put("jrs.nonbursting$jrs.to_disk", String.valueOf(false));
        } else {
            properties.put("jrs.to_disk", String.valueOf(false));
        }
    }

    public boolean isDiskPathValid() {
        return this.getBoolean;
    }

    public boolean isDiskNameValid() {
        return this.get;
    }

    public boolean checkTask() {
        int n = this.add.getRowCount();
        for (int i = 0; i < n; ++i) {
            CheckListItem checkListItem = (CheckListItem)this.add.getValue(i);
            if (!checkListItem.isChecked()) continue;
            return true;
        }
        return false;
    }

    public boolean checkEdit() {
        boolean bl = true;
        int n = this.add.getRowCount();
        for (int i = 0; i < n; ++i) {
            CheckListItem checkListItem = (CheckListItem)this.add.getValue(i);
            if (!checkListItem.isChecked()) continue;
            ISubItem iSubItem = (ISubItem)checkListItem.getValue();
            if (iSubItem instanceof DiskResult) {
                this.getBoolean = ((DiskResult)iSubItem).isDiskPathValid();
                this.get = ((DiskResult)iSubItem).isDiskNameValid();
            }
            bl &= iSubItem.hasEdited();
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object instanceof CheckListItem) {
            this.addCheckListSelectionListener.removeAll();
            Object object2 = ((CheckListItem)object).getValue();
            if (object2 != null) {
                ((JComponent)object2).setBounds(this.append);
                this.addCheckListSelectionListener.add((Component)object2);
                ((ISubItem)object2).setEnabled(((CheckListItem)object).isChecked());
            }
            this.addCheckListSelectionListener.updateUI();
        }
    }

    public void checkListValueChanged(Object object) {
        Object object2;
        this.addCheckListSelectionListener.removeAll();
        if (object != null && (object2 = ((CheckListItem)object).getValue()) != null) {
            ((JComponent)object2).setBounds(this.append);
            this.addCheckListSelectionListener.add((Component)object2);
        }
        this.addCheckListSelectionListener.updateUI();
    }

    public void setValues(Hashtable hashtable) {
        boolean bl = true;
        bl = this.createTitledBorder ? CSUtil.getBoolean((String)((String)hashtable.get("jrs.nonbursting$jrs.to_disk"))) : CSUtil.getBoolean((String)((String)hashtable.get("jrs.to_disk")));
        if (hashtable != null && this.add != null) {
            int n = this.add.getRowCount();
            for (int i = 0; i < n; ++i) {
                CheckListItem checkListItem = (CheckListItem)this.add.getValue(i);
                if (bl) {
                    if (this.createTitledBorder) {
                        checkListItem.setChecked(CSUtil.getBoolean((String)((String)hashtable.get("jrs.nonbursting$" + checkListItem.getId())), (boolean)false));
                    } else {
                        checkListItem.setChecked(CSUtil.getBoolean((String)((String)hashtable.get(checkListItem.getId())), (boolean)false));
                    }
                }
                if (checkListItem.getValue() == null) continue;
                ((ISubItem)checkListItem.getValue()).setValues(hashtable, this.createTitledBorder);
                ((ISubItem)checkListItem.getValue()).setEnabled(checkListItem.isChecked());
            }
        }
    }
}

