package com.jinfonet.jdbc.demo.common;

import java.text.DateFormat;
import java.text.ParseException;

public class RecordResult
{
	Object[] objs;

	public RecordResult(int colSize)
	{
		objs = new Object[colSize];
	}

    public String getString(int columnIndex)
	{
		return (String)objs[columnIndex - 1];
	}

    public boolean getBoolean(int columnIndex)
	{
		try{
			return ((Boolean)objs[columnIndex - 1]).booleanValue();
		}catch(Exception e){
			objs[columnIndex - 1] = new Boolean((String)objs[columnIndex - 1]);
			return ((Boolean)objs[columnIndex - 1]).booleanValue();
		}
	}

    public byte getByte(int columnIndex)
	{
		try{
			return ((Byte)objs[columnIndex - 1]).byteValue();
		}catch(Exception e){
			objs[columnIndex - 1] = new Byte((String)objs[columnIndex - 1]);
			return ((Byte)objs[columnIndex - 1]).byteValue();
		}
	}

    public short getShort(int columnIndex)
	{
		try{
			return ((Short)objs[columnIndex - 1]).shortValue();
		}catch(Exception e){
			objs[columnIndex - 1] = new Short((String)objs[columnIndex - 1]);
			return ((Short)objs[columnIndex - 1]).shortValue();
		}
	}

    public int getInt(int columnIndex)
	{
		try{
			return ((Integer)objs[columnIndex - 1]).intValue();
		}catch(Exception e){
			objs[columnIndex - 1] = new Integer((String)objs[columnIndex - 1]);
			return ((Integer)objs[columnIndex - 1]).intValue();
		}
	}

    public long getLong(int columnIndex)
	{
		try{
			return ((Long)objs[columnIndex - 1]).longValue();
		}catch(Exception e){
			objs[columnIndex - 1] = new Long((String)objs[columnIndex - 1]);
			return ((Long)objs[columnIndex - 1]).longValue();
		}
	}

    public float getFloat(int columnIndex)
	{
		try{
			return ((Float)objs[columnIndex - 1]).floatValue();
		}catch(Exception e){
			objs[columnIndex - 1] = new Float((String)objs[columnIndex - 1]);
			return ((Float)objs[columnIndex - 1]).floatValue();
		}
	}

    public double getDouble(int columnIndex)
	{
		try{
			return ((Double)objs[columnIndex - 1]).doubleValue();
		}catch(Exception e){
			objs[columnIndex - 1] = new Double((String)objs[columnIndex - 1]);
			return ((Double)objs[columnIndex - 1]).doubleValue();
		}
	}

    public java.math.BigDecimal getBigDecimal(int columnIndex)
	{
		try{
			return (java.math.BigDecimal)objs[columnIndex - 1];
		}catch(Exception e){
			java.math.BigDecimal ret = new java.math.BigDecimal((String)objs[columnIndex - 1]);
			return ret;
		}
	}

}

