package com.jinfonet.jdbc.demo.common;

import com.jinfonet.jdbc.obj.JCollection;
import com.jinfonet.jdbc.obj.JIterator;
import java.sql.*;

public class SQLReader
{
	/*
		return type must be the class that implement the Collection interface
		This collection can be one of the following three classes 
		java.util.collection for Java2
		java.util.Vector for Java1.1 
		com.jinfonet.jdbc.obj.JCollection for both.
	*/
	public static JCollection execSQL(String jdbcDriver, String url, String sql)
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		int colSize = 0;

		try{
			//init driver
			Class.forName(jdbcDriver).newInstance();
		}catch(Exception e)	{
			System.out.println("class not found");
		}
		try	{
			//connect to url
			conn = DriverManager.getConnection(url);
		}catch(SQLException e)	{
			System.out.println("connection fail");
		}
			//exec sql
		try	{
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		}catch(SQLException e)	{
			System.out.println("execute fail");
		}
			//create the collection
		try	{	
			ResultSetMetaData rsmd = rs.getMetaData();
			colSize = rsmd.getColumnCount();
		}catch(Exception e)	{
			System.out.println("get column size error");
		}
		
		JCollection jc = new SQLCollection(stmt, rs, colSize);
		try	{
		rs.close();
		}catch(SQLException e)	{
			System.out.println("close error");
		}
		return jc;


	}
}

/*
	JCollection is we define the interface, you can replace it with other implements
*/
class SQLCollection implements JCollection
{
	Statement stmt;
	ResultSet rs;
	java.util.Vector v = new java.util.Vector();
	int colSize = 0;

	SQLCollection(Statement stmt, ResultSet rs,int colSize)
	{
		this.stmt = stmt;
		this.rs = rs;
		this.colSize = colSize;
		init();
	}

	void init()
	{
		try	{
		while(rs.next())
		{
			RecordResult row = new RecordResult(colSize);
			for(int i = 0;i<colSize;i++)
				row.objs[i] = rs.getObject(i+1);

			v.addElement(row);
		}
		}catch(SQLException e)	{
		}
		
	}

	public int size()
	{
		return v.size();
	}

	public JIterator getIterator()
	{
		return new VIterator(v);
	}

	public void setCollection(Object obj)
	{
	}
}

class VIterator implements JIterator
{
	java.util.Vector iterator;
	int row = 0;
	VIterator(java.util.Vector iter)
	{
		this.iterator = iter;
	}

	public boolean hasNext()
	{
		return row < iterator.size();
	}

	public Object next()
	{
		return iterator.elementAt(row++);
	}
}