import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationLDAPServer;
import jet.server.api.admin.security.JGroup;
import jet.server.api.admin.security.JUser;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;

/**
 * 
 * @author xiaoxi.lu
 * This demo is created to demonstrate the usage of the JReport Server API methods to create groups on server.
 * You can add groups,which you wish to be added on server,in "addGroupTest".
 * 
 * Announcements:1.Please confirm your server is shutdown.
 *               2.If the group to be added is exist,it will occur "InUseException".
 *               
 *
 */

public class AddGroup {
	String submiter = "admin";
	static String reporthome = "";
	
	public static void main(String[] args)
	{
//	    for(int i = 0; i < args.length; i++){
//	    	String arg = args[i]; //4
//	    	System.out.println(arg);
//	    	if(arg.indexOf("-reporthome") == 0){
//	    		reporthome = args[i].substring(args[i].indexOf(":") + 1);
//	    	}
//	    }
		reporthome= "D:\\JReport\\V11Update1\\B201206291505";
		AddGroup ss = new  AddGroup();
	    ss.doSecurity();
	}
	
	public void doSecurity() {	
		HttpRptServer httpRptServer = null;
		try {
			// Set report home
			System.getProperties().put("reporthome", reporthome);

			// Creates instance of RptServer (JReport Server can not be running already)
			HttpUtil.initEnv(System.getProperties());
			httpRptServer = HttpUtil.getHttpRptServer();
			AdminService adminServ = httpRptServer.getAdminService();
			SecurityAdminService secServ = adminServ.getSecurityAdminService();
			String curRealm = secServ.getCurRealm();
			//add groups to server
			addGroupTest(secServ,curRealm ); 
			//get your current groups.
			getGroupInfo(secServ,curRealm );
			
		} catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			System.out.print("\n");
			httpRptServer.shutdown();
			System.out.println("Server "+ httpRptServer +" shutdown.");
		}
		System.exit(0);
    }

	
	
	private void addGroupTest(SecurityAdminService secServ, String curRealm){
		try {
			secServ.addGroup(curRealm, "addGroup", "test addGroup method", submiter);			
			secServ.addGroup(curRealm, "addGroup1", "test addGroup method", submiter);			
			secServ.addGroup(curRealm, "addGroup2", "test addGroup method", submiter);			
			secServ.addGroup(curRealm, "addGroup3", "test addGroup method", submiter);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchGroupException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InUseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	private void getGroupInfo(SecurityAdminService secServ, String curRealm){

		Vector vv = null;
		
		try {
			vv= new Vector();
			JGroup groupName[]=secServ.getAllJGroups(curRealm, submiter);
			if(groupName.length!=0){
				for(int i=0;i<groupName.length;i++){
			        vv.add(groupName[i].getName().toString());
				}
				
			}
        }catch (NoSuchRealmException e) {
		    // TODO Auto-generated catch block
		    e.printStackTrace();
	    } catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}catch(NullPointerException e){
			e.printStackTrace();
		}
		int j=0;
		System.out.println("Find goups as below:");
		while(!vv.isEmpty()){
			System.out.println(vv.elementAt(j).toString());
			j++;
			if(j>=vv.size()){
				break;
			}
		}
	}
}
