import java.util.Vector;

import jet.server.api.RptServer;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.admin.security.JUser;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.UserExistsException;
import jet.server.api.http.HttpUtil;

/**
 * 
 * @author xiaoxi.lu
 * This demo is created to demonstrate the usage of the JReport Server API methods to create user on server.
 * You can add users,which you wish to be added on server,in "addUserTest".
 * 
 * Announcements:1.Please confirm your server is shutdown.
 *               2.If the user to be added is exist,it will occur "UserExistsException".
 *               
 *
 */
public class AddUser {
	String submiter = "admin";
	static String reporthome = "";
	
    public static void main(String[] args)
    {
//	    for(int i = 0; i < args.length; i++){
//	    	String arg = args[i]; //4
//	    	System.out.println(arg);
//	    	if(arg.indexOf("-reporthome") == 0){
//	    		reporthome = args[i].substring(args[i].indexOf(":") + 1);
//	    	}
//	    }
        RptServer httpRptServer = null;
		try {
			
			reporthome= "D:\\JReport\\V11Update1\\B201206291505";
			
			// Set report home
			System.getProperties().put("reporthome", reporthome);

			// Creates instance of RptServer (JReport Server can not be running already)
			HttpUtil.initEnv(System.getProperties());
			httpRptServer = HttpUtil.getHttpRptServer();
			AdminService adminServ = httpRptServer.getAdminService();
			
			SecurityAdminService secServ = adminServ.getSecurityAdminService();
			
			System.out.println("-------------------"+secServ.getCurRealm().toString());
			
			AddUser asd = new AddUser();
			String curRealm = secServ.getCurRealm();
			//add users to server
			asd.addUserTest(secServ,curRealm );
			//get you current users
			asd.getAllUser(secServ, curRealm);
			
		} catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			System.out.print("\n");
			httpRptServer.shutdown();
			System.out.println("Server "+ httpRptServer +" shutdown.");
		}
		System.exit(0);
    
	}
    private void addUserTest(SecurityAdminService secServ, String curRealm){
	try {
			secServ.addUser(curRealm,submiter,"addUser","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUser1","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUser2","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUser3","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUserforIntoGroup","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUserforIntoRole","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UserExistsException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    private void getAllUser(SecurityAdminService secServ, String curRealm){
		Vector vv = null;
		
		try {
			vv= new Vector();
			JUser userName[]=secServ.getAllJUser(curRealm, submiter);
			if(userName.length!=0){
				for(int i=0;i<userName.length;i++){
			        vv.add(userName[i].getName().toString());
				}
				
			}
        }catch (NoSuchRealmException e) {
		    // TODO Auto-generated catch block
		    e.printStackTrace();
	    } catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}catch(NullPointerException e){
			e.printStackTrace();
		}
		int j=0;
		System.out.println("Find users as below:");
		while(!vv.isEmpty()){
			System.out.println(vv.elementAt(j).toString());
			j++;
			if(j>=vv.size()){
				break;
			}
		}
		
    }
}
