import java.io.IOException;
import java.text.DateFormat;
import java.util.*;

import jet.cs.util.*;
import jet.server.api.*;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationLDAPServer;
import jet.server.api.admin.security.JUser;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.RoleExistsException;
import jet.server.api.exception.UserExistsException;
import jet.server.api.http.HttpUtil;
/**
 * This demo is created to demonstrate the usage of the JReport Server API methods to create user to server.
 * You can add users,which you wish to be added on server,in "addGroupTest".
 * 
 * Announcements:1.Please confirm your server is shutdown.
 *               2.If the user to be added is exist,it will occur "UserExistsException".
 *               3.This demo is use to create security testing environment, please use this demo as your requirements.
 * 
 */

public class SecurityUserCover
{
	String submiter = "admin";
	static String reporthome = "";
	
	CatchInfo uu = new CatchInfo();
	/**
	 * Add user and other security cover,get user information.
	 * Please set your server install path as "reporthome".
	 * @param args
	 */
    public static void main(String[] args)
    {
//	    for(int i = 0; i < args.length; i++){
//	    	String arg = args[i]; //4
//	    	System.out.println(arg);
//	    	if(arg.indexOf("-reporthome") == 0){
//	    		reporthome = args[i].substring(args[i].indexOf(":") + 1);
//	    	}
//	    }
        RptServer httpRptServer = null;
		try {
			
			reporthome= "D:\\JReport\\V11Update1\\B201206291505";
			
			// Set report home
			System.getProperties().put("reporthome", reporthome);

			// Creates instance of RptServer (JReport Server can not be running already)
			HttpUtil.initEnv(System.getProperties());
			httpRptServer = HttpUtil.getHttpRptServer();
			AdminService adminServ = httpRptServer.getAdminService();
			
			SecurityAdminService secServ = adminServ.getSecurityAdminService();
			
			System.out.println("-------------------"+secServ.getCurRealm().toString());
			
			SecurityUserCover asd = new SecurityUserCover();
			String curRealm = secServ.getCurRealm();
			//add users
			asd.addUserTest(secServ,curRealm );
			//get current users
			asd.getUser(secServ,curRealm );
			
		} catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			httpRptServer.shutdown();
			System.out.println("Server "+ httpRptServer +" shutdown.");
		}
		System.exit(0);
    
	}
    /**
     * Add users and other information for security configuration.
     * Please configure the "addUser\addGroup\addUserIntoGroup\addRole\addUserIntoRole\
     * addNewParentRolesToUser\addPrivilegedUsers"
     * @param secServ
     * @param curRealm
     */
    private void addUserTest(SecurityAdminService secServ, String curRealm){
//		String tmp = "";
    	//add users
	    try {
			secServ.addUser(curRealm,submiter,"addUser","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUser1","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUser2","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUser3","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUserforIntoGroup","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			secServ.addUser(curRealm,submiter,"addUserforIntoRole","1234","test add user by addUser()",
					 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
			
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UserExistsException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//add group for "addUserIntoGroup" security configuration.
		try {
			secServ.addGroup(curRealm, "addGroup1", "test addGroup method", submiter);
			secServ.addGroup(curRealm, "addGroup", "test addGroup method", submiter);
		} catch (NoSuchRealmException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		} catch (BadRealmException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		} catch (NoSuchGroupException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		} catch (InUseException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		} catch (IOException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}			
		
		//add user into group
		try {
			secServ.addUserIntoGroup(curRealm, submiter, "addUserforIntoGroup", "addGroup1");
		} catch (NoSuchRealmException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (BadRealmException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchGroupException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchUserException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		//add role for "addUserIntoRole" security configuration.
		try {
			secServ.addRole(curRealm, "addRole", "test addGroup method", submiter);
			secServ.addRole(curRealm, "addRoleForGroup", "for test addNewParentRolesToUser", submiter);
		} catch (NoSuchRealmException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		} catch (BadRealmException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		} catch (RoleExistsException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//add user into role.
		try {
			secServ.addUserIntoRole(curRealm, "addRole", "addUserforIntoRole", submiter);
		} catch (NoSuchRealmException e1) {
				// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (BadRealmException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchUserException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchRoleException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		//add new parent role to user
		try {
			secServ.addNewParentRolesToUser(curRealm, submiter, "addUser3", "addRoleForGroup");
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchUserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//add role's privilege.
		Vector vv = null;
		
		try {
			vv= new Vector();
			JUser userName[]=secServ.getAllJUser(curRealm, submiter);
			if(userName.length!=0){
				for(int i=0;i<userName.length;i++){
			        vv.add(userName[i].getName().toString());
				}
			}
			try {
				secServ.addPrivilegedUsers(curRealm, submiter, APIConst.PRIVILEGE_PUBLISH_REPORT, vv);
		    } catch (NoSuchUserException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		    } catch (NoSuchRealmException e) {
			    // TODO Auto-generated catch block
			    e.printStackTrace();
		    } catch (BadRealmException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}catch(NullPointerException e){
				e.printStackTrace();
			}

	}
    
    /**
     * Get users information.
     * @param secServ
     * @param curRealm
     */
	private void getUser(SecurityAdminService secServ, String curRealm){
		
		Vector jr = null;
		Vector vv = null;
		String sv = null;
		
		try {
			JUser ju = secServ.getJUser(submiter, curRealm, "addUser");
			uu.JUserPrint(ju);
		} catch (NoSuchUserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}catch(NullPointerException e){
			e.printStackTrace();
			System.out.println("There may be no accessed information can be found, please don't care and keep on.");
		}
		
		try {
			JUser[] jra =  secServ.getJUsersByJGroup(curRealm, submiter, "addGroup");
			for (int i = 0; i < jra.length ; i++) {
				uu.JUserPrint(jra[i]);
			}						
		} catch (NoSuchGroupException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}catch(NullPointerException e){
			e.printStackTrace();
			System.out.println("There may be no accessed information can be found, please don't care and keep on.");
		}
		
		try {
			jr= secServ.getPrivilegedUsers(curRealm, submiter, APIConst.PRIVILEGE_PUBLISH_REPORT);
			uu.printList("get Privileged Users", jr);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try {
			Hashtable[] hh = secServ.getPrivileges(curRealm, submiter);
			for (int i = 0; i < hh.length ; i++) {
				uu.printHash(hh[i]);
			}
		} catch (NoSuchGroupException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		try {
			JUser[] juser = secServ.getSubJUsersByJRole(curRealm, submiter, "addGroup1");
			for (int i = 0; i < juser.length ; i++) {
				uu.JUserPrint(juser[i]);
			}			
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		try {
			sv = secServ.getUserDescription(curRealm, "addUser");
			uu.printSring("get User Description(addUser)", sv);
			sv = secServ.getUserEmail(curRealm, "addUser");
			uu.printSring("get User Email(addUser)", sv);
			sv = secServ.getUserFullname(curRealm, "addUser");
			uu.printSring("get User Fullname(addUser)", sv);
			int jj = secServ.getUserParentGroupsCount(curRealm, "addUser");
			uu.printSring("get User Parent Groups Count(addUser)", String.valueOf(jj));
			jj = secServ.getUserParentRolesCount(curRealm, "addUser");
			uu.printSring("get User Parent Roles Count(addUser)", String.valueOf(jj));
			jj = secServ.getUserPasswordExpireTime(curRealm, "addUser");
			uu.printSring("get User Password Expire Time(addUser)", String.valueOf(jj));
			jj = secServ.getUserPasswordMinLength(curRealm, "addUser");
			uu.printSring("get User Password Min Length(addUser)", String.valueOf(jj));
			vv = secServ.getUserPrivileges(curRealm, submiter, "addUser");
			uu.printList("get User Privileges(addUser)", vv);
			
			boolean bl = secServ.isUserAccountDisable(curRealm, "addUser");
			uu.printSring("get is User Account Disable(addUser)", String.valueOf(bl));
			bl = secServ.isUserPasswordNeverExpire(curRealm, "addUser");
			uu.printSring("get is User Password Never Expire(addUser)", String.valueOf(bl));
			bl = secServ.isUserPasswordPermitBlank(curRealm, "addUser");
			uu.printSring("get is User Password Permit Blank(addUser)", String.valueOf(bl));
			
			
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchUserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
