<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="jet.cs.util.*, 
                 jet.server.util.nls.*,
                 jet.server.api.http.*,
                 jet.server.api.*,
                 java.io.*,
                 javax.xml.bind.DatatypeConverter,
                 java.util.*" %>

<!-- 
This jsp page is a dispatcher for experimenting with the two
different versions of checkLogin() that are available in the
JReport Server API.

This page reports the current state and provides a selection of links
at the bottom to run scenarios of interest.

This one also allows a logout operation, in order to clear
previous activity that logged someone in.

To run the LoginLogout set of pages, move the login*.jsp pages in this folder 
to the folder "public_html/jinfonet".  

Access this page from a browser by way of a bookmark.

   localhost:8888/jinfonet/loginIndex.jsp

If this shows a user logged in and you want to see a demonstration
of what happens when a user is not logged in, press the "Logout" button.

Select one of the scenarios at the bottom of the page to run and click the 
link to run it.

Read the comments in each JSP page to understand what they do.

This page is simply a dispatcher to request the other JSP pages.

Note that turning on Single Sign On will not be available without
deploying the MyExtenralAuthorized.java file that is the APISecurity/SingleSignOn 
folder next to this folder.
Read the comments in that file to learn how to deploy it to the classpath
of the server.
When it is deployed, this JSP page will notice it and enable turning on single
sign on as an option to do.

-->
<html>
<head>
<title>Experiment with accessing page protected by checkLogin()</title>
</head>
<body>

<%
    HttpRptServer httpRptServer = null;
    HttpUserSessionManager httpUserSessionManager = null;
    UserSession userSession = null;
    session = request.getSession(true);

    String jrUser1 = "NULL";  
    String jrUser2 = "[N/A - JReport UserSession does not exist]";
    String jrUser3 = "NULL" ;
    String appUser = "";

    String extAuthorizedClassName = "";  // name of user written class to do external authorization

    String jSessionID = session.getId(); // Java Servlet Session ID
    String usSessionID = "";

    // Request Header might contain credentials, in the header field named "Authorization".
    // The credentials would come from the browser, 
    //     when it has been asked to participate in HTTP Basic authentication.
    // If so, the Header field value looks like this "Basic encoded-Data".
    // encoded-Data is the base64 encoding of a string that looks like this "user:password"
    String authorization = request.getHeader("Authorization");
    String hdrUser = "";
    String hdrPwd = "";
    String headerAuthorization = "NULL";
    if (authorization != null) {
        String encodedUserPwd = authorization.substring(6).trim();
        String UserPwd = new String(DatatypeConverter.parseBase64Binary(encodedUserPwd));
        int pColon = UserPwd.indexOf(":");
        hdrUser = UserPwd.substring(0, pColon);
        hdrPwd = UserPwd.substring(pColon+1);
        headerAuthorization = hdrUser + ":" + hdrPwd;  // same as UserPwd
    }

    // is the MyExternalAuthorized class on the class path.
    // If it is, then it can be used to set it as the one to use to turn on Single Sign On.
    // If not, then it can't be used.
    boolean packageIsFound = false;
    try {
        Class.forName("com.example.MyExternalAuthorized");
        // here when class exists.
        packageIsFound = true;
    } 
    catch (ClassNotFoundException e) {
        // end up here when there is no class deployed.
        packageIsFound = false;
    }

    // establish context and handle for JReport API calls.
    httpRptServer = HttpUtil.getHttpRptServer(request);
    if (httpRptServer == null) {
        System.getProperties().put("jreport.context", application);
        HttpUtil.initEnv(System.getProperties());
        httpRptServer = HttpUtil.getHttpRptServer(request);
    }
    if (httpRptServer == null) {
%>
<h3>No Report Server</h3>
</body></html>
<%
    } else {

        // The HttpUserSessionManager manages the JReport user session across multiple HTTP requests.
        // When a user is logged in, it manages the content of the JReport UserSssion, 
        //   which is stored in the Servlet Session.  This gives a way to hold state acorss multiple HTTP requests.
        // When a user is not logged in, there is no JReport UserSession, so later getUser() will return null.
        httpUserSessionManager = httpRptServer.getHttpUserSessionManager();    

        // get name of class if an ExternalAuthorized is set.
        HttpExternalAuthorized httpExternalAuthorized = (HttpExternalAuthorized)httpUserSessionManager.getHttpExternalAuthorized();
        if (httpExternalAuthorized != null) {
            extAuthorizedClassName = httpExternalAuthorized.getClass().getName();
        } else {
            extAuthorizedClassName = "[External Authorized is not set]";
        }

        // get UserSession session ID 
        userSession = (UserSession)httpUserSessionManager.getUserSession(request);
        if (userSession != null) {
            usSessionID = userSession.getID();
        } else {
            usSessionID = "[UserSession does not exist]";
        }

        // Get user three different ways starting with one that works when user is logged in or not logged in.
     
        // When there is no current user.  this getUser() returns an empty string.
        jrUser1 = (String)httpUserSessionManager.getUser(request);
        if (jrUser1.equals("")) {
             jrUser1 = "NULL";  // establish display value
        }

        // When there is no current user.  HttpUtil.getUser() returns an empty string.
        jrUser3 = (String)HttpUtil.getUser(request); 
        if (jrUser3.equals("")) {
            jrUser3 = "NULL"; // establish display value
        }

        if (jrUser1 != null && ! jrUser1.equals("NULL")) {
            // this way to get user only work when there is a current user.
            jrUser2 = (String)httpUserSessionManager.getUserSession(request).getUserID();
            if (jrUser2.equals("")) {
                jrUser2 = "NULL"; // establish display value
            }
        }

    if (session.getAttribute("authorized_user") != null) {
        appUser = session.getAttribute("authorized_user").toString();
    } else {
        appUser = "No Current User";
    }

%>

<h4>Experimenting with checkLogin() for controlling access to JSP page</h4>

<b>JReport Server User:</b>
<br>
HttpUtil.getUser(request):  <b><%=jrUser3 %></b>
<br>
httpRptServer.getHttpUserSessionManager().getUser(request):  <b><%=jrUser1 %></b>
<br>
httpRptServer.getHttpUserSessionManager().getUserSession().getUserID(): <b><%=jrUser2 %></b>
<p>
<b>Application User:</b>
<br>
session.getAttribute("authorized_user"): <b><%=appUser %></b>
</p>

<p>
Java Servlet Session ID: <%=jSessionID %>
<br>
UserSession Session ID: <%=usSessionID %>
<br>
Header Authorization Field: <%=headerAuthorization %>
<br>
ExternalAuthorized Class Name: <b><%= extAuthorizedClassName %></b>

<hr>
<table width="900" cellspacing="16" cellpadding="8" border="0">
<tr>
  <td width="30%" bgcolor="ffe7a8" >
  <form name="form-logout" action="loginLogout.jsp">
    <fieldset >
    <legend>LOGOUT, clear user</legend>
      <input type="submit" value="Logout">
    </fieldset>
  </form>
  </td>
  <td width="35%" bgcolor="ffe7a8" >
  <form name="form-sso-off" action="loginTurnOffSSO.jsp">
    <fieldset >
    <legend>TURN OFF Single Sign On</legend>
      <input type="submit" value="Tun Off SSO">
    </fieldset>
  </form>
  </td>
  <td bgcolor="ffe7a8" >
      <%
      if (packageIsFound) {
      %>
  <form name="form-sso-on" action="loginTurnOnSSO.jsp">
    <fieldset >
    <legend>TURN On Single Sign On</legend>
      <input type="submit" value="Tun On SSO">
    </fieldset>
  </form>
      <%
      } else {
      %>
      Package not found in classpath: 
          <br>
          <b><i>com.example.MyExternalAuthorized</i></b>
          <br>
          Unable to turn on SSO
      <%
      }
      %>
  </td>
</tr>
</table>
<hr>

<h4>Click link to select a checkLogin() protection scenario to try:</h4>

Access page that is protected by HttpUtil.checkLogin():
<br>
&nbsp;&nbsp;&nbsp;&nbsp;<a href="loginDoCheckLogin.jsp?action=1&target=util">Use no special action to authenticate</a>
<br>
&nbsp;&nbsp;&nbsp;&nbsp;<a href="loginDoCheckLogin.jsp?action=2&target=util">Use emulation of application login</a>
<br>
&nbsp;&nbsp;&nbsp;&nbsp;<a href="loginDoCheckLogin.jsp?action=3&target=util">Use JReport Server login credentials in URL</a>
<p>
Access page that is protected by HttpSessionUserManager.checkLogin():
<br>
&nbsp;&nbsp;&nbsp;&nbsp;<a href="loginDoCheckLogin.jsp?action=1&target=session">Use no special action to authenticate</a>
<br>
&nbsp;&nbsp;&nbsp;&nbsp;<a href="loginDoCheckLogin.jsp?action=2&target=session">Use emulation of application login</a>

<br>
&nbsp;&nbsp;&nbsp;&nbsp;<a href="loginDoCheckLogin.jsp?action=3&target=session">Use JReport Server login credentials in URL</a>

</body>
</html>

<%
    }
%>
