import java.text.DateFormat;
import java.util.*;

import jet.cs.util.*;
import jet.server.api.*;
import jet.server.api.http.HttpUtil;

/**
 * This demo is created to demonstrate the usage of the JReport Server API methods to run and publish results.
 * This interface can work both locally in the same JVM or remotely without changing the code.
 * Define jrs.remote.host and jrs.remote.rmiport to access a remote JReport Server
 * Also see RemoteAPIDemoPublishRpt.java
 * 
 * Assume that there is a catalog SampleReports.cat, a report CustomerAnalysis.cls 
 * already deployed to /SampleReports in Public Reports.
 */

public class APIDemoPublishRpt
{

    public static void main(String[] args)
	{
    	RptServer server = null;
		try {
			// Set report home
			System.getProperties().put("reporthome", "C:\\JReport\\Server");

			// Creates instance of RptServer
			HttpUtil.initEnv(System.getProperties());
			server = HttpUtil.getHttpRptServer();
			System.out.println("========server="+server);

			// Set task properties
			Properties props = new Properties();
			props.put(APIConst.TAG_TASK_CLASS, APIConst.TASK_TO_RPT);
			props.put(APIConst.TAG_LAUNCH_TYPE, String.valueOf(APIConst.IMMEDIATELY));
			props.put(APIConst.TAG_CATALOG, "/SampleReports/SampleReports.cat");
			props.put(APIConst.TAG_REPORT, "CustomerAnalysis.cls");
			props.put(APIConst.TAG_TO_DISK, "true");
			props.put(APIConst.TAG_TO_VERSION, "true");
			props.put(APIConst.TAG_TO_MAIL, "true");

			// TO DISK
			// Set the value of PDF for TO_DISK
			props.put(APIConst.TAG_TO_PDF, "true");

			// Set the value of HTML for TO_DISK
			props.put(APIConst.TAG_TO_HTML, "true");

			// Set the value of XML for TO_DISK
			props.put(APIConst.TAG_TO_XML, "true");

            // Specifies the pdf result filename.
		    props.put(APIConst.TAG_PDF, "CustomerAnalysis.pdf");

		    // Specifies the html result filename.
            props.put(APIConst.TAG_HTML, "html_CustomerAnalysis");

            // Specifies the xml result filename.
            props.put(APIConst.TAG_XML, "CustomerAnalysis.xml");

			props.put(APIConst.TAG_REPORT_LANGUAGE, "en_US");
			String today = DateFormat.getDateInstance(DateFormat.LONG, new Locale("en", "US")).format(new Date());
			//set value of parameter "p_StartDate" & "p_EndDate".
			props.put(APIConst.TAG_PARAM_PREFIX + "p_StartDate", "January 1, 2006");
			props.put(APIConst.TAG_PARAM_PREFIX + "p_EndDate", today);


			// Specifies the resource directory "/SampleReports" that the result create into.
			// The real path of pdf result file is
			// "server_install_root/jreports/SampleReports/CustomerAnalysis.pdf".
			props.put(APIConst.TAG_PDF_DIR, "/SampleReports");

			// Specifies the resource directory "/SampleReports" that the result create into.
			// The real path of html result files is
			// "server_install_root/jreports/SampleReports/html_CustomerAnalysis*.*".
			// html result files include html_CustomerAnalysis.css, html_CustomerAnalysis_*.html etc.
			props.put(APIConst.TAG_HTML_DIR, "/SampleReports");

			// Specifies the resource directory "/SampleReports" that the result create into.
			// The real path of xml result file is
			// "server_install_root/jreports/SampleReports/CustomerAnalysis.xml".
			props.put(APIConst.TAG_XML_DIR, "/SampleReports");

			// TO VERSION
			props.put(APIConst.TAG_EXPIRE_DAYS, "1");

			// Set the value of rst for TO_VERSION, and the rst file is named
			// by system, for example "admin1070244954140.rst"(username+currenttime+".rst")
			// The real path of rst file is similar to
			// "server_install_root/history/1/admin1070244954140/admin1070244954140.rst"
			// The rst result can be accessed by the url
			// "http://host:port/sendfileservlet_path/history/1/admin1070244954140/admin1070244954140.rst".
			props.put(APIConst.TAG_TO_VERSION_RST, "true");

			// Set the value of pdf for TO_VERSION, and the pdf file is named
			// by system, for example "admin1070244954140.pdf"(username+currenttime+".pdf")
			// The real path of pdf file is similar to
			// "server_install_root/history/1/admin1070244954140/admin1070244954140.pdf"
			// The pdf result can be accessed by the url
			// "http://host:port/sendfileservlet_path/history/1/admin1070244954140/admin1070244954140.pdf".
			props.put(APIConst.TAG_TO_VERSION_PDF, "true");

			// Set the value of xls for TO_VERSION, and the xls file is named
			// by system, for example "admin1070244954140.xls"(username+currenttime+".xls")
			// The real path of xls file is similar to
			// "server_install_root/history/1/admin1070244954140/admin1070244954140.xls"
			// The xls result can be accessed by the url
			// "http://host:port/sendfileservlet_path/history/1/admin1070244954140/admin1070244954140.xls".
			props.put(APIConst.TAG_TO_VERSION_EXCEL, "true");

			// Set the value of txt for TO_VERSION, and the txt file is named
			// by system, for example "admin1070244954140.txt"(username+currenttime+".txt")
			// The real path of txt file is similar to
			// "server_install_root/history/1/admin1070244954140/admin1070244954140.txt"
			// The txt result can be accessed by the url
			// "http://host:port/sendfileservlet_path/history/1/admin1070244954140/admin1070244954140.txt".
			props.put(APIConst.TAG_TO_VERSION_TXT, "true");

			// TO EMAIL
			Properties mail = new Properties();

			// Set the first mail properties
			mail.put(APIConst.TAG_MAIL_TO, "user1@mymailserver");
			mail.put(APIConst.TAG_MAIL_SUBJECT, "CustomerAnalysis");
			mail.put(APIConst.TAG_MAIL_COMMENT, "to user1.");

			// Set APIConst.TAG_JRMAIL property field by properties of an E-Mail.
			props.put(APIConst.TAG_JRMAIL + "0", jet.server.api.http.HttpUtil.makeQuery(mail));

			mail.clear();
			// Set the second mail properties
			mail.put(APIConst.TAG_MAIL_TO, "user2@mymailserver");
			mail.put(APIConst.TAG_MAIL_SUBJECT, "CustomerAnalysis");
			mail.put(APIConst.TAG_MAIL_COMMENT, "to user2.");

			// Set APIConst.TAG_JRMAIL property field by properties of an E-Mail.
			props.put(APIConst.TAG_JRMAIL + "1", jet.server.api.http.HttpUtil.makeQuery(mail));

			System.out.println("========submitScheduledTask=" + props);

			String taskID = server.submitScheduledTask("admin", props);
			System.out.println("========taskID=" + taskID);

 			// Waiting for the task to be completed
			Vector completeRecords = null;
			CompletedTaskTable completeTable = server.getCompletedTaskTable();
			while (true) {
				System.out.print(">");
				Thread.sleep(2000);
				completeRecords = completeTable.getCompletedTaskRecordsByTaskID(taskID);
				// Check if the task completed
				if (completeRecords.size() > 0) {
					// Completed
					break;
				}
			}

			System.out.println("\n========completeRecords=" + completeRecords);

			// Get the completed record
			CompletedTaskRecord completeRecord = (CompletedTaskRecord)completeRecords.elementAt(0);
			System.out.println("========completeRecord=" + completeRecord);

			if (completeRecord.isSuccessful()) {
				System.out.println("========Result generated! \nResult files=" + completeRecord.getSuccessInfo());
			} else {
				System.out.println("========Fail! Error message: \n" + completeRecord.getErrorMessage());
			}

		
		}catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			server.shutdown();
			System.out.println("Server "+ server +" shutdown.");
		}
		System.exit(0);
    }
}
