/*
 * Created on Jul 26, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package jreport.uds.javabean;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Collection;

/**
 * In order to extend the Java object to the data type of SQL. This Mapping class defined the mapping from
 * Java Class to SQL data type as well as a default value for fake data generation in FakeDataGeneratorForJavaBean
 */

class DataTypeMapping {
	private static Hashtable mapping = null;
	
	static {
		mapping = new Hashtable(22);
		mapping.put(String.class, new SQLTypeInfo(Types.VARCHAR, "VARCHAR", 50, 50, 0, "test" ));
		mapping.put(Byte.class, new SQLTypeInfo(Types.TINYINT, "TINYINT", 10,10,0, new Byte((byte)0)));
		mapping.put(Character.class, new SQLTypeInfo(Types.CHAR, "CHAR", 1, 1, 0, new Character('a')));
		mapping.put(Double.class, new SQLTypeInfo(Types.DOUBLE, "DOUBLE", 20, 20, 5, new Double(2222.22)));
		mapping.put(Float.class, new SQLTypeInfo(Types.FLOAT, "FLOAT", 20, 20, 5, new Float(1.1)));
		mapping.put(Integer.class, new SQLTypeInfo(Types.INTEGER, "INTEGER", 10, 10, 0, new Integer(1)));
		mapping.put(Long.class, new SQLTypeInfo(Types.BIGINT, "BIGINT", 10,10,0, new Long(1)));
		mapping.put(Number.class, new SQLTypeInfo(Types.NUMERIC, "NUMERIC", 20, 20, 5, new Float(1.1)));
		mapping.put(BigDecimal.class, new SQLTypeInfo(Types.DECIMAL, "DECIMAL", 20,20,5, new BigDecimal(1.1)));
		mapping.put(BigInteger.class, new SQLTypeInfo(Types.BIGINT, "BIGINT", 10, 10, 0, new BigInteger("1")));
		mapping.put(Boolean.class, new SQLTypeInfo(Types.BIT, "BIT", 1,1,0, new Boolean(false)));
		
		mapping.put(Date.class, new SQLTypeInfo(Types.DATE, "DATE", 10,10,0, new Date(System.currentTimeMillis())));
		mapping.put(Time.class, new SQLTypeInfo(Types.TIME, "TIME", -1,-1,0, new Time(System.currentTimeMillis())));
		mapping.put(Timestamp.class, new SQLTypeInfo(Types.TIMESTAMP, "TIMESTAMP", -1,-1,0, new Timestamp(System.currentTimeMillis())));
		
		mapping.put(byte.class, new SQLTypeInfo(Types.TINYINT, "TINYINT", 10,10,0, new Byte((byte)0)));
		mapping.put(char.class, new SQLTypeInfo(Types.CHAR,"CHAR",1,1,0,new Character('a')));
		mapping.put(double.class, new SQLTypeInfo(Types.DOUBLE, "DOUBLE", 20,20,5,new Double(2222.22)));
		mapping.put(float.class, new SQLTypeInfo(Types.FLOAT,"FLOAT",20,20,5,new Float(1.1)));
		mapping.put(int.class, new SQLTypeInfo(Types.INTEGER,"INTEGER",10,10,0,new Integer(1)));
		mapping.put(long.class, new SQLTypeInfo(Types.BIGINT,"BIGINT",10,10,0,new Long(1)));
		mapping.put(short.class, new SQLTypeInfo(Types.SMALLINT,"SMALLINT",10,10,0,new Integer(1)));
		mapping.put(boolean.class, new SQLTypeInfo(Types.BIT, "BIT", 1,1,0, new Boolean(false)));
		
	}
	
	public static SQLTypeInfo getSQLType(Class cls){
		if( mapping !=null){
			if(isDetailCollectionClass(cls)) // If it is collection type of property, we need to 
				//return string type data to pass Data Info into DataCenter
				return  ((SQLTypeInfo)mapping.get(String.class));
			else
				return ((SQLTypeInfo)mapping.get(cls));
		}else
			return null;
		
	}
	
	public static boolean isDetailCollectionClass(Class cls){
		if( cls.isArray() ||
			cls.isAssignableFrom(Collection.class)||
			cls.isAssignableFrom(Vector.class)){
			return true;
		}
		return false;
	}
	
	public static boolean isQualifiedDetailCollection(Class cls){
		if(cls.isArray()){
			if( mapping.get(cls.getComponentType())==null)
				return true;
			else
				return false;
		}else{
			return isDetailCollectionClass(cls);
		}
	}
	
	public static void main(String art[]){
		DataTypeMapping.getSQLType(String.class);
		System.exit(0);
		
	}
	
	
}
