
package jreport.uds.javabean.api;

import java.util.Properties;

import jreport.uds.javabean.exception.JavaBeanDataProviderException;

/*
 * Created on Jul 17, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author jennyw
 *
 * This interface is provided for any Java Object as data for the data source - UDSForJavaBean.
 * UDSForJavaBean will create instance of a certain JavaBeanDataProvider in getResultSet() method, 
 * and then it will call init() method of this new instance to initialize the data in it. 
 * 
 * When JReport engine gets Resultset object from UDSForJavaBean object, it will call next() method 
 * from the Resultset object to navigate each record. ResultSet object call data provider's  next()
 * method to get the next data object and convert it to proper data field values to the engine.
 * 
 * After engine finishes using the ResultSet object, it will all releaseResultset() of the UDS object, 
 * then the UDSForJavaBean object will then call the exit() function from the data provider to notice
 * it to close.
 * 
 * Also getMetadataJavaBean() method is called by UDS as well as ResultsetMetadata object to populate the
 * metadata of the data soruce according to the Java Bean Class.  
 *  
 */
public interface JavaBeanDataProvider {
	public void init(String dataID, Properties initprops) throws JavaBeanDataProviderException;
	public Class getMetadataJavaBean() throws ClassNotFoundException;
	public Object next() throws JavaBeanDataProviderException;
	public boolean requireDetails(String collectionPropName);
	public int getMaxShareTimes(String collectionPropName);
	public int getTimeoutForSubCollection(String collectionPropName);
	public void exit()throws JavaBeanDataProviderException;
}
