

import java.sql.*;
import java.util.Properties;
import java.io.*;

import jet.datasource.*;
import toolkit.db.gui.ConnectionsBroker;

/**
 *	The class is an example of new UDS API.  It can run a simple SQL
 *	statement in DBMS through JDBC.
 */

public class SQLDataSource implements JRUserDataSource
{
	Connection connection = null;
	Statement stmt = null;
  	ResultSet rs = null;

	/**
	 *	@param param "DRIVER=driver&URL=url&USER=user&PSWD=password&SQL=sql"
	 */
	public ResultSet getResultSet(String param) throws JRUserDataSourceException
	{
        	// Parse the SQL string.
		String strProp = param.replace('&', '\n');
		ByteArrayInputStream is = new ByteArrayInputStream(strProp.getBytes());

        	Properties properties = new Properties();
        	try
        	{
            		properties.load(is);  // May throw IOException.
        	}
        	catch (IOException e)
        	{
            	throw new JRUserDataSourceException(e.getMessage());
        	}
		// Get the Diver string
		String strDriver = properties.getProperty("DRIVER");

		// Get the URL string
        	String strURL = properties.getProperty("URL");

		// Get the User name.
        	String strUser = properties.getProperty("USER");

		// Get the password string.
        	String strPassword = properties.getProperty("PSWD");

		// Get the SQL string.
        	String strSQL = properties.getProperty("SQL");

		// Build a connection according the URL string.
        	try
        	{

            		connection = ConnectionsBroker.getConnection( strURL, strUser, strPassword, strDriver);

			// Create a statement.
            		stmt = connection.createStatement();

			// Execute the SQL string.
            		boolean bSuc = stmt.execute(strSQL);
            		if (bSuc)
            		{
				// Succeed.
				rs = stmt.getResultSet();
                		return rs;
            		}

			// Failed.
            		return null;
        	}
        	catch (SQLException e)
        	{
            		throw new JRUserDataSourceException(e.getMessage());
        	}
        	catch (ClassNotFoundException e)
        	{
            		throw new JRUserDataSourceException(e.getMessage());
        	}
    	}

	/**
	 * Free the resources such as : Connection, Statement, ResultSet.
	 */
    	public void releaseResultSet() throws JRUserDataSourceException
    	{
        	try
        	{
            		if (rs != null)
            		{
                		rs.close();
                		rs = null;
            		}

                    	if (stmt != null)
                    	{
                        	stmt.close();
                        	stmt = null;
                    	}

                    	if (connection != null)
                    	{
        			ConnectionsBroker.closeCachedConnection(connection);
//                        	connection.close();
                        	connection = null;
                    	}
        	}
        	catch (SQLException e)
        	{
            		throw new JRUserDataSourceException(e.getMessage());
        	}
    	}
}
