<%@ include file="nlsResource.jsp" %>
<%@ page import="java.io.*, java.util.*, jet.cs.util.*, jet.server.api.*, jet.server.api.http.*, jet.server.log.*" %>
<%@ page errorPage="errorpage.jsp" %>
<%@ include file="AuthCheck.jsp" %>
<%
/**
 * This JSP shows how to run InvoiceReport.cls by using the server API.
 * This JSP will be called by getRptDescPage2.jsp.  It can not run by itself as it needs parameters.
 *
 * Usage:
 * Copy this file and getRptDescPage2.jsp into <server_install_home>/public_html/jinfonet. 
 * Then start standalone report server and the following URL if using a standard standalong JReport Server.
 * "http://localhost:8888/jinfonet/getRptDescPage2.jsp".
 */
	try{

		//get properties for running the report
		Properties ht = HttpUtil.getParameters(request);


		HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();

		String user = HttpUtil.getUser(request);

		String rst = null;

		String cat = request.getParameter(APIConst.TAG_CATALOG);
		String rptName = request.getParameter(APIConst.TAG_REPORT);
		if(ServiceLogger.isLoggable(ServiceLogger.DEBUG, ServiceLog.LEVEL_TRIVIAL)){
			ServiceLogger.logDebug("runReport2.jsp cat:"+cat+" rptName:"+rptName, ServiceLog.LEVEL_TRIVIAL);
		}
		
		//run the report
		rst = httpRptServer.runReport(user, cat, rptName, ht);
		if(ServiceLogger.isLoggable(ServiceLogger.DEBUG, ServiceLog.LEVEL_TRIVIAL)){
			ServiceLogger.logDebug("runReport2.jsp rst:"+rst, ServiceLog.LEVEL_TRIVIAL);
		}

		System.out.println("===================rst="+rst);
		if(rst == null) {
			response.sendError(HttpServletResponse.SC_NOT_ACCEPTABLE, "result file is null!");
		}else{
			
			File rstFile = new File(rst);
			
			//register the result owner to pass security check.
			httpRptServer.getTempResultOwnerManager().registerOwner(user, HttpUtil.getTempResultKey(rstFile.getName()));
			
			//response.setStatus(HttpServletResponse.SC_OK);
			//response.setContentType("text/html");
			//response.sendRedirect(HttpUtil.getBaseNoPath(request, false) + "/servlet/sendfile/result/" + rstFile.getName());
			
			//redirect to SendFileServlet for sending results.
			String base = "/servlet/sendfile/result/" + rstFile.getName();
			response.setStatus(HttpServletResponse.SC_MOVED_TEMPORARILY);
			response.setHeader("Location", base);
			response.setHeader("Content-Location", base);
%>
<html>
<head>
<title>Redirection Page</title>
</head>
<H1>Redirection Page</H1>
If this page appears, it means your browser does not support redirection. Please click the following address to redirect:
<A href="<%= base %>"><%= base %></A>
</body>
</html>
<%
		}
	} catch(Throwable t) {
		ServiceLogger.logError(t);
		response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, t.getMessage());
	}
%>
