/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.ConfigurationManager;

import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Setting.SettingNamesEnum;
import com.ttv.manager.Setting.SettingValues;
import com.ttv.manager.Setting.SettingValuesTypeEnum;
import com.ttv.manager.Setting.TimeZoneValues;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.ProgramTemplate;
import com.ttv.zBandInterface.Setting;
import com.ttv.zBandInterface.SettingTypeEnum;
import com.ttv.zBandInterface.TimeZones;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.rpc.holders.StringHolder;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager {
    private static final Category log = Category.getInstance(ConfigurationManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, ConfigurationManager> ourInstances = new HashMap();
    public static final Long DEFAULT_ITEMS_PER_PAGE = new Long(15L);
    public static final Long DEFAULT_PITCHES_PER_PAGE = new Long(25L);
    public static final Long DEFAULT_SCROLL_COUNT = new Long(5L);
    public static final Long DEFAULT_REFRESH_TIME = new Long(60L);
    public static final Long WS_PROCESSING_TIMEOUT = new Long(60L);
    public static final Long WS_BottomOfQDelay = new Long(0L);
    private String username = null;
    private String userTimeZone = "";

    public static synchronized ConfigurationManager getInstance(String username) {
        ConfigurationManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new ConfigurationManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private ConfigurationManager(String username) {
        this.username = username;
    }

    private SettingValues translateSetting(Setting setting) {
        SettingValues settingValues = new SettingValues();
        settingValues.setId(setting.getId());
        settingValues.setName(setting.getName());
        settingValues.setDescription(setting.getDescription());
        if (setting.getType().getValue().equals("Boolean")) {
            settingValues.setType(SettingValuesTypeEnum.Boolean.getValue());
        } else if (setting.getType().getValue().equals("Email")) {
            settingValues.setType(SettingValuesTypeEnum.Email.getValue());
        } else if (setting.getType().getValue().equals("Multiline")) {
            settingValues.setType(SettingValuesTypeEnum.Multiline.getValue());
        } else if (setting.getType().getValue().equals("Number")) {
            settingValues.setType(SettingValuesTypeEnum.Number.getValue());
        } else if (setting.getType().getValue().equals("String")) {
            settingValues.setType(SettingValuesTypeEnum.String.getValue());
        } else if (setting.getType().getValue().equals("TimeZone")) {
            settingValues.setType(SettingValuesTypeEnum.TimeZone.getValue());
        }
        settingValues.setValue(setting.getValue());
        settingValues.setSystem(setting.isSystem());
        return settingValues;
    }

    public SettingValues getSetting(SettingNamesEnum settingNamesEnum) throws WSDatabaseException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getSetting() start:");
        try {
            Setting setting = WSLocator.getzBandInterface(this.username).getSetting(settingNamesEnum.getValue());
            SettingValues settingValues = this.translateSetting(setting);
            return settingValues;
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("getSetting() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public ArrayList<SettingValues> getSettings() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getSettings() start:");
        ArrayList<SettingValues> settingValuesList = new ArrayList<SettingValues>();
        try {
            Setting[] settings = WSLocator.getzBandInterface(this.username).getSettings();
            for (int i = 0; i < settings.length; ++i) {
                settingValuesList.add(this.translateSetting(settings[i]));
                log.debug((Object)("Setting Name: " + settings[i].getName()));
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("getSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return settingValuesList;
    }

    public ArrayList<SettingValues> getSystemSettings() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getSystemSettings() start:");
        ArrayList<SettingValues> systemSettings = new ArrayList<SettingValues>();
        ArrayList<SettingValues> allSettings = this.getSettings();
        for (SettingValues sv : allSettings) {
            if (!sv.isSystem()) continue;
            systemSettings.add(sv);
        }
        systemSettings.add(this.getMailHostSettingValues());
        systemSettings.add(this.getManualIngestionFolderSettingValues());
        systemSettings.add(this.getPackageExpirySettingValues());
        systemSettings.add(this.getMaxUploadRateSettingValues());
        systemSettings.add(this.getMaxExportRateSettingValues());
        systemSettings.add(this.getMaxEncryptionRateSettingValues());
        systemSettings.add(this.getMaxNumberOfEncryptionSettingValues());
        systemSettings.add(this.getManualFailBackSettingValues());
        log.debug((Object)("getSystemSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return systemSettings;
    }

    public ArrayList<SettingValues> getUserSettings() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getUserSettings() start:");
        ArrayList<SettingValues> userSettings = new ArrayList<SettingValues>();
        ArrayList<SettingValues> allSettings = this.getSettings();
        for (SettingValues sv : allSettings) {
            if (sv.isSystem()) continue;
            userSettings.add(sv);
        }
        userSettings.add(this.getPasswordSettingValue());
        log.debug((Object)("getUserSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return userSettings;
    }

    public void populateUserSelectedTimeZone() throws WSServerDownException, WSDatabaseException, WSInvalidLoginException, WSConnectException {
        ArrayList<SettingValues> allSettings = this.getSettings();
        int userTimeZoneId = 0;
        for (SettingValues sv : allSettings) {
            if (sv.isSystem() || !sv.getType().equals("TimeZone")) continue;
            userTimeZoneId = Integer.parseInt(sv.getValue());
            break;
        }
        if (userTimeZoneId == 0) {
            GregorianCalendar greCal = new GregorianCalendar();
            this.userTimeZone = greCal.getTimeZone().getID();
        } else {
            try {
                TimeZones[] timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
                for (int i = 0; i < timeZones.length; ++i) {
                    if (timeZones[i].getId() != userTimeZoneId) continue;
                    this.userTimeZone = timeZones[i].getJavaname();
                    break;
                }
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
        }
    }

    private Setting translateSettingValues(SettingValues settingValues) {
        Setting setting = new Setting();
        setting.setId(settingValues.getId());
        setting.setName(settingValues.getName());
        setting.setSystem(settingValues.isSystem());
        setting.setValue(settingValues.getValue());
        if (settingValues.getType().equals("Boolean")) {
            setting.setType(SettingTypeEnum.Boolean);
        } else if (settingValues.getType().equals("Email")) {
            setting.setType(SettingTypeEnum.Email);
        } else if (settingValues.getType().equals("Multiline")) {
            setting.setType(SettingTypeEnum.Multiline);
        } else if (settingValues.getType().equals("Number")) {
            setting.setType(SettingTypeEnum.Number);
        } else if (settingValues.getType().equals("String")) {
            setting.setType(SettingTypeEnum.String);
        } else if (settingValues.getType().equals("FileExtension")) {
            setting.setType(SettingTypeEnum.String);
        } else if (settingValues.getType().equals("TimeZone")) {
            setting.setType(SettingTypeEnum.TimeZone);
        }
        return setting;
    }

    public void updateSetting(SettingValues settingValues) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)("calling updateSetting(). Updating setting [" + settingValues.getName() + "with setting id [" + settingValues.getId() + "]"));
        if (settingValues.getId().equals(SettingNamesEnum.MailHost.getValue())) {
            String mailHost = settingValues.getValue();
            this.setMailHost(mailHost);
            return;
        }
        if (settingValues.getId().equals(SettingNamesEnum.ManualIngestFolder.getValue())) {
            String manualIngestionFolder = settingValues.getValue();
            this.setManualIngestionFolder(manualIngestionFolder);
            return;
        }
        if (settingValues.getId().equals(SettingNamesEnum.PackageExpiry.getValue())) {
            String packageExpiry = settingValues.getValue();
            this.setPackageExpiry(this.translateFromBooleanSetting(packageExpiry));
            return;
        }
        if (settingValues.getId().equals(SettingNamesEnum.MaxUploadRate.getValue())) {
            String maxUploadRate = settingValues.getValue();
            this.setMaxUploadRate(maxUploadRate);
            return;
        }
        if (settingValues.getId().equals(SettingNamesEnum.MaxExportRate.getValue())) {
            String maxExportRate = settingValues.getValue();
            this.setMaxExportRate(maxExportRate);
            return;
        }
        if (settingValues.getId().equals(SettingNamesEnum.MaxEncryptionRate.getValue())) {
            String maxEncryptionRate = settingValues.getValue();
            this.setMaxEncryptionRate(maxEncryptionRate);
            return;
        }
        if (settingValues.getId().equals(SettingNamesEnum.MaxNumberOfEncryption.getValue())) {
            String maxNumberOfEncryption = settingValues.getValue();
            this.setMaxNumberOfEncryption(maxNumberOfEncryption);
            return;
        }
        if (settingValues.getId().equals(SettingNamesEnum.ManualFailBack.getValue())) {
            String manualFailBack = settingValues.getValue();
            this.setManualFailBack(this.translateFromBooleanSetting(manualFailBack));
            return;
        }
        Setting setting = this.translateSettingValues(settingValues);
        try {
            WSLocator.getzBandInterface(this.username).setSetting(setting);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)("Setting updated [" + settingValues.getName() + "] with setting id [" + settingValues.getId() + "] to [" + settingValues.getValue() + "]"));
    }

    public Long getItemsPerPage() {
        try {
            SettingValues settingvalue = this.getSetting(SettingNamesEnum.ItemsPerPage);
            return new Long(settingvalue.getValue());
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ItemsPerPage, using defaults");
        }
        catch (NumberFormatException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ItemsPerPage, using defaults");
        }
        catch (WSDatabaseException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ItemsPerPage, using defaults");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ItemsPerPage, using defaults");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ItemsPerPage, using defaults");
        }
        return DEFAULT_ITEMS_PER_PAGE;
    }

    public Long getRefreshTime() {
        try {
            SettingValues settingvalue = this.getSetting(SettingNamesEnum.RefreshTime);
            return new Long(settingvalue.getValue());
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: RefreshTime, using defaults");
        }
        catch (NumberFormatException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: RefreshTime, using defaults");
        }
        catch (WSDatabaseException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: RefreshTime, using defaults");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: RefreshTime, using defaults");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: RefreshTime, using defaults");
        }
        return DEFAULT_REFRESH_TIME;
    }

    public Long getQueueRefreshTime() {
        try {
            SettingValues settingvalue = this.getSetting(SettingNamesEnum.QueueRefreshTime);
            return new Long(settingvalue.getValue());
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: QueueRefreshTime, using defaults");
        }
        catch (NumberFormatException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: QueueRefreshTime, using defaults");
        }
        catch (WSDatabaseException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: QueueRefreshTime, using defaults");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: QueueRefreshTime, using defaults");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: QueueRefreshTime, using defaults");
        }
        return DEFAULT_REFRESH_TIME;
    }

    public Long getPitchsPerPage() {
        try {
            SettingValues settingvalue = this.getSetting(SettingNamesEnum.TransmissionsPerPage);
            return new Long(settingvalue.getValue());
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: PitchsPerPage, using defaults");
        }
        catch (NumberFormatException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: PitchsPerPage, using defaults");
        }
        catch (WSDatabaseException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: PitchsPerPage, using defaults");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: PitchsPerPage, using defaults");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: PitchsPerPage, using defaults");
        }
        return DEFAULT_PITCHES_PER_PAGE;
    }

    public Long getScrollCount() {
        try {
            SettingValues settingvalue = this.getSetting(SettingNamesEnum.ScrollByCount);
            return new Long(settingvalue.getValue());
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ScrollCount, using defaults");
        }
        catch (NumberFormatException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ScrollCount, using defaults");
        }
        catch (WSDatabaseException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ScrollCount, using defaults");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ScrollCount, using defaults");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ScrollCount, using defaults");
        }
        return DEFAULT_SCROLL_COUNT;
    }

    public Long getWsProcessingTimeout() {
        try {
            SettingValues settingvalue = this.getSetting(SettingNamesEnum.ProcessingTimeout);
            return new Long(settingvalue.getValue());
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        catch (NumberFormatException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSsPProcessingTimeout, using defaults");
        }
        catch (WSDatabaseException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        return WS_PROCESSING_TIMEOUT;
    }

    public Long getBottomOfQDelay() {
        try {
            SettingValues settingvalue = this.getSetting(SettingNamesEnum.BottomOfQDelay);
            return new Long(settingvalue.getValue());
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        catch (NumberFormatException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSsPProcessingTimeout, using defaults");
        }
        catch (WSDatabaseException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        return WS_BottomOfQDelay;
    }

    public String getVersions() throws WSInvalidLoginException, WSServerDownException, WSConnectException {
        StringBuffer versions = new StringBuffer();
        StringHolder pitcher = new StringHolder();
        StringHolder pitchermanager = new StringHolder();
        StringHolder assetmanager = new StringHolder();
        try {
            WSLocator.getzBandInterface(this.username).getVersion(pitcher, pitchermanager, assetmanager);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        versions.append("Manager Version:");
        versions.append(pitchermanager.value);
        versions.append("|");
        versions.append("Pitcher Version:");
        versions.append(pitchermanager.value);
        versions.append(" (Transport Layer Version :");
        versions.append(pitcher.value);
        versions.append(")");
        return versions.toString();
    }

    public String getUserTimeZone() {
        if (this.userTimeZone.isEmpty()) {
            GregorianCalendar greCal = new GregorianCalendar();
            this.userTimeZone = greCal.getTimeZone().getID();
            log.debug((Object)("DEFAULT TIME ZONE = " + this.userTimeZone));
        } else {
            log.debug((Object)("USER SELECTED TIME ZONE = " + this.userTimeZone));
        }
        return this.userTimeZone;
    }

    public void setUserTimeZone(String userTimeZone) {
        this.userTimeZone = userTimeZone;
    }

    private String getMailHost() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            return WSLocator.getzBandInterface(this.username).getConfiguration("RASSMTPServerName", type, global);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private void setMailHost(String mailHost) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            WSLocator.getzBandInterface(this.username).setConfiguration("RASSMTPServerName", type, global, mailHost);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)("Updated setting [mail host] to [" + mailHost + "] by user [" + this.username + "]"));
    }

    private SettingValues getMailHostSettingValues() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.MailHost.getValue(), new String("Mail Host"), new String("SMTP mail server settings to use for e-mail notifications."), this.getMailHost(), systemSetting, SettingValuesTypeEnum.String.getValue());
        return sv;
    }

    private String getPackageExpiry() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        String result = "";
        try {
            result = this.translateToBooleanSetting(WSLocator.getzBandInterface(this.username).getConfiguration("RemoveReferencedFiles", type, global));
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the ZRas server");
        }
        log.debug((Object)("result: getPackageExpiry: " + result));
        return result;
    }

    private void setPackageExpiry(String packageExpiry) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            WSLocator.getzBandInterface(this.username).setConfiguration("RemoveReferencedFiles", type, global, packageExpiry);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the ZRas server");
        }
        audit.info((Object)("updated setting [Package Expiry] to [" + packageExpiry + "] by user [" + this.username + "]"));
    }

    private SettingValues getPackageExpirySettingValues() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.PackageExpiry.getValue(), new String("Delete Content from Remote NAS"), new String("Whether or not a Package\ufffds content is deleted from the remote NAS when the Package expires or is deleted.  By default, no Package content is deleted from the remote NAS."), this.getPackageExpiry(), systemSetting, SettingValuesTypeEnum.Boolean.getValue());
        return sv;
    }

    private String getMaxUploadRate() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            return WSLocator.getzBandInterface(this.username).getConfiguration("UploadRateLimit", type, global);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private void setMaxUploadRate(String maxUploadRate) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            WSLocator.getzBandInterface(this.username).setConfiguration("UploadRateLimit", type, global, maxUploadRate);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)("Updated setting [mail host] to [" + maxUploadRate + "] by user [" + this.username + "]"));
    }

    private SettingValues getMaxUploadRateSettingValues() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.MaxUploadRate.getValue(), new String("Manual Package Ingestion Rate (Mbps)"), new String("The maximum rate, in Mbps, at which the Pitcher will ingest manually added Packages.  By default, Packages will ingest at 60 Mbps."), this.getMaxUploadRate(), systemSetting, SettingValuesTypeEnum.Number.getValue());
        return sv;
    }

    private String getMaxExportRate() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            return WSLocator.getzBandInterface(this.username).getConfiguration("ProgramExportRateLimit", type, global);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private void setMaxExportRate(String maxExportRate) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            WSLocator.getzBandInterface(this.username).setConfiguration("ProgramExportRateLimit", type, global, maxExportRate);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)("Updated setting [mail host] to [" + maxExportRate + "] by user [" + this.username + "]"));
    }

    private SettingValues getMaxExportRateSettingValues() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.MaxExportRate.getValue(), new String("Package Export Rate (Mbps)"), new String("The maximum rate, in Mbps, at which the Pitcher will export Packages.  By default, Packages will export at 60 Mbps."), this.getMaxExportRate(), systemSetting, SettingValuesTypeEnum.Number.getValue());
        return sv;
    }

    private String getMaxEncryptionRate() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            return WSLocator.getzBandInterface(this.username).getConfiguration("StagingRateLimit", type, global);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private void setMaxEncryptionRate(String maxEncryptionRate) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            WSLocator.getzBandInterface(this.username).setConfiguration("StagingRateLimit", type, global, maxEncryptionRate);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)("Updated setting [mail host] to [" + maxEncryptionRate + "] by user [" + this.username + "]"));
    }

    private SettingValues getMaxEncryptionRateSettingValues() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.MaxEncryptionRate.getValue(), new String("VideoSecure Encryption Rate (Mbps)"), new String("The maximum rate, in Mbps, at which the Pitcher will VideoSecure encrypt Packages.  By default, Packages will VideoSecure encrypt at 60 Mbps."), this.getMaxEncryptionRate(), systemSetting, SettingValuesTypeEnum.Number.getValue());
        return sv;
    }

    private String getMaxNumberOfEncryption() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            return WSLocator.getzBandInterface(this.username).getConfiguration("DynamicStagingThreadCount", type, global);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private void setMaxNumberOfEncryption(String maxNumberOfEncryption) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            WSLocator.getzBandInterface(this.username).setConfiguration("DynamicStagingThreadCount", type, global, maxNumberOfEncryption);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)("Updated setting [mail host] to [" + maxNumberOfEncryption + "] by user [" + this.username + "]"));
    }

    private SettingValues getMaxNumberOfEncryptionSettingValues() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.MaxNumberOfEncryption.getValue(), new String("Simultaneous VideoSecure Package Encryption"), new String("The maximum number of Packages that the Pitcher will VideoSecure encrypt simultaneously.  By default, the Pitcher will VideoSecure encrypt at most 2 packages simultaneously."), this.getMaxNumberOfEncryption(), systemSetting, SettingValuesTypeEnum.Number.getValue());
        return sv;
    }

    private String getManualFailBack() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        String result = "";
        try {
            result = this.translateToBooleanSetting(WSLocator.getzBandInterface(this.username).getConfiguration("AutomaticFailoverRecovery", type, global));
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("result: getManualFailBack: " + result));
        return result;
    }

    private void setManualFailBack(String manualFailBack) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = true;
        try {
            WSLocator.getzBandInterface(this.username).setConfiguration("AutomaticFailoverRecovery", type, global, manualFailBack);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)("Updated setting [mail host] to [" + manualFailBack + "] by user [" + this.username + "]"));
    }

    private SettingValues getManualFailBackSettingValues() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.ManualFailBack.getValue(), new String("Pitcher Automatic Fail-back"), new String("Whether the Pitcher will automatically fail back to the primary.  By default, manual intervention is required to fail back to the primary Pitcher."), this.getManualFailBack(), systemSetting, SettingValuesTypeEnum.Boolean.getValue());
        log.debug((Object)("Print: getManualFailBackSettingValues: " + sv.print()));
        return sv;
    }

    private String getManualIngestionFolder() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = false;
        try {
            return WSLocator.getzBandInterface(this.username).getConfiguration("LocalIngestionFolder", type, global);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    private void setManualIngestionFolder(String manualIngestionFolder) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String type = "";
        boolean global = false;
        try {
            WSLocator.getzBandInterface(this.username).setConfiguration("LocalIngestionFolder", type, global, manualIngestionFolder);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        audit.info((Object)("Updated setting [manual ingestion folder] to [" + manualIngestionFolder + "] by user [" + this.username + "]"));
    }

    private SettingValues getManualIngestionFolderSettingValues() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.ManualIngestFolder.getValue(), new String("Directory used by system for manual ingestion of assets"), new String("WARNING: It's not recommended to change this value"), this.getManualIngestionFolder(), systemSetting, SettingValuesTypeEnum.String.getValue());
        return sv;
    }

    public String getFileExensionsToEncryptForVODPackages() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ProgramTemplate programTemplate;
        try {
            programTemplate = WSLocator.getzBandInterface(this.username).getProgramTemplate("9668c403-a4bc-4d75-9dac-2e09c0937ffc");
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        return programTemplate.getPreencryptionfiles();
    }

    public String getFileExensionsToEncryptForNonVODPackages() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ProgramTemplate programTemplate;
        try {
            programTemplate = WSLocator.getzBandInterface(this.username).getProgramTemplate("628ff3a6-4524-45f6-aba5-17d2106546f3");
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        return programTemplate.getPreencryptionfiles();
    }

    private SettingValues getPasswordSettingValue() {
        boolean systemSetting = true;
        SettingValues sv = new SettingValues(SettingNamesEnum.Password.getValue(), new String("Password"), new String("Resets the password for the logged in user."), this.getPersonalPassword(), systemSetting, SettingValuesTypeEnum.Password.getValue());
        return sv;
    }

    private String getPersonalPassword() {
        String passwd = "******";
        return passwd;
    }

    private ArrayList<TimeZoneValues> translateTimeZones() throws WSDatabaseException, WSPermissionException, WSConnectException, WSServerDownException, WSInvalidLoginException {
        ArrayList<TimeZoneValues> timeZoneList;
        try {
            TimeZones[] timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
            timeZoneList = new ArrayList<TimeZoneValues>();
            for (int i = 0; i < timeZones.length; ++i) {
                TimeZones timeZone = timeZones[i];
                TimeZoneValues tzValue = new TimeZoneValues();
                tzValue.setId(new Integer(timeZone.getId()));
                tzValue.setDisplayname(timeZone.getDisplayname());
                tzValue.setJavaname(timeZone.getJavaname());
                timeZoneList.add(tzValue);
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        return timeZoneList;
    }

    public ArrayList<TimeZoneValues> getTimeZones() throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getTimeZones() start:");
        ArrayList timezonesList = new ArrayList();
        ArrayList<TimeZoneValues> tzValuesList = this.translateTimeZones();
        log.debug((Object)("getSystemSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return tzValuesList;
    }

    public String getJavaTimeZone(int id) throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String javaTimeZone;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getJavaTimeZone() start:");
        try {
            TimeZones timezone = WSLocator.getzBandInterface(this.username).getTimeZone(id);
            javaTimeZone = timezone.getJavaname();
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("getSystemSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return javaTimeZone;
    }

    public int getTimeZoneId(String javaName) throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        TimeZones[] timeZones;
        int timeZoneId = -1;
        try {
            timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        for (int i = 0; i < timeZones.length; ++i) {
            if (!timeZones[i].getJavaname().equals(javaName)) continue;
            return i;
        }
        return timeZoneId;
    }

    public String getTimeZoneDisplayValue(String javaName) throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        TimeZones[] timeZones;
        String timeZoneDisplayValue = "";
        try {
            timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        for (int i = 0; i < timeZones.length; ++i) {
            if (!timeZones[i].getJavaname().equals(javaName)) continue;
            return timeZones[i].getDisplayname();
        }
        return timeZoneDisplayValue;
    }

    public String getTimeZoneDisplayValue(int TimeZoneId) throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        TimeZones[] timeZones;
        String timeZoneDisplayValue = "";
        try {
            timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        for (int i = 0; i < timeZones.length; ++i) {
            if (timeZones[i].getId() != TimeZoneId) continue;
            return timeZones[i].getDisplayname();
        }
        return timeZoneDisplayValue;
    }

    private String translateToBooleanSetting(String settingValue) {
        log.debug((Object)("settingValue: translateBooleanSetting: " + settingValue));
        if (settingValue == null) {
            return "false";
        }
        String result = "";
        if (settingValue.equals("0")) {
            result = "false";
        } else if (settingValue.equals("1")) {
            result = "true";
        }
        return result;
    }

    private String translateFromBooleanSetting(String settingValue) {
        log.debug((Object)("settingValue: translateBooleanSetting: " + settingValue));
        if (settingValue == null) {
            return "0";
        }
        String result = "";
        if (settingValue.equalsIgnoreCase("true")) {
            result = "1";
        } else if (settingValue.equalsIgnoreCase("false")) {
            result = "0";
        }
        return result;
    }
}

