/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.DeviceManager;

import com.ttv.manager.Catcher.CatcherFilter;
import com.ttv.manager.Catcher.CatcherFilterByEnum;
import com.ttv.manager.Catcher.CatcherMulticastStateEnum;
import com.ttv.manager.Catcher.CatcherSortByEnum;
import com.ttv.manager.Catcher.CatcherType;
import com.ttv.manager.Catcher.CatcherValues;
import com.ttv.manager.Catcher.CatchersResult;
import com.ttv.manager.CatcherGroup.CatcherGroupFilter;
import com.ttv.manager.CatcherGroup.CatcherGroupSortByEnum;
import com.ttv.manager.CatcherGroup.CatcherGroupTypeEnum;
import com.ttv.manager.CatcherGroup.CatcherGroupValues;
import com.ttv.manager.CatcherGroup.CatcherGroupsResult;
import com.ttv.manager.ConfigurationManager.ConfigurationManager;
import com.ttv.manager.Contact.ContactValues;
import com.ttv.manager.Contact.ContactsResult;
import com.ttv.manager.Contact.UContactFilter;
import com.ttv.manager.Contact.UContactSortByEnum;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Metadata.MetadataValues;
import com.ttv.manager.Queue.PitcherValues;
import com.ttv.manager.Queue.QueueFilter;
import com.ttv.manager.Queue.QueueSortByEnum;
import com.ttv.manager.Queue.QueueStatusEnum;
import com.ttv.manager.Queue.QueueTypeEnum;
import com.ttv.manager.Queue.QueueValues;
import com.ttv.manager.Service.ServiceValues;
import com.ttv.manager.Target.QueueTarget;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSDuplicateException;
import com.ttv.manager.WSException.WSInternalErrorException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSLinkObjectException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.WSException.WSValueNullException;
import com.ttv.manager.util.CommonUtils;
import com.ttv.manager.util.FilterProperty;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.Channel;
import com.ttv.zBandInterface.ChannelFilter;
import com.ttv.zBandInterface.ChannelSortByEnum;
import com.ttv.zBandInterface.ChannelStatusEnum;
import com.ttv.zBandInterface.ChannelTarget;
import com.ttv.zBandInterface.ChannelTargetFilter;
import com.ttv.zBandInterface.ChannelTargetFilterByEnum;
import com.ttv.zBandInterface.ChannelTypeEnum;
import com.ttv.zBandInterface.Client;
import com.ttv.zBandInterface.ClientFilter;
import com.ttv.zBandInterface.ClientGroup;
import com.ttv.zBandInterface.ClientGroupFilter;
import com.ttv.zBandInterface.ClientGroupSortByEnum;
import com.ttv.zBandInterface.ClientGroupTypeEnum;
import com.ttv.zBandInterface.ClientMulticastStateEnum;
import com.ttv.zBandInterface.ClientSortByEnum;
import com.ttv.zBandInterface.Contact;
import com.ttv.zBandInterface.ContactFilter;
import com.ttv.zBandInterface.ContactSortByEnum;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.DuplicateException;
import com.ttv.zBandInterface.InternalErrorException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidFilterValueException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.LinkObjectException;
import com.ttv.zBandInterface.Metadata;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.Pitcher;
import com.ttv.zBandInterface.Service;
import com.ttv.zBandInterface.holders.ChannelArrayHolder;
import com.ttv.zBandInterface.holders.ChannelTargetArrayHolder;
import com.ttv.zBandInterface.holders.ClientArrayHolder;
import com.ttv.zBandInterface.holders.ClientGroupArrayHolder;
import com.ttv.zBandInterface.holders.ClientGroupTypeEnumHolder;
import com.ttv.zBandInterface.holders.ContactArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManager {
    private static final Category log = Category.getInstance(DeviceManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static ArrayList<QueueValues> queueValuesList = null;
    private static HashMap<String, DeviceManager> ourInstances = new HashMap();
    private String username = null;

    public static synchronized DeviceManager getInstance(String username) {
        DeviceManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new DeviceManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private DeviceManager(String username) {
        this.username = username;
    }

    private ClientGroupFilter translateCatcherGroupFilter(CatcherGroupFilter catcherGroupFilter) {
        ClientGroupFilter clientGroupFilter = new ClientGroupFilter();
        clientGroupFilter.setAscending(catcherGroupFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToClientGroupFilterPropertyList(catcherGroupFilter.getFilterPropertyList());
        clientGroupFilter.setFilter(CommonUtils.serializeFilter(fp));
        if (catcherGroupFilter.getSortby().equals(CatcherGroupSortByEnum.Name.getValue())) {
            clientGroupFilter.setSortby(ClientGroupSortByEnum.Name);
        } else if (catcherGroupFilter.getSortby().equals(CatcherGroupSortByEnum.Service.getValue())) {
            clientGroupFilter.setSortby(ClientGroupSortByEnum.Service);
        }
        clientGroupFilter.setIndex(catcherGroupFilter.getIndex());
        if (catcherGroupFilter.getLimit() == null) {
            clientGroupFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        } else {
            clientGroupFilter.setLimit(catcherGroupFilter.getLimit());
        }
        return clientGroupFilter;
    }

    private CatcherValues translateClient(Client client) {
        CatcherValues catcherValues = new CatcherValues();
        catcherValues.setId(client.getId());
        catcherValues.setAddress1(client.getAddress1());
        catcherValues.setAddress2(client.getAddress2());
        catcherValues.setCity(client.getCity());
        catcherValues.setContact1Id(client.getContact1Id());
        catcherValues.setContact2Id(client.getContact2Id());
        catcherValues.setCountry(client.getCountry());
        catcherValues.setEnabled(client.getEnabled());
        catcherValues.setHostname(client.getHostname());
        catcherValues.setId(client.getId());
        catcherValues.setName(client.getName());
        catcherValues.setPostal(client.getPostal());
        catcherValues.setSerial(client.getSerial());
        catcherValues.setServiceid(client.getServiceid());
        catcherValues.setServicename(client.getServicename());
        catcherValues.setState(client.getState());
        catcherValues.setTimeSincePoll(client.getTimesincepoll());
        catcherValues.setIsUnicastPush(client.getUnicastpush());
        catcherValues.setDiskfree(client.getDiskfree());
        catcherValues.setComment(client.getComment());
        if (client.getMulticaststate().equals(ClientMulticastStateEnum.Unknown)) {
            catcherValues.setMulticaststate(CatcherMulticastStateEnum.Unknown.getValue());
        } else if (client.getMulticaststate().equals(ClientMulticastStateEnum.No)) {
            catcherValues.setMulticaststate(CatcherMulticastStateEnum.No.getValue());
        } else if (client.getMulticaststate().equals(ClientMulticastStateEnum.Yes)) {
            catcherValues.setMulticaststate(CatcherMulticastStateEnum.Yes.getValue());
        }
        return catcherValues;
    }

    private CatcherGroupValues translateClientGroup(ClientGroup clientGroup) {
        CatcherGroupValues catcherGroupValues = new CatcherGroupValues();
        catcherGroupValues.setId(clientGroup.getId());
        catcherGroupValues.setName(clientGroup.getName());
        catcherGroupValues.setServiceid(clientGroup.getServiceid());
        catcherGroupValues.setServiceName(clientGroup.getServicename());
        catcherGroupValues.setCatcherCount(clientGroup.getClientcount());
        catcherGroupValues.setIsUnicastPush(clientGroup.getUnicastpush());
        if (clientGroup.getType().equals(ClientGroupTypeEnum.Individual)) {
            catcherGroupValues.setType(CatcherGroupTypeEnum.Individual.getValue());
        } else if (clientGroup.getType().equals(ClientGroupTypeEnum.Normal)) {
            catcherGroupValues.setType(CatcherGroupTypeEnum.Normal.getValue());
        } else if (clientGroup.getType().equals(ClientGroupTypeEnum.Special)) {
            catcherGroupValues.setType(CatcherGroupTypeEnum.Special.getValue());
        }
        return catcherGroupValues;
    }

    public CatcherGroupValues getCatcherGroup(String catchergroupid) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        CatcherGroupValues catcherGroupValues;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getCatcherGroup() start:");
        try {
            catcherGroupValues = this.translateClientGroup(WSLocator.getzBandInterface(this.username).getClientGroup(catchergroupid));
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("getCatcherGroup() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return catcherGroupValues;
    }

    public CatcherGroupsResult getCatcherGroups() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        CatcherGroupFilter catcherGroupFilter = new CatcherGroupFilter();
        catcherGroupFilter.setSortby(CatcherGroupSortByEnum.Name.getValue());
        catcherGroupFilter.setAscending(new Boolean(true));
        catcherGroupFilter.setIndex(new Long(0L));
        catcherGroupFilter.setLimit(new Long(-1L));
        return this.getCatcherGroups(catcherGroupFilter);
    }

    public CatcherGroupsResult getCatcherGroups(CatcherGroupFilter catcherGroupFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getCatcherGroups() start:");
        CatcherGroupsResult result = new CatcherGroupsResult();
        if (catcherGroupFilter == null) {
            this.getCatcherGroups();
        }
        ClientGroupArrayHolder clientGroupArrayHolder = new ClientGroupArrayHolder();
        LongHolder count = new LongHolder();
        ClientGroupFilter clientGroupFilter = this.translateCatcherGroupFilter(catcherGroupFilter);
        try {
            WSLocator.getzBandInterface(this.username).getClientGroups(clientGroupFilter, clientGroupArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ClientGroup[] clientGroups = clientGroupArrayHolder.value;
        ArrayList<CatcherGroupValues> catcherGroupValuesList = new ArrayList<CatcherGroupValues>();
        ArrayList<ServiceValues> serviceValuesList = this.getServices();
        if (clientGroups != null) {
            for (int i = 0; i < clientGroups.length; ++i) {
                ClientGroup clientGroup = clientGroups[i];
                if (clientGroup == null) continue;
                CatcherGroupValues catcherGroupValues = this.translateClientGroup(clientGroup);
                for (ServiceValues serviceValues : serviceValuesList) {
                    if (!serviceValues.getId().equals(catcherGroupValues.getServiceid())) continue;
                    catcherGroupValues.setServiceName(serviceValues.getName());
                }
                catcherGroupValuesList.add(catcherGroupValues);
            }
        }
        result = new CatcherGroupsResult(catcherGroupValuesList, new Long(count.value));
        log.debug((Object)("getCatcherGroups() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    public CatchersResult getCatchers() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        CatcherFilter catcherFilter = new CatcherFilter();
        catcherFilter.setAscending(new Boolean(true));
        catcherFilter.setIndex(new Long(0L));
        catcherFilter.setLimit(new Long(-1L));
        catcherFilter.setSortby(CatcherSortByEnum.Name.getValue());
        return this.getCatchers(catcherFilter);
    }

    public CatchersResult getCatchersPendingApproval() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        CatcherFilter catcherFilter = new CatcherFilter();
        catcherFilter.setAscending(new Boolean(true));
        catcherFilter.setIndex(new Long(0L));
        FilterProperty filterProperty = new FilterProperty();
        filterProperty.setFilterby(CatcherFilterByEnum.Enabled.getValue());
        filterProperty.setFilter("false");
        ArrayList<FilterProperty> filterPropertyList = new ArrayList<FilterProperty>();
        filterPropertyList.add(filterProperty);
        catcherFilter.setFilterPropertyList(filterPropertyList);
        catcherFilter.setSortby(CatcherSortByEnum.Name.getValue());
        return this.getCatchers(catcherFilter);
    }

    public CatcherValues getCatcher(String id) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        CatcherValues catcherValues;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getCatcher() start:");
        try {
            catcherValues = this.translateClient(WSLocator.getzBandInterface(this.username).getClient(id));
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("getCatcher() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return catcherValues;
    }

    public void updateCatcher(CatcherValues catcherValues) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSDuplicateException, WSLinkObjectException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"updateCatcher() start:");
        Client client = this.translateCatcherValues(catcherValues);
        try {
            WSLocator.getzBandInterface(this.username).setClient(client);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSLinkObjectException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("updateCatcher() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)(" : updated catcher [" + catcherValues.getName() + " by user [" + this.username + "]"));
        }
    }

    public void approveCatcher(String catcherid, String replacecatcherid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSValueNullException, WSDuplicateException, WSLinkObjectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"approveCatchers() start:");
        log.debug((Object)("approving Catcher:[" + catcherid + "]"));
        try {
            WSLocator.getzBandInterface(this.username).approveClient(catcherid, replacecatcherid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("approveCatchers() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)(" : catcher [" + catcherid + "]approved by user [" + this.username + "]"));
        }
    }

    public void disableCatchers(ArrayList<String> catcheridlist) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSPermissionException, WSInvalidValueException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"diableCatchers() start:");
        try {
            for (String catcherid : catcheridlist) {
                log.debug((Object)("disabling Catcher:[" + catcherid + "]"));
                WSLocator.getzBandInterface(this.username).disableClient(catcherid);
                audit.info((Object)(" : catcher [" + catcherid + "]disabled by user [" + this.username + "]"));
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("disableCatchers() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public void addCatchersToGroups(ArrayList<String> catcherIdList, ArrayList<String> catcherGroupIdList) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"addCatchersToGroups() start:");
        String[] clientids = new String[catcherIdList.size()];
        for (int i = 0; i < catcherIdList.size(); ++i) {
            clientids[i] = catcherIdList.get(i);
        }
        try {
            for (String catchergroupid : catcherGroupIdList) {
                WSLocator.getzBandInterface(this.username).addClientsToGroup(catchergroupid, clientids);
                audit.info((Object)("[" + clientids.length + "] catchers added to catcher group with id [" + catchergroupid + "] by user [" + this.username + "]"));
            }
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("addCatchersToGroups() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public void removeCatchersFromGroup(ArrayList<String> catcherIdList, String catchergroupid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"removeCatchersFromGroup() start:");
        String[] clientids = new String[catcherIdList.size()];
        for (int i = 0; i < catcherIdList.size(); ++i) {
            clientids[i] = catcherIdList.get(i);
        }
        try {
            WSLocator.getzBandInterface(this.username).removeClientsFromGroup(catchergroupid, clientids);
            audit.info((Object)("[" + clientids.length + "] catchers removed from catcher group with id [" + catchergroupid + "] by user [" + this.username + "]"));
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("removeCatchersFromGroup() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    private ClientFilter translateCatcherFilter(CatcherFilter catcherFilter) {
        ClientFilter clientFilter = new ClientFilter();
        ArrayList<FilterProperty> fp = CommonUtils.translateToClientFilterPropertyList(catcherFilter.getFilterPropertyList());
        clientFilter.setFilter(CommonUtils.serializeFilter(fp));
        clientFilter.setAscending(catcherFilter.getAscending());
        clientFilter.setIndex(catcherFilter.getIndex());
        if (catcherFilter.getLimit() == null) {
            clientFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        } else {
            clientFilter.setLimit(catcherFilter.getLimit());
        }
        if (catcherFilter.getSortby().equals(CatcherSortByEnum.Name.getValue())) {
            clientFilter.setSortby(ClientSortByEnum.Name);
        } else if (catcherFilter.getSortby().equals(CatcherSortByEnum.Service.getValue())) {
            clientFilter.setSortby(ClientSortByEnum.Service);
        }
        return clientFilter;
    }

    public CatchersResult getCatchers(CatcherFilter catcherFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getCatchers() start:");
        CatchersResult result = new CatchersResult();
        if (catcherFilter == null) {
            return this.getCatchers();
        }
        ClientFilter clientFilter = this.translateCatcherFilter(catcherFilter);
        ClientArrayHolder clientArrayHolder = new ClientArrayHolder();
        LongHolder count = new LongHolder(0L);
        try {
            WSLocator.getzBandInterface(this.username).getClients(clientFilter, clientArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            log.error((Object)("Exception is:" + e), (Throwable)e);
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Client[] clients = clientArrayHolder.value;
        ArrayList<CatcherValues> catcherValuesList = new ArrayList<CatcherValues>();
        if (clients != null) {
            for (int i = 0; i < clients.length; ++i) {
                Client client = clients[i];
                if (client == null) continue;
                CatcherValues catcherValues = this.translateClient(client);
                catcherValuesList.add(catcherValues);
            }
        }
        result = new CatchersResult(catcherValuesList, new Long(count.value));
        log.debug((Object)("getCatchers() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    public ArrayList<CatcherType> getCatcherTypes() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getCatcherTypes() start:");
        ArrayList<CatcherType> catcherTypesList = new ArrayList<CatcherType>();
        ChannelFilter channelFilter = new ChannelFilter();
        ChannelArrayHolder channelArrayHolder = new ChannelArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getChannels(channelFilter, channelArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Channel[] channels = channelArrayHolder.value;
        if (channels != null) {
            for (int i = 0; i < channels.length; ++i) {
                Channel channel = channels[i];
                if (channel == null) continue;
                CatcherType catcherType = new CatcherType();
                catcherType.setId(channel.getId());
                catcherType.setServiceid(channel.getServiceid());
                catcherType.setName(channel.getName());
                catcherType.setTransmitrate(channel.getTransmitrate());
                catcherType.setReliability(channel.getReliability());
                catcherType.setActivenode(channel.getActivenode());
                catcherType.setDescription(channel.getDescription());
                catcherType.setDatarate(channel.getDatarate());
                catcherTypesList.add(catcherType);
            }
        }
        log.debug((Object)("getCatcherTypes() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return catcherTypesList;
    }

    private Client translateCatcherValues(CatcherValues catcherValues) {
        Client client = new Client();
        client.setId(catcherValues.getId());
        client.setAddress1(catcherValues.getAddress1());
        client.setAddress2(catcherValues.getAddress2());
        client.setCity(catcherValues.getCity());
        client.setContact1Id(catcherValues.getContact1Id());
        client.setContact2Id(catcherValues.getContact2Id());
        client.setCountry(catcherValues.getCountry());
        client.setEnabled(catcherValues.getEnabled());
        client.setHostname(catcherValues.getHostname());
        client.setId(catcherValues.getId());
        client.setName(catcherValues.getName());
        client.setPostal(catcherValues.getPostal());
        client.setSerial(catcherValues.getSerial());
        client.setServiceid(catcherValues.getServiceid());
        client.setServicename(catcherValues.getServicename());
        client.setState(catcherValues.getState());
        client.setTimesincepoll(catcherValues.getTimeSincePoll());
        client.setUnicastpush(catcherValues.getIsUnicastPush());
        client.setDiskfree(catcherValues.getDiskfree());
        client.setComment(catcherValues.getComment());
        if (catcherValues.getMulticaststate().equals("Unknown")) {
            client.setMulticaststate(ClientMulticastStateEnum.Unknown);
        } else if (catcherValues.getMulticaststate().equals("No")) {
            client.setMulticaststate(ClientMulticastStateEnum.No);
        } else if (catcherValues.getMulticaststate().equals("Yes")) {
            client.setMulticaststate(ClientMulticastStateEnum.Yes);
        }
        return client;
    }

    private ClientGroup translateCatcherGroupValues(CatcherGroupValues catcherGroupValues) {
        ClientGroup clientGroup = new ClientGroup();
        clientGroup.setId(catcherGroupValues.getId());
        clientGroup.setName(catcherGroupValues.getName());
        clientGroup.setServiceid(catcherGroupValues.getServiceid());
        clientGroup.setServicename(catcherGroupValues.getServiceName());
        clientGroup.setUnicastpush(catcherGroupValues.getIsUnicastPush());
        if (catcherGroupValues.getType() == null) {
            catcherGroupValues.setType(CatcherGroupTypeEnum.Normal.getValue());
        }
        if (catcherGroupValues.getType().equals(CatcherGroupTypeEnum.Individual.getValue())) {
            clientGroup.setType(ClientGroupTypeEnum.Individual);
        } else if (catcherGroupValues.getType().equals(CatcherGroupTypeEnum.Special.getValue())) {
            clientGroup.setType(ClientGroupTypeEnum.Special);
        } else {
            clientGroup.setType(ClientGroupTypeEnum.Normal);
        }
        return clientGroup;
    }

    public String addCatcherGroup(CatcherGroupValues catcherGroupValues) throws WSValueNullException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSDuplicateException, WSLinkObjectException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String catcherGroupId;
        long begin = System.currentTimeMillis();
        log.debug((Object)"addCatcherGroup() start:");
        if (catcherGroupValues == null || catcherGroupValues.getName().trim().equals("")) {
            log.error((Object)"Catcher Group Name cannot be null");
            throw new WSValueNullException("Catcher Group cannot be null");
        }
        try {
            catcherGroupId = WSLocator.getzBandInterface(this.username).createClientGroup(this.translateCatcherGroupValues(catcherGroupValues));
            audit.info((Object)("Catcher group added [" + catcherGroupValues.getName() + "] " + " with id [" + catcherGroupId + "] by user [" + this.username + "]"));
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSLinkObjectException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("addCatcherGroup() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return catcherGroupId;
    }

    public void updateCatcherGroup(CatcherGroupValues catcherGroupValues) throws WSValueNullException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSDuplicateException, WSLinkObjectException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"updateCatcherGroup() start:");
        if (catcherGroupValues == null || catcherGroupValues.getName().equals("")) {
            log.error((Object)"Catcher Group cannot be null");
            throw new WSValueNullException("Catcher Group cannot be null");
        }
        ClientGroup clientGroup = this.translateCatcherGroupValues(catcherGroupValues);
        try {
            WSLocator.getzBandInterface(this.username).setClientGroup(clientGroup);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSLinkObjectException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("updateCatcherGroup() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Catcher group added [" + catcherGroupValues.getName() + "] by user [" + this.username + "]"));
    }

    public void deleteCatcherGroup(String id) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deleteCatcherGroup() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteClientGroup(id);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("deleteCatcherGroup() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Catcher group with id deleted [" + id + "] by user [" + this.username + "]"));
    }

    public void deleteCatcher(String id) throws WSValueNullException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deleteCatcherGroup() start:");
        if (id == null || id.equals("")) {
            log.error((Object)"Catcher id cannot be null");
            throw new WSValueNullException("Catcher id cannot be null");
        }
        try {
            WSLocator.getzBandInterface(this.username).deleteClient(id);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("deleteCatcher() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Catcher with id deleted [" + id + "] by user [" + this.username + "]"));
    }

    private ContactFilter translateUContactFilter(UContactFilter ucontactFilter) {
        ContactFilter contactFilter = new ContactFilter();
        UContactSortByEnum ucontactSortByEnum = ucontactFilter.getSortby();
        if (ucontactSortByEnum.equals(UContactSortByEnum.Email)) {
            contactFilter.setSortby(ContactSortByEnum.Email);
        } else if (ucontactSortByEnum.equals(UContactSortByEnum.FirstName)) {
            contactFilter.setSortby(ContactSortByEnum.FirstName);
        } else if (ucontactSortByEnum.equals(UContactSortByEnum.LastName)) {
            contactFilter.setSortby(ContactSortByEnum.LastName);
        } else if (ucontactSortByEnum.equals(UContactSortByEnum.Title)) {
            contactFilter.setSortby(ContactSortByEnum.Title);
        }
        contactFilter.setAscending(ucontactFilter.getAscending());
        contactFilter.setFilter(CommonUtils.serializeFilter(ucontactFilter.getFilter()));
        contactFilter.setIndex(ucontactFilter.getIndex());
        contactFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        return contactFilter;
    }

    private ContactValues translateContact(Contact contact) {
        ContactValues contactValues = new ContactValues();
        contactValues.setAddress1(contact.getAddress1());
        contactValues.setAddress2(contact.getAddress2());
        contactValues.setCity(contact.getCity());
        contactValues.setCountry(contact.getCountry());
        contactValues.setEmail(contact.getEmail());
        contactValues.setFax(contact.getFax());
        contactValues.setFirstname(contact.getFirstname());
        contactValues.setId(contact.getId());
        contactValues.setLastname(contact.getLastname());
        contactValues.setMobile(contact.getMobile());
        contactValues.setPhone(contact.getPhone());
        contactValues.setPostal(contact.getPostal());
        contactValues.setState(contact.getState());
        contactValues.setTitle(contact.getTitle());
        return contactValues;
    }

    private Contact translateContactValues(ContactValues contactValues) {
        Contact contact = new Contact();
        contact.setAddress1(contactValues.getAddress1());
        contact.setAddress2(contactValues.getAddress2());
        contact.setCity(contactValues.getCity());
        contact.setCountry(contactValues.getCountry());
        contact.setEmail(contactValues.getEmail());
        contact.setFax(contactValues.getFax());
        contact.setFirstname(contactValues.getFirstname());
        contact.setId(contactValues.getId());
        contact.setLastname(contactValues.getLastname());
        contact.setMobile(contactValues.getMobile());
        contact.setPhone(contactValues.getPhone());
        contact.setPostal(contactValues.getPostal());
        contact.setState(contactValues.getState());
        contact.setTitle(contactValues.getTitle());
        return contact;
    }

    public ContactValues getContact(String contactid) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ContactValues contactValues;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getContact() start:");
        try {
            contactValues = this.translateContact(WSLocator.getzBandInterface(this.username).getContact(contactid));
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("getContact() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return contactValues;
    }

    public ContactsResult getContacts(UContactFilter ucontactFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getContacts() start:");
        ContactsResult result = new ContactsResult();
        if (ucontactFilter == null) {
            return this.getContacts();
        }
        ContactFilter contactFilter = this.translateUContactFilter(ucontactFilter);
        ContactArrayHolder contactArrayHolder = new ContactArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getContacts(contactFilter, contactArrayHolder, count);
            Contact[] contacts = contactArrayHolder.value;
            ArrayList<ContactValues> contactValuesList = new ArrayList<ContactValues>();
            if (contacts != null) {
                for (int i = 0; i < contacts.length; ++i) {
                    Contact contact = contacts[i];
                    if (contact == null) continue;
                    ContactValues contactValues = this.translateContact(contact);
                    contactValuesList.add(contactValues);
                }
            }
            result = new ContactsResult(contactValuesList, new Long(count.value));
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("getContacts() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return result;
    }

    public ContactsResult getContacts() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        UContactFilter ucontactFilter = new UContactFilter();
        ucontactFilter.setAscending(new Boolean(true));
        ucontactFilter.setIndex(new Long(1L));
        ucontactFilter.setLimit(new Long(-1L));
        return this.getContacts(ucontactFilter);
    }

    public String addContact(ContactValues contactValues) throws WSValueNullException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSDuplicateException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String contactId;
        long begin = System.currentTimeMillis();
        log.debug((Object)"addContact() start:");
        String fname = contactValues.getFirstname();
        String lname = contactValues.getLastname();
        if (fname == null || lname == null || fname.equals("") || lname.equals("")) {
            throw new WSValueNullException("First Name or Last Name cannot be null");
        }
        Contact contact = this.translateContactValues(contactValues);
        try {
            contactId = WSLocator.getzBandInterface(this.username).createContact(contact);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("addContact() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Contact added for [" + contactValues.getFirstname() + " " + contactValues.getLastname() + "] by user [" + this.username + "]"));
        }
        return contactId;
    }

    public void deleteContact(String id) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deleteContact() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteContact(id);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("deleteContact() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Contact delete with id  [" + id + "] by user [" + this.username + "]"));
        }
    }

    public void updateContact(ContactValues contactValues) throws WSValueNullException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSDuplicateException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"updateContact() start:");
        String fname = contactValues.getFirstname();
        String lname = contactValues.getLastname();
        if (fname == null || lname == null || fname.equals("") || lname.equals("")) {
            throw new WSValueNullException("First Name or Last Name cannot be null");
        }
        Contact contact = this.translateContactValues(contactValues);
        try {
            WSLocator.getzBandInterface(this.username).setContact(contact);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("updateContact() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Contact updated for  [" + contactValues.getFirstname() + " " + contactValues.getLastname() + "] by user [" + this.username + "]"));
        }
    }

    private ChannelFilter translateQueueFilter(QueueFilter queueFilter) {
        ChannelFilter channelFilter = new ChannelFilter();
        channelFilter.setFilter(CommonUtils.serializeFilter(queueFilter.getFilter()));
        channelFilter.setAscending(queueFilter.getAscending());
        channelFilter.setIndex(queueFilter.getIndex());
        channelFilter.setLimit(ConfigurationManager.getInstance(this.username).getItemsPerPage());
        if (queueFilter.getSortby().equals(QueueSortByEnum.Name)) {
            channelFilter.setSortby(ChannelSortByEnum.Name);
        }
        return channelFilter;
    }

    public synchronized ArrayList<QueueValues> getQueues() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getQueues() start:");
        QueueFilter queueFilter = new QueueFilter();
        queueFilter.setAscending(new Boolean(true));
        queueFilter.setIndex(new Long(0L));
        queueFilter.setSortby(QueueSortByEnum.Name);
        queueValuesList = this.getQueues(queueFilter);
        log.debug((Object)("getQueues() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return queueValuesList;
    }

    public String getQueueName(String queueid) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getQueueName() start:");
        ArrayList<QueueValues> queueValuesList = this.getQueues();
        String queuename = "";
        for (QueueValues queueValues : queueValuesList) {
            if (!queueValues.getId().equals(queueid)) continue;
            queuename = queueValues.getName();
            break;
        }
        log.debug((Object)("getQueueName() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return queuename;
    }

    private QueueValues translateChannel(Channel channel) {
        QueueValues queueValues = new QueueValues();
        queueValues.setActivenode(channel.getActivenode());
        queueValues.setDatarate(channel.getDatarate());
        queueValues.setDescription(channel.getDescription());
        queueValues.setEncryptionRequired(channel.getEncryptionrequired());
        queueValues.setId(channel.getId());
        String[] nodesData = channel.getNodes();
        ArrayList<String> nodesList = new ArrayList<String>();
        if (nodesData != null) {
            for (int i = 0; i < nodesData.length; ++i) {
                log.debug((Object)("Queue HostName = " + nodesData[i]));
                nodesList.add(nodesData[i]);
            }
        }
        queueValues.setNodesList(nodesList);
        Metadata[] metadata = channel.getMetadata();
        ArrayList<MetadataValues> metadataValuesList = new ArrayList<MetadataValues>();
        if (metadata != null) {
            for (int i = 0; i < metadata.length; ++i) {
                metadataValuesList.add(CommonUtils.translateMetadata(metadata[i]));
            }
        }
        queueValues.setMetadataValuesList(metadataValuesList);
        queueValues.setName(channel.getName());
        queueValues.setServiceid(channel.getServiceid());
        queueValues.setReliability(channel.getReliability());
        if (channel.getStatus().equals(ChannelStatusEnum.Available)) {
            queueValues.setStatus(QueueStatusEnum.Available.getValue());
        } else if (channel.getStatus().equals(ChannelStatusEnum.Busy)) {
            queueValues.setStatus(QueueStatusEnum.Busy.getValue());
        } else if (channel.getStatus().equals(ChannelStatusEnum.Dead)) {
            queueValues.setStatus(QueueStatusEnum.Dead.getValue());
        } else if (channel.getStatus().equals(ChannelStatusEnum.Paused)) {
            queueValues.setStatus(QueueStatusEnum.Paused.getValue());
        }
        if (channel.getType().equals(ChannelTypeEnum.MCAST)) {
            queueValues.setType(QueueTypeEnum.MCAST.getValue());
        } else if (channel.getType().equals(ChannelTypeEnum.UCAST)) {
            queueValues.setType(QueueTypeEnum.UCAST.getValue());
        }
        queueValues.setTransmitrate(channel.getTransmitrate());
        queueValues.setRepairRetries(channel.getRepairretries());
        queueValues.setPause(channel.getOnhold());
        return queueValues;
    }

    private ArrayList<QueueValues> getQueues(QueueFilter queueFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ArrayList<QueueValues> queueValuesList = new ArrayList<QueueValues>();
        ChannelFilter channelFilter = this.translateQueueFilter(queueFilter);
        ChannelArrayHolder channelArrayHolder = new ChannelArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getChannels(channelFilter, channelArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Channel[] channels = channelArrayHolder.value;
        if (channels != null) {
            for (int i = 0; i < channels.length; ++i) {
                Channel channel = channels[i];
                if (channel == null) continue;
                QueueValues queueValues = this.translateChannel(channel);
                queueValuesList.add(queueValues);
            }
        }
        return queueValuesList;
    }

    public void setRepairRetries(String queueid, Long repairretries) throws WSPermissionException, WSInternalErrorException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"setRepairRetries() start:");
        try {
            WSLocator.getzBandInterface(this.username).setChannelRepairRetries(queueid, repairretries);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (InternalErrorException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInternalErrorException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("setRepairRetries() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Repair retries for queue [" + queueid + "] set to [" + repairretries + " by user [" + this.username + "]"));
        }
    }

    public void pause(String queueid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"pause() start:");
        try {
            WSLocator.getzBandInterface(this.username).holdChannel(queueid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("pause() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Queue paused with queue id [" + queueid + "] by user [" + this.username + "]"));
    }

    public void resume(String queueid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"resume() start:");
        try {
            WSLocator.getzBandInterface(this.username).releaseChannel(queueid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("resume() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Queue resumed with queue id [" + queueid + "] by user [" + this.username + "]"));
        }
    }

    public ArrayList<ServiceValues> getServices() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getServices() start:");
        ArrayList<ServiceValues> serviceValuesList = new ArrayList<ServiceValues>();
        try {
            Service[] services = WSLocator.getzBandInterface(this.username).getServices();
            if (services != null) {
                for (int i = 0; i < services.length; ++i) {
                    Service service = services[i];
                    if (service == null) continue;
                    ServiceValues serviceValues = new ServiceValues();
                    serviceValues.setDescription(service.getDescription());
                    serviceValues.setId(service.getId());
                    serviceValues.setName(service.getName());
                    serviceValuesList.add(serviceValues);
                }
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("getServices() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return serviceValuesList;
    }

    public ArrayList<PitcherValues> getPitcherValues() throws WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getPitcherValues() start:");
        ArrayList<PitcherValues> pitcherValueList = new ArrayList<PitcherValues>();
        try {
            Pitcher[] pitchers = WSLocator.getzBandInterface(this.username).getPitchers();
            if (pitchers != null) {
                for (int i = 0; i < pitchers.length; ++i) {
                    Pitcher pitcher = pitchers[i];
                    if (pitcher == null) continue;
                    PitcherValues pitcherValues = new PitcherValues();
                    pitcherValues.setHostname(pitcher.getHostname());
                    pitcherValues.setAlive(pitcher.getAlive());
                    pitcherValueList.add(pitcherValues);
                }
            }
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("getPitcherValues() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return pitcherValueList;
    }

    public boolean swapQueueNodes(String queueId, ArrayList<String> nodeList) throws WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"swapQueueNodes() start:");
        String tempNode = "";
        String tempNode1 = "";
        String tempNode2 = "";
        if (nodeList.size() > 1) {
            tempNode = nodeList.get(0);
            tempNode1 = nodeList.get(0);
            tempNode2 = nodeList.get(1);
        }
        tempNode1 = tempNode2;
        tempNode2 = tempNode;
        String nodeListWithCommaAsDel = new String("");
        try {
            for (int i = 0; i < nodeList.size(); ++i) {
                nodeListWithCommaAsDel = i == 0 ? nodeListWithCommaAsDel + tempNode1 : (i == 1 ? nodeListWithCommaAsDel + "," + tempNode2 : nodeListWithCommaAsDel + "," + nodeList.get(i));
            }
            log.debug((Object)("Node List with comma as delimeter  = " + nodeListWithCommaAsDel));
            WSLocator.getzBandInterface(this.username).setChannelNodes(queueId, nodeListWithCommaAsDel);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("swapQueueNodes() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return true;
    }

    public boolean setQueueNodes(String queueId, ArrayList<String> nodeList) throws WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"setQueueNodes() start:");
        String nodeListWithCommaAsDel = new String("");
        try {
            for (int i = 0; i < nodeList.size(); ++i) {
                nodeListWithCommaAsDel = i == 0 ? nodeListWithCommaAsDel + nodeList.get(i) : nodeListWithCommaAsDel + "," + nodeList.get(i);
            }
            log.debug((Object)("Node List with comma as delimeter  = " + nodeListWithCommaAsDel));
            WSLocator.getzBandInterface(this.username).setChannelNodes(queueId, nodeListWithCommaAsDel);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("setQueueNodes() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return true;
    }

    private QueueTarget translateChannelTarget(ChannelTarget channelTarget) {
        QueueTarget queueTarget = new QueueTarget();
        queueTarget.setQueueid(channelTarget.getChannelid());
        queueTarget.setCatchergroupid(channelTarget.getClientgroupid());
        queueTarget.setCatchergroupname(channelTarget.getClientgroupname());
        if (channelTarget.getClientgrouptype().equals(ClientGroupTypeEnum.Individual)) {
            queueTarget.setCatchergrouptype(CatcherGroupTypeEnum.Individual);
        } else if (channelTarget.getClientgrouptype().equals(ClientGroupTypeEnum.Normal)) {
            queueTarget.setCatchergrouptype(CatcherGroupTypeEnum.Normal);
        } else if (channelTarget.getClientgrouptype().equals(ClientGroupTypeEnum.Special)) {
            queueTarget.setCatchergrouptype(CatcherGroupTypeEnum.Special);
        }
        return queueTarget;
    }

    public void createQueueTarget(String catcherGrpId, String unicastQId) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        log.debug((Object)"createQueueTarget() start:");
        if (catcherGrpId != null && unicastQId != null) {
            ChannelTarget cTarget = new ChannelTarget();
            cTarget.setChannelid(unicastQId);
            cTarget.setClientgroupid(catcherGrpId);
            try {
                WSLocator.getzBandInterface(this.username).createChannelTarget(cTarget);
            }
            catch (PermissionException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSPermissionException)emgr.TranslateException(e);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (LinkObjectException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSLinkObjectException)emgr.TranslateException(e);
            }
            catch (InvalidValueException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidValueException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
        }
        log.debug((Object)"createQueueTarget() end:");
    }

    public QueueTarget getQueueTargets(String catherid) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSDatabaseException, WSInvalidValueException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getQueueTargets() start:");
        ChannelTargetFilter chTargetFilter = new ChannelTargetFilter();
        String filter = ChannelTargetFilterByEnum.ClientGroupId.getValue() + "=" + catherid;
        chTargetFilter.setFilter(filter);
        ChannelTargetArrayHolder targetHolder = new ChannelTargetArrayHolder();
        LongHolder count = new LongHolder(0L);
        try {
            WSLocator.getzBandInterface(this.username).getChannelTargets(chTargetFilter, targetHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ChannelTarget[] channelTargets = targetHolder.value;
        QueueTarget queueTarget = null;
        if (channelTargets != null && channelTargets[0] != null) {
            queueTarget = this.translateChannelTarget(channelTargets[0]);
        }
        log.debug((Object)("getQueueTargets() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return queueTarget;
    }

    public void deleteQueueTarget(ArrayList<String> catcheridlist) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSConnectException, WSInvalidLoginException, WSServerDownException, WSPermissionException {
        log.debug((Object)"deleteQueueTarget() start:");
        for (String catcherid : catcheridlist) {
            ChannelTargetFilter chTargetFilter = new ChannelTargetFilter();
            String filter = ChannelTargetFilterByEnum.ClientGroupId.getValue() + "=" + catcherid;
            chTargetFilter.setFilter(filter);
            ChannelTargetArrayHolder targetHolder = new ChannelTargetArrayHolder();
            LongHolder count = new LongHolder(0L);
            try {
                WSLocator.getzBandInterface(this.username).getChannelTargets(chTargetFilter, targetHolder, count);
            }
            catch (InvalidFilterException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidFilterException)emgr.TranslateException(e);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (InvalidValueException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidValueException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
            ChannelTarget[] channelTargets = targetHolder.value;
            if (channelTargets == null) continue;
            for (int i = 0; i < channelTargets.length; ++i) {
                try {
                    WSLocator.getzBandInterface(this.username).deleteChannelTarget(channelTargets[i].getChannelid(), channelTargets[i].getClientgroupid());
                    continue;
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
            }
        }
        log.debug((Object)"deleteQueueTarget() end:");
    }

    public QueueTarget chooseQueueTarget(String catcherGrpId) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        log.debug((Object)"chooseQueueTarget() start:");
        StringHolder catcherGroupId = new StringHolder(catcherGrpId);
        StringHolder queueId = new StringHolder();
        StringHolder catcherGrpName = new StringHolder();
        ClientGroupTypeEnumHolder clientGrpTyeHolder = new ClientGroupTypeEnumHolder();
        try {
            WSLocator.getzBandInterface(this.username).chooseChannelTarget(catcherGroupId, queueId, catcherGrpName, clientGrpTyeHolder);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        QueueTarget qTarget = new QueueTarget();
        qTarget.setCatchergroupid(catcherGroupId.value);
        qTarget.setCatchergroupname(catcherGrpName.value);
        qTarget.setQueueid(queueId.value);
        if (clientGrpTyeHolder.value.getValue().equals(ClientGroupTypeEnum.Individual.getValue())) {
            qTarget.setCatchergrouptype(CatcherGroupTypeEnum.Individual);
        } else if (clientGrpTyeHolder.value.getValue().equals(ClientGroupTypeEnum.Normal.getValue())) {
            qTarget.setCatchergrouptype(CatcherGroupTypeEnum.Normal);
        } else if (clientGrpTyeHolder.value.getValue().equals(ClientGroupTypeEnum.Special)) {
            qTarget.setCatchergrouptype(CatcherGroupTypeEnum.Special);
        }
        log.debug((Object)"chooseQueueTarget() end:");
        return qTarget;
    }
}

