/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.RuleManager;

import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Rule.RuleListValueResult;
import com.ttv.manager.Rule.RuleListValues;
import com.ttv.manager.Rule.RuleValues;
import com.ttv.manager.Rule.StepValues;
import com.ttv.manager.Rule.URuleFilter;
import com.ttv.manager.Rule.URuleSortByEnum;
import com.ttv.manager.Rule.UStepResultEnum;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSDuplicateException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.util.CommonUtils;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.DuplicateException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidFilterValueException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.Rule;
import com.ttv.zBandInterface.RuleFilter;
import com.ttv.zBandInterface.RuleList;
import com.ttv.zBandInterface.RuleSortByEnum;
import com.ttv.zBandInterface.Step;
import com.ttv.zBandInterface.StepOperatorEnum;
import com.ttv.zBandInterface.StepResultEnum;
import com.ttv.zBandInterface.holders.RuleArrayHolder;
import com.ttv.zBandInterface.holders.RuleListArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.rpc.holders.LongHolder;
import org.apache.log4j.Category;

public class RuleManager {
    private static final Category log = Category.getInstance(RuleManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, RuleManager> ourInstances = new HashMap();
    private String username = null;

    public static synchronized RuleManager getInstance(String username) {
        RuleManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new RuleManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private RuleManager(String username) {
        this.username = username;
    }

    private RuleFilter translateURuleFilter(URuleFilter uruleFilter) {
        RuleFilter ruleFilter = new RuleFilter();
        ruleFilter.setAscending(uruleFilter.getAscending());
        ruleFilter.setFilter(CommonUtils.serializeFilter(uruleFilter.getFilterPropertyList()));
        ruleFilter.setIndex(uruleFilter.getIndex());
        ruleFilter.setLimit(new Long(-1L));
        if (uruleFilter.getSortby().equals(URuleSortByEnum.Order)) {
            ruleFilter.setSortby(RuleSortByEnum.Order);
        }
        return ruleFilter;
    }

    private StepValues translateStep(Step step) {
        StepValues stepValues = new StepValues();
        stepValues.setAction(step.getAction());
        stepValues.setId(step.getId());
        stepValues.setOperand1(step.getOperand1());
        stepValues.setOperand2(step.getOperand2());
        stepValues.setOperator(step.getOperator().getValue());
        stepValues.setOrder(step.getOrder());
        if (step.getResult().equals(StepResultEnum.False)) {
            stepValues.setResult(UStepResultEnum.False.getValue());
        } else if (step.getResult().equals(StepResultEnum.True)) {
            stepValues.setResult(UStepResultEnum.True.getValue());
        } else if (step.getResult().equals(StepResultEnum.Void)) {
            stepValues.setResult(UStepResultEnum.Void.getValue());
        }
        return stepValues;
    }

    private RuleValues translateRule(Rule rule) {
        RuleValues ruleValues = new RuleValues();
        ruleValues.setActive(rule.isActive());
        ruleValues.setAuto(rule.isAuto());
        ruleValues.setId(rule.getId());
        ruleValues.setName(rule.getName());
        ruleValues.setOrder(rule.getOrder());
        Step[] steps = rule.getSteps();
        ArrayList<StepValues> stepValuesList = new ArrayList<StepValues>();
        if (steps != null) {
            for (int i = 0; i < steps.length; ++i) {
                Step step = steps[i];
                if (step == null) continue;
                StepValues stepValues = this.translateStep(step);
                stepValuesList.add(stepValues);
            }
        }
        ruleValues.setSteps(stepValuesList);
        return ruleValues;
    }

    private Rule translateRuleValues(RuleValues rv) {
        Rule rule = new Rule();
        if (rv.getId() != null) {
            rule.setId(rv.getId());
        } else {
            UUID.randomUUID();
        }
        rule.setActive(rv.isActive());
        rule.setAuto(rv.isAuto());
        rule.setName(rv.getName());
        rule.setOrder(rv.getOrder());
        ArrayList<Step> steps = new ArrayList<Step>();
        if (rv.getSteps() != null) {
            for (StepValues sv : rv.getSteps()) {
                steps.add(this.translateStepValues(sv));
            }
        }
        rule.setSteps(steps.toArray(new Step[steps.size()]));
        return rule;
    }

    private Step translateStepValues(StepValues sv) {
        Step step = new Step();
        if (sv.getId() != null) {
            step.setId(sv.getId());
        } else {
            UUID.randomUUID();
        }
        step.setOrder(sv.getOrder());
        step.setOperand1(sv.getOperand1());
        step.setOperator(StepOperatorEnum.fromValue(sv.getOperator()));
        step.setOperand2(sv.getOperand2());
        step.setResult(StepResultEnum.fromString(sv.getResult()));
        step.setAction(sv.getAction());
        return step;
    }

    public RuleValues getRule(String ruleId) throws WSDatabaseException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getRule(id) start:");
        RuleValues rulevalue = null;
        try {
            Rule rule = WSLocator.getzBandInterface(this.username).getRule(ruleId);
            rulevalue = this.translateRule(rule);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("getRule(id) complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return rulevalue;
    }

    public RuleListValueResult getRuleList(URuleFilter uruleFilter) throws WSInvalidFilterValueException, WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getRuleList() start:");
        RuleListValueResult result = new RuleListValueResult();
        RuleFilter filter = this.translateURuleFilter(uruleFilter);
        RuleListArrayHolder rules = new RuleListArrayHolder();
        LongHolder count = new LongHolder(0L);
        try {
            WSLocator.getzBandInterface(this.username).getRuleList(filter, rules, count);
            RuleList[] ruleLists = rules.value;
            ArrayList<RuleListValues> ruleListValues = new ArrayList<RuleListValues>();
            if (ruleLists != null) {
                RuleListValues rv = null;
                for (int r = 0; r < ruleLists.length; ++r) {
                    rv = new RuleListValues(ruleLists[r].getId(), ruleLists[r].getName());
                    ruleListValues.add(rv);
                }
            }
            result.setCount(new Long(count.value));
            result.setRuleListValuesList(ruleListValues);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("getRuleList() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    public ArrayList<RuleValues> getRules(URuleFilter uruleFilter, Long since) throws WSInvalidFilterValueException, WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getRules() start:");
        if (uruleFilter == null || since == null) {
            return this.getRules(Calendar.getInstance().getTimeInMillis());
        }
        RuleFilter ruleFilter = this.translateURuleFilter(uruleFilter);
        RuleArrayHolder ruleArrayHolder = new RuleArrayHolder();
        LongHolder count = new LongHolder();
        Calendar rulesChangedSince = Calendar.getInstance();
        rulesChangedSince.setTimeInMillis(since);
        try {
            WSLocator.getzBandInterface(this.username).getRules(ruleFilter, rulesChangedSince, ruleArrayHolder, count);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Rule[] rules = ruleArrayHolder.value;
        ArrayList<RuleValues> ruleValuesList = new ArrayList<RuleValues>();
        if (rules != null) {
            for (int i = 0; i < rules.length; ++i) {
                Rule rule = rules[i];
                if (rule == null) continue;
                RuleValues ruleValues = this.translateRule(rule);
                ruleValuesList.add(ruleValues);
            }
        }
        log.debug((Object)("getRules() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return ruleValuesList;
    }

    public ArrayList<RuleValues> getRules(Long since) throws WSInvalidFilterValueException, WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        URuleFilter uruleFilter = new URuleFilter();
        uruleFilter.setAscending(new Boolean(true));
        uruleFilter.setIndex(new Long(1L));
        uruleFilter.setLimit(new Long(-1L));
        uruleFilter.setSortby(URuleSortByEnum.Order);
        return this.getRules(uruleFilter, since);
    }

    public void deleteRule(String id) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"deleteRule() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteRule(id);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("deleteRule() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Rule deleted with id [" + id + "] by user [" + this.username + "]"));
        }
    }

    public String createRule(RuleValues rv) throws WSDuplicateException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"createRule() start:");
        try {
            String ruleId;
            String string = ruleId = WSLocator.getzBandInterface(this.username).createRule(this.translateRuleValues(rv));
            return string;
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("createRule() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Rule [" + rv.getName() + "] created by user [" + this.username + "]"));
        }
    }

    public void setRule(RuleValues rv) throws WSDuplicateException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"setRule() start:");
        try {
            WSLocator.getzBandInterface(this.username).setRule(this.translateRuleValues(rv));
        }
        catch (DuplicateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDuplicateException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            log.debug((Object)("setRule() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Rule set for [" + rv.getName() + "]  by user [" + this.username + "]"));
        }
    }
}

