/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.util;

import com.ttv.manager.Metadata.MetadataValues;
import com.ttv.manager.Pitch.PitchDetailsFilterByEnum;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.util.FilterProperty;
import com.ttv.zBandInterface.JobDetailFilterByEnum;
import com.ttv.zBandInterface.Metadata;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Category;

public class CommonUtils {
    private static final Category log = Category.getInstance(CommonUtils.class);
    private static final String comma = ",";

    public static synchronized MetadataValues translateMetadata(Metadata metadata) {
        MetadataValues metadataValues = null;
        if (metadata.getProperty() != null) {
            String metadataValue = metadata.getValue();
            if (metadataValue == null) {
                metadataValue = "";
            }
            metadataValues = new MetadataValues(metadata.getProperty(), metadataValue);
        }
        return metadataValues;
    }

    public static synchronized ArrayList<FilterProperty> translateToProviderFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) throws WSInvalidFilterException {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                if ("Provider".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("None".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty(fp.getFilterby(), fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                String fby = fp.getFilterby();
                throw new WSInvalidFilterException("FilterBy value '" + fby + "' does not match known values");
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToProgramFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) throws WSInvalidFilterException {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp2;
                FilterProperty wsfp1;
                Calendar c;
                Date date;
                SimpleDateFormat formatter;
                FilterProperty wsfp;
                if ("Package".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Provider".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ProviderId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("License Start".equals(fp.getFilterby())) {
                    if (fp.getFilteroperator().equals("=")) {
                        formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        date = CommonUtils.dateVal(fp.getFilter());
                        c = Calendar.getInstance();
                        c.setTime(date);
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        wsfp1 = new FilterProperty("LicenseStart", ">=", formatter.format((Object)c.getTime()));
                        c.set(11, 23);
                        c.set(12, 59);
                        c.set(13, 59);
                        wsfp2 = new FilterProperty("LicenseStart", "<=", formatter.format((Object)c.getTime()));
                        wsFilterPropertyList.add(wsfp1);
                        wsFilterPropertyList.add(wsfp2);
                        continue;
                    }
                    wsfp = new FilterProperty("LicenseStart", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("License End".equals(fp.getFilterby())) {
                    if (fp.getFilteroperator().equals("=")) {
                        formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        date = CommonUtils.dateVal(fp.getFilter());
                        c = Calendar.getInstance();
                        c.setTime(date);
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        wsfp1 = new FilterProperty("LicenseEnd", ">=", formatter.format((Object)c.getTime()));
                        c.set(11, 23);
                        c.set(12, 59);
                        c.set(13, 59);
                        wsfp2 = new FilterProperty("LicenseEnd", "<=", formatter.format((Object)c.getTime()));
                        wsFilterPropertyList.add(wsfp1);
                        wsFilterPropertyList.add(wsfp2);
                        continue;
                    }
                    wsfp = new FilterProperty("LicenseEnd", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Package Type".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("TemplateId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Pitch Status".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("JobCount", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("None".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("None", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                String fby = fp.getFilterby();
                throw new WSInvalidFilterException("FilterBy value '" + fby + "' does not match known values");
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToClientFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) throws WSInvalidFilterException {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                if ("Contact".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ContactId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Enabled".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Enabled", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Catcher".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Service".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ServiceId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("CatcherGroupId".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ClientGroupId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Host Name".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Hostname", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("InActive".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("InactiveFor", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("DiskSpace".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("DiskFreeBelow", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("MulticastState".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("MulticastState", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                String fby = fp.getFilterby();
                throw new WSInvalidFilterException("FilterBy value '" + fby + "' does not match known values");
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToClientGroupFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) throws WSInvalidFilterException, WSInvalidFilterValueException {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                log.info((Object)("fp.getFilterby()" + fp.getFilterby()));
                log.info((Object)("fp.getFilteroperator()" + fp.getFilteroperator()));
                if ("Catcher Group".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Service".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ServiceId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("CatcherId".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ClientId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Type".equals(fp.getFilterby())) {
                    String[] typearray = fp.getFilter().split("\\|");
                    String wsfilter = "";
                    if (typearray != null) {
                        for (int i = 0; i < typearray.length; ++i) {
                            if (typearray[i].equals("Individual")) {
                                if (i == 0) {
                                    wsfilter = "Individual";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Individual";
                                continue;
                            }
                            if (typearray[i].equals("Normal")) {
                                if (i == 0) {
                                    wsfilter = "Normal";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Normal";
                                continue;
                            }
                            if (typearray[i].equals("Special")) {
                                if (i == 0) {
                                    wsfilter = "Special";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Special";
                                continue;
                            }
                            throw new WSInvalidFilterValueException("Filter value '" + typearray[i] + "' does not match known values");
                        }
                    }
                    FilterProperty wsfp2 = new FilterProperty("Type", fp.getFilteroperator(), wsfilter);
                    wsFilterPropertyList.add(wsfp2);
                    continue;
                }
                if ("Catcher Name".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ClientName", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Catcher Count".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ClientCount", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                String fby = fp.getFilterby();
                throw new WSInvalidFilterException("FilterBy value '" + fby + "' does not match known values");
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToJobFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) throws WSInvalidFilterException, WSInvalidFilterValueException {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp2;
                FilterProperty wsfp1;
                Calendar c;
                Date date;
                SimpleDateFormat formatter;
                FilterProperty wsfp;
                if ("Catcher Name".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ClientName", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("License Start".equals(fp.getFilterby())) {
                    if (fp.getFilteroperator().equals("=")) {
                        formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        date = CommonUtils.dateVal(fp.getFilter());
                        c = Calendar.getInstance();
                        c.setTime(date);
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        wsfp1 = new FilterProperty("LicenseStart", ">=", formatter.format((Object)c.getTime()));
                        c.set(11, 23);
                        c.set(12, 59);
                        c.set(13, 59);
                        wsfp2 = new FilterProperty("LicenseStart", "<=", formatter.format((Object)c.getTime()));
                        wsFilterPropertyList.add(wsfp1);
                        wsFilterPropertyList.add(wsfp2);
                        continue;
                    }
                    wsfp = new FilterProperty("LicenseStart", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("License End".equals(fp.getFilterby())) {
                    if (fp.getFilteroperator().equals("=")) {
                        formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        date = CommonUtils.dateVal(fp.getFilter());
                        c = Calendar.getInstance();
                        c.setTime(date);
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        wsfp1 = new FilterProperty("LicenseEnd", ">=", formatter.format((Object)c.getTime()));
                        c.set(11, 23);
                        c.set(12, 59);
                        c.set(13, 59);
                        wsfp2 = new FilterProperty("LicenseEnd", "<=", formatter.format((Object)c.getTime()));
                        wsFilterPropertyList.add(wsfp1);
                        wsFilterPropertyList.add(wsfp2);
                        continue;
                    }
                    wsfp = new FilterProperty("LicenseEnd", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Queue".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ChannelId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Package".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Provider".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ProviderId", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Start Date".equals(fp.getFilterby())) {
                    if (fp.getFilteroperator().equals("=")) {
                        formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        date = CommonUtils.dateVal(fp.getFilter());
                        c = Calendar.getInstance();
                        c.setTime(date);
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        wsfp1 = new FilterProperty("StartTime", ">=", formatter.format((Object)c.getTime()));
                        c.set(11, 23);
                        c.set(12, 59);
                        c.set(13, 59);
                        wsfp2 = new FilterProperty("StartTime", "<=", formatter.format((Object)c.getTime()));
                        wsFilterPropertyList.add(wsfp1);
                        wsFilterPropertyList.add(wsfp2);
                        continue;
                    }
                    wsfp = new FilterProperty("StartTime", fp.getFilteroperator(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Status".equals(fp.getFilterby())) {
                    String[] statusarray = fp.getFilter().split("\\|");
                    String wsfilter = "";
                    if (statusarray != null) {
                        for (int i = 0; i < statusarray.length; ++i) {
                            if (statusarray[i].equals("Failed")) {
                                if (i == 0) {
                                    wsfilter = "Failed";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Failed";
                                continue;
                            }
                            if (statusarray[i].equals("Repairing")) {
                                if (i == 0) {
                                    wsfilter = "Repairing";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Repairing";
                                continue;
                            }
                            if (statusarray[i].equals("Transmitting")) {
                                if (i == 0) {
                                    wsfilter = "Transmitting";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Transmitting";
                                continue;
                            }
                            if (statusarray[i].equals("Waiting")) {
                                if (i == 0) {
                                    wsfilter = "Waiting";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Waiting";
                                continue;
                            }
                            if (statusarray[i].equals("WaitingForAck")) {
                                if (i == 0) {
                                    wsfilter = "WaitingForAcknowledgement";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "WaitingForAcknowledgement";
                                continue;
                            }
                            if (statusarray[i].equals("Complete")) {
                                if (i == 0) {
                                    wsfilter = "Complete";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Complete";
                                continue;
                            }
                            if (statusarray[i].equals("Staged")) {
                                if (i == 0) {
                                    wsfilter = "Staged";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Staged";
                                continue;
                            }
                            if (statusarray[i].equals("Encrypting")) {
                                if (i == 0) {
                                    wsfilter = "Encrypting";
                                    continue;
                                }
                                wsfilter = wsfilter + "|" + "Encrypting";
                                continue;
                            }
                            throw new WSInvalidFilterValueException("Filter value '" + statusarray[i] + "' does not match known values");
                        }
                    }
                    FilterProperty wsfp3 = new FilterProperty("Status", fp.getFilteroperator(), wsfilter);
                    wsFilterPropertyList.add(wsfp3);
                    continue;
                }
                String fby = fp.getFilterby();
                throw new WSInvalidFilterException("FilterBy value '" + fby + "' does not match known values");
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToJobDetailsFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) throws WSInvalidFilterException {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                if (fp.getFilterby().equals(PitchDetailsFilterByEnum.PitchId.getValue())) {
                    wsfp = new FilterProperty(JobDetailFilterByEnum.JobId.getValue(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if (fp.getFilterby().equals(PitchDetailsFilterByEnum.CatcherId.getValue())) {
                    wsfp = new FilterProperty(JobDetailFilterByEnum.ClientId.getValue(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if (fp.getFilterby().equals(PitchDetailsFilterByEnum.Status.getValue())) {
                    wsfp = new FilterProperty(JobDetailFilterByEnum.Status.getValue(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if (fp.getFilterby().equals(PitchDetailsFilterByEnum.CatcherExists.getValue())) {
                    wsfp = new FilterProperty(JobDetailFilterByEnum.ClientExists.getValue(), fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                String fby = fp.getFilterby();
                throw new WSInvalidFilterException("FilterBy value '" + fby + "' does not match known values");
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized String serializeFilter(ArrayList<FilterProperty> filterPropertyList) {
        String result = "";
        if (filterPropertyList != null) {
            Iterator<FilterProperty> iter = filterPropertyList.iterator();
            while (iter.hasNext()) {
                FilterProperty filterProperty = iter.next();
                result = result + filterProperty.getFilterby();
                result = result + filterProperty.getFilteroperator();
                result = result + filterProperty.getFilter();
                if (!iter.hasNext()) continue;
                result = result + comma;
            }
        }
        log.debug((Object)("Filter criteria sent to ws[" + result + "]"));
        return result;
    }

    public static Date date(String date, String pattern) {
        Date result = null;
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (date != null && date.length() > 0) {
            if (pattern != null && pattern.length() > 0) {
                sdf.applyPattern(pattern);
                try {
                    result = sdf.parse(date.trim());
                }
                catch (ParseException e) {}
            } else {
                try {
                    result = sdf.parse(date.trim());
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static Date dateVal(String s) {
        Date result = null;
        if (s != null & s.length() > 0) {
            String p;
            String[] patterns;
            String[] arr$ = patterns = new String[]{"EEE MMM dd HH:mm:ss z yyyy", "yyyyMMdd HHmmssSSS", "yyMMdd HHmmssSSS", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss.SSS", "MM/dd/yyyy HH:mm:ss.SSS", "yyyy-MM-dd", "yyyy/MM/dd", "HH:mm:ss.SSS", "HH:mm:ss"};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = CommonUtils.date(s, p = arr$[i$])) == null; ++i$) {
            }
        }
        return result;
    }
}

