/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.tandbergtv.metadatamanager.MetadataManagerDAO;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.factoryImpl.IdentifierFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldBase;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.NextRevision;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.CriteriaBuilder;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.IRuleManager;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.spec.IValidator;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.metadatamanager.util.Binder;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import com.tandbergtv.metadatamanager.validation.Schema.SchemaValidator;
import com.tandbergtv.metadatamanager.validation.Schematron.CustomSchematronBuilder;
import com.tandbergtv.metadatamanager.validation.Schematron.SchematronValidator;
import com.tandbergtv.metadatamanager.validation.ValidationError;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class SpecHandlerBase
implements ISpecHandler {
    public static final String EMPTY_STRING_VALUE = "";
    private static String SCHEMA_VALIDATOR = "SchemaValidator";
    protected MetadataManagerDAO metadataManagerDAO;
    protected AssetSearchService searchService;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected ITranslator toTTV;
    protected ITranslator fromTTV;
    protected URL mappingResourceUrl;
    protected Map<String, IValidator> ruleValidators;
    protected String schemaResource;
    protected Spec spec;
    protected String rootElementName;
    protected IRuleManager ruleManager;
    protected Map<String, Set<String>> specSpecificTTVXpaths;
    protected InputStream specSpecificTTVXpathsStream;

    @Override
    public void setRuleManager(IRuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    @Override
    public IRuleManager getRuleManager() {
        return this.ruleManager;
    }

    public Spec getSpec() {
        return this.spec;
    }

    public void setSpec(Spec spec) {
        this.spec = spec;
    }

    public String getSchemaResource() {
        return this.schemaResource;
    }

    public void setSchemaResource(String schemaResource) {
        this.schemaResource = schemaResource;
    }

    @Override
    public Map<String, IValidator> getRuleValidators() {
        return this.ruleValidators;
    }

    @Override
    public void setRuleValidators(Map<String, IValidator> validators) {
        this.ruleValidators = validators;
    }

    public URL getMappingResourceUrl() {
        return this.mappingResourceUrl;
    }

    @Override
    public void setMappingResourceUrl(URL mappingResourceUrl) {
        this.mappingResourceUrl = mappingResourceUrl;
    }

    public ITranslator getToTTV() {
        return this.toTTV;
    }

    @Override
    public void setToTTV(ITranslator toTTV) {
        this.toTTV = toTTV;
    }

    public ITranslator getFromTTV() {
        return this.fromTTV;
    }

    @Override
    public void setFromTTV(ITranslator fromTTV) {
        this.fromTTV = fromTTV;
    }

    public MetadataManagerDAO getMetadataManagerDAO() {
        return this.metadataManagerDAO;
    }

    public void setMetadataManagerDAO(MetadataManagerDAO metadataManagerDAO) {
        this.metadataManagerDAO = metadataManagerDAO;
    }

    public AssetSearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(AssetSearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public void setSpecSpecificTTVXpathsStream(InputStream specSpecificTTVXpathsStream) {
        this.specSpecificTTVXpathsStream = specSpecificTTVXpathsStream;
        BufferedReader br = new BufferedReader(new InputStreamReader(specSpecificTTVXpathsStream));
        this.specSpecificTTVXpaths = new HashMap<String, Set<String>>();
        try {
            String line;
            String type = EMPTY_STRING_VALUE;
            HashSet set = null;
            while ((line = br.readLine()) != null) {
                if (line.equals(EMPTY_STRING_VALUE)) continue;
                if (line.startsWith("[")) {
                    type = line.replaceAll("\\[", EMPTY_STRING_VALUE);
                    type = type.replaceAll("\\]", EMPTY_STRING_VALUE);
                    if (this.specSpecificTTVXpaths.containsKey(type = type.trim().toLowerCase())) continue;
                    set = new HashSet();
                    this.specSpecificTTVXpaths.put(type, set);
                    continue;
                }
                this.specSpecificTTVXpaths.get(type).add(line.trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Set<String>> getSpecSpecificTTVXpaths() {
        return this.specSpecificTTVXpaths;
    }

    @Override
    @Transactional
    public List<IIdentifier> deleteAll(List<IIdentifier> ids) {
        ArrayList<IIdentifier> deletedAssetIds = new ArrayList<IIdentifier>();
        for (IIdentifier id : ids) {
            try {
                this.deleteUnique(id);
                deletedAssetIds.add(id);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error deleting asset with id: " + id.toString()), (Throwable)e);
            }
        }
        return deletedAssetIds;
    }

    @Override
    @Transactional
    public void deleteUnique(IIdentifier id) throws SearchException {
        Asset asset = id.getAsset();
        this.logger.debug((Object)("Deleting asset - TTV Id for: " + id.toString() + " is = " + asset.getId()));
        this.metadataManagerDAO.delete(asset);
    }

    private static Document kludge(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLSerializer serializer = new XMLSerializer(baos, format);
            serializer.serialize(doc);
            byte[] docBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(docBytes);
            Document input = null;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            input = builder.parse(bais);
            return input;
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Document get(IIdentifier id) throws MetadataException, SearchException, TranslationException {
        return this.get(id, null);
    }

    @Override
    @Transactional
    public List<IIdentifier> getIdentifiers(Document doc) throws MetadataException {
        this.logger.debug((Object)"Trying to extract identifiers from the given document");
        List<Asset> assets = this.convertDocumentToAssets(doc);
        ArrayList<IIdentifier> returnIdentifierList = new ArrayList<IIdentifier>();
        if (assets != null) {
            for (Asset a : assets) {
                IIdentifier identifier = this.extractId(a);
                returnIdentifierList.add(identifier);
            }
        }
        return returnIdentifierList;
    }

    @Override
    @Transactional
    public List<IIdentifier> put(Document doc) throws MetadataException {
        return this.put(doc, null, null, null);
    }

    @Override
    @Transactional
    public List<IIdentifier> put(Document doc, String revisionSource, String revisionComment, String externalRevision) throws MetadataException {
        this.logger.debug((Object)"In put()");
        RootAssetRevision rootAssetRevision = new RootAssetRevision(revisionSource, revisionComment, externalRevision);
        boolean prune = true;
        List<Asset> assetList = this.save(doc, prune, rootAssetRevision);
        ArrayList<IIdentifier> savedIdList = new ArrayList<IIdentifier>();
        for (Asset ma : assetList) {
            savedIdList.add(this.extractId(ma));
        }
        return savedIdList;
    }

    @Override
    @Transactional
    public List<Asset> save(Document doc) throws MetadataException {
        boolean prune = true;
        return this.save(doc, prune, new RootAssetRevision());
    }

    private List<Asset> save(Document doc, boolean prune, RootAssetRevision rootAssetRevision) throws MetadataException {
        List<Asset> assets = this.convertDocumentToAssets(doc);
        return this.mergeSaveAssets(assets, prune, rootAssetRevision, false, false);
    }

    private List<Asset> convertDocumentToAssets(Document doc) throws MetadataException {
        Document convertedDoc = null;
        try {
            convertedDoc = this.getToTTV().translate(doc);
        }
        catch (TranslationException e) {
            this.logger.error((Object)e);
            throw new MetadataException(e.getMessage(), e);
        }
        List<Asset> assets = new Binder().bind(convertedDoc);
        return assets;
    }

    protected List<Asset> mergeSaveAssets(List<Asset> toBeMergedAssets, boolean prune, RootAssetRevision rootAssetRevision, boolean isRollback, boolean saveAsDraft) throws MetadataException {
        List<Asset> mergedAssets;
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        boolean createRevision = true;
        for (Asset asset : toBeMergedAssets) {
            HashSet<String> criteriaValueSet = new HashSet<String>();
            this.checkDuplicateChildItems(asset, criteriaValueSet);
        }
        if (saveAsDraft) {
            for (Asset asset : toBeMergedAssets) {
                try {
                    Asset existingAsset = this.getMetadataManagerDAO().getAsset(asset.getTTVId(), true);
                    if (!(existingAsset instanceof Group)) continue;
                    int revNumber = ((Group)existingAsset).getLatestRevisionNumber();
                    RootAssetRevision revision = ((Group)existingAsset).getRevision(revNumber);
                    if (revision.isDraft()) {
                        createRevision = false;
                        continue;
                    }
                    rootAssetRevision.setDraft(true);
                    createRevision = true;
                }
                catch (SearchException e) {
                    rootAssetRevision.setDraft(true);
                    createRevision = true;
                }
            }
        } else {
            createRevision = true;
        }
        try {
            mergedAssets = this.mergeAssets(toBeMergedAssets, prune, createRevision);
        }
        catch (SearchException e) {
            this.logger.error((Object)e);
            throw new MetadataException(e.getMessage(), e);
        }
        for (Asset ma : mergedAssets) {
            assetList.add(ma);
            if (!(ma instanceof Group)) continue;
            Group group = (Group)ma;
            if (createRevision) {
                if (!isRollback && !group.isRevisionNumberUpdated()) {
                    this.logger.info((Object)("No new changes made to Asset:" + group + ", abort saving a new revision!"));
                    continue;
                }
                if (isRollback && !group.isRevisionNumberUpdated()) {
                    group.setLatestRevisionNumber(group.getLatestRevisionNumber() + 1);
                }
                group.addRootAssetRevision(rootAssetRevision);
            }
            this.getMetadataManagerDAO().saveAsset(group);
        }
        return assetList;
    }

    @Override
    @Transactional
    public List<Asset> incrementalSave(Document doc) throws MetadataException {
        boolean prune = false;
        return this.save(doc, prune, new RootAssetRevision());
    }

    @Override
    public List<ValidationError> validateSchema(Document doc) {
        SchemaValidator validator = new SchemaValidator(this.getSchemaValidatorName(), this.schemaResource);
        return validator.validate(doc);
    }

    @Override
    public List<ValidationError> customValidate(Document doc, IValidator baseRules, String ruleSet) {
        List<ValidationError> errors = baseRules.validate(doc);
        Map<String, Boolean> ruleMap = this.ruleManager.getRuleSet(ruleSet);
        errors = this.removeOverridenErrors(errors, ruleMap);
        errors.addAll(this.addRequiredErrors(doc, ruleMap));
        return errors;
    }

    private List<ValidationError> addRequiredErrors(Document doc, Map<String, Boolean> ruleMap) {
        InputStream is = CustomSchematronBuilder.buildSchematron(ruleMap);
        SchematronValidator customValidator = new SchematronValidator("custom", is);
        return customValidator.validate(doc);
    }

    private List<ValidationError> removeOverridenErrors(List<ValidationError> errors, Map<String, Boolean> ruleMap) {
        ArrayList<ValidationError> toDelete = new ArrayList<ValidationError>();
        for (ValidationError ve : errors) {
            if (!ve.getErrorCode().equals("ERR-02") || !this.errorFoundInMap(ve, ruleMap)) continue;
            toDelete.add(ve);
        }
        for (ValidationError ve : toDelete) {
            errors.remove(ve);
        }
        return errors;
    }

    private boolean errorFoundInMap(ValidationError ve, Map<String, Boolean> ruleMap) {
        for (Map.Entry<String, Boolean> entry : ruleMap.entrySet()) {
            try {
                if (!this.compareXPaths(entry.getKey(), ve.getErrorLocation() + "/" + ve.getErrorFields().get(0))) continue;
                return true;
            }
            catch (IndexOutOfBoundsException e) {
            }
        }
        return false;
    }

    private boolean compareXPaths(String string1, String string2) {
        String str1 = string1.replaceAll("\\[[0-9]*\\]|@", EMPTY_STRING_VALUE);
        String str2 = string2.replaceAll("\\[[0-9]*\\]|@", EMPTY_STRING_VALUE);
        return str1.equals(str2);
    }

    @Override
    public List<ValidationError> validateField(Document doc, IValidator baseRules, String xpath) {
        List<ValidationError> errors = baseRules.validate(doc);
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (ValidationError ve : errors) {
            try {
                if (!this.compareXPaths(xpath, ve.getErrorLocation() + "/" + ve.getErrorFields().get(0))) continue;
                results.add(ve);
            }
            catch (IndexOutOfBoundsException e) {}
        }
        return results;
    }

    private String getSchemaValidatorName() {
        return this.getSpec().toString() + SCHEMA_VALIDATOR;
    }

    private List<Asset> mergeAssets(List<Asset> assets, boolean prune, boolean createRevision) throws SearchException, MetadataException {
        Iterator<Asset> assetIter = assets.iterator();
        ArrayList<Asset> mergedAssets = new ArrayList<Asset>();
        while (assetIter.hasNext()) {
            Asset currAsset = assetIter.next();
            if ((currAsset = AssetUtil.deleteEmptyFields(currAsset)) instanceof Group) {
                NextRevision nextRevision = new NextRevision();
                TTVId existingTTVId = this.getTTVId(currAsset, null);
                Asset mergedAsset = currAsset;
                if (existingTTVId != null) {
                    Asset existingAsset = this.getMetadataManagerDAO().getAsset(existingTTVId, false);
                    if (createRevision) {
                        nextRevision.setRevisionNumber(existingAsset.getLatestRevisionNumber() + 1);
                    } else {
                        nextRevision = null;
                    }
                    mergedAsset = this.mergeAsset(currAsset, existingAsset, prune, nextRevision);
                } else {
                    AssetUtil.copyFieldsToFieldRevisions(mergedAsset, nextRevision);
                }
                mergedAssets.add(mergedAsset);
                continue;
            }
            throw new MetadataException("Adding an ITEM is not supported yet! Add a Group");
        }
        return mergedAssets;
    }

    protected Asset mergeAsset(Asset newAsset, Asset oldAsset, boolean prune, NextRevision nextRevision) throws SearchException {
        Asset rootAsset = oldAsset;
        oldAsset = this.mergeAndAddIncomingIntoExistingAsset(newAsset, oldAsset, rootAsset, nextRevision);
        if (prune) {
            oldAsset = this.pruneExistingAssetTree(newAsset, oldAsset, nextRevision);
        }
        return oldAsset;
    }

    protected Asset mergeAndAddIncomingIntoExistingAsset(Asset newAsset, Asset oldAsset, Asset rootAsset, NextRevision nextRevision) throws SearchException {
        String assetType = this.getAssetType(newAsset);
        this.mergeFields(newAsset, oldAsset, assetType, nextRevision);
        for (Relation newRelation : newAsset.getRelations()) {
            Asset newTargetAsset = newRelation.getTargetAsset();
            if (this.requireSpecSpecificMerging(this.getAssetType(newTargetAsset))) {
                this.specSpecificMerging(oldAsset, nextRevision, newRelation, newTargetAsset);
                continue;
            }
            this.mergeExistingTargetAsset(newTargetAsset, rootAsset, oldAsset, nextRevision);
        }
        return oldAsset;
    }

    protected void mergeExistingTargetAsset(Asset newTargetAsset, Asset rootAsset, Asset oldAsset, NextRevision nextRevision) throws SearchException {
        NextRevision currentAssetRevision = null;
        if (nextRevision == null) {
            currentAssetRevision = new NextRevision();
            currentAssetRevision.setRevisionNumber(oldAsset.getLatestRevisionNumber());
        }
        boolean ifExistingTargetAsset = true;
        Asset existingTargetAsset = this.searchTargetAssetInMemory(newTargetAsset, rootAsset, oldAsset);
        if (existingTargetAsset == null) {
            TTVId existingTtvId = this.getTTVId(newTargetAsset, rootAsset);
            if (existingTtvId != null) {
                existingTargetAsset = this.getMetadataManagerDAO().getAsset(existingTtvId, false);
                if (nextRevision == null) {
                    oldAsset.addChild(existingTargetAsset, currentAssetRevision, false);
                } else {
                    oldAsset.addChild(existingTargetAsset, nextRevision, false);
                }
            } else {
                ifExistingTargetAsset = false;
                if (nextRevision == null) {
                    oldAsset.addChild(newTargetAsset, currentAssetRevision, true);
                } else {
                    oldAsset.addChild(newTargetAsset, nextRevision, true);
                }
            }
        }
        if (ifExistingTargetAsset) {
            this.mergeAndAddIncomingIntoExistingAsset(newTargetAsset, existingTargetAsset, rootAsset, nextRevision);
            if (nextRevision != null && existingTargetAsset.isRevisionNumberUpdated()) {
                oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
            }
        }
    }

    protected Asset searchTargetAssetInMemory(Asset newTargetAsset, Asset rootAsset, Asset oldAsset) {
        SearchCriteria criteria = this.prepareSearchPathById(newTargetAsset.getFields());
        return oldAsset.getAsset(criteria);
    }

    protected void specSpecificMerging(Asset oldAsset, NextRevision nextRevision, Relation newRelation, Asset targetAsset) {
    }

    protected void specSpecificMergingNoSave(Asset oldAsset, Relation newRelation, Asset targetAsset) {
    }

    protected Asset pruneExistingAssetTree(Asset newAsset, Asset oldAsset, NextRevision nextRevision) throws SearchException {
        ArrayList<Relation> oldRelationsToBeDeleted = new ArrayList<Relation>();
        for (Relation oldRelation : oldAsset.getRelations()) {
            String oldTargetAssetType;
            Asset oldTargetAsset = oldRelation.getTargetAsset();
            if (oldTargetAsset.getTTVId().getId() <= 0L || oldTargetAsset instanceof File || !this.isAssetTypePartOfSpec(oldTargetAssetType = this.getAssetType(oldTargetAsset))) continue;
            Asset newTargetAsset = this.searchNewTargetAsset(oldTargetAssetType, newAsset, oldTargetAsset);
            if (newTargetAsset == null) {
                oldRelationsToBeDeleted.add(oldRelation);
                continue;
            }
            this.pruneExistingAssetTree(newTargetAsset, oldTargetAsset, nextRevision);
        }
        this.removeOldRelations(oldAsset, nextRevision, oldRelationsToBeDeleted);
        return oldAsset;
    }

    protected Asset searchNewTargetAsset(String oldTargetAssetType, Asset newAsset, Asset oldTargetAsset) {
        Asset newTargetAsset = null;
        if (this.requireSpecSpecificSearchForPruning(oldTargetAssetType)) {
            newTargetAsset = this.specSpecificSearchForPruning(oldTargetAssetType, newAsset, oldTargetAsset);
        } else {
            SearchCriteria crit = this.prepareSearchPathById(oldTargetAsset.getFields());
            for (Relation rel : newAsset.getRelations()) {
                Asset currentTargetAsset = rel.getTargetAsset();
                List<Field> fields = currentTargetAsset.getFields();
                if (!this.isSearchCriteriaPresent(crit, fields)) continue;
                newTargetAsset = currentTargetAsset;
                break;
            }
        }
        return newTargetAsset;
    }

    protected boolean isAssetTypePartOfSpec(String assetType) {
        return this.specSpecificTTVXpaths.containsKey(assetType.toLowerCase());
    }

    protected void removeOldRelations(Asset oldAsset, NextRevision nextRevision, ArrayList<Relation> oldRelationsToBeDeleted) throws SearchException {
        if (nextRevision != null) {
            for (Relation oldRelationToBeDeleted : oldRelationsToBeDeleted) {
                oldRelationToBeDeleted.setDeleteRevision(nextRevision.getRevisionNumber());
                List<Field> oldTargetAssetFields = oldRelationToBeDeleted.getTargetAsset().getFields();
                oldTargetAssetFields.removeAll(oldTargetAssetFields);
            }
            if (oldRelationsToBeDeleted.size() > 0) {
                oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
            }
        }
    }

    protected Asset specSpecificSearchForPruning(String assetType, Asset newAsset, Asset oldTargetAsset) {
        return null;
    }

    protected boolean requireSpecSpecificSearchForPruning(String assetType) {
        return false;
    }

    protected boolean requireSpecSpecificMerging(String assetType) {
        return false;
    }

    protected String getAssetType(Asset targetAsset) {
        String assetType = EMPTY_STRING_VALUE;
        if ((targetAsset = new AssetUtil().unWrap(targetAsset)) instanceof Group) {
            Group g = (Group)targetAsset;
            assetType = g.getType();
        } else {
            Item i = (Item)targetAsset;
            assetType = i.getType();
        }
        return assetType;
    }

    protected boolean isSearchCriteriaPresent(SearchCriteria criteria, List<Field> fields) {
        Iterator entryIterator = criteria.entrySet().iterator();
        boolean fieldsFound = true;
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            String xpath = (String)entry.getKey();
            String value = (String)entry.getValue();
            fieldsFound = false;
            for (Field f : fields) {
                if (!f.getTtvXPath().equals(xpath) || !f.getValue().equals(value)) continue;
                fieldsFound = true;
                break;
            }
            if (fieldsFound) continue;
            return false;
        }
        return true;
    }

    protected TTVId getTTVId(Asset asset, Asset rootAsset) throws SearchException {
        com.tandbergtv.workflow.util.SearchCriteria crit;
        SearchCriteria criteria = this.prepareSearchPathById(asset.getFields());
        if (rootAsset == null) {
            criteria.put("rootlevel", "true");
        }
        if ((crit = CriteriaBuilder.buildFieldRevisionSearchCriteria(criteria, false)).getSearchList().size() == 0) {
            return null;
        }
        ArrayList<TTVId> ids = new ArrayList<TTVId>();
        Collection<Asset> assets = this.searchService.search(crit);
        if (rootAsset == null) {
            for (Asset a : assets) {
                ids.add(a.getTTVId());
            }
        } else if (assets != null && assets.size() != 0) {
            long rootId = rootAsset.getId();
            for (Asset a : assets) {
                if (a.getRoot() == null || a.getRoot().getId() != rootId) continue;
                ids.add(a.getTTVId());
            }
        }
        if (ids.size() > 1) {
            throw new SearchException("Multiple assets with spec Id: " + criteria.toString() + " were found.");
        }
        return ids.size() == 1 ? (TTVId)ids.get(0) : null;
    }

    protected void checkDuplicateChildItems(Asset asset, Set<String> criteriaValueSet) throws MetadataException {
        SearchCriteria criteria = this.prepareSearchPathById(asset.getFields());
        StringBuffer criteriaValues = new StringBuffer();
        for (String value : criteria.values()) {
            criteriaValues.append(value);
        }
        if (criteriaValueSet.contains(criteriaValues.toString())) {
            throw new MetadataException("Multiple assets with spec Id: " + criteria.toString() + " were found.");
        }
        criteriaValueSet.add(criteriaValues.toString());
        for (Relation relation : asset.getRelations()) {
            this.checkDuplicateChildItems(relation.getTargetAsset(), criteriaValueSet);
        }
    }

    protected Map<String, String> translate(List<String> fields) {
        HashMap<String, String> fieldXpaths = new HashMap<String, String>();
        Map<String, String> fieldMappings = MappingFileParser.readFieldMapping(this.getMappingResourceUrl());
        for (String field : fields) {
            if (fieldMappings.containsKey(field)) {
                fieldXpaths.put(field, fieldMappings.get(field));
                continue;
            }
            throw new RuntimeException("Cannot map field: " + field + " to TTV equivalent.");
        }
        return fieldXpaths;
    }

    protected SearchCriteria prepareSearchPathById(List<Field> fields) {
        SearchCriteria criteria = new SearchCriteria();
        IdentifierBase identifer = this.getIdentifier();
        identifer.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idPaths = identifer.getTTVPaths();
        Iterator<Map.Entry<String, String>> pathIter = idPaths.entrySet().iterator();
        while (pathIter.hasNext()) {
            boolean isEntryFound = false;
            Map.Entry<String, String> entry = pathIter.next();
            for (Field f : fields) {
                if (!f.getTtvXPath().equals(entry.getValue())) continue;
                isEntryFound = true;
                criteria.put(entry.getValue(), f.getValue());
                break;
            }
            if (isEntryFound) continue;
            criteria.put(entry.getValue(), EMPTY_STRING_VALUE);
        }
        return criteria;
    }

    public void mergeFields(Asset newAsset, Asset oldAsset, String assetType, NextRevision nextRevision) {
        List<Field> oldFields = oldAsset.getFields();
        List<FieldRevision> oldFieldRevisions = oldAsset.getFieldRevisions();
        List<Object> toBeDeletedFieldRevisions = new ArrayList();
        List<Object> toBeDeletedFields = new ArrayList();
        toBeDeletedFieldRevisions = this.getToBeDeleted(newAsset.getFieldsMap(), oldAsset.getFieldRevisions(), assetType);
        if (nextRevision == null) {
            oldFieldRevisions.removeAll(toBeDeletedFieldRevisions);
        } else if (toBeDeletedFieldRevisions != null && toBeDeletedFieldRevisions.size() > 0) {
            this.removeFieldRevisions(oldAsset, toBeDeletedFieldRevisions, nextRevision);
        }
        toBeDeletedFields = this.getToBeDeleted(newAsset.getFieldsMap(), oldFields, assetType);
        oldFields.removeAll(toBeDeletedFields);
        this.updateExistingFields(newAsset, oldAsset, nextRevision);
    }

    protected void updateExistingFields(Asset newAsset, Asset oldAsset, NextRevision nextRevision) {
        List<Field> newFields = newAsset.getFields();
        if (newFields != null) {
            for (Field newField : newFields) {
                Field oldField;
                FieldBase newf;
                FieldRevision oldFieldRevision = this.getFieldForXpathAndIndex(oldAsset.getFieldRevisionsMap(), newField.getTtvXPath(), newField.getIndices());
                if (oldFieldRevision != null) {
                    if (!newField.getValue().equalsIgnoreCase(oldFieldRevision.getValue())) {
                        if (nextRevision != null) {
                            FieldRevision newFieldRevision = new FieldRevision(oldFieldRevision, nextRevision);
                            newFieldRevision.setValue(newField.getValue());
                            oldAsset.addFieldRevision(newFieldRevision, nextRevision);
                        } else {
                            oldFieldRevision.setValue(newField.getValue());
                        }
                    }
                } else if (nextRevision == null) {
                    NextRevision tempNextRevision = new NextRevision();
                    tempNextRevision.setRevisionNumber(oldAsset.getLatestRevisionNumber());
                    newf = new FieldRevision(newField, tempNextRevision);
                    ((FieldRevision)newf).setDeleteRevision(0);
                    ((FieldRevision)newf).setAddRevision(tempNextRevision.getRevisionNumber());
                    ((FieldRevision)newf).setRevisionNumber(tempNextRevision.getRevisionNumber());
                    oldAsset.addFieldRevision((FieldRevision)newf, tempNextRevision);
                } else {
                    FieldRevision newf2 = new FieldRevision(newField, nextRevision);
                    newf2.setDeleteRevision(0);
                    newf2.setAddRevision(nextRevision.getRevisionNumber());
                    newf2.setRevisionNumber(nextRevision.getRevisionNumber());
                    oldAsset.addFieldRevision(newf2, nextRevision);
                }
                if ((oldField = this.getFieldForXpathAndIndex(oldAsset.getFieldsMap(), newField.getTtvXPath(), newField.getIndices())) != null) {
                    oldField.setValue(newField.getValue());
                    continue;
                }
                newf = new Field(newField);
                oldAsset.addField((Field)newf);
            }
        }
    }

    protected <T extends IField> T getFieldForXpathAndIndex(Map<String, T> iFieldsMap, String xpath, List<Integer> indices) {
        return (T)((IField)iFieldsMap.get(xpath + indices));
    }

    @Override
    public Document get(IIdentifier id, String revision) throws MetadataException, SearchException, TranslationException {
        this.logger.debug((Object)"In get(id, revision)");
        TTVId assetId = id.getAssetTTVId();
        Document assetDoc = this.getRevision(assetId, revision, true);
        return assetDoc;
    }

    protected Document getRevision(TTVId ttvId, String revision, boolean isForReadOnly) throws SearchException, TranslationException {
        Asset asset = this.getAssetTree(ttvId, revision, isForReadOnly);
        Document tree = new Binder().bind(asset);
        Document assetDoc = this.getFromTTV().translate(SpecHandlerBase.kludge(tree));
        return assetDoc;
    }

    protected int parseThenGetInternalRevisionNumber(String revision) throws SearchException {
        int delimiterIndex = revision.lastIndexOf(Asset.EXTERNAL_INTERNAL_REVISION_DELIMITER);
        if (delimiterIndex < 0 || delimiterIndex == revision.length() - 1) {
            throw new SearchException("Revision: " + revision + " is not in the format of " + RootAssetRevision.REVISION_FORMAT);
        }
        return Integer.parseInt(revision.substring(delimiterIndex + 1));
    }

    protected String parseThenGetExternalRevisionNumber(String revision) throws SearchException {
        int delimiterIndex = revision.lastIndexOf(Asset.EXTERNAL_INTERNAL_REVISION_DELIMITER);
        if (delimiterIndex < 0) {
            throw new SearchException("Revision: " + revision + " is not in the format of " + RootAssetRevision.REVISION_FORMAT);
        }
        String externalRevision = revision.substring(0, delimiterIndex);
        if (externalRevision == null) {
            externalRevision = EMPTY_STRING_VALUE;
        }
        return externalRevision;
    }

    @Override
    public List<RootAssetRevision> getRevisions(IIdentifier id) throws MetadataException, SearchException, TranslationException {
        Asset asset = id.getAsset();
        if (!(asset instanceof Group)) {
            throw new MetadataException("Asset identified by input id: " + id + " is not a top-level asset!");
        }
        asset = this.metadataManagerDAO.getAsset(asset.getTTVId(), true);
        return ((Group)asset).getRevisions();
    }

    protected Asset findAsset(Asset searchCandidate, List<Asset> searchTargets) {
        SearchCriteria crit = this.prepareSearchPathById(searchCandidate.getFields());
        boolean assetFound = false;
        for (Asset searchTarget : searchTargets) {
            List<Field> fields = searchTarget.getFields();
            assetFound = this.isSearchCriteriaPresent(crit, fields);
            if (!assetFound) continue;
            return searchTarget;
        }
        return null;
    }

    protected Asset getAssetTree(TTVId ttvId, String revision, boolean isForReadOnly) throws SearchException {
        Asset asset;
        int internalRevisionNumber = 0;
        if (revision != null && (internalRevisionNumber = this.parseThenGetInternalRevisionNumber(revision)) <= 0) {
            throw new SearchException("Version: " + revision + " is invalid, please provide a valid version.");
        }
        try {
            asset = this.metadataManagerDAO.getAsset(ttvId, internalRevisionNumber, isForReadOnly);
        }
        catch (InvalidRevisionException e) {
            throw new SearchException("Version: " + revision + " is invalid, please provide a valid version.");
        }
        return asset;
    }

    @Override
    public Document rollBackToRevision(TTVId ttvId, String revision) throws MetadataException, SearchException, TranslationException, InvalidRevisionException {
        this.verifyVersionNumber(ttvId, revision);
        Asset oldAsset = this.getAssetTree(ttvId, revision, true);
        ArrayList<Asset> toBeMergedAssets = new ArrayList<Asset>();
        toBeMergedAssets.add(oldAsset);
        RootAssetRevision rootAssetRevision = new RootAssetRevision("test", "Rollback to revision " + revision, this.parseThenGetExternalRevisionNumber(revision));
        this.mergeSaveAssets(toBeMergedAssets, true, rootAssetRevision, true, false);
        return this.getRevision(ttvId, null, true);
    }

    private void verifyVersionNumber(TTVId ttvId, String revision) throws SearchException, InvalidRevisionException {
        Asset oldAsset = this.getAssetTree(ttvId, null, true);
        if (revision.equalsIgnoreCase(oldAsset.getVersion())) {
            throw new InvalidRevisionException("Can't rollback to latest version: " + revision + ", please try a different version.");
        }
    }

    @Override
    public List<Asset> save(Document doc, String revisionSource, String revisionComment, String externalRevision) throws MetadataException {
        return null;
    }

    @Override
    public Spec getSpecName(Document doc) {
        String name = doc.getDocumentElement().getNodeName();
        if (name.equals(this.rootElementName)) {
            return this.spec;
        }
        return null;
    }

    protected <N extends IField, O extends IField> List<O> getToBeDeleted(Map<String, N> newFieldsMap, List<O> oldFields, String assetType) {
        ArrayList<IField> toBeDeletedFields = new ArrayList<IField>();
        if (oldFields != null) {
            for (IField oldField : oldFields) {
                N newField;
                if (!this.isXPathPartOfSpec(assetType, oldField.getTtvXPath()) || (newField = this.getFieldForXpathAndIndex(newFieldsMap, oldField.getTtvXPath(), oldField.getIndices())) != null) continue;
                toBeDeletedFields.add(oldField);
            }
        }
        return toBeDeletedFields;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        assetType = assetType.toLowerCase();
        Set<String> xpathSet = null;
        if (this.specSpecificTTVXpaths.containsKey(assetType)) {
            xpathSet = this.specSpecificTTVXpaths.get(assetType);
        }
        return xpathSet != null && xpathSet.contains(ttvXPath);
    }

    protected void removeFieldRevisions(Asset oldAsset, List<FieldRevision> toBeDeleted, NextRevision nextRevision) {
        if (toBeDeleted != null && toBeDeleted.size() > 0) {
            oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
            for (FieldRevision field : toBeDeleted) {
                field.setDeleteRevision(nextRevision.getRevisionNumber());
                List<FieldRevision> previousUnDeletedFields = this.metadataManagerDAO.getUnDeletedFieldRevsions(field);
                for (FieldRevision previousUnDeletedField : previousUnDeletedFields) {
                    previousUnDeletedField.setDeleteRevision(nextRevision.getRevisionNumber());
                    oldAsset.addFieldRevision(previousUnDeletedField, nextRevision);
                }
            }
        }
    }

    @Override
    @Transactional
    public List<Asset> mergeWithoutSave(Document doc) throws MetadataException {
        List<Asset> assets = this.convertDocumentToAssets(doc);
        ArrayList<Asset> returnAssets = new ArrayList<Asset>();
        for (Asset newAsset : assets) {
            newAsset = AssetUtil.deleteEmptyFields(newAsset);
            Asset existingAsset = null;
            try {
                existingAsset = this.extractId(newAsset).getAsset();
            }
            catch (SearchException e) {
                // empty catch block
            }
            if (existingAsset == null || existingAsset.getState() == AssetState.INACTIVE) {
                NextRevision nextRevision = new NextRevision();
                AssetUtil.copyFieldsToFieldRevisions(newAsset, nextRevision);
                returnAssets.add(newAsset);
                continue;
            }
            if (existingAsset instanceof Group) {
                this.mergeRecursively(newAsset, existingAsset);
                returnAssets.add(newAsset);
                continue;
            }
            String assetType = this.getAssetType(newAsset);
            this.mergeFields(newAsset, existingAsset, assetType);
            newAsset.setTTVId(existingAsset.getTTVId());
            returnAssets.add(existingAsset);
        }
        return returnAssets;
    }

    @Override
    @Transactional
    public List<Asset> mergeWithoutSave(Long assetId, Document doc) throws MetadataException {
        ArrayList<Asset> returnAssets = new ArrayList<Asset>();
        Asset existingAsset = null;
        TTVId ttvId = (TTVId)IdentifierFactory.getTTVIdentifier();
        ttvId.setId(assetId);
        try {
            existingAsset = this.getMetadataManagerDAO().getAsset(ttvId, false);
        }
        catch (SearchException e) {
            throw new MetadataException("Unable to find asset with id=" + ttvId.getId());
        }
        List<Asset> assets = this.convertDocumentToAssets(doc);
        for (Asset newAsset : assets) {
            newAsset = AssetUtil.deleteEmptyFields(newAsset);
            if (existingAsset == null || existingAsset.getState() == AssetState.INACTIVE) {
                NextRevision nextRevision = new NextRevision();
                AssetUtil.copyFieldsToFieldRevisions(newAsset, nextRevision);
                returnAssets.add(newAsset);
                continue;
            }
            if (existingAsset instanceof Group) {
                this.mergeRecursively(newAsset, existingAsset);
                returnAssets.add(newAsset);
                continue;
            }
            String assetType = this.getAssetType(newAsset);
            this.mergeFields(newAsset, existingAsset, assetType);
            newAsset.setTTVId(existingAsset.getTTVId());
            returnAssets.add(existingAsset);
        }
        return returnAssets;
    }

    private void mergeRecursively(Asset newAsset, Asset existingAsset) {
        String assetType = this.getAssetType(newAsset);
        newAsset.setTTVId(existingAsset.getTTVId());
        this.mergeFields(newAsset, existingAsset, assetType);
        for (Relation r : existingAsset.getRelations()) {
            Asset existingTargetAsset = r.getTargetAsset();
            String existingAssetType = this.getAssetType(existingTargetAsset);
            if (this.requireSpecSpecificMerging(existingAssetType)) {
                this.specSpecificMergingNoSave(newAsset, r, existingTargetAsset);
                continue;
            }
            if (existingTargetAsset instanceof File) continue;
            Asset newTargetAsset = this.findAsset(existingTargetAsset, newAsset.getImmediateChildren());
            if (newTargetAsset == null) {
                if (this.isAssetTypePartOfSpec(existingAssetType)) continue;
                Item i = new Item();
                i.setType(existingAssetType);
                i.setFields(existingTargetAsset.getFields());
                i.setTTVId(existingTargetAsset.getTTVId());
                newAsset.addChild(i);
                continue;
            }
            this.mergeRecursively(newTargetAsset, existingTargetAsset);
        }
    }

    protected void mergeFields(Asset newAsset, Asset existingAsset, String assetType) {
        List<Field> newFields = newAsset.getFields();
        List<Field> oldFields = existingAsset.getFields();
        for (Field f : oldFields) {
            Field newField = this.getFieldForXpathAndIndex(newAsset.getFieldsMap(), f.getTtvXPath(), f.getIndices());
            if (newField != null || this.isXPathPartOfSpec(assetType, f.getTtvXPath())) continue;
            Field newf = new Field();
            newf.setTtvXPath(f.getTtvXPath());
            newf.setValue(f.getValue());
            newf.setIndices(f.getIndices());
            newFields.add(newf);
        }
    }

    @Override
    public Document convertAssetToXMLDocument(Asset asset) throws TranslationException {
        Document tree = new Binder().bind(asset);
        Document assetDoc = this.getFromTTV().translate(SpecHandlerBase.kludge(tree));
        return assetDoc;
    }
}

