/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.model.Field;
import java.util.ArrayList;
import java.util.List;

public class FieldTreeNode {
    private String name;
    private Integer currentIndex = 0;
    private Field field = null;
    private List<FieldTreeNode> children = new ArrayList<FieldTreeNode>();
    private boolean isAttribute = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public List<FieldTreeNode> getChildren() {
        if (this.children == null) {
            return new ArrayList<FieldTreeNode>();
        }
        return this.children;
    }

    public void setChildren(List<FieldTreeNode> children) {
        this.children = children;
    }

    public Integer getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(Integer currentIndex) {
        this.currentIndex = currentIndex;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    public void addChild(FieldTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList<FieldTreeNode>();
        }
        this.children.add(child);
    }

    public boolean isLeafNode() {
        return this.field != null;
    }

    public FieldTreeNode getNode(String name, Integer index) {
        for (FieldTreeNode node : this.children) {
            if (!node.getName().equals(name) || !node.getCurrentIndex().equals(index)) continue;
            return node;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("{").append(this.getName().toString()).append("(").append(this.getCurrentIndex().toString()).append(")").append(",[");
        int i = 0;
        for (FieldTreeNode e : this.getChildren()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(e.getName().toString());
            ++i;
        }
        sb.append("]").append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof FieldTreeNode) {
            FieldTreeNode f = (FieldTreeNode)o;
            if (!(this.field == null && f.field == null || this.field.equals(f.field))) {
                return false;
            }
            if (this.children.size() != f.children.size()) {
                return false;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i).equals(f.children.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

