/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import java.util.List;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;

public class ListFieldInfo
extends FieldInfo {
    SearchOperator operator;
    List<String> values;

    public ListFieldInfo() {
        this.operator = SearchOperator.IN;
        this.isConjunction = true;
    }

    public ListFieldInfo(String ttvxpath, List<String> values) {
        this.ttvxpath = ttvxpath;
        this.operator = SearchOperator.IN;
        this.values = values;
        this.isConjunction = true;
    }

    public ListFieldInfo(String ttvxpath, List<String> values, SearchOperator operator) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.values = values;
        this.isConjunction = true;
    }

    public ListFieldInfo(String ttvxpath, List<String> values, SearchOperator operator, boolean isConjunction) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.values = values;
        this.isConjunction = isConjunction;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    @Override
    public void createEntity(String property, Entity assetEntity) {
        String valueColumnName = "";
        SearchType searchType = SearchType.STRING;
        Entity field = new Entity("field", property, "f");
        if (this.ttvxpath.contains("CustomField[@name")) {
            this.handleCustomFieldValueParameter(field);
            field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.EQUAL));
        } else {
            field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.EQUAL));
            valueColumnName = this.getValueColumnName();
            searchType = this.getSearchTypeBasedOnColumn(valueColumnName);
            ListParameter listParam = new ListParameter(valueColumnName, this.ignoreCase, searchType, this.getOperator());
            for (String value : this.values) {
                listParam.addValue((Object)value);
            }
            field.addParameter((SearchParameterBase)listParam);
        }
        ValueParameter assetTypeParam = this.addAssetTypeCriteria();
        if (assetTypeParam != null) {
            field.addParameter((SearchParameterBase)assetTypeParam);
        }
        assetEntity.addParameter((SearchParameterBase)field, this.isConjunction());
    }

    private void handleCustomFieldValueParameter(Entity field) {
        ListParameter listParam;
        boolean isInt = true;
        boolean isFloat = true;
        boolean isDate = false;
        boolean isString = false;
        String val = "";
        if (this.values != null) {
            val = this.values.get(0);
        }
        try {
            Integer.parseInt(val);
            listParam = new ListParameter("intValue", SearchType.NUMERIC, this.getOperator());
            for (String value : this.values) {
                listParam.addValue((Object)value);
            }
            field.addParameter((SearchParameterBase)listParam);
        }
        catch (NumberFormatException e) {
            isInt = false;
        }
        if (!isInt) {
            try {
                Float.parseFloat(val);
                listParam = new ListParameter("floatValue", SearchType.NUMERIC, this.getOperator());
                for (String value : this.values) {
                    listParam.addValue((Object)value);
                }
                field.addParameter((SearchParameterBase)listParam);
            }
            catch (NumberFormatException e) {
                isFloat = false;
            }
            if (!isFloat) {
                try {
                    DateParser.parse(val);
                    listParam = new ListParameter("dateValue", SearchType.DATE, this.getOperator());
                    for (String value : this.values) {
                        listParam.addValue((Object)value);
                    }
                    field.addParameter((SearchParameterBase)listParam);
                }
                catch (NumberFormatException e) {
                    isDate = false;
                }
                catch (InvalidDateException e) {
                    isDate = false;
                }
                if (!isDate) {
                    listParam = new ListParameter("value", this.ignoreCase, SearchType.STRING, this.getOperator());
                    for (String value : this.values) {
                        listParam.addValue((Object)value);
                    }
                    field.addParameter((SearchParameterBase)listParam);
                    isString = true;
                }
            }
        }
        if (!isString) {
            listParam = new ListParameter("value", SearchType.STRING, this.getOperator());
            for (String value : this.values) {
                listParam.addValue((Object)value);
            }
            field.addParameter((SearchParameterBase)listParam, false);
        }
    }
}

