/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum LogicalOperator {
    EQUAL,
    LESSTHAN,
    GREATERTHAN,
    LESSTHANEQUAL,
    GREATERTHANEQUAL,
    ISEMPTY,
    ISNOTEMPTY,
    NOTEQUAL,
    CONTAINS,
    DOESNOTCONTAIN,
    IN,
    NOTIN,
    AND,
    OR,
    NOT,
    XOR,
    STARTSWITH,
    ENDSWITH,
    DOESNOTSTARTWITH,
    DOESNOTENDWITH,
    EVALCHILDFIELDS,
    LENGTHEQUALS,
    LENGTHLESSTHAN,
    LENGTHGREATERTHAN,
    REGEX,
    GREATERTHANTODAY,
    LESSTHANTODAY,
    CONTAINSUNPARSABLE,
    NOTGREATERTHANTODAY,
    NOTLESSTHANTODAY,
    DOESNOTCONTAINUNPARSABLE,
    TIER1EQUALS,
    TIER2EQUALS,
    TIER3EQUALS,
    TIER4EQUALS,
    ISNULL,
    ISNOTNULL;


    public static LogicalOperator lookUp(String operator) {
        LogicalOperator[] allOper;
        for (LogicalOperator oper : allOper = LogicalOperator.values()) {
            if (!oper.name().equalsIgnoreCase(operator)) continue;
            return oper;
        }
        throw new IllegalArgumentException("No value found for " + operator);
    }

    public LogicalOperator invert() {
        switch (this) {
            case EQUAL: {
                return NOTEQUAL;
            }
            case LESSTHAN: {
                return GREATERTHANEQUAL;
            }
            case GREATERTHAN: {
                return LESSTHANEQUAL;
            }
            case LESSTHANEQUAL: {
                return GREATERTHAN;
            }
            case GREATERTHANEQUAL: {
                return LESSTHAN;
            }
            case ISEMPTY: {
                return ISNOTEMPTY;
            }
            case ISNOTEMPTY: {
                return ISEMPTY;
            }
            case NOTEQUAL: {
                return EQUAL;
            }
            case CONTAINS: {
                return DOESNOTCONTAIN;
            }
            case DOESNOTCONTAIN: {
                return CONTAINS;
            }
            case IN: {
                return NOTIN;
            }
            case NOTIN: {
                return IN;
            }
            case STARTSWITH: {
                return DOESNOTSTARTWITH;
            }
            case DOESNOTSTARTWITH: {
                return STARTSWITH;
            }
            case ENDSWITH: {
                return DOESNOTENDWITH;
            }
            case DOESNOTENDWITH: {
                return ENDSWITH;
            }
            case GREATERTHANTODAY: {
                return NOTGREATERTHANTODAY;
            }
            case NOTGREATERTHANTODAY: {
                return GREATERTHANTODAY;
            }
            case LESSTHANTODAY: {
                return NOTLESSTHANTODAY;
            }
            case NOTLESSTHANTODAY: {
                return LESSTHANTODAY;
            }
            case CONTAINSUNPARSABLE: {
                return DOESNOTCONTAINUNPARSABLE;
            }
            case DOESNOTCONTAINUNPARSABLE: {
                return CONTAINSUNPARSABLE;
            }
            case TIER1EQUALS: {
                return TIER1EQUALS;
            }
            case TIER2EQUALS: {
                return TIER2EQUALS;
            }
            case TIER3EQUALS: {
                return TIER3EQUALS;
            }
            case TIER4EQUALS: {
                return TIER4EQUALS;
            }
            case AND: {
                return AND;
            }
            case OR: {
                return OR;
            }
            case NOT: {
                return NOT;
            }
            case XOR: {
                return XOR;
            }
            case EVALCHILDFIELDS: {
                return EVALCHILDFIELDS;
            }
            case LENGTHEQUALS: {
                return LENGTHEQUALS;
            }
            case LENGTHLESSTHAN: {
                return LENGTHLESSTHAN;
            }
            case LENGTHGREATERTHAN: {
                return LENGTHGREATERTHAN;
            }
            case REGEX: {
                return REGEX;
            }
        }
        return this;
    }
}

