/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.ExpNode;
import com.tandbergtv.metadatamanager.DocumentDAOHelper;
import com.tandbergtv.metadatamanager.search.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.classic.Session;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

public class AssetSearchServiceImpl
implements AssetSearchService {
    private HibernateTemplate hibernateTemplate;
    private static AssetSearchQueryBuilder asqb = new AssetSearchQueryBuilder();
    private static final Logger logger = Logger.getLogger(AssetSearchServiceImpl.class);

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Document> search(ExpNode condition, boolean onlyOriginals) {
        String query = asqb.buildQueryForFullDoc(condition, onlyOriginals);
        logger.debug((Object)query);
        Session session = this.hibernateTemplate.getSessionFactory().getCurrentSession();
        return DocumentDAOHelper.getDocuments((org.hibernate.Session)session, query);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Long> searchForDocId(ExpNode condition, boolean onlyOriginals) {
        final String query = asqb.buildQuery(condition, onlyOriginals, null);
        logger.debug((Object)query);
        List result = (List)this.getHibernateTemplate().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                SQLQuery q = session.createSQLQuery(query).addScalar("docId", (Type)new LongType());
                return q.list();
            }
        });
        ArrayList<Long> assetIds = new ArrayList<Long>();
        for (int i = 0; i < result.size(); ++i) {
            if (!(result.get(i) instanceof Long)) continue;
            Long id = (Long)result.get(i);
            assetIds.add(Long.valueOf(id.toString()));
        }
        return assetIds;
    }

    @Override
    public Collection<Long> searchForDocId(ExpNode condition, boolean onlyOriginals, ExpNode generalConditions) {
        final String query = asqb.buildQuery(condition, onlyOriginals, generalConditions);
        logger.debug((Object)query);
        List result = (List)this.getHibernateTemplate().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                SQLQuery q = session.createSQLQuery(query).addScalar("docId", (Type)new LongType());
                return q.list();
            }
        });
        ArrayList<Long> assetIds = new ArrayList<Long>();
        for (int i = 0; i < result.size(); ++i) {
            if (!(result.get(i) instanceof Long)) continue;
            Long id = (Long)result.get(i);
            assetIds.add(Long.valueOf(id.toString()));
        }
        return assetIds;
    }

    @Override
    @Transactional
    public List<String> getFieldValuesFromForRevision(String path, Long documentId) {
        return this.getFieldValuesHelper(path, documentId, "mdm_metadata_revision");
    }

    @Override
    @Transactional
    public List<String> getFieldValues(String fieldXpath, Long documentId) {
        return this.getFieldValuesHelper(fieldXpath, documentId, "mdm_metadata");
    }

    private List<String> getFieldValuesHelper(String path, Long documentId, String tableName) {
        StringBuffer query = new StringBuffer("select value from ");
        query.append(tableName);
        query.append(" mdm,\txmltable('for $i in /");
        query.append(path);
        query.append(" \r\nreturn <ROW><value>{$i}</value></ROW>'");
        query.append("passing sys_nc_rowinfo$ ");
        query.append("columns value varchar(2000) path '/ROW/value')  xtab ");
        query.append("where xmlexists('$p/ECMFSpec[@documentId = ");
        query.append(documentId);
        query.append(" ]' passing sys_nc_rowinfo$ as \"p\")");
        final String finalQuery = query.toString();
        logger.debug((Object)finalQuery);
        List result = (List)this.getHibernateTemplate().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                SQLQuery q = session.createSQLQuery(finalQuery);
                return q.list();
            }
        });
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < result.size(); ++i) {
            String value = (String)result.get(i);
            results.add(value);
        }
        return results;
    }
}

