/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.search.XpathNodeCardinality;
import com.tandbergtv.metadatamanager.specimpl.ttv.schema.SpecLoader;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SearchSchemaHelper {
    public static final String CUSTOM_FIELD = "/Fields/CustomFields/CustomField";
    public static final String CUSTOM_FIELD_CHECK = "/Fields/CustomFields/CustomField[@name=";
    private Document spec;
    private XPathFactory factory = XPathFactory.newInstance();

    public SearchSchemaHelper() {
        try {
            SpecLoader sl = new SpecLoader();
            this.spec = sl.getSpecAsDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCustomField(String field) {
        return field.startsWith(CUSTOM_FIELD_CHECK);
    }

    private String[] combineArrays(String[] assetTypes, String[] xpaths) {
        String[] result = new String[assetTypes.length + xpaths.length];
        int pos = 0;
        for (String str : assetTypes) {
            result[pos++] = str;
        }
        for (String str : xpaths) {
            result[pos++] = str;
        }
        return result;
    }

    public Collection<String> getAssetTypesWFile(String assetPath) {
        HashSet<String> assetTypes = new HashSet<String>();
        int lastAssetStart = assetPath.lastIndexOf(47) == -1 ? 0 : assetPath.lastIndexOf(47) + 1;
        String lastAssetName = assetPath.substring(lastAssetStart);
        String expression = "//xs:element[fn:upper-case(@name)='" + lastAssetName.toUpperCase() + "']/@type";
        try {
            String type = this.getXpath().evaluate(expression, this.getSpec());
            String exp = "//xs:complexType[@name='" + type + "' and xs:attribute/@name='assetId']/xs:sequence/xs:element";
            NodeList childNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
            for (int j = 0; j < childNodes.getLength(); ++j) {
                NamedNodeMap attributes = childNodes.item(j).getAttributes();
                String childType = attributes.getNamedItem("type").getNodeValue();
                String childName = attributes.getNamedItem("name").getNodeValue();
                this.getAssetTypesWFileRec(assetTypes, assetPath, childName, childType);
            }
            return assetTypes;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<String> getAssetTypesWFile() {
        HashSet<String> assetTypes = new HashSet<String>();
        String exp = "//xs:complexType[@name='ECMFSpecComplexType']/xs:sequence/xs:element";
        try {
            NodeList childNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
            for (int j = 0; j < childNodes.getLength(); ++j) {
                NamedNodeMap attributes = childNodes.item(j).getAttributes();
                String childType = attributes.getNamedItem("type").getNodeValue();
                String childName = attributes.getNamedItem("name").getNodeValue();
                this.getAssetTypesWFileRec(assetTypes, "", childName, childType);
            }
            return assetTypes;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getAssetTypesWFileRec(Set<String> assetTypes, String assetPrefix, String nodeName, String nodeType) throws XPathExpressionException {
        if (nodeName.equals("File")) {
            assetTypes.add(assetPrefix);
            return true;
        }
        boolean result = false;
        String exp = "//xs:complexType[@name='" + nodeType + "' and xs:attribute/@name='assetId']/xs:sequence/xs:element";
        NodeList nodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap attributes = nodes.item(i).getAttributes();
            String type = attributes.getNamedItem("type").getNodeValue();
            String name = attributes.getNamedItem("name").getNodeValue();
            if (type.equals(nodeType)) continue;
            String newPrefix = assetPrefix.isEmpty() ? "" : assetPrefix + "/";
            if (!this.getAssetTypesWFileRec(assetTypes, newPrefix = newPrefix + nodeName.toUpperCase(), name, type)) continue;
            result = true;
        }
        if (result && !assetPrefix.isEmpty()) {
            assetTypes.add(assetPrefix);
        }
        return result;
    }

    public List<String> getChildAssetTypes(String assetPath) throws XPathExpressionException {
        assetPath = this.getCorrectedAssetPath(assetPath, false);
        ArrayList<String> assetTypes = new ArrayList<String>();
        int lastAssetStart = assetPath.lastIndexOf(47) == -1 ? 0 : assetPath.lastIndexOf(47) + 1;
        String lastAssetName = assetPath.substring(lastAssetStart);
        String expression = "//xs:element[@name='" + lastAssetName + "']";
        Object result = this.getXpath().evaluate(expression, this.getSpec(), XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String type = nodes.item(i).getAttributes().getNamedItem("type").getNodeValue();
            String exp = "//xs:complexType[@name='" + type + "' and xs:attribute/@name='assetId']/xs:sequence/xs:element";
            NodeList childNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
            for (int j = 0; j < childNodes.getLength(); ++j) {
                NamedNodeMap attributes = childNodes.item(j).getAttributes();
                String childType = attributes.getNamedItem("type").getNodeValue();
                String childName = attributes.getNamedItem("name").getNodeValue();
                this.getChildAssetTypesRec(assetTypes, assetPath, childName, childType);
            }
        }
        return assetTypes;
    }

    public List<String> getAssetTypesWOFile() throws XPathExpressionException {
        ArrayList<String> assetTypes = new ArrayList<String>();
        String exp = "//xs:complexType[@name='ECMFSpecComplexType']/xs:sequence/xs:element";
        NodeList childNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
        for (int j = 0; j < childNodes.getLength(); ++j) {
            NamedNodeMap attributes = childNodes.item(j).getAttributes();
            String childType = attributes.getNamedItem("type").getNodeValue();
            String childName = attributes.getNamedItem("name").getNodeValue();
            this.getChildAssetTypesRec(assetTypes, "", childName, childType);
        }
        return assetTypes;
    }

    private void getChildAssetTypesRec(List<String> assetTypes, String assetPrefix, String nodeName, String nodeType) throws XPathExpressionException {
        if (nodeName.equals("File")) {
            return;
        }
        String exp = "//xs:complexType[@name='" + nodeType + "' and xs:attribute/@name='assetId']/xs:sequence/xs:element";
        NodeList nodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
        if (nodes.getLength() > 0) {
            assetTypes.add(assetPrefix + "/" + nodeName);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap attributes = nodes.item(i).getAttributes();
            String type = attributes.getNamedItem("type").getNodeValue();
            String name = attributes.getNamedItem("name").getNodeValue();
            if (type.equals(nodeType)) continue;
            this.getChildAssetTypesRec(assetTypes, assetPrefix + "/" + nodeName, name, type);
        }
    }

    public String getCorrectedAssetPath(String assetPath, boolean includeFirstIndex) {
        StringBuffer sb = new StringBuffer();
        List<XpathNodeCardinality> nodes = this.getXpathCardinality(assetPath, "");
        for (XpathNodeCardinality node : nodes) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(node.getNodeName());
            if (!includeFirstIndex || node.getCardinality() <= 0) continue;
            sb.append("[1]");
        }
        return sb.toString();
    }

    public List<XpathNodeCardinality> getXpathCardinality(String assetType, String fieldXpath) {
        ArrayList<XpathNodeCardinality> nodes = new ArrayList<XpathNodeCardinality>();
        try {
            String[] fieldPaths = fieldXpath.isEmpty() ? new String[]{} : (fieldXpath.startsWith("/") ? fieldXpath.substring(1).split("/") : fieldXpath.split("/"));
            String[] assetTypes = assetType.split("/");
            String expression = "//xs:element[fn:upper-case(@name)='" + assetTypes[0].toUpperCase() + "']";
            Object result = this.getXpath().evaluate(expression, this.getSpec(), XPathConstants.NODESET);
            NodeList nodeList = (NodeList)result;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String type = nodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
                String name = nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String exp = "//xs:complexType[@name='" + type + "' and xs:sequence/xs:element/@name='Fields']";
                NodeList assetNodes = (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
                if (assetNodes.getLength() == 0) continue;
                if (assetNodes.getLength() > 1) {
                    throw new RuntimeException("WTF");
                }
                String[] fullPath = this.combineArrays(assetTypes, fieldPaths);
                nodes.add(new XpathNodeCardinality(name, 1));
                if (fullPath.length <= 1) continue;
                this.buildAssetType(fullPath, 1, type, nodes);
            }
            return nodes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String prepareSelectXpath(String assetType, String fieldXpath) {
        if (SearchSchemaHelper.isCustomField(fieldXpath)) {
            CustomFieldXPathConverter.getActualXpath(fieldXpath);
        }
        StringBuffer sb = new StringBuffer("/ECMFSpec");
        List<XpathNodeCardinality> nodes = this.getXpathCardinality(assetType, fieldXpath);
        for (XpathNodeCardinality node : nodes) {
            sb.append("/");
            sb.append(node.getNodeName());
            if (node.getCardinality() <= 1) continue;
            sb.append("[1]");
        }
        return sb.toString();
    }

    private NodeList getElementsofTypeExp(String type) throws XPathExpressionException {
        String exp = "//xs:complexType[@name='" + type + "']/*";
        return (NodeList)this.getXpath().evaluate(exp, this.getSpec(), XPathConstants.NODESET);
    }

    private boolean buildAssetType(String[] path, int pos, String currType, List<XpathNodeCardinality> nodes) throws XPathExpressionException {
        if (path[pos].startsWith("@")) {
            nodes.add(new XpathNodeCardinality(path[pos], 1));
            return true;
        }
        NodeList immediateChilren = this.getElementsofTypeExp(currType);
        NodeList childItems = null;
        for (int i = 0; i < immediateChilren.getLength(); ++i) {
            Node node = immediateChilren.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("xs:sequence") || nodeName.equals("xs:all") || nodeName.equals("xs:choice")) {
                childItems = immediateChilren.item(i).getChildNodes();
                break;
            }
            if (!nodeName.equals("xs:complexContent")) continue;
            String baseType = this.getXpath().evaluate("xs:extension/@base", node);
            if (this.buildAssetType(path, pos, baseType, nodes)) {
                return true;
            }
            NodeList childNodes = (NodeList)this.getXpath().evaluate("xs:extension/*/xs:element", node, XPathConstants.NODESET);
            if (childNodes.getLength() <= 0) continue;
            childItems = childNodes;
        }
        if (childItems == null) {
            throw new RuntimeException("Error evaluating xpath " + path.toString());
        }
        return this.handleNodeList(childItems, path, pos, nodes);
    }

    private boolean handleNodeList(NodeList childItems, String[] path, int pos, List<XpathNodeCardinality> nodes) throws XPathExpressionException {
        for (int j = 0; j < childItems.getLength(); ++j) {
            String childAssetName;
            Node childNode = childItems.item(j);
            if (!childNode.getNodeName().equals("xs:element") || !(childAssetName = childItems.item(j).getAttributes().getNamedItem("name").getNodeValue()).equalsIgnoreCase(path[pos])) continue;
            int maxOccurs = 1;
            Node maxOccursNode = childItems.item(j).getAttributes().getNamedItem("maxOccurs");
            if (maxOccursNode != null && maxOccursNode.getNodeValue().equalsIgnoreCase("unbounded")) {
                maxOccurs = Integer.MAX_VALUE;
            } else if (maxOccursNode != null) {
                maxOccurs = Integer.parseInt(maxOccursNode.getNodeValue());
            }
            nodes.add(new XpathNodeCardinality(childAssetName, maxOccurs));
            if (++pos < path.length) {
                String childType = childItems.item(j).getAttributes().getNamedItem("type").getNodeValue();
                this.buildAssetType(path, pos, childType, nodes);
            }
            return true;
        }
        return false;
    }

    private XPath getXpath() {
        XPath xpath = this.factory.newXPath();
        xpath.setNamespaceContext(new UniversalNamespaceResolver(this.spec));
        xpath.setXPathFunctionResolver(new MyFunctionResolver());
        return xpath;
    }

    private Document getSpec() {
        return this.spec;
    }

    public class MyFunctionResolver
    implements XPathFunctionResolver {
        @Override
        public XPathFunction resolveFunction(QName fname, int arity) {
            if (fname == null) {
                throw new NullPointerException("The function name cannot be null.");
            }
            if (fname.equals(new QName("http://www.w3.org/2005/xpath-functions", "upper-case", "fn"))) {
                return new XPathFunction(){

                    public Object evaluate(List args) {
                        NodeList nodes = (NodeList)args.get(0);
                        return nodes.item(0).getNodeValue().toUpperCase();
                    }
                };
            }
            return null;
        }
    }

    private class UniversalNamespaceResolver
    implements NamespaceContext {
        private Document sourceDocument;

        public UniversalNamespaceResolver(Document document) {
            this.sourceDocument = document;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("")) {
                return this.sourceDocument.lookupNamespaceURI(null);
            }
            if (prefix.equals("fn")) {
                return "http://www.w3.org/2005/xpath-functions";
            }
            return this.sourceDocument.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.sourceDocument.lookupPrefix(namespaceURI);
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

