/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.SearchFieldBuilder;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.SpecHandlerBase;
import com.tandbergtv.metadatamanager.specimpl.ValidatorHelper;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class AssetValidator {
    private SpecHandlerBase parentHandler;

    public AssetValidator(SpecHandlerBase specificationHandler) {
        this.parentHandler = specificationHandler;
    }

    public void validate(Asset rootAsset) throws MetadataException {
        Collection<ISpecHandler> handlers = this.getSpecificationHandlersForValidation();
        for (ISpecHandler handler : handlers) {
            this.validateAssetInTree(rootAsset, handler);
        }
    }

    public void validateWithCurrentSpecification(Asset rootAsset) throws MetadataException {
        this.validateAssetInTree(rootAsset, this.parentHandler);
    }

    public void validateForPersistence(Asset rootAsset) throws MetadataException {
        List<Asset> assets = this.getAssetsInTree(rootAsset);
        for (Asset currentAsset : assets) {
            this.doValidateForPersistence(currentAsset);
        }
    }

    private void validateAssetInTree(Asset rootAsset, ISpecHandler handler) throws MetadataException {
        List<Asset> assets = this.getAssetsInTree(rootAsset);
        ArrayList<SearchCriteria> assetKeys = new ArrayList<SearchCriteria>();
        for (Asset currentAsset : assets) {
            this.validateAssetInTree(currentAsset, handler, assetKeys);
        }
    }

    private List<Asset> getAssetsInTree(Asset asset) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        this.getAssetsInTree(asset, assets);
        return assets;
    }

    private void getAssetsInTree(Asset asset, List<Asset> assets) {
        assets.add(asset);
        int currentIndex = 0;
        while (currentIndex < assets.size()) {
            Asset currentAsset;
            if ((currentAsset = assets.get(currentIndex++)).getRelations() == null) continue;
            for (Relation relation : asset.getRelations()) {
                Asset target = relation.getTargetAsset();
                if (assets.contains(target)) continue;
                assets.add(target);
            }
        }
    }

    private void validateAssetInTree(Asset asset, ISpecHandler hander, Collection<SearchCriteria> assetKeys) throws MetadataException {
        SearchCriteria assetKey = this.getAssetSpecificationKey(asset, hander);
        if (assetKey == null || assetKey.isEmptyCriteria()) {
            return;
        }
        if (this.hasAssetKey(assetKeys, assetKey)) {
            String specificationName = hander.getSpecName();
            String msg = "Found multiple assets in asset tree with key " + assetKey.toString() + " for specification " + specificationName + ".";
            throw new MetadataException(msg);
        }
        assetKeys.add(assetKey);
    }

    private SearchCriteria getAssetSpecificationKey(Asset asset, ISpecHandler handler) {
        IIdentifier identifier = handler.extractId(asset);
        if (!identifier.isValidIdentifier()) {
            return null;
        }
        Map<String, String> idPaths = identifier.getTTVPaths();
        Map<String, String> identifiers = identifier.getSpecIdentifiers();
        SearchCriteria criteria = new SearchCriteria();
        for (String specificationIDXPath : idPaths.keySet()) {
            String ttvIDXPath = idPaths.get(specificationIDXPath);
            String value = identifiers.get(specificationIDXPath);
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvIDXPath)) {
                return null;
            }
            if (value != null && value.equals("")) {
                value = null;
            }
            criteria.put(ttvIDXPath, value);
        }
        return criteria;
    }

    private boolean hasAssetKey(Collection<SearchCriteria> assetKeys, SearchCriteria assetKey) {
        for (SearchCriteria currentAssetKey : assetKeys) {
            if (!assetKey.hasSameCriteria(currentAssetKey)) continue;
            return true;
        }
        return false;
    }

    private Collection<ISpecHandler> getSpecificationHandlersForValidation() {
        ValidatorHelper helper = ValidatorHelper.getInstance();
        return helper.getSpecificationHandlersForValidation();
    }

    private void doValidateForPersistence(Asset asset) throws MetadataException {
        Predicate checkOriginalEmpty;
        Asset root = asset.getRoot() != null ? asset.getRoot() : asset;
        TTVId rootId = root.getTTVId();
        Long docId = null;
        Long originalDocId = root.getOriginalAssetID();
        if (rootId.isValidIdentifier()) {
            docId = rootId.getId();
        }
        if (docId == null && root.getOriginalAssetID() != null) {
            return;
        }
        if (!asset.getSpecKeyValuesHasChanged()) {
            return;
        }
        Collection<ISpecHandler> handlers = docId == null ? this.getSpecificationHandlersForValidation() : asset.getSpecHandlersForValidation();
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        ExpList docIdExpList = new ExpList();
        if (docId != null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(String.valueOf(docId));
            PredicateRightValue ignoreMe = new PredicateRightValue("/@documentId", "ECMFSpec", FieldType.ASSET, values, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
            docIdExpList.addItem((ExpNode)new ExpValue((Predicate)ignoreMe));
            if (originalDocId == null || originalDocId <= 0L) {
                ExpList checkOriginalList = new ExpList("OR");
                PredicateRightValue checkOriginal = new PredicateRightValue("/@originalDocumentId", "ECMFSpec", FieldType.ASSET, values, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
                checkOriginalList.addItem((ExpNode)new ExpValue((Predicate)checkOriginal));
                checkOriginalEmpty = new Predicate("/@originalDocumentId", "ECMFSpec", FieldType.ASSET, LogicalOperator.ISEMPTY, Boolean.valueOf(false));
                checkOriginalList.addItem((ExpNode)new ExpValue(checkOriginalEmpty));
                docIdExpList.addItem((ExpNode)checkOriginalList);
            }
        }
        if (originalDocId != null && originalDocId > 0L) {
            ArrayList<String> oaValues = new ArrayList<String>();
            oaValues.add(String.valueOf(originalDocId));
            PredicateRightValue checkIfDocIsOriginal = new PredicateRightValue("/@documentId", "ECMFSpec", FieldType.ASSET, oaValues, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
            docIdExpList.addItem((ExpNode)new ExpValue((Predicate)checkIfDocIsOriginal));
            ExpList checkIfItIsAnotherCopyOfOrigList = new ExpList("OR");
            PredicateRightValue checkIfItIsAnotherCopyOfOrig = new PredicateRightValue("/@originalDocumentId", "ECMFSpec", FieldType.ASSET, oaValues, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
            checkIfItIsAnotherCopyOfOrigList.addItem((ExpNode)new ExpValue((Predicate)checkIfItIsAnotherCopyOfOrig));
            checkOriginalEmpty = new Predicate("/@originalDocumentId", "ECMFSpec", FieldType.ASSET, LogicalOperator.ISEMPTY, Boolean.valueOf(false));
            checkIfItIsAnotherCopyOfOrigList.addItem((ExpNode)new ExpValue(checkOriginalEmpty));
            docIdExpList.addItem((ExpNode)checkIfItIsAnotherCopyOfOrigList);
        }
        AssetSearchService service = this.parentHandler.searchService;
        StringBuilder searchAssetSpecKeys = new StringBuilder();
        for (ISpecHandler handler : handlers) {
            ExpList searchFields;
            SearchCriteria assetKey = this.getAssetSpecificationKey(asset, handler);
            if (assetKey == null || assetKey.isEmptyCriteria() || (searchFields = new SearchFieldBuilder().getAssetSearchFields(assetKey, false)) == null || searchFields.isEmpty()) continue;
            searchAssetSpecKeys.append(handler.getSpecName() + ".assetKey=" + assetKey.toString() + ":");
            Collection<Long> docIDs = service.searchForDocId((ExpNode)searchFields, false, (ExpNode)docIdExpList);
            int matchingAssetCount = docIDs != null ? docIDs.size() : 0;
            if (matchingAssetCount <= 0) continue;
            String assetName = "Asset[";
            assetName = assetName + (asset.getTTVId().isValidIdentifier() ? Long.valueOf(asset.getId()) : asset.getAssetType());
            assetName = assetName + "]";
            String msg = assetName + " has key(s) which is/are not unique in the system. ";
            msg = msg + searchAssetSpecKeys.toString();
            throw new MetadataException(msg);
        }
    }
}

