/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.SearchFieldBuilder;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.binder.ECMFBinder;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

public abstract class IdentifierBase
implements IIdentifier,
Serializable {
    private static final Logger logger = Logger.getLogger(IIdentifier.class);
    private static final long serialVersionUID = 2127389786395783352L;
    private AssetSearchService searchService;
    private URL mappingResourceUrl;

    public URL getMappingResourceUrl() {
        return this.mappingResourceUrl;
    }

    public void setMappingResourceUrl(URL mappingResourceUrl) {
        this.mappingResourceUrl = mappingResourceUrl;
    }

    @Override
    @Transactional
    public Asset getAsset() throws SearchException {
        logger.debug((Object)"In Identfier.getAsset()");
        List<Object> docs = new ArrayList();
        SearchCriteria criteriaMap = this.buildSearchCriteriaMap(this.getSpecIdentifiers(), this.getTTVPaths());
        ExpList assetSearchFields = this.buildSearchFields(criteriaMap);
        docs = this.searchService.search((ExpNode)assetSearchFields, true);
        if (docs.size() == 0) {
            throw new SearchException("No document found with id: " + criteriaMap.toString());
        }
        if (docs.size() > 1) {
            throw new SearchException("Multiple documents found with id: " + criteriaMap.toString());
        }
        List<Asset> rootAssets = new ECMFBinder().bind((Document)docs.get(0));
        return rootAssets.get(0);
    }

    @Override
    @Transactional
    public TTVId getAssetTTVId() throws SearchException {
        logger.debug((Object)"In Identfier.getAssetTTVId()");
        Collection<Object> assetIDs = new ArrayList();
        SearchCriteria criteriaMap = this.buildSearchCriteriaMap(this.getSpecIdentifiers(), this.getTTVPaths());
        ExpList assetProperties = this.buildSearchFields(criteriaMap);
        assetIDs = this.searchService.searchForDocId((ExpNode)assetProperties, true);
        if (assetIDs.size() == 0) {
            throw new SearchException("No asset found with id: " + criteriaMap.toString());
        }
        if (assetIDs.size() > 1) {
            throw new SearchException("Multiple assets found with id: " + criteriaMap.toString());
        }
        return new TTVId((Long)assetIDs.iterator().next());
    }

    protected ExpList buildSearchFields(SearchCriteria criteriaMap) {
        return new SearchFieldBuilder().getAssetSearchFields(criteriaMap, true);
    }

    protected SearchCriteria buildSearchCriteriaMap(Map<String, String> idFields, Map<String, String> ttvXpaths) {
        SearchCriteria criteria = new SearchCriteria();
        for (Map.Entry<String, String> entry : idFields.entrySet()) {
            if (!ttvXpaths.containsKey(entry.getKey())) continue;
            criteria.put(ttvXpaths.get(entry.getKey()), entry.getValue());
        }
        return criteria;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> ids = this.getSpecIdentifiers();
        Iterator<Map.Entry<String, String>> iter = ids.entrySet().iterator();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            Map.Entry<String, String> entry = iter.next();
            sb.append(entry.getKey());
            sb.append("[");
            sb.append(entry.getValue());
            sb.append("]");
        }
        return sb.toString();
    }

    public AssetSearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(AssetSearchService searchService) {
        this.searchService = searchService;
    }
}

