/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.authentication.ejb;

import com.tandbergtv.neptune.authentication.entity.AuthenticationResponse;
import com.tandbergtv.neptune.authentication.entity.BasicRole;
import com.tandbergtv.neptune.authentication.entity.BasicUser;
import com.tandbergtv.neptune.authentication.entity.IAuthenticationResponse;
import com.tandbergtv.neptune.authentication.entity.IRole;
import com.tandbergtv.neptune.authentication.service.internal.IInternalAuthenticationService;
import com.tandbergtv.neptune.authorization.service.internal.IEJB3RoleGenerator;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Local(value={IInternalAuthenticationService.class})
@Stateless
@RunAs(value="NeptuneAuthentication")
public class LocalAuthenticationService
implements IInternalAuthenticationService {
    @PersistenceContext(unitName="NeptuneRealm")
    protected EntityManager entityManager;
    @EJB
    protected IEJB3RoleGenerator roleGenerator;

    public IAuthenticationResponse authenticateUser(String userName, String password) {
        AuthenticationResponse response = null;
        if (userName == null || userName.trim().length() == 0) {
            return new AuthenticationResponse(null, "The user name cannot be null / blank.");
        }
        if (password == null || password.trim().length() == 0) {
            return new AuthenticationResponse(null, "The password cannot be null / blank.");
        }
        User persistedUser = this.getPersistedUser(userName);
        if (persistedUser == null || !persistedUser.isActive()) {
            response = new AuthenticationResponse(null, "The user name does not exist.");
        } else if (!password.equals(persistedUser.getPassword())) {
            response = new AuthenticationResponse(null, "The password is incorrect.");
        } else {
            BasicUser user = new BasicUser();
            user.setUserName(persistedUser.getUserName());
            user.setFirstName(persistedUser.getFirstName());
            user.setLastName(persistedUser.getLastName());
            user.setActive(persistedUser.isActive());
            user.setRoles(this.convertToEJB3Roles(persistedUser.getRoles()));
            response = new AuthenticationResponse(user);
        }
        return response;
    }

    private User getPersistedUser(String userName) {
        User persistedUser = null;
        Query query = this.entityManager.createNamedQuery("User.FindByUserName");
        query.setParameter("userName", (Object)userName);
        try {
            persistedUser = (User)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return persistedUser;
    }

    protected Set<IRole> convertToEJB3Roles(Collection<Role> persistedRoles) {
        HashSet<IRole> roles = new HashSet<IRole>();
        if (persistedRoles != null) {
            HashSet<Permission> assignedPermissions = new HashSet<Permission>();
            for (Role persistedRole : persistedRoles) {
                for (Permission persistedPermission : persistedRole.getPermissions()) {
                    assignedPermissions.add(persistedPermission);
                }
            }
            for (Permission assignedPermission : assignedPermissions) {
                String moduleName = assignedPermission.getModule().getName();
                String permissionName = assignedPermission.getName();
                String roleName = this.roleGenerator.generateRole(moduleName, permissionName);
                roles.add(new BasicRole(roleName, moduleName, permissionName));
            }
        }
        return roles;
    }
}

