/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.rolemgmt.ejb;

import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.rolemgmt.service.IRoleManager;
import com.tandbergtv.neptune.rolemgmt.service.internal.IExternalRoleManager;
import com.tandbergtv.neptune.rolemgmt.service.internal.IInternalRoleManager;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class RoleManager
implements IRoleManager {
    @EJB
    IInternalRoleManager internalManager;
    @EJB
    IExternalRoleManager externalManager;
    @EJB
    IUserLdapContext userLdapContext;

    @RolesAllowed(value={"RoleManagement_View"})
    public List<Role> getRoles() {
        return this.getRoleManager().getRoles();
    }

    @RolesAllowed(value={"RoleManagement_View"})
    public Role getRole(RoleKey roleKey) {
        return this.getRoleManager().getRole(roleKey);
    }

    @RolesAllowed(value={"RoleManagement_Create"})
    public Role createRole(Role role) throws ValidationException {
        this.validate(role);
        return this.getRoleManager().createRole(role);
    }

    @RolesAllowed(value={"RoleManagement_Modify"})
    public Role updateRole(Role role) throws ValidationException {
        this.validate(role);
        return this.getRoleManager().updateRole(role);
    }

    @RolesAllowed(value={"RoleManagement_Delete"})
    public boolean deleteRole(RoleKey roleKey) {
        return this.getRoleManager().deleteRole(roleKey);
    }

    @RolesAllowed(value={"RoleManagement_Delete"})
    public boolean deleteRoles(RoleKey ... roleKeys) {
        return this.getRoleManager().deleteRoles(roleKeys);
    }

    @RolesAllowed(value={"RoleManagement_View"})
    public boolean isReadOnly() {
        return this.getRoleManager().isReadOnly();
    }

    private void validate(Role role) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.isBlank(role.getName())) {
            validationMessages.add("Name is required.");
        }
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private IRoleManager getRoleManager() {
        Object manager = null;
        manager = this.userLdapContext.isExternalUserModelEnabled() ? this.externalManager : this.internalManager;
        return manager;
    }
}

