/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.cms.portal.util.paging.PagingAspect;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.usermgmt.service.IUserValidityService;
import com.tandbergtv.neptune.usermgmt.service.UserValidationException;
import com.tandbergtv.neptune.usermgmt.service.internal.IExternalUserManager;
import com.tandbergtv.neptune.usermgmt.service.internal.IInternalUserManager;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.aspectj.runtime.internal.AroundClosure;

@Stateless
public class UserManager
implements IUserManager {
    @EJB
    IInternalUserManager internalManager;
    @EJB
    IExternalUserManager externalManager;
    @EJB
    IUserLdapContext userLdapContext;
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;

    @RolesAllowed(value={"UserManagement_View"})
    public List<User> getUsers() {
        return this.getUserManager().getUsers();
    }

    @RolesAllowed(value={"UserManagement_View"})
    public User getUser(UserKey userKey) {
        return this.getUserManager().getUser(userKey);
    }

    @RolesAllowed(value={"UserManagement_View"})
    public User getUser(String userName) {
        return this.getUserManager().getUser(userName);
    }

    @RolesAllowed(value={"UserManagement_View"})
    public List<User> getUsersWithPermission(String moduleName, String permissionName) {
        return this.getUserManager().getUsersWithPermission(moduleName, permissionName);
    }

    @RolesAllowed(value={"UserManagement_Create"})
    public User createUser(User user) throws ValidationException {
        this.validate(user, true);
        return this.getUserManager().createUser(user);
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User updateUser(User user) throws ValidationException {
        this.validate(user, false);
        return this.getUserManager().updateUser(user);
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User updateUserWithPassword(User user) throws ValidationException {
        this.validate(user, true);
        return this.getUserManager().updateUserWithPassword(user);
    }

    @RolesAllowed(value={"UserManagement_Delete"})
    public boolean deleteUser(UserKey userKey) {
        return this.getUserManager().deleteUser(userKey);
    }

    @RolesAllowed(value={"UserManagement_Delete"})
    public boolean deleteUsers(UserKey ... userKeys) {
        return this.getUserManager().deleteUsers(userKeys);
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User setActiveStatus(UserKey userKey, boolean active) {
        return this.getUserManager().setActiveStatus(userKey, active);
    }

    @RolesAllowed(value={"UserManagement_View"})
    public boolean isReadOnly() {
        return this.getUserManager().isReadOnly();
    }

    private void validate(User user, boolean withPassword) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.isBlank(user.getUserName())) {
            validationMessages.add("User Name is required.");
        } else if (user.getUserName().length() < 3 || user.getUserName().length() > 16) {
            validationMessages.add("User Name must be between 3 and 16 characters.");
        }
        if (withPassword) {
            if (this.isBlank(user.getPassword())) {
                validationMessages.add("Password is required.");
            } else if (user.getPassword().length() < 6 || user.getPassword().length() > 16) {
                validationMessages.add("Password must be between 6 and 16 characters.");
            }
            if (!this.isBlank(user.getUserName()) && !this.isBlank(user.getPassword()) && user.getUserName().equalsIgnoreCase(user.getPassword())) {
                validationMessages.add("User Name and password cannot be the same, case-insensitive");
            }
        }
        if (user.getRoles().isEmpty()) {
            validationMessages.add("Roles is required.");
        }
        if (this.isBlank(user.getFirstName())) {
            validationMessages.add("First Name is required.");
        } else if (user.getFirstName().length() > 16) {
            validationMessages.add("First Name cannot exceed 16 characters.");
        }
        if (this.isBlank(user.getLastName())) {
            validationMessages.add("Last Name is required.");
        }
        if (this.isBlank(user.getEmail())) {
            validationMessages.add("Email is required.");
        } else if (!user.getEmail().matches("^.+@.+$")) {
            validationMessages.add("Email is not valid.");
        }
        if (this.isBlank(user.getEmployeeId())) {
            validationMessages.add("Employee ID is required.");
        }
        if (this.isBlank(user.getDepartment())) {
            validationMessages.add("Department is required.");
        }
        if (this.isBlank(user.getLocation())) {
            validationMessages.add("Location is required.");
        }
        if (!this.isBlank(user.getUserName())) {
            for (Role role : user.getRoles()) {
                String string = "SELECT role FROM Role role WHERE role.id = :roleId";
                EntityManager entityManager = this.entityManager;
                Query query = PagingAspect.ajc$cflowStack$0.isValid() ? UserManager.createQuery_aroundBody1$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
                query.setParameter("roleId", (Object)role.getId());
                List roles = query.getResultList();
                user.setRoles(new HashSet(roles));
                this.validateWithComponents(user, validationMessages);
            }
        }
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validateWithComponents(User user, List<String> validationMessages) {
        ServiceLoader<IUserValidityService> userValidityLoader = ServiceLoader.load(IUserValidityService.class);
        if (userValidityLoader != null) {
            for (IUserValidityService userValidityProvider : userValidityLoader) {
                try {
                    userValidityProvider.validate(user);
                }
                catch (UserValidationException e) {
                    validationMessages.add(e.getLocalizedMessage());
                }
            }
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private IUserManager getUserManager() {
        Object manager = null;
        manager = this.userLdapContext.isExternalUserModelEnabled() ? this.externalManager : this.internalManager;
        return manager;
    }

    private static final /* synthetic */ Query createQuery_aroundBody1$advice(UserManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc_aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc_aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }
}

