/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.authentication.ejb;

import com.tandbergtv.neptune.authentication.entity.AuthenticationResponse;
import com.tandbergtv.neptune.authentication.entity.BasicRole;
import com.tandbergtv.neptune.authentication.entity.BasicUser;
import com.tandbergtv.neptune.authentication.entity.IAuthenticationResponse;
import com.tandbergtv.neptune.authentication.entity.IRole;
import com.tandbergtv.neptune.authentication.service.internal.IExternalAuthenticationService;
import com.tandbergtv.neptune.authorization.service.internal.IEJB3RoleGenerator;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.usermgmt.service.internal.IExternalUserManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.naming.Context;
import javax.naming.ldap.LdapContext;
import org.apache.log4j.Logger;

@Local(value={IExternalAuthenticationService.class})
@Stateless
public class LdapAuthenticationService
implements IExternalAuthenticationService {
    private static final Logger logger = Logger.getLogger(LdapAuthenticationService.class);
    @EJB
    IUserLdapContext userLdapContext;
    @EJB
    IExternalUserManager userManager;
    @EJB
    protected IEJB3RoleGenerator roleGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAuthenticationResponse authenticateUser(String userName, String password) {
        if (userName == null || userName.trim().length() == 0) {
            return new AuthenticationResponse(null, "The user name cannot be null / blank.");
        }
        if (password == null || password.trim().length() == 0) {
            return new AuthenticationResponse(null, "The password cannot be null / blank.");
        }
        HashMap<String, String> environmentOverride = new HashMap<String, String>();
        String userDN = "uid=" + userName + ",ou=People,dc=example,dc=com";
        environmentOverride.put("java.naming.security.principal", userDN);
        environmentOverride.put("java.naming.security.credentials", password);
        LdapContext context = null;
        boolean authenticationSuccess = false;
        try {
            context = this.userLdapContext.openContext(environmentOverride);
            authenticationSuccess = true;
        }
        catch (Exception e) {
            authenticationSuccess = false;
        }
        finally {
            this.closeContext(context);
        }
        AuthenticationResponse response = null;
        if (authenticationSuccess) {
            User persistedUser = this.userManager.getUser(new UserKey(null, userDN));
            BasicUser user = new BasicUser();
            user.setUserName(persistedUser.getUserName());
            user.setFirstName(persistedUser.getFirstName());
            user.setLastName(persistedUser.getLastName());
            user.setActive(persistedUser.isActive());
            user.setRoles(this.convertToEJB3Roles(persistedUser.getRoles()));
            response = new AuthenticationResponse(user);
        } else {
            response = new AuthenticationResponse(null, "The user failed authentication.");
        }
        return response;
    }

    protected Set<IRole> convertToEJB3Roles(Collection<Role> persistedRoles) {
        HashSet<IRole> roles = new HashSet<IRole>();
        if (persistedRoles != null) {
            HashSet<Permission> assignedPermissions = new HashSet<Permission>();
            for (Role persistedRole : persistedRoles) {
                for (Permission persistedPermission : persistedRole.getPermissions()) {
                    assignedPermissions.add(persistedPermission);
                }
            }
            for (Permission assignedPermission : assignedPermissions) {
                String moduleName = assignedPermission.getModule().getName();
                String permissionName = assignedPermission.getName();
                String roleName = this.roleGenerator.generateRole(moduleName, permissionName);
                roles.add(new BasicRole(roleName, moduleName, permissionName));
            }
        }
        return roles;
    }

    private void closeContext(Context context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failure closing the LDAP context.", (Throwable)e);
        }
    }
}

